/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.alarm;

import com.tridium.fox.session.IncompatibleVersionException;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxClientWebsocketBehavior;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.alarm.BAlarmChannel;
import com.tridium.nd.alarm.BNiagaraAlarmDeviceExt;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.ICoalesceable;
import javax.baja.util.Queue;

public class AlarmWorker
implements Runnable,
ICoalesceable {
    public static int WORKER_SLEEP = 1000;
    private final Queue workQueue;
    private final BNiagaraAlarmDeviceExt ext;
    private final BNiagaraStation station;
    private boolean isAlive = false;

    AlarmWorker(BNiagaraAlarmDeviceExt ext, Queue workQueue) {
        this.ext = ext;
        this.workQueue = workQueue;
        this.station = (BNiagaraStation)ext.getDevice();
    }

    private BFoxClientConnection getConnection() throws Exception {
        return this.station.getClientConnection();
    }

    private BAlarmChannel getAlarmChannel() throws Exception {
        return (BAlarmChannel)this.getConnection().getChannels().get("alarm", BAlarmChannel.TYPE);
    }

    public void start() {
        this.isAlive = true;
        BNiagaraNetwork net = this.station.getNiagaraNetwork();
        if (net != null) {
            net.getWorkers().register(this, WORKER_SLEEP);
        }
    }

    public void kill() {
        this.kill("");
    }

    public void kill(String reason) {
        this.isAlive = false;
        BNiagaraNetwork net = this.station.getNiagaraNetwork();
        if (net != null) {
            net.getWorkers().unregister(this);
        }
        this.ext.setWorkerState("stopped (" + reason + ")");
        if (BNiagaraAlarmDeviceExt.logger.isLoggable(Level.FINE)) {
            BNiagaraAlarmDeviceExt.logger.fine("stopped (" + reason + ")");
        }
    }

    public boolean isRunning() {
        return this.isAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.isAlive) {
            this.ext.setWorkerState("waiting for alarms...");
            Object obj = this.workQueue.peek();
            try {
                if (obj == null) {
                    return;
                }
                try {
                    this.ext.setWorkerState("waiting for connection...");
                    if (BNiagaraAlarmDeviceExt.logger.isLoggable(Level.FINE)) {
                        BNiagaraAlarmDeviceExt.logger.fine("waiting for connection...");
                    }
                    try {
                        this.getConnection().engageNoRetry((BFoxClientConnection.Interest)this.ext, this.getConnection().getRetryPeriod().getMillis(), true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.ext.setWorkerState("disengaging...");
                        if (this.getConnection().isEngaged((BFoxClientConnection.Interest)this.ext) && this.ext.isRunning()) {
                            this.getConnection().disengage((BFoxClientConnection.Interest)this.ext);
                        }
                        this.ext.setWorkerState("disengaged");
                        if (BNiagaraAlarmDeviceExt.logger.isLoggable(Level.FINE)) {
                            BNiagaraAlarmDeviceExt.logger.fine("disengaged");
                        }
                        return;
                    }
                    IncompatibleVersionException exception = null;
                    while (this.workQueue.size() > 0) {
                        obj = this.workQueue.dequeue();
                        if (obj instanceof BNiagaraAlarmDeviceExt.InitJob) {
                            this.ext.setWorkerState("executing init (" + obj.getClass() + ") job...");
                            if (BNiagaraAlarmDeviceExt.logger.isLoggable(Level.FINE)) {
                                BNiagaraAlarmDeviceExt.logger.fine("executing init (" + obj.getClass() + ") job...");
                            }
                            ((BNiagaraAlarmDeviceExt.InitJob)obj).execute();
                            continue;
                        }
                        if (!(obj instanceof BNiagaraAlarmDeviceExt.AlarmRecordQueueItem)) continue;
                        BAlarmRecord alarm = ((BNiagaraAlarmDeviceExt.AlarmRecordQueueItem)obj).record;
                        Array alarms = new Array(BAlarmRecord.class);
                        Array uuids = new Array(BUuid.class);
                        alarms.add((Object)alarm);
                        uuids.add((Object)alarm.getUuid());
                        this.ext.setWorkerState("batching alarms of type '" + alarm.getAckState() + "'");
                        if (BNiagaraAlarmDeviceExt.logger.isLoggable(Level.FINE)) {
                            BNiagaraAlarmDeviceExt.logger.fine("batching alarms of type '" + alarm.getAckState() + "'");
                        }
                        while (this.isNextAlarmOfType(this.workQueue, alarm.getAckState())) {
                            BAlarmRecord rec = ((BNiagaraAlarmDeviceExt.AlarmRecordQueueItem)this.workQueue.dequeue()).record;
                            Optional service = Sys.findService((Type)BAlarmService.TYPE);
                            if (uuids.contains((Object)rec.getUuid()) && (!service.isPresent() || ((BAlarmService)service.get()).getCoalesceAlarms())) continue;
                            alarms.add((Object)rec);
                            uuids.add((Object)rec.getUuid());
                        }
                        this.ext.setWorkerState("sending alarms...");
                        if (BNiagaraAlarmDeviceExt.logger.isLoggable(Level.FINE)) {
                            BNiagaraAlarmDeviceExt.logger.fine("sending " + alarms.size() + " alarms...");
                        }
                        try {
                            if (alarm.getAckState() == BAckState.ackPending) {
                                this.getAlarmChannel().ackAlarms((BAlarmRecord[])alarms.trim());
                                continue;
                            }
                            if (alarm.getSource().get(alarm.getSource().size() - 1).toString().equals(this.getAlarmChannel().getDeviceExt().getSlotPath().toString())) {
                                this.sendAlarmUpdates((BAlarmRecord[])alarms.trim());
                                continue;
                            }
                            this.getAlarmChannel().newAlarms((BAlarmRecord[])alarms.trim());
                        }
                        catch (IncompatibleVersionException ive) {
                            if (exception != null) continue;
                            exception = ive;
                        }
                    }
                    if (exception == null) continue;
                    throw exception;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.ext.setLastSendFailureCause("Cannot send Alarms " + e);
                    this.ext.setLastSendFailureTime(BAbsTime.now());
                    if (BNiagaraAlarmDeviceExt.logger.isLoggable(Level.FINE)) {
                        BNiagaraAlarmDeviceExt.logger.fine("Cannot send Alarms: " + e.getMessage());
                    }
                    this.workQueue.clear();
                    this.workQueue.enqueue(obj);
                    BNiagaraAlarmDeviceExt bNiagaraAlarmDeviceExt = this.ext;
                    bNiagaraAlarmDeviceExt.getClass();
                    this.workQueue.enqueue((Object)new BNiagaraAlarmDeviceExt.InitNewAlarms(bNiagaraAlarmDeviceExt, this.ext.getLastSendTime()));
                    BNiagaraAlarmDeviceExt bNiagaraAlarmDeviceExt2 = this.ext;
                    bNiagaraAlarmDeviceExt2.getClass();
                    this.workQueue.enqueue((Object)new BNiagaraAlarmDeviceExt.InitAlarmUpdates(bNiagaraAlarmDeviceExt2, this.ext.getLastSendTime()));
                    this.workQueue.enqueue((Object)new BNiagaraAlarmDeviceExt.InitAckPending(this.ext));
                    Thread.sleep(1000L);
                }
                finally {
                    this.ext.setWorkerState("disengaging...");
                    if (this.getConnection().isEngaged((BFoxClientConnection.Interest)this.ext) && this.ext.isRunning()) {
                        this.getConnection().disengage((BFoxClientConnection.Interest)this.ext);
                    }
                    this.ext.setWorkerState("disengaged");
                    if (!BNiagaraAlarmDeviceExt.logger.isLoggable(Level.FINE)) continue;
                    BNiagaraAlarmDeviceExt.logger.fine("disengaged");
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    boolean isNextAlarmOfType(Queue q, BAckState state) {
        Object obj = q.peek();
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BNiagaraAlarmDeviceExt.AlarmRecordQueueItem)) {
            return false;
        }
        return ((BNiagaraAlarmDeviceExt.AlarmRecordQueueItem)obj).record.getAckState() == state;
    }

    private void sendAlarmUpdates(BAlarmRecord[] alarms) throws Exception {
        for (int i = 0; i < alarms.length; ++i) {
            BAlarmRecord alarm = alarms[i];
            BOrdList src = alarm.getSource();
            src = BOrdList.remove((BOrdList)src, (int)(src.size() - 1));
            alarm.setSource(src);
            String origHyperlinkOrdKey = "unconvertedHyperlinkOrd";
            BObject hyperlink = alarm.getAlarmData().get(origHyperlinkOrdKey);
            if (hyperlink == null) {
                origHyperlinkOrdKey = "hyperlinkOrd";
                hyperlink = alarm.getAlarmData().get(origHyperlinkOrdKey);
            }
            if (hyperlink == null) continue;
            BNiagaraStation station = (BNiagaraStation)this.getAlarmChannel().getDeviceExt().getParent();
            String toRemove = AlarmWorker.makeStationSessionOrdSegment(station);
            if (!hyperlink.toString().startsWith(toRemove)) continue;
            String newHyperlink = hyperlink.toString().substring(toRemove.length());
            alarm.setAlarmData(BFacets.make((BFacets)alarm.getAlarmData(), (String)origHyperlinkOrdKey, (BIDataValue)BString.make((String)newHyperlink)));
        }
        this.getAlarmChannel().updateAlarms(alarms);
    }

    static final String makeStationSessionOrdSegment(BNiagaraStation station) {
        StringBuilder buff = new StringBuilder();
        buff.append(station.getAddress().toString());
        buff.append("|fox");
        boolean foxwssOnly = BFoxClientWebsocketBehavior.useWebsocketOnly.equals((Object)station.getClientConnection().getFoxOverWebsocket());
        if (foxwssOnly) {
            buff.append("wss");
        } else if (station.getClientConnection().getUseFoxs()) {
            buff.append('s');
        }
        buff.append(':');
        if (foxwssOnly) {
            buff.append(station.getClientConnection().getFoxOverWebsocketPort());
        } else {
            buff.append(station.getFoxPort());
        }
        buff.append('|');
        return buff.toString();
    }

    public String toString() {
        try {
            return this.station.getName() + ":Alarm Worker";
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public Object getCoalesceKey() {
        return this;
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        return c;
    }
}

