/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.sys.BFoxClientWebsocketBehavior;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.sys.metrics.BISubLicenseable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.baja.license.Feature;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BNiagaraEdgeLiteStation
extends BNiagaraStation
implements BISubLicenseable {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraEdgeLiteStation.class);
    public static final BIcon EDGE_LITE_ICON = BIcon.make((String)"module://icons/x16/unused/modem.png");
    public static final BIcon SECURE_EDGE_LITE_ICON = BIcon.make((BIcon)EDGE_LITE_ICON, (BIcon)BIcon.std((String)"badges/lock.png"));
    public static final BIcon WEB_SOCKET_EDGE_LITE_ICON = BIcon.make((BIcon)EDGE_LITE_ICON, (BIcon)BIcon.std((String)"badges/socketConnected.png"));
    public static final String NIAGARA_EDGE_LITE_LEVEL = "edgeLite1";
    private static int edgeLiteLicenseLimit = -1;
    private static final Map<String, BNiagaraEdgeLiteStation> hostIdsInUse = new ConcurrentHashMap<String, BNiagaraEdgeLiteStation>();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public String getLicenseKeyPrefix() {
        return EdgeStationHolder.hasEdgeDevicePercentage ? null : NIAGARA_EDGE_LITE_LEVEL;
    }

    public double getLicenseLimitIncrement() {
        return EdgeStationHolder.edgeDeviceLimitIncrement;
    }

    @Override
    public void stopped() throws Exception {
        hostIdsInUse.values().remove(this);
        super.stopped();
    }

    @Override
    public void clientOpened() {
        FoxMessage hello = this.getClientConnection().session().getRemoteHello();
        String remotePlatformType = hello.getString("niagaraPlatformType", null);
        if (!NIAGARA_EDGE_LITE_LEVEL.equals(remotePlatformType)) {
            throw new LocalizableRuntimeException("niagaraDriver", "niagaraEdgeLite.illegalConnection", new Object[]{remotePlatformType, NIAGARA_EDGE_LITE_LEVEL});
        }
        String remoteHostId = hello.getString("hostId", "unknown");
        BNiagaraEdgeLiteStation existing = hostIdsInUse.get(remoteHostId);
        if (existing == null) {
            hostIdsInUse.put(remoteHostId, this);
        } else if (existing != this) {
            throw new LocalizableRuntimeException("niagaraDriver", "niagaraEdgeLite.duplicateHostId", new Object[]{existing.getStationName()});
        }
        super.clientOpened();
    }

    public static BNiagaraStation getSuitableNiagaraStationInstance(FoxMessage remoteHello) {
        if (remoteHello != null && NIAGARA_EDGE_LITE_LEVEL.equals(remoteHello.getString("niagaraPlatformType", null)) && BNiagaraEdgeLiteStation.getEdgeLiteLicenseLimit() > 0) {
            return new BNiagaraEdgeLiteStation();
        }
        return new BNiagaraStation();
    }

    private static int getEdgeLiteLicenseLimit() {
        if (edgeLiteLicenseLimit < 0) {
            try {
                Feature feature = Sys.getLicenseManager().getFeature("tridium", "niagaraDriver");
                String val = feature.get(BISubLicenseable.getLicenseKey((BObject)new BNiagaraEdgeLiteStation(), (String)"device.limit"), "0");
                edgeLiteLicenseLimit = "none".equals(TextUtil.toLowerCase((String)val)) ? Integer.MAX_VALUE : Integer.parseInt(val);
            }
            catch (Exception e) {
                edgeLiteLicenseLimit = 0;
            }
        }
        return edgeLiteLicenseLimit;
    }

    @Override
    public BIcon getIcon() {
        if (this.getClientConnection().getFoxOverWebsocket().equals((Object)BFoxClientWebsocketBehavior.useWebsocketOnly) || this.getClientConnection().getFoxOverWebsocketInUse() && !this.getClientConnection().getFoxOverWebsocket().equals((Object)BFoxClientWebsocketBehavior.websocketDisabled)) {
            return WEB_SOCKET_EDGE_LITE_ICON;
        }
        return this.getClientConnection().getUseFoxs() ? SECURE_EDGE_LITE_ICON : EDGE_LITE_ICON;
    }

    private static final class EdgeStationHolder {
        static boolean hasEdgeDevicePercentage = false;
        static double edgeDeviceLimitIncrement = 1.0;

        private EdgeStationHolder() {
        }

        static {
            boolean foundDevicePercentage = false;
            try {
                Feature feature = Sys.getLicenseManager().getFeature("tridium", "niagaraDriver");
                feature.check();
                hasEdgeDevicePercentage = foundDevicePercentage = feature.get("edgeLite1_device.percentage") != null;
                int percentage = feature.geti("edgeLite1_device.percentage", 100);
                if (percentage > 0) {
                    edgeDeviceLimitIncrement = (double)percentage / 100.0;
                }
            }
            catch (Throwable t) {
                StringBuilder sb = new StringBuilder();
                sb.append("Could not lookup 'edgeLite1_device.percentage' from 'niagaraDriver' license feature. ");
                if (foundDevicePercentage) {
                    sb.append("Reverting to use 'edgeLite1_device.limit' (if available).");
                } else {
                    sb.append("Reverting to use a percentage of 100% for NiagaraEdgeStations counting against the 'device.limit' (if available).");
                }
                BNiagaraNetwork.LOG.log(Level.SEVERE, sb.toString(), t);
            }
        }
    }
}

