/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui.signing;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import com.tridium.platcrypto.ui.BCertViewDialog;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import java.security.cert.X509Certificate;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")
public class BCertificateNotTrustedDialog
extends BCertViewDialog {
    @Generated
    public static final Action cancelButtonPressed = BCertificateNotTrustedDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCertificateNotTrustedDialog.class);
    protected static Lexicon lex = Lexicon.make((String)"program");
    protected static BImage logo = BImage.make((String)"module://icons/x32/warning.png");
    protected BButton cancelButton;
    protected boolean closeResult = false;

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BCertificateNotTrustedDialog(BWidget parent, NX509Certificate cert) throws Exception {
        super(parent, lex.getText("program.certNotTrusted"));
        this.cert = cert;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    public static boolean showWithResult(BWidget owner, NX509Certificate cert) throws Exception {
        BCertificateNotTrustedDialog dialog = new BCertificateNotTrustedDialog(owner, cert);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    protected BWidget buildHeader() {
        return new BWizardHeader(logo, this.cert.getSubject(), lex.getText("program.certNotTrusted", new Object[]{this.cert.getSubject()}));
    }

    protected BWidget buildContent() throws Exception {
        BEdgePane edgePane = new BEdgePane();
        edgePane.setTop(BCertificateNotTrustedDialog.buildInfo());
        edgePane.setCenter(super.buildContent());
        return edgePane;
    }

    private static BWidget buildInfo() {
        BLabel label = new BLabel(lex.getText("cert.prompt.notTrusted") + '\n', BHalign.left);
        StyleUtils.addStyleClass((IStylable)label, (String)"strong");
        return new BBorderPane((BWidget)label, 10.0, 10.0, 5.0, 10.0);
    }

    protected BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(lex.getText("cert.prompt.dialog.accept"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BAbstractButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(true);
        this.cancelButton = new BButton(lex.getText("cert.prompt.dialog.reject"));
        buttonPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BAbstractButton.actionPerformed, (Slot)cancelButtonPressed);
        this.cancelButton.setEnabled(true);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    public void doOkButtonPressed(BWidgetEvent event) {
        this.closeResult = true;
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.closeResult = false;
        this.close();
    }

    public boolean getResult() {
        return this.closeResult;
    }

    public static boolean installUntrustedCertificate(NX509Certificate cert, BWidget parent, BComponent componentInSession) throws Exception {
        if (BCertificateNotTrustedDialog.showWithResult(parent, cert)) {
            ChannelCryptoManager ccm = new ChannelCryptoManager(componentInSession);
            ICoreTrustStore trustStore = ccm.getUserTrustStore();
            CertUtils.addUniqueCertificate((X509Certificate)cert.getCertificate(), (ICoreTrustStore)trustStore);
            trustStore.save();
            return true;
        }
        return false;
    }
}

