/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui.batch;

import com.tridium.program.batch.BSlotFlagsBatchRoutine;
import com.tridium.program.ui.batch.BBatchEditor;
import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.util.BFlagConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="propertyChanged"), @NiagaraAction(name="useSelectionChanged")})
public class BSetFlagsDialog
extends BOptionDialog {
    @Generated
    public static final Action propertyChanged = BSetFlagsDialog.newAction((int)0, null);
    @Generated
    public static final Action useSelectionChanged = BSetFlagsDialog.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSetFlagsDialog.class);
    private static Lexicon lex = Lexicon.make((String)"program");
    private static final FlagWrapper[] FLAGS;
    private static final Object USE_SELECTED_COMPONENTS;
    private BListDropDown dropDown;
    private BListDropDown flagDropDown;
    private BCheckBox useSelection = new BCheckBox(lex.getText("batchEditor.setFlagsOnSelectedObjects"));
    private SetFlag setFlag;
    private Hashtable<Object, boolean[]> validFlags;

    @Generated
    public void propertyChanged() {
        this.invoke(propertyChanged, null, null);
    }

    @Generated
    public void useSelectionChanged() {
        this.invoke(useSelectionChanged, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BSlotFlagsBatchRoutine open(BBatchEditor editor) {
        BSetFlagsDialog dlg = new BSetFlagsDialog(editor);
        return BSetFlagsDialog.open(editor, dlg);
    }

    public static BSlotFlagsBatchRoutine open(BBatchEditor editor, BSetFlagsDialog dlg) {
        dlg.setBoundsCenteredOnOwner();
        dlg.open();
        if (dlg.getResult() == 1) {
            try {
                boolean useSelected = dlg.useSelection.isSelected();
                String slotName = useSelected ? "null" : (String)dlg.dropDown.getList().getSelectedItem();
                int f = ((FlagWrapper)dlg.flagDropDown.getList().getSelectedItem()).flag.getMask();
                boolean setOrRemove = dlg.setFlag.isSelected();
                return BSlotFlagsBatchRoutine.make((boolean)useSelected, (String)SlotPath.escape((String)slotName), (int)f, (boolean)setOrRemove);
            }
            catch (Exception e) {
                BDialog.error((BWidget)editor, (String)"Error", (Object)"Failed", (Throwable)e);
            }
        }
        return null;
    }

    private BSetFlagsDialog(BBatchEditor parent) {
        super((BWidget)parent, lex.getText("batchEditor.commands.slotFlags.label"), (BWidget)new BNullWidget(), 3, null, null);
        this.useSelection.setSelected(false);
        this.linkTo((BComponent)this.useSelection, (Slot)BCheckBox.actionPerformed, (Slot)useSelectionChanged);
        int len = parent.table.model.kids.size();
        this.validFlags = new Hashtable();
        String firstSlotName = null;
        for (int i = 0; i < len; ++i) {
            Property prop;
            BComponent comp = parent.table.model.kids.get(i);
            BComplex p = comp.getParent();
            if (p instanceof BComponent && (prop = comp.getPropertyInParent()) != null) {
                int j;
                BFlagConfig flagConfig = new BFlagConfig((BIPropertyContainer)((BComponent)p), new Slot[]{prop});
                boolean[] flagEnabled = this.validFlags.get(USE_SELECTED_COMPONENTS);
                if (flagEnabled == null) {
                    flagEnabled = new boolean[FLAGS.length];
                    for (j = 0; j < FLAGS.length; ++j) {
                        flagEnabled[j] = flagConfig.isEnabled(BSetFlagsDialog.FLAGS[j].flag);
                    }
                } else {
                    for (j = 0; j < FLAGS.length; ++j) {
                        flagEnabled[j] = flagEnabled[j] && flagConfig.isEnabled(BSetFlagsDialog.FLAGS[j].flag);
                    }
                }
                this.validFlags.put(USE_SELECTED_COMPONENTS, flagEnabled);
            }
            Object[] c = comp.getSlots();
            while (c.next()) {
                int j;
                Slot s = c.slot();
                String slotName = SlotPath.unescape((String)s.getName());
                if (firstSlotName == null) {
                    firstSlotName = slotName;
                }
                BFlagConfig flagConfig = new BFlagConfig((BIPropertyContainer)comp, new Slot[]{s});
                boolean[] flagEnabled = this.validFlags.get(slotName);
                if (flagEnabled == null) {
                    flagEnabled = new boolean[FLAGS.length];
                    for (j = 0; j < FLAGS.length; ++j) {
                        flagEnabled[j] = flagConfig.isEnabled(BSetFlagsDialog.FLAGS[j].flag);
                    }
                } else {
                    for (j = 0; j < FLAGS.length; ++j) {
                        flagEnabled[j] = flagEnabled[j] && flagConfig.isEnabled(BSetFlagsDialog.FLAGS[j].flag);
                    }
                }
                this.validFlags.put(slotName, flagEnabled);
            }
        }
        this.dropDown = new BListDropDown();
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<Object> e = this.validFlags.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (key == USE_SELECTED_COMPONENTS) continue;
            list.add((String)key);
        }
        Object[] cols = list.toArray(new String[0]);
        Arrays.sort(cols);
        for (Object col : cols) {
            this.dropDown.getList().addItem((Object)SlotPath.unescape((String)col));
        }
        if (cols.length > 0) {
            this.dropDown.getList().setSelectedIndex(0);
        }
        this.linkTo((BComponent)this.dropDown, (Slot)BListDropDown.listActionPerformed, (Slot)propertyChanged);
        this.flagDropDown = new BListDropDown();
        if (firstSlotName != null) {
            boolean[] flagEnabled = this.validFlags.get(firstSlotName);
            boolean anyEnabled = false;
            for (int i = 0; i < FLAGS.length; ++i) {
                if (!flagEnabled[i]) continue;
                this.flagDropDown.getList().addItem((Object)FLAGS[i]);
                anyEnabled = true;
            }
            if (anyEnabled) {
                this.flagDropDown.getList().setSelectedIndex(0);
            }
        }
        BGridPane grid1 = new BGridPane(1);
        grid1.setHalign(BHalign.left);
        grid1.add(null, (BValue)this.useSelection);
        BGridPane grid2 = new BGridPane(2);
        grid2.setHalign(BHalign.left);
        grid2.add(null, (BValue)new BLabel(lex.getText("batchEditor.slot")));
        grid2.add(null, (BValue)this.dropDown);
        grid2.add(null, (BValue)new BLabel(lex.getText("batchEditor.flag")));
        grid2.add(null, (BValue)this.flagDropDown);
        ToggleCommandGroup group = new ToggleCommandGroup();
        this.setFlag = new SetFlag((BWidget)this);
        group.add((ToggleCommand)this.setFlag);
        RemoveFlag removeFlag = new RemoveFlag((BWidget)this);
        group.add((ToggleCommand)removeFlag);
        this.setFlag.setSelected(true);
        BGridPane grid3 = new BGridPane(2);
        grid3.setHalign(BHalign.left);
        grid3.add(null, (BValue)new BRadioButton((ToggleCommand)this.setFlag));
        grid3.add(null, (BValue)new BRadioButton((ToggleCommand)removeFlag));
        BGridPane grid = new BGridPane(1);
        grid.setHalign(BHalign.left);
        grid.add(null, (BValue)grid1);
        grid.add(null, (BValue)grid2);
        grid.add(null, (BValue)grid3);
        this.setContent((BWidget)new BBorderPane((BWidget)grid, 10.0, 10.0, 10.0, 10.0));
    }

    public void doPropertyChanged() {
        try {
            String slotName = (String)this.dropDown.getList().getSelectedItem();
            if (slotName == null) {
                this.flagDropDown.getList().removeAllItems();
                this.flagDropDown.getList().setSelectedIndex(0);
                return;
            }
            boolean[] flagEnabled = this.validFlags.get(slotName);
            Object oldSelection = this.flagDropDown.getSelectedItem();
            FlagWrapper newSelection = null;
            this.flagDropDown.getList().removeAllItems();
            for (int i = 0; i < FLAGS.length; ++i) {
                if (!flagEnabled[i]) continue;
                this.flagDropDown.getList().addItem((Object)FLAGS[i]);
                if (FLAGS[i] != oldSelection) continue;
                newSelection = FLAGS[i];
            }
            if (newSelection != null) {
                this.flagDropDown.getList().setSelectedItem(newSelection);
            } else {
                this.flagDropDown.getList().setSelectedIndex(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doUseSelectionChanged() {
        boolean enabled = !this.useSelection.isSelected();
        this.dropDown.setEnabled(enabled);
        if (!enabled) {
            boolean[] flagEnabled = this.validFlags.get(USE_SELECTED_COMPONENTS);
            Object oldSelection = this.flagDropDown.getSelectedItem();
            FlagWrapper newSelection = null;
            this.flagDropDown.getList().removeAllItems();
            for (int i = 0; i < FLAGS.length; ++i) {
                if (!flagEnabled[i]) continue;
                this.flagDropDown.getList().addItem((Object)FLAGS[i]);
                if (FLAGS[i] != oldSelection) continue;
                newSelection = FLAGS[i];
            }
            if (newSelection != null) {
                this.flagDropDown.getList().setSelectedItem(newSelection);
            } else {
                this.flagDropDown.getList().setSelectedIndex(0);
            }
        } else {
            this.doPropertyChanged();
        }
    }

    static {
        Flags.Flag[] flags = Flags.getFlags();
        FLAGS = new FlagWrapper[flags.length];
        for (int i = 0; i < flags.length; ++i) {
            BSetFlagsDialog.FLAGS[i] = new FlagWrapper(flags[i]);
        }
        USE_SELECTED_COMPONENTS = new Object();
    }

    static class RemoveFlag
    extends ToggleCommand {
        RemoveFlag(BWidget owner) {
            super(owner, lex.getText("batchEditor.removeFlag"));
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    static class SetFlag
    extends ToggleCommand {
        SetFlag(BWidget owner) {
            super(owner, lex.getText("batchEditor.setFlag"));
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    static class FlagWrapper {
        Flags.Flag flag;

        public FlagWrapper(Flags.Flag flag) {
            this.flag = flag;
        }

        public String toString() {
            return this.flag.getDisplayName(null);
        }
    }
}

