/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import com.tridium.program.ui.BProgramModuleBuilder;
import com.tridium.security.BPermissionGroupInfo;
import com.tridium.workbench.security.BPermissionGroupFE;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;

public class ProgramModuleBuilderCommands {
    private final BProgramModuleBuilder builder;
    AddPermissionRequestCommand addPermissionCommand;
    EditPermissionRequestCommand editPermissionCommand;
    RemovePermissionRequestCommand removePermissionCommand;

    public ProgramModuleBuilderCommands(BProgramModuleBuilder builder) {
        this.builder = builder;
        this.addPermissionCommand = new AddPermissionRequestCommand();
        this.editPermissionCommand = new EditPermissionRequestCommand();
        this.removePermissionCommand = new RemovePermissionRequestCommand();
    }

    class RemovePermissionRequestCommand
    extends ProgramModuleBuilderCommand {
        public RemovePermissionRequestCommand() {
            super("programModuleBuilder.removePermissionRequest");
        }

        public CommandArtifact doInvoke() {
            BPermissionGroupInfo[] permissionGroupInfos = (BPermissionGroupInfo[])((ProgramModuleBuilderCommands)ProgramModuleBuilderCommands.this).builder.pmod.getPermissions().getChildren(BPermissionGroupInfo.class);
            for (int row : ((ProgramModuleBuilderCommands)ProgramModuleBuilderCommands.this).builder.permissions.getSelection().getRows()) {
                ((ProgramModuleBuilderCommands)ProgramModuleBuilderCommands.this).builder.pmod.getPermissions().remove(permissionGroupInfos[row].getName());
            }
            return null;
        }
    }

    class EditPermissionRequestCommand
    extends ProgramModuleBuilderCommand {
        public EditPermissionRequestCommand() {
            super("programModuleBuilder.editPermissionRequest");
        }

        public CommandArtifact doInvoke() {
            BPermissionGroupFE plugin = new BPermissionGroupFE();
            BPermissionGroupInfo oldInfo = ((ProgramModuleBuilderCommands)ProgramModuleBuilderCommands.this).builder.permissions.getSelectedPermission();
            if (oldInfo != null) {
                plugin.loadValue((BObject)oldInfo);
                int r = BDialog.open((BWidget)ProgramModuleBuilderCommands.this.builder, (String)this.getLabel(), (Object)plugin, (int)3);
                if (r == 2) {
                    return null;
                }
                BPermissionGroupInfo newInfo = plugin.getPermissionGroupInfo();
                ((ProgramModuleBuilderCommands)ProgramModuleBuilderCommands.this).builder.pmod.getPermissions().set(oldInfo.getName(), (BValue)newInfo);
            }
            return null;
        }
    }

    class AddPermissionRequestCommand
    extends ProgramModuleBuilderCommand {
        public AddPermissionRequestCommand() {
            super("programModuleBuilder.addPermissionRequest");
        }

        public CommandArtifact doInvoke() {
            BPermissionGroupFE plugin = new BPermissionGroupFE();
            plugin.loadValue((BObject)new BPermissionGroupInfo());
            plugin.doUpdateParameters();
            int r = BDialog.open((BWidget)ProgramModuleBuilderCommands.this.builder, (String)this.getLabel(), (Object)plugin, (int)3);
            if (r == 2) {
                return null;
            }
            BPermissionGroupInfo permissionGroupInfo = plugin.getPermissionGroupInfo();
            ((ProgramModuleBuilderCommands)ProgramModuleBuilderCommands.this).builder.permissions.add(permissionGroupInfo);
            return null;
        }
    }

    class ProgramModuleBuilderCommand
    extends Command {
        public ProgramModuleBuilderCommand(String keyBase) {
            super((BWidget)ProgramModuleBuilderCommands.this.builder, UiLexicon.bajaui().module, keyBase);
        }
    }
}

