/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.hsqldb;

import com.tridium.rdb.hsqldb.HsqlStatement;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.baja.rdb.BRdbms;

public final class HsqlConnection
implements Connection {
    private Connection wrap;

    HsqlConnection(Connection wrap) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(BRdbms.RDB_CONNECTION_PERMISSION);
        }
        this.wrap = wrap;
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> new HsqlStatement(this.wrap.createStatement()));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String s) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.prepareStatement(s));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String s) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.prepareCall(s));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public String nativeSQL(String s) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.nativeSQL(s));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public void setAutoCommit(boolean b) throws SQLException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.setAutoCommit(b);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.getAutoCommit());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return false;
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.commit();
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.rollback();
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.close();
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.isClosed());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return false;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.getMetaData());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public void setReadOnly(boolean b) throws SQLException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.setReadOnly(b);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.isReadOnly());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return false;
        }
    }

    @Override
    public void setCatalog(String s) throws SQLException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.setCatalog(s);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.getCatalog());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public void setTransactionIsolation(int i) throws SQLException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.setTransactionIsolation(i);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.getTransactionIsolation());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return 0;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.getWarnings());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.clearWarnings();
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
        }
    }

    @Override
    public Statement createStatement(int i, int i2) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> new HsqlStatement(this.wrap.createStatement(i, i2)));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String s, int i, int i2) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.prepareStatement(s, i, i2));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String s, int i, int i2) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.prepareCall(s, i, i2));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.getTypeMap());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> stringClassMap) throws SQLException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.setTypeMap(stringClassMap);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
        }
    }

    @Override
    public void setHoldability(int i) throws SQLException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.setHoldability(i);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.getHoldability());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return 0;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.setSavepoint());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public Savepoint setSavepoint(String s) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.setSavepoint(s));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.rollback(savepoint);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.releaseSavepoint(savepoint);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
        }
    }

    @Override
    public Statement createStatement(int i, int i2, int i3) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> new HsqlStatement(this.wrap.createStatement(i, i2, i3)));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String s, int i, int i2, int i3) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.prepareStatement(s, i, i2, i3));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String s, int i, int i2, int i3) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.prepareCall(s, i, i2, i3));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String s, int i) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.prepareStatement(s, i));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String s, int[] ints) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.prepareStatement(s, ints));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String s, String[] strings) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.prepareStatement(s, strings));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.createClob());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.createBlob());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.createNClob());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.createSQLXML());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public boolean isValid(int i) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.isValid(i));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return false;
        }
    }

    @Override
    public void setClientInfo(String s, String s2) throws SQLClientInfoException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.setClientInfo(s, s2);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrowClient(e);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.setClientInfo(properties);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrowClient(e);
        }
    }

    @Override
    public String getClientInfo(String s) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.getClientInfo(s));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.getClientInfo());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public Array createArrayOf(String s, Object[] objects) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.createArrayOf(s, objects));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public Struct createStruct(String s, Object[] objects) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.createStruct(s, objects));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public void setSchema(String s) throws SQLException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.setSchema(s);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.getSchema());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.abort(executor);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int i) throws SQLException {
        try {
            AccessController.doPrivileged(() -> {
                this.wrap.setNetworkTimeout(executor, i);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.getNetworkTimeout());
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return 0;
        }
    }

    @Override
    public <T> T unwrap(Class<T> tClass) throws SQLException {
        try {
            return (T)AccessController.doPrivileged(() -> this.wrap.unwrap(tClass));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return null;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        try {
            return AccessController.doPrivileged(() -> this.wrap.isWrapperFor(aClass));
        }
        catch (PrivilegedActionException e) {
            HsqlConnection.rethrow(e);
            return false;
        }
    }

    public static void rethrow(PrivilegedActionException e) throws SQLException {
        Exception e2 = e.getException();
        if (e2 instanceof SQLException) {
            throw (SQLException)e2;
        }
        throw new SQLException(e2);
    }

    public static void rethrowClient(PrivilegedActionException e) throws SQLClientInfoException {
        Exception e2 = e.getException();
        if (e2 instanceof SQLClientInfoException) {
            throw (SQLClientInfoException)e2;
        }
        throw new SQLClientInfoException(null, (Throwable)e2);
    }
}

