/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.hsqldb;

import com.tridium.nre.security.SecretChars;
import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.hsqldb.HsqlConnection;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.sys.station.BStationSaveJob;
import com.tridium.sys.station.Station;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.job.BJob;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.security.BPassword;
import javax.baja.security.PasswordEncodingContext;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.LexiconModule;
import javax.baja.util.Version;
import org.hsqldb.DatabaseURL;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.persist.HsqlProperties;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="hostAddress", type="BOrd", defaultValue="BOrd.NULL", flags=5, override=true), @NiagaraProperty(name="baseDirectory", type="BOrd", defaultValue="BOrd.make(\"file:^^hsqldb\")", facets={@Facet(name="BFacets.TARGET_TYPE", value="\"baja:IDirectory\"")}), @NiagaraProperty(name="databaseName", type="String", defaultValue=""), @NiagaraProperty(name="useEncryptedConnection", type="boolean", defaultValue="false", flags=5, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}, override=true), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT", flags=5, override=true), @NiagaraProperty(name="defragOnSave", type="boolean", defaultValue="false"), @NiagaraProperty(name="defragAndSavePeriodicSchedule", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(true, BTime.make(2,0,0), BTime.make(23,29,29), BRelTime.makeDays(30), BDaysOfWeekBits.make(BDaysOfWeekBits.SUNDAY)))"), @NiagaraProperty(name="checkpointDefragSize", type="int", defaultValue="2", flags=4), @NiagaraProperty(name="removedManualPassword", type="boolean", defaultValue="false", flags=69)})
@NiagaraAction(name="defragAndSave")
public class BHsqlDatabase
extends BRdbms {
    @Generated
    public static final Property hostAddress = BHsqlDatabase.newProperty((int)5, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property baseDirectory = BHsqlDatabase.newProperty((int)0, (BValue)BOrd.make((String)"file:^^hsqldb"), (BFacets)BFacets.make((String)"targetType", (String)"baja:IDirectory"));
    @Generated
    public static final Property databaseName = BHsqlDatabase.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property useEncryptedConnection = BHsqlDatabase.newProperty((int)5, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property password = BHsqlDatabase.newProperty((int)5, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property defragOnSave = BHsqlDatabase.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property defragAndSavePeriodicSchedule = BHsqlDatabase.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((boolean)true, (BTime)BTime.make((int)2, (int)0, (int)0), (BTime)BTime.make((int)23, (int)29, (int)29), (BRelTime)BRelTime.makeDays((int)30), (BDaysOfWeekBits)BDaysOfWeekBits.make((int)1))), null);
    @Generated
    public static final Property checkpointDefragSize = BHsqlDatabase.newProperty((int)4, (int)2, null);
    @Generated
    public static final Property removedManualPassword = BHsqlDatabase.newProperty((int)69, (boolean)false, null);
    @Generated
    public static final Action defragAndSave = BHsqlDatabase.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHsqlDatabase.class);
    private Properties oldPropertiesFile;
    private boolean checkedForHsqlUpgrade = false;
    private final RdbmsDialect dialect = new RdbmsDialect(){

        public String getValidationQuery() {
            return "CALL USER()";
        }

        public void issueCheckpoint(Connection conn) throws SQLException {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("**********ISSUE  CHECKPOINT DEFRAG ********** ->" + BHsqlDatabase.this.getDefragOnSave());
            }
            if (BHsqlDatabase.this.getDefragOnSave()) {
                this.executeSql(conn, "SET FILES DEFRAG " + BHsqlDatabase.this.getCheckpointDefragSize());
                this.executeSql(conn, "CHECKPOINT DEFRAG");
            } else {
                this.executeSql(conn, "SET FILES DEFRAG 0");
                this.executeSql(conn, "CHECKPOINT");
            }
        }

        private void executeSql(Connection conn, String sql) throws SQLException {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(sql);
            }
            try (Statement statement = conn.createStatement();){
                statement.execute(sql);
            }
        }

        public boolean supportsBatchInsert() {
            return false;
        }

        public boolean supportsBatchUpdate() {
            return false;
        }

        public boolean supportsBatchDelete() {
            return true;
        }

        public int getInsertionMode() {
            return 2;
        }

        public String getIdentityCreation() {
            return "GENERATED BY DEFAULT AS IDENTITY";
        }

        public String getIdentityLookup() {
            return "CALL IDENTITY()";
        }

        public String getSequenceName(String tableName) {
            throw new UnsupportedOperationException();
        }

        public String getSequenceLookup(String tableName) {
            throw new UnsupportedOperationException();
        }

        public String getAlterColumn() {
            return "ALTER COLUMN";
        }

        public String getAlterColumnSuffix() {
            return null;
        }

        public boolean getAlterColumnSupportsNotNull() {
            return false;
        }

        public String getStringLengthFunctionName() {
            return "CHAR_LENGTH";
        }

        public int getMaxTableName() {
            return 128;
        }

        public int getMaxIndexName() {
            return 128;
        }

        public int getMaxConstraintName() {
            return 128;
        }

        public int getMaxColumnName() {
            return 128;
        }

        public boolean allowsUnicodeNames() {
            return false;
        }

        public String getColumnIdentifier(String schemaName, String tableName, String columnName) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName + "." + tableName + ".\"" + columnName + "\"";
            }
            return tableName + ".\"" + columnName + "\"";
        }

        public String getTableIdentifier(String schemaName, String tableName) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName + "." + tableName;
            }
            return tableName;
        }

        public String getDropIndex(String tableName, String indexName) {
            return "DROP INDEX " + indexName;
        }

        public String getDropConstraint(String tableName, Constraint constraint) {
            return "ALTER TABLE " + tableName + " DROP CONSTRAINT " + constraint.getName();
        }

        public String getIntType() {
            return "INTEGER";
        }

        public String getLongType() {
            return "BIGINT";
        }

        public String getFloatType() {
            return "REAL";
        }

        public String getDoubleType() {
            return "DOUBLE PRECISION";
        }

        public String getCharType() {
            return BHsqlDatabase.this.getUseUnicodeEncodingScheme() ? "CHAR" : "CHAR";
        }

        public String getVarCharType() {
            return BHsqlDatabase.this.getUseUnicodeEncodingScheme() ? "NVARCHAR" : "VARCHAR";
        }

        public String getUuidType() {
            return "BINARY(16)";
        }

        public String getDateType() {
            return "DATE";
        }

        public String getBooleanType() {
            return "BOOLEAN";
        }

        public String getTimestampType() {
            return "TIMESTAMP";
        }

        public boolean supportsBooleanType() {
            return true;
        }

        public boolean supportsDateType() {
            return true;
        }

        public boolean supportsMillisecondTimestamp() {
            return BHsqlDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.localTimestamp) || BHsqlDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcTimestamp);
        }

        public boolean useUtcTimestamps() {
            return BHsqlDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcTimestamp);
        }

        public String getBlobType() {
            return "LONGVARBINARY";
        }

        public boolean usesDefaultBlobTranslator() {
            return true;
        }

        public void setBlobValue(RdbmsPreparedStatement prep, int index, byte[] bytes) {
            throw new UnsupportedOperationException();
        }

        public String getClobType() {
            return "LONGVARCHAR";
        }

        public boolean usesDefaultClobTranslator() {
            return true;
        }

        public void setClobValue(RdbmsPreparedStatement prep, int index, String str) {
            throw new UnsupportedOperationException();
        }

        public AesSysKeyEncoder getSysEncoder() {
            return BHsqlDatabase.this.getEncoder();
        }

        public String getOnDelete(int onDelete) {
            switch (onDelete) {
                case 1: {
                    return "CASCADE";
                }
                case 0: {
                    return "NO ACTION";
                }
            }
            throw new IllegalStateException();
        }

        public boolean supportsDropColumn() {
            return true;
        }

        public boolean supportsRenameTable() {
            return false;
        }

        public boolean supportsClusteredIndex() {
            return false;
        }

        public int getJdbcTypeBlob() {
            return -4;
        }

        public int getJdbcTypeBoolean() {
            return 16;
        }

        public int getJdbcTypeChar() {
            return 1;
        }

        public int getJdbcTypeClob() {
            return -1;
        }

        public int getJdbcTypeDouble() {
            return 8;
        }

        public int getJdbcTypeFloat() {
            return 7;
        }

        public int getJdbcTypeInt() {
            return 4;
        }

        public int getJdbcTypeLong() {
            return -5;
        }

        public int getJdbcTypeTimestamp() {
            return -5;
        }

        public int getJdbcTypeUuid() {
            return -2;
        }

        public int getJdbcTypeVarchar() {
            return 12;
        }

        public int getJdbcTypeDate() {
            return 91;
        }
    };
    public static final Logger logger = Logger.getLogger("rdb");
    private static final LexiconModule lex = LexiconModule.make(BHsqlDatabase.class);
    private ExecutorService defragAndSaveExecutor = Executors.newSingleThreadExecutor();
    private static final SecureRandom secureRandom = new SecureRandom();

    @Generated
    public BOrd getBaseDirectory() {
        return (BOrd)this.get(baseDirectory);
    }

    @Generated
    public void setBaseDirectory(BOrd v) {
        this.set(baseDirectory, (BValue)v, null);
    }

    @Generated
    public String getDatabaseName() {
        return this.getString(databaseName);
    }

    @Generated
    public void setDatabaseName(String v) {
        this.setString(databaseName, v, null);
    }

    @Generated
    public boolean getDefragOnSave() {
        return this.getBoolean(defragOnSave);
    }

    @Generated
    public void setDefragOnSave(boolean v) {
        this.setBoolean(defragOnSave, v, null);
    }

    @Generated
    public BTimeTrigger getDefragAndSavePeriodicSchedule() {
        return (BTimeTrigger)this.get(defragAndSavePeriodicSchedule);
    }

    @Generated
    public void setDefragAndSavePeriodicSchedule(BTimeTrigger v) {
        this.set(defragAndSavePeriodicSchedule, (BValue)v, null);
    }

    @Generated
    public int getCheckpointDefragSize() {
        return this.getInt(checkpointDefragSize);
    }

    @Generated
    public void setCheckpointDefragSize(int v) {
        this.setInt(checkpointDefragSize, v, null);
    }

    @Generated
    public boolean getRemovedManualPassword() {
        return this.getBoolean(removedManualPassword);
    }

    @Generated
    public void setRemovedManualPassword(boolean v) {
        this.setBoolean(removedManualPassword, v, null);
    }

    @Generated
    public void defragAndSave() {
        this.invoke(defragAndSave, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void rdbmsStarted() throws Exception {
        this.add("defragAndSavePeriodicSchedulePeriodicScheduleLink", (BValue)new BLink(this.getDefragAndSavePeriodicSchedule().getOrdInSession(), "fireTrigger", "defragAndSave", true), 6);
        this.updateDefragAndSaveFlags();
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (prop.equals(defragOnSave) || prop.equals(defragAndSavePeriodicSchedule)) {
            this.updateDefragAndSaveFlags();
        }
    }

    private void updateDefragAndSaveFlags() {
        int flag1 = this.getFlags((Slot)defragAndSave);
        int flag2 = this.getFlags((Slot)defragAndSavePeriodicSchedule);
        if (this.getDefragOnSave()) {
            flag1 |= 1;
            flag1 |= 4;
            flag2 |= 1;
            flag2 |= 4;
        } else {
            flag1 &= 0xFFFFFFFE;
            flag1 &= 0xFFFFFFFB;
            flag2 &= 0xFFFFFFFE;
            flag2 &= 0xFFFFFFFB;
        }
        this.setFlags((Slot)defragAndSave, flag1);
        this.setFlags((Slot)defragAndSavePeriodicSchedule, flag2);
    }

    public void stopped() throws Exception {
        try (Connection connection = AccessController.doPrivileged(() -> this.getPrivilegedConnection(null));
             Statement statement = connection.createStatement();){
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SHUTDOWN");
            }
            statement.execute("SHUTDOWN");
            this.defragAndSaveExecutor.shutdown();
        }
        catch (Exception e) {
            Throwable cause = e;
            if (e instanceof PrivilegedActionException && e.getCause() != null) {
                cause = e.getCause();
            }
            throw new BajaRuntimeException(cause);
        }
    }

    public void updateToKeyRingPassword() throws Exception {
        this.setHsqlPassword(this.createKeyRingEncryptedPassword());
    }

    private void setHsqlPassword(BPassword newPassword) {
        try (SecretChars newHsqlPasswordValue = new SecretChars(AccessController.doPrivileged(() -> ((BPassword)newPassword).getValue()).toCharArray(), false);){
            try (Connection connection = AccessController.doPrivileged(() -> this.getPrivilegedConnection(null));
                 Statement statement = connection.createStatement();){
                String sql = "SET PASSWORD '" + newHsqlPasswordValue.asString(false) + "'";
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("SET PASSWORD *****");
                }
                statement.execute(sql);
                this.setPassword(newPassword);
                this.setRemovedManualPassword(true);
            }
            catch (Exception e) {
                Throwable cause = e;
                if (e instanceof PrivilegedActionException && e.getCause() != null) {
                    cause = e.getCause();
                }
                logger.log(Level.SEVERE, "Cannot change hsql password", cause);
            }
        }
    }

    public void doDefragAndSave() throws Exception {
        if (this.getDefragOnSave()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Cannot issue CHECKPOINT DEFRAG on " + this.getName() + " (" + this.getType() + ") as redundant where on each save sation alreading issuing CHECKPOINT DEFRAG");
            }
            return;
        }
        this.defragAndSaveExecutor.submit(() -> {
            try (Connection connection = AccessController.doPrivileged(() -> this.getPrivilegedConnection(null));){
                String sql;
                try (Statement statement = connection.createStatement();){
                    sql = "SET FILES DEFRAG " + this.getCheckpointDefragSize();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(sql);
                    }
                    statement.execute(sql);
                }
                statement = connection.createStatement();
                var4_9 = null;
                try {
                    sql = "CHECKPOINT DEFRAG";
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(sql);
                    }
                    statement.execute(sql);
                }
                catch (Throwable throwable) {
                    var4_9 = throwable;
                    throw throwable;
                }
                finally {
                    if (statement != null) {
                        if (var4_9 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable) {
                                var4_9.addSuppressed(throwable);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                Throwable cause = e;
                if (e instanceof PrivilegedActionException && e.getCause() != null) {
                    cause = e.getCause();
                }
                logger.log(Level.SEVERE, "Cannot issue checkpoint on " + this.getName() + " (" + this.getType() + ')', logger.isLoggable(Level.FINE) ? cause : null);
                return;
            }
            try {
                BStationSaveJob job = new BStationSaveJob();
                Station.saveSync((BJob)job);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot save sation after issuing \"CHECKPOINT DEFRAG\"", e);
            }
        });
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "rdbHsqlDb");
    }

    private BPassword createKeyRingEncryptedPassword() {
        byte[] keyBytes = new byte[32];
        secureRandom.nextBytes(keyBytes);
        try (PasswordEncodingContext pContext = PasswordEncodingContext.makeKeyring();){
            BPassword bPassword = BPassword.make((String)ByteArrayUtil.toHexString((byte[])keyBytes), (Context)pContext);
            return bPassword;
        }
    }

    public void doPing() {
        try {
            if (!this.getRemovedManualPassword()) {
                this.updateToKeyRingPassword();
                this.setFlags((Slot)password, this.getFlags((Slot)password) | 1 | 4);
            }
            try (Connection conn = AccessController.doPrivileged(() -> this.getPrivilegedConnection(null));
                 Statement statement = conn.createStatement();){
                RdbmsDialect dialect = (RdbmsDialect)this.getRdbmsContext();
                statement.execute(dialect.getValidationQuery());
                this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)false));
                this.pingOk();
            }
        }
        catch (Throwable e) {
            Throwable cause = e;
            if (e instanceof PrivilegedActionException && e.getCause() != null || e instanceof BajaRuntimeException && e.getMessage() == null && e.getCause() != null) {
                cause = e.getCause();
            }
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
            this.pingFail(cause.getMessage());
        }
    }

    public Connection getConnection(String userName, BPassword password) throws SQLException {
        if (this.getDatabaseName().isEmpty()) {
            throw new BajaRuntimeException("Database Name cannot be empty");
        }
        if (this.getUserName().isEmpty()) {
            throw new BajaRuntimeException("Username cannot be empty");
        }
        Connection conn = null;
        try {
            boolean firstCheck = this.checkForHsqlUpgrade();
            FilePath path = (FilePath)this.getBaseDirectory().parse()[0];
            BDirectory dir = AccessController.doPrivileged(() -> BFileSystem.INSTANCE.makeDir(path));
            String home = ((BLocalFileStore)dir.getStore()).getLocalFile().getAbsolutePath();
            String url = "jdbc:hsqldb:file:" + home + File.separator + this.getDatabaseName();
            Properties info = new Properties();
            if (firstCheck) {
                BHsqlDatabase.addProps(info);
            }
            if (Flags.isUserDefined1((BComplex)this, (Slot)BHsqlDatabase.password)) {
                this.setPassword(BPassword.make((String)""));
                this.setFlags((Slot)BHsqlDatabase.password, this.getFlags((Slot)BHsqlDatabase.password) & 0xEFFFFFFF | 1 | 4);
                this.updateToKeyRingPassword();
                password = this.getPassword();
            }
            info.put("user", userName);
            if (password.isDefault()) {
                password = this.createKeyRingEncryptedPassword();
                this.setPassword(password);
                this.setRemovedManualPassword(true);
            }
            info.put("password", AccessController.doPrivileged(() -> ((BPassword)password).getValue()));
            HsqlProperties hprops = AccessController.doPrivileged(() -> DatabaseURL.parseURL(url, true, true));
            hprops.addProperties(info);
            conn = AccessController.doPrivileged(() -> new JDBCConnection(hprops));
            return new HsqlConnection(conn);
        }
        catch (Throwable e) {
            if (conn != null) {
                conn.close();
            }
            throw new BajaRuntimeException(e);
        }
    }

    public static void addProps(Properties info) {
        info.put("check_props", "true");
        info.put("hsqldb.log_data", "false");
        info.put("hsqldb.default_table_type", "cached");
        info.put("hsqldb.applog", "0");
        info.put("hsqldb.lock_file", "false");
    }

    private synchronized boolean checkForHsqlUpgrade() throws Exception {
        if (this.checkedForHsqlUpgrade) {
            return false;
        }
        this.checkedForHsqlUpgrade = true;
        AccessController.doPrivileged(() -> {
            System.setProperty("hsqldb.reconfig_logging", "false");
            return null;
        });
        BIFile propsFile = null;
        try {
            propsFile = (BIFile)BOrd.make((String)(this.getBaseDirectory() + "/" + this.getDatabaseName() + ".properties")).get();
        }
        catch (Exception e) {
            return true;
        }
        Properties props = new Properties();
        try (InputStream inputStream = propsFile.getInputStream();){
            props.load(inputStream);
        }
        String versionProp = props.getProperty("version");
        Version version = new Version(versionProp);
        Version version20 = new Version("2.0");
        Version version25 = new Version("2.5");
        if (version.compareTo(version25) < 0) {
            logger.info("Upgrading HSQL Database from " + version + " to 2.X");
            String stringModified = props.getProperty("modified");
            if (stringModified != null && stringModified.equals("yes")) {
                String warningText = "***This HSQL " + version + " Database was being modified while the HSQL backup occured; if you plan on safely upgrading a backup of a Hsql database to HSQL 2.X, you may need to shutdown the station using Hsql old version before backing it up.";
                logger.warning(warningText);
            }
            BHsqlDatabase.addProps(props);
            try (OutputStream outputStream = propsFile.getOutputStream();){
                props.store(outputStream, "none");
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Cannot write to properties file", e);
            }
            this.oldPropertiesFile = props;
            BIFile scriptFile = (BIFile)BOrd.make((String)(this.getBaseDirectory() + "/" + this.getDatabaseName() + ".script")).get();
            String bigString = BajaFileUtil.readString((BIFile)scriptFile);
            if (version.compareTo(version20) < 0) {
                bigString = TextUtil.replace((String)bigString, (String)" BINARY", (String)" BINARY(16)");
            }
            bigString = TextUtil.replace((String)bigString, (String)" DEADLOCK", (String)" CONFLICT");
            scriptFile.write(bigString.getBytes());
            return true;
        }
        return true;
    }

    public RdbmsContext getRdbmsContext() {
        return this.dialect;
    }
}

