/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ws;

import com.tridiumx.analytics.aon.Amap;
import com.tridiumx.analytics.aon.Aobj;
import com.tridiumx.analytics.aon.Aon;
import com.tridiumx.analytics.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Predicate;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.units.BUnit;
import javax.baja.units.UnitException;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.BFormat;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.data.Combination;
import javax.bajax.analytics.time.BAnalyticTimeRange;
import javax.bajax.analytics.time.BInterval;
import javax.bajax.analytics.time.Interval;
import javax.bajax.analytics.time.TimeRange;

class WsAnalyticsContext
extends AnalyticContext {
    protected Amap args;
    private AnalyticContext inner;

    public WsAnalyticsContext() {
    }

    public WsAnalyticsContext(Amap args, Context cx) {
        super(cx);
        this.args = args;
        this.inner = new AnalyticContext(cx);
        String unitStr = this.getArg("unit");
        try {
            this.unit = BUnit.getUnit((String)unitStr);
        }
        catch (UnitException ue) {
            Utils.log().warning(ue.getMessage());
        }
    }

    @Override
    public Id getData() {
        if (this.data != null) {
            return this.data;
        }
        String data = this.getArg("data");
        String[] Id1 = data.split(":");
        if (Id1.length == 2) {
            this.inner.setData(Id.newId((String)Id1[0], (String)Id1[1]));
        } else {
            WsAnalyticsContext.makeError(this.args, "Invalid Data Source", "Unknown method: " + data, null);
        }
        return this.inner.getData();
    }

    @Override
    public Predicate<Entity> getDataFilter() {
        if (this.dataFilter != null) {
            return this.dataFilter;
        }
        String dataFilter = this.getArg("dataFilter");
        if (dataFilter == null) {
            return this.dataFilter;
        }
        this.inner.setDataFilter(dataFilter);
        return this.inner.getDataFilter();
    }

    static Amap makeError(Amap map, String id, String msg, Throwable ex) {
        map.put("error", WsAnalyticsContext.makeError(id, msg, ex));
        return map;
    }

    static Amap makeError(String id, String msg, Throwable ex) {
        Amap ret = Aon.makeMap();
        if (id != null) {
            ret.put("id", id);
        }
        if (msg != null) {
            ret.put("display", msg);
        }
        if (ex != null) {
            ret.put("details", ex);
        }
        return ret;
    }

    @Override
    public BINavNode getNode() {
        if (this.node != null) {
            return this.node;
        }
        BOrd ord = BOrd.make((String)this.getArg("node"));
        BComponent node = ord.resolve((BObject)Sys.getStation()).getComponent();
        this.inner.setNode((BINavNode)node);
        return this.inner.getNode();
    }

    @Override
    public Combination getAggregation(boolean force) {
        String aggType = this.getArg("aggregation");
        if (aggType == null) {
            return this.getDataPolicy().getDefaultAggregation();
        }
        this.aggregation = BCombination.make(aggType);
        return this.aggregation;
    }

    @Override
    public BString getSeriesName() {
        this.inner.setSeriesName(BFormat.make((String)(this.args.get("seriesName") != null ? this.args.get("seriesName").toString() : "%node.navDisplayName%-%data.name%")));
        return this.inner.getSeriesName();
    }

    @Override
    public Context getBase() {
        if (this.inner == null) {
            return null;
        }
        return this.inner.getBase();
    }

    @Override
    public Interval getInterval(boolean force) {
        String interval1 = this.getArg("interval");
        if (interval1 == null) {
            return BInterval.fifteenMinutes;
        }
        this.interval = BInterval.make(interval1);
        return this.interval;
    }

    @Override
    public Combination getRollup(boolean force) {
        String rollUpType;
        String string = rollUpType = this.getArg("rollup") == null ? this.getArg("rollUp") : this.getArg("rollup");
        if (rollUpType == null) {
            return this.getDataPolicy().getDefaultRollup();
        }
        this.rollup = BCombination.make(rollUpType);
        return this.rollup;
    }

    @Override
    public TimeRange getTimeRange(boolean force) {
        String timeR;
        String string = timeR = this.getArg("timerange") == null ? this.getArg("timeRange") : this.getArg("timerange");
        if (timeR == null && force) {
            return BAnalyticTimeRange.today;
        }
        this.timeRange = BAnalyticTimeRange.make(timeR);
        return this.timeRange;
    }

    @Override
    public BUnit getUnit(boolean force) {
        if (this.unit != null) {
            return this.unit;
        }
        if (!force) {
            return null;
        }
        BUnit ret = (BUnit)this.getDataPolicy().getFacets().get("units");
        if (ret != null) {
            return ret;
        }
        return BUnit.NULL;
    }

    @Override
    public BDaysOfWeekBits getDowInclusion() {
        if (this.dowInclusion != null) {
            return this.dowInclusion;
        }
        String dow = this.getArg("dow");
        if (dow != null) {
            if (dow.matches("^[0-1]{1,7}$")) {
                BDaysOfWeekBits temp;
                int bits = Integer.parseInt(String.format("%1$-7s", dow).replaceAll(" ", "0"), 2);
                this.dowInclusion = temp = BDaysOfWeekBits.make((int)bits);
                this.inner.setDowInclusion(temp);
            } else {
                WsAnalyticsContext.makeError(this.args, "Invalid DOW inclusion format", "Using default value of 1111111", null);
            }
        }
        return this.inner.getDowInclusion();
    }

    public AnalyticContext getAnalyticContext() {
        return this.inner;
    }

    protected String getArg(String param) {
        return this.args.getString(param);
    }

    protected String getArg(String param, String def) {
        return this.args.get(param, def);
    }

    protected String[] getArgs(String param) {
        Aobj obj = this.args.get(param);
        if (obj == null) {
            return null;
        }
        if (obj.isList()) {
            ArrayList<String> list = new ArrayList<String>();
            Iterator<Aobj> it = obj.toList().iterator();
            while (it.hasNext()) {
                list.add(it.next().toString());
            }
            if (list.isEmpty()) {
                return null;
            }
            return list.toArray(new String[0]);
        }
        return new String[]{obj.toString()};
    }
}

