/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ws;

import com.tridiumx.analytics.aon.Alist;
import com.tridiumx.analytics.aon.Amap;
import com.tridiumx.analytics.aon.Aobj;
import com.tridiumx.analytics.aon.Aon;
import com.tridiumx.analytics.data.AbstractAnalyticValue;
import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.time.TimeBinding;
import com.tridiumx.analytics.util.StatusUtils;
import com.tridiumx.analytics.util.WrapperException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.TreeSet;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.history.BIHistory;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdTarget;
import javax.baja.nav.BINavNode;
import javax.baja.status.BIStatusValue;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

class Encoder {
    private static final String TYPE_BOOL = "boolean";
    private static final String TYPE_ENUM = "enum";
    private static final String TYPE_NUM = "numeric";
    private static final String TYPE_STR = "string";
    private static final String TYPE_STS = "status";
    private static final String TYPE_TIME = "time";
    private static final byte skipBits = 6;

    private Encoder() {
    }

    public static void encodeUnit(AnalyticContext cx, Amap map) {
        BUnit u = cx.getUnit(true);
        if (u != null && !u.isNull()) {
            Amap units = map.putMap("unit");
            units.put("name", u.getUnitName());
            units.put("symbol", u.getSymbol());
        } else {
            map.remove("unit");
        }
    }

    public static void encodeValue(Object val, AnalyticContext cx, Amap map) {
        BFacets f = cx.getFacets();
        Encoder.addValue(map, "value", val, f);
        StatusUtils.getBits(val);
        map.put(TYPE_STS, StatusUtils.toString(val));
        map.put("seriesName", cx.getSeriesName().toString());
        if (val instanceof BObject) {
            map.put("display", ((BObject)val).toString((Context)f));
        }
        if (val instanceof NumericValue) {
            Encoder.encodeUnit(cx, map);
        }
    }

    public static void encodeTrend(AnalyticTrend trend, AnalyticContext cx, Amap map) {
        BFacets f = cx.getFacets();
        Alist rows = map.putList("rows");
        BStatus sts = BStatus.ok;
        while (trend.hasNext()) {
            AnalyticValue val = trend.next();
            BAbsTime ts = BAbsTime.make((long)val.getTimestamp());
            Object value1 = val.getValue();
            Alist row = rows.addList();
            row.add(Encoder.toString(ts));
            Encoder.addValue(row, value1, f);
            sts = BStatus.make((int)val.getStatus());
            row.add(Encoder.toString(sts));
            if (val instanceof AbstractAnalyticValue) {
                row.add(((AbstractAnalyticValue)val).getTrendFlags().toString());
            }
            map.put("seriesName", cx.getSeriesName().toString());
        }
        Encoder.encodeUnit(cx, map);
    }

    public static void encodeAlarm(BAlarmRecord alarm, Amap map, Context cx) {
        try {
            BFacets data;
            BObject tmp;
            map.put("uuid", alarm.getUuid().encodeToString());
            map.put("timestamp", alarm.getTimestamp().encodeToString());
            map.put("lastUpdated", alarm.getLastUpdate().encodeToString());
            map.put("priority", alarm.getPriority());
            map.put("alarmClass", alarm.getAlarmClass());
            map.put("ackState", alarm.getAckState().getDisplayTag(cx));
            if (!alarm.getAckTime().isNull()) {
                map.put("ackTime", alarm.getAckTime().encodeToString());
                map.put("ackUser", String.valueOf(alarm.getUser()));
            }
            if (!alarm.getNormalTime().isNull()) {
                map.put("normalTime", alarm.getNormalTime().encodeToString());
            }
            map.put("alarmTransition", alarm.getAlarmTransition().getDisplayTag(cx));
            BOrdList list = alarm.getSource();
            if (list.size() > 0) {
                try {
                    map.put("source", list.encodeToString());
                    map.put("sourceState", alarm.getSourceState().getDisplayTag(cx));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((tmp = (data = alarm.getAlarmData()).get("msgText")) != null) {
                map.put("message", BFormat.format((String)tmp.toString(cx), (Object)alarm, (Context)cx));
            }
            if ((tmp = data.get("instructions")) != null) {
                map.put("instructions", BFormat.format((String)tmp.toString(cx), (Object)alarm, (Context)cx));
            }
            if ((tmp = data.get("notes")) != null) {
                map.put("notes", BFormat.format((String)tmp.toString(cx), (Object)alarm, (Context)cx));
            }
        }
        catch (Exception x) {
            WrapperException.throwRuntime(x);
        }
    }

    public static void encodeNode(OrdTarget cx, Amap map) {
        BComplex comp = cx.get().asComplex();
        map.put("name", comp.getDisplayName((Context)cx));
        map.put("icon", "/ord?" + comp.getIcon().toString((Context)cx));
        Encoder.encodeNiagaraNode(comp, cx, map);
    }

    static void encodeGraph(Amap map, BComplex cpx, BFacets facets) {
        String type = cpx.getType().toString();
        map.put("type", type);
        map.put("icon", "/ord?" + cpx.getIcon().toString((Context)facets));
        SlotCursor cur = cpx.getProperties();
        BValue obj = null;
        BFacets base = facets;
        if (base == null) {
            base = BFacets.NULL;
        }
        while (cur.next()) {
            obj = cur.get();
            Property p = cur.property();
            Amap kid = map.putMap(p.getName());
            facets = BFacets.make((BFacets)base, (BFacets)cpx.getSlotFacets((Slot)p));
            kid.put("display", cpx.getDisplayName((Slot)p, (Context)facets));
            if (obj instanceof BComplex) {
                Encoder.encodeGraph(kid, (BComplex)obj, facets);
                continue;
            }
            if (!(obj instanceof BSimple)) continue;
            Encoder.encodeGraph(kid, (BSimple)obj, facets);
        }
    }

    public static void encodeQuery(OrdTarget result, Amap map) {
        BObject obj = result.get();
        if (obj instanceof BITable) {
            Encoder.encodeQuery((BITable)obj, map);
        } else {
            Encoder.addValue(map.putList("rows").addList(), obj, Encoder.getFacets(result));
        }
    }

    static void encodeQuery(BITable<?> table, Amap res) {
        String tmp;
        long start = System.currentTimeMillis();
        Alist columns = res.putList("columns");
        Column[] cols = table.getColumns().list();
        int len = cols.length;
        BObject val = null;
        TableCursor cur = table.cursor();
        boolean hasRow = cur.next();
        BFacets[] facets = new BFacets[len];
        int ordIdx = -1;
        for (int i = 0; i < len; ++i) {
            Amap col = columns.addMap();
            tmp = cols[i].getDisplayName(null);
            col.put("name", tmp);
            if (ordIdx < 0 && (tmp = tmp.toLowerCase()).equals("ord")) {
                ordIdx = i;
            }
            if (!hasRow) continue;
            val = (BObject)cur.cell(cols[i]);
            tmp = Encoder.getPrimitiveType(val);
            if (tmp == null) {
                tmp = TYPE_STR;
            }
            col.put("type", tmp);
            facets[i] = BFacets.make((BFacets)table.getTableFacets(), (BFacets)cols[i].getFacets());
            Encoder.encodeMeta(tmp, col, facets[i]);
        }
        Alist rows = res.putList("rows");
        int count = 0;
        BStation subscriberBase = Sys.getStation();
        BObject toSubscribe = null;
        while (hasRow) {
            Alist row = rows.addList();
            for (int i = 0; i < len; ++i) {
                try {
                    val = (BObject)cur.cell(cols[i]);
                    if (i == ordIdx) {
                        try {
                            toSubscribe = null;
                            if (val instanceof BOrd) {
                                toSubscribe = ((BOrd)val).get((BObject)subscriberBase);
                            } else {
                                tmp = val.toString(null);
                                if (tmp.length() > 0) {
                                    toSubscribe = BOrd.make((String)tmp).get((BObject)subscriberBase);
                                }
                            }
                            if (toSubscribe instanceof BComponent && !toSubscribe.asComponent().isSubscribed()) {
                                toSubscribe.asComponent().lease();
                            }
                        }
                        catch (Exception weTried) {
                            ordIdx = -1;
                        }
                    }
                    Encoder.addValue(row, val, facets[i]);
                    continue;
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            if (++count % 100 == 0) {
                if (System.currentTimeMillis() - start > 300000L) break;
                Thread.yield();
            }
            hasRow = cur.next();
        }
    }

    static void encodeGraph(Amap map, BSimple simple, BFacets facets) {
        String type = Encoder.getPrimitiveType(simple);
        map.put("type", type);
        map.put("icon", "/ord?" + simple.getIcon().toString((Context)facets));
        if (facets != null) {
            Encoder.encodeMeta(type, map, facets);
        }
        Encoder.addValue(map, "value", simple, facets);
    }

    static void encodeMeta(String type, Amap map, BFacets facets) {
        BEnumRange r;
        if (type == TYPE_NUM) {
            double d;
            BUnit u = (BUnit)facets.get("units", null);
            if (u != null && !u.isNull()) {
                Amap units = map.putMap("unit");
                units.put("name", u.getUnitName());
                units.put("symbol", u.getSymbol());
            }
            if (!Double.isInfinite(d = facets.getd("min", Double.NEGATIVE_INFINITY))) {
                map.put("min", d);
            }
            if (!Double.isInfinite(d = facets.getd("max", Double.POSITIVE_INFINITY))) {
                map.put("max", d);
            }
        } else if (type == TYPE_BOOL) {
            if (facets.get("trueText", null) != null) {
                map.put("trueText", facets.get("trueText").toString(null));
            }
            if (facets.get("falseText", null) != null) {
                map.put("falseText", facets.get("falseText").toString(null));
            }
        } else if (type == TYPE_ENUM && (r = (BEnumRange)facets.get("range", null)) != null) {
            Alist rangeList = map.putList("range");
            int[] ints = r.getOrdinals();
            for (int i = 0; i < ints.length; ++i) {
                rangeList.add(r.getDisplayTag(ints[i], null));
            }
        }
    }

    static void encodeNiagaraNode(BComplex node, OrdTarget cx, Amap map) {
        if (node instanceof BINavNode) {
            BINavNode nav = (BINavNode)node;
            map.put("hasChildren", nav.getNavChildren().length > 0);
        } else {
            map.put("hasChildren", false);
        }
        Property[] props = node.getPropertiesArray();
        Alist dataList = null;
        for (int i = 0; i < props.length; ++i) {
            String s;
            BOrd ord;
            OrdTarget target;
            BValue obj = node.get(props[i]);
            if (Flags.isHidden((BComplex)node, (Slot)props[i]) || !(target = (ord = BOrd.make((String)("slot:" + props[i].getName()))).resolve((BObject)node, (Context)cx)).canRead() || (s = Encoder.getPrimitiveType(obj)) == null) continue;
            if (dataList == null) {
                dataList = map.putList("data");
            }
            String path = "slot:" + props[i].getName();
            Amap dataMap = dataList.addMap();
            dataMap.put("data", path);
            dataMap.put("name", node.getDisplayName((Slot)props[i], (Context)cx));
            dataMap.put("type", s);
            dataMap.put("icon", "/ord?" + obj.getIcon().toString((Context)cx));
            dataMap.put("hasTrend", Encoder.getHistory((BObject)obj) != null);
            Encoder.encodeMeta(s, dataMap, Encoder.getFacets(target));
        }
        ActionSpec[] actions = Encoder.getActions(cx);
        int len = 0;
        Alist actionList = null;
        if (actions != null && actions.length > 0) {
            len = actions.length;
            actionList = map.putList("actions");
        }
        for (int i = 0; i < len; ++i) {
            Amap action = actionList.addMap();
            action.put("action", actions[i].getName());
            action.put("display", actions[i].getDisplay());
            if (actions[i].hasParameter()) {
                Amap param = action.putMap("parameter");
                BObject arg = actions[i].getParameter();
                if (arg.isSimple()) {
                    Encoder.encodeGraph(param, (BSimple)arg, actions[i].getFacets());
                } else if (arg.isComplex()) {
                    Encoder.encodeGraph(param, (BComplex)arg, actions[i].getFacets());
                }
            }
            if (!actions[i].hasReturn()) continue;
            action.put("resultType", actions[i].getReturnType());
        }
    }

    static BValue getActionParameter(BComponent comp, Action action) {
        BValue parm = null;
        try {
            parm = comp.getActionParameterDefault(action);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (parm == null) {
                parm = action.getParameterDefault();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (parm == null) {
                parm = (BValue)action.getParameterType().getInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parm;
    }

    static String getPrimitiveType(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BIStatusValue) {
            o = ((BIStatusValue)o).getStatusValue().getValueValue();
        }
        if (o instanceof BINumeric) {
            return TYPE_NUM;
        }
        if (o instanceof BIBoolean) {
            return TYPE_BOOL;
        }
        if (o instanceof BIEnum) {
            return TYPE_ENUM;
        }
        if (o instanceof BString) {
            return TYPE_STR;
        }
        if (o instanceof BAbsTime) {
            return TYPE_TIME;
        }
        if (o instanceof BRelTime) {
            return TYPE_NUM;
        }
        if (o instanceof BStatus) {
            return TYPE_STS;
        }
        if (o instanceof BSimple) {
            return ((BSimple)o).getType().toString();
        }
        return null;
    }

    private static Alist addValue(Alist list, Object obj, BFacets f) {
        if (obj == null) {
            return list.add((Aobj)null);
        }
        return list.add(Encoder.getValue(obj, f));
    }

    public static Amap addValue(Amap map, String key, Object obj, BFacets f) {
        if (obj == null) {
            return map.put(key, (Aobj)null);
        }
        return map.put(key, Encoder.getValue(obj, f));
    }

    private static ActionSpec[] getActions(OrdTarget target) {
        BObject o = target.get();
        TreeSet<ActionSpec> ret = null;
        if (o instanceof BComponent) {
            ret = Encoder.getActions(o.asComponent(), target);
        }
        if (ret == null) {
            ret = new TreeSet();
        }
        if (ret == null || ret.size() == 0) {
            return new ActionSpec[0];
        }
        return ret.toArray(new ActionSpec[0]);
    }

    private static TreeSet<ActionSpec> getActions(BComponent comp, OrdTarget target) {
        TreeSet<ActionSpec> ret = new TreeSet<ActionSpec>();
        if (!target.canInvoke()) {
            return ret;
        }
        Action[] ary = comp.getActionsArray();
        for (int i = 0; i < ary.length; ++i) {
            if (Flags.isHidden((BComplex)comp, (Slot)ary[i])) continue;
            BValue parm = Encoder.getActionParameter(comp, ary[i]);
            ret.add(Encoder.makeActionSpec(comp, ary[i], parm));
        }
        return ret;
    }

    static BFacets getFacets(BObject o) {
        BEnumRange r;
        BFacets tmp;
        BIHistory h;
        BFacets ret;
        if (o instanceof BIHistory && (ret = (BFacets)(h = (BIHistory)o).getConfig().get("valueFacets")) != null) {
            return ret;
        }
        if (o instanceof BIBoolean) {
            tmp = ((BIBoolean)o).getBooleanFacets();
            if (tmp != null && !tmp.isNull()) {
                if (!tmp.gets("trueText", "true").equalsIgnoreCase("true")) {
                    return tmp;
                }
                if (!tmp.gets("falseText", "false").equalsIgnoreCase("false")) {
                    return tmp;
                }
            }
        } else if (o instanceof BIEnum && (tmp = ((BIEnum)o).getEnumFacets()) != null && (r = (BEnumRange)tmp.get("range", null)) != null && !r.isNull()) {
            return tmp;
        }
        if (o instanceof BINumeric && !(tmp = ((BINumeric)o).getNumericFacets()).isNull()) {
            return tmp;
        }
        if (o instanceof BIStatusValue && !(tmp = ((BIStatusValue)o).getStatusValueFacets()).isNull()) {
            return tmp;
        }
        return BFacets.NULL;
    }

    private static BFacets getFacets(OrdTarget target) {
        BFacets f = Encoder.getFacets(target.get());
        if (!f.isNull()) {
            return f;
        }
        Property slot = target.getPropertyInParent();
        BComplex parent = target.getParent();
        if (parent != null && slot != null && !(f = parent.getSlotFacets((Slot)slot)).isNull()) {
            return f;
        }
        slot = target.getSlotInComponent();
        parent = target.getComponent();
        if (parent != null && slot != null && !(f = parent.getSlotFacets((Slot)slot)).isNull()) {
            return f;
        }
        return target.getFacets();
    }

    private static BIHistory getHistory(BObject obj) {
        BComponent comp;
        Object[] ary;
        if (obj instanceof BIHistory) {
            return (BIHistory)obj;
        }
        if (obj instanceof BComponent && (ary = (comp = obj.asComponent()).getChildren(BHistoryExt.class)) != null && ary.length > 0) {
            return ((BHistoryExt)ary[0]).getHistory();
        }
        return null;
    }

    private static Aobj getValue(Object o, BFacets cx) {
        if (o instanceof BINumeric) {
            double d = ((BINumeric)o).getNumeric();
            if (cx != null && cx.get("precision", null) != null) {
                int pr = cx.geti("precision", 2);
                BigDecimal bd = BigDecimal.valueOf(d);
                d = bd.setScale(pr, RoundingMode.HALF_UP).doubleValue();
            }
            return Aon.make(d);
        }
        if (o instanceof BIStatusValue) {
            o = ((BIStatusValue)o).getStatusValue().getValueValue();
        }
        if (o instanceof BIBoolean) {
            return Aon.make(((BIBoolean)o).getBoolean());
        }
        if (o instanceof BIEnum) {
            BEnum e = ((BIEnum)o).getEnum();
            int ord = e.getOrdinal();
            BEnumRange r = (BEnumRange)cx.getFacets().get("range");
            if (r != null && r.isOrdinal(ord)) {
                return Aon.make(r.getDisplayTag(ord, null));
            }
            return Aon.make(((BIEnum)o).getEnum().getDisplayTag(null));
        }
        if (o instanceof BAbsTime) {
            return Aon.make(Encoder.toString((BAbsTime)o));
        }
        if (o instanceof BRelTime) {
            return Aon.make(((BRelTime)o).getMillis());
        }
        if (o instanceof BStatus) {
            return Aon.make(Encoder.toString((BStatus)o));
        }
        if (o instanceof BSimple) {
            try {
                return Aon.make(((BSimple)o).encodeToString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (o instanceof BObject) {
            return Aon.make(((BObject)o).toString(null));
        }
        return Aon.make(o.toString());
    }

    private static ActionSpec makeActionSpec(BComponent comp, Action a, BValue arg) {
        String name = a.getName();
        String display = comp.getDisplayName((Slot)a, null);
        String ret = null;
        Type t = a.getReturnType();
        if (t != null) {
            try {
                ret = Encoder.getPrimitiveType(t.getInstance());
                if (ret == null) {
                    ret = t.toString();
                }
            }
            catch (Exception x) {
                ret = t.toString();
            }
        }
        return new ActionSpec(name, display, (BObject)arg, ret, comp.getSlotFacets((Slot)a));
    }

    private static String toString(BAbsTime time) {
        return TimeBinding.toString(time.getMillis());
    }

    private static String toString(BStatus status) {
        return StatusUtils.toString(status.getBits());
    }

    static class ActionSpec
    implements Comparable<Object> {
        String name;
        String display;
        BFacets facets;
        BObject in;
        String out;

        public ActionSpec(String name, String display, BObject in, String out, BFacets facets) {
            this.name = name;
            this.display = display;
            this.in = in;
            this.out = out;
            this.facets = facets;
        }

        @Override
        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }

        public String getDisplay() {
            return this.display;
        }

        public BFacets getFacets() {
            return this.facets;
        }

        public String getName() {
            return this.name;
        }

        public BObject getParameter() {
            return this.in;
        }

        public String getParameterType() {
            String s = Encoder.getPrimitiveType(this.in);
            if (s == null) {
                s = this.in.getType().toString();
            }
            return s;
        }

        public String getReturnType() {
            return this.out;
        }

        public boolean hasParameter() {
            return this.in != null;
        }

        public boolean hasReturn() {
            return this.out != null;
        }

        public String toString() {
            return this.name;
        }
    }
}

