/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.util;

import com.tridiumx.analytics.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.baja.sys.BDouble;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class CachedTrend
implements AnalyticConstants {
    private static final BDouble one = BDouble.make((double)1.0);
    private AnalyticContext cx;
    private List<AnalyticValue> values = new ArrayList<AnalyticValue>();

    private CachedTrend(AnalyticContext cx) {
        this.cx = cx;
    }

    public static CachedTrend make(AnalyticTrend arg) {
        AnalyticValue val;
        AnalyticContext cx = arg.getContext().newCopy();
        long end = cx.getEndTime();
        CachedTrend ret = new CachedTrend(cx);
        while (arg.hasNext() && !Utils.isEnded((val = arg.next()).getTimestamp(), end)) {
            val = val.newCopy();
            ret.values.add(val);
        }
        return ret;
    }

    public AnalyticTrend newTrend() {
        return new MyTrend();
    }

    private class MyTrend
    implements AnalyticTrend {
        private Iterator<AnalyticValue> iterator;

        MyTrend() {
            this.iterator = CachedTrend.this.values.iterator();
        }

        @Override
        public AnalyticContext getContext() {
            return CachedTrend.this.cx;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public AnalyticValue next() {
            return this.iterator.next();
        }

        @Override
        public AnalyticTrend setContext(AnalyticContext cx) {
            throw new IllegalStateException(Utils.lex("cannotSetContext"));
        }

        @Override
        public void close() {
        }
    }
}

