/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.trend;

import com.tridiumx.analytics.data.AbstractAnalyticValue;
import com.tridiumx.analytics.history.BInterpolationTrendFlags;
import com.tridiumx.analytics.trend.AggregateTrend;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.baja.sys.BAbsTime;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.Combiner;
import javax.bajax.analytics.time.BInterval;
import javax.bajax.analytics.time.Interval;

public class IgnoredAggregateTrend
extends AggregateTrend {
    private long startTime;
    private long endTime;
    private long currentTime;
    private long currentTS;
    private BInterval interval = BInterval.none;
    protected AnalyticValue[] aggregatedValues;
    private long minTimestamp;

    public IgnoredAggregateTrend(Collection<AnalyticTrend> trends) {
        super(trends);
    }

    public IgnoredAggregateTrend(Collection<AnalyticTrend> trends, Combiner combiner) {
        super(trends, combiner);
    }

    @Override
    public AnalyticContext getContext() {
        return this.trends[0].getContext();
    }

    @Override
    protected void init() {
        super.init();
        AnalyticContext ctx = this.getContext();
        this.startTime = this.currentTS = ctx.getStartTime();
        this.endTime = ctx.getEndTime();
        this.currentTime = BAbsTime.now().getMillis();
        this.endTime = this.endTime < 0L || this.endTime > this.currentTime ? this.currentTime : this.endTime;
        this.interval = (BInterval)this.getInterval();
        this.aggregatedValues = new AnalyticValue[this.trends.length];
        this.computeMinTimestamp();
    }

    @Override
    public boolean hasNext() {
        boolean flag;
        boolean bl = flag = this.currentTS < this.endTime;
        if (flag) {
            if (this.findNextTs() == -1L) {
                return false;
            }
            boolean hasAtLeastOneValue = false;
            int len = this.aggregatedValues.length;
            for (int i = 0; i < len; ++i) {
                if (this.aggregatedValues[i] == null) continue;
                hasAtLeastOneValue = true;
            }
            return hasAtLeastOneValue;
        }
        return false;
    }

    @Override
    protected AnalyticValue getNext() {
        this.combiner.reset();
        int counter = 0;
        int len = this.aggregatedValues.length;
        for (int i = 0; i < len; ++i) {
            if (this.aggregatedValues[i] == null) continue;
            this.combiner.update(this.aggregatedValues[i]);
            ++counter;
        }
        AbstractAnalyticValue ret = (AbstractAnalyticValue)this.combiner.getValue();
        if (counter != this.aggregatedValues.length) {
            ret.setTrendFlags(BInterpolationTrendFlags.make(ret.getTrendFlags().getBits() | 4));
        }
        return ret;
    }

    @Override
    protected long findNextTs() {
        boolean hasAtLeastOneVal = false;
        for (int tIndex = 0; tIndex < this.trends.length; ++tIndex) {
            AnalyticTrend trend = this.trends[tIndex];
            if (trend == null) {
                this.aggregatedValues[tIndex] = null;
                continue;
            }
            AnalyticValue val = this.values[tIndex];
            if (val == null) {
                if (trend.hasNext()) {
                    AnalyticValue record = trend.next();
                    long nextRecTs = record.getTimestamp();
                    if (!this.interval.equals(BInterval.none)) {
                        nextRecTs = this.interval.next(nextRecTs);
                    }
                    if (nextRecTs < this.endTime && nextRecTs < this.currentTime) {
                        this.values[tIndex] = val = record;
                        this.computeMinTimestamp();
                    } else {
                        this.values[tIndex] = null;
                        this.aggregatedValues[tIndex] = null;
                    }
                } else {
                    this.values[tIndex] = null;
                    this.aggregatedValues[tIndex] = null;
                }
            }
            if (val == null) continue;
            long recTs = val.getTimestamp();
            if (!this.interval.equals(BInterval.none)) {
                if (recTs == this.currentTS) {
                    this.aggregatedValues[tIndex] = val;
                    hasAtLeastOneVal = true;
                    this.values[tIndex] = null;
                    continue;
                }
                this.aggregatedValues[tIndex] = null;
                continue;
            }
            if (recTs == this.minTimestamp) {
                this.aggregatedValues[tIndex] = val.newCopy();
                hasAtLeastOneVal = true;
                if (trend.hasNext()) {
                    AnalyticValue record = trend.next();
                    long nextRecTs = record.getTimestamp();
                    if (nextRecTs < this.endTime && nextRecTs < this.currentTime) {
                        this.values[tIndex] = record;
                        continue;
                    }
                    this.values[tIndex] = null;
                    continue;
                }
                this.values[tIndex] = null;
                continue;
            }
            this.aggregatedValues[tIndex] = null;
        }
        if (!this.interval.equals(BInterval.none)) {
            this.currentTS = this.interval.next(this.currentTS);
        } else {
            boolean allAggsNullValues = Arrays.stream(this.aggregatedValues).allMatch(value -> value == null);
            if (!allAggsNullValues) {
                this.computeMinTimestamp();
            }
            long l = this.currentTS = allAggsNullValues ? this.endTime : this.minTimestamp;
        }
        if (this.interval.equals(BInterval.none)) {
            return this.currentTS;
        }
        if (!hasAtLeastOneVal && this.currentTS < this.endTime) {
            return this.findNextTs();
        }
        return this.currentTS;
    }

    private void computeMinTimestamp() {
        Optional<AnalyticValue> optional = Arrays.stream(this.values).filter(Objects::nonNull).min((v1, v2) -> {
            if (v1 != null && v2 != null) {
                return Long.compare(v1.getTimestamp(), v2.getTimestamp());
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            return 0;
        });
        this.minTimestamp = optional.isPresent() ? optional.get().getTimestamp() : this.endTime;
    }

    private Interval getInterval() {
        return this.trends[0].getContext().getInterval(true);
    }
}

