/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.naming;

import com.tridium.collection.GenericColumn;
import com.tridium.collection.GenericColumnList;
import com.tridiumx.analytics.history.BInterpolationTrendFlags;
import com.tridiumx.analytics.naming.AnalyticMultiTrendCursor;
import com.tridiumx.analytics.naming.BAbstractTrendResolver;
import com.tridiumx.analytics.naming.BAnalyticTrendRecord;
import com.tridiumx.analytics.util.Utils;
import java.util.List;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.MultiAnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;

@NiagaraType
public class BAnalyticMultiTrendResolver
extends BAbstractTrendResolver {
    @Generated
    public static final Type TYPE = Sys.loadType(BAnalyticMultiTrendResolver.class);
    protected MultiAnalyticContext mcx;
    protected List<BFacets> trendFacets;
    private AnalyticMultiTrendCursor cursor;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAnalyticMultiTrendResolver() {
    }

    public BAnalyticMultiTrendResolver(AnalyticTrend trend, MultiAnalyticContext mcx, List<BFacets> trendFacets) {
        this(trend, mcx, trendFacets, true);
    }

    public BAnalyticMultiTrendResolver(AnalyticTrend trend, MultiAnalyticContext mcx, List<BFacets> trendFacets, boolean cursorInit) {
        this.trend = trend;
        this.mcx = mcx;
        this.trendFacets = trendFacets;
        if (cursorInit) {
            this.cursor = new AnalyticMultiTrendCursor((BITable<BAnalyticTrendRecord>)this, trend, trendFacets, mcx);
        }
    }

    public TableCursor<BAnalyticTrendRecord> cursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        this.cursor = new AnalyticMultiTrendCursor((BITable<BAnalyticTrendRecord>)this, this.trend, this.trendFacets, this.mcx);
        return this.cursor;
    }

    public ColumnList getColumns() {
        int valColCount = !this.mcx.getAggMode() ? this.trendFacets.size() : 1;
        Lexicon lex = Lexicon.make((String)"analytics", (Context)this.mcx);
        GenericColumn[] cols = new GenericColumn[1 + valColCount * 3];
        int counter = 0;
        cols[counter++] = new GenericColumn("timestamp", lex.get("trendTable.timestamp"), BAbsTime.DEFAULT.getType(), 0, Utils.timeFacets);
        if (this.mcx != null && this.mcx.getAggMode()) {
            cols[counter++] = new GenericColumn("value", lex.get("trendTable.value"), BValue.TYPE, 0, BFacets.NULL);
            cols[counter++] = new GenericColumn("status", lex.get("trendTable.status"), BValue.TYPE, 0, BFacets.NULL);
            cols[counter++] = new GenericColumn("trendFlags", lex.get("trendTable.interpolationTrendFlags"), BValue.TYPE, 0, BFacets.NULL);
        } else {
            List<AnalyticContext> roots = this.cursor.getNodeContextList(this.mcx);
            for (int i = 0; i < valColCount; ++i) {
                String seriesName = roots.get(i).getSeriesName().getString();
                if (seriesName == null || "".equals(seriesName.trim())) {
                    seriesName = roots.get(i).getNode().getNavDisplayName(null);
                }
                cols[counter++] = new GenericColumn("value" + (i + 1), seriesName, BValue.TYPE, 0, BFacets.NULL);
                cols[counter++] = new GenericColumn("status" + (i + 1), seriesName + " status", BStatus.ok.toDataValue().getType(), 0, BFacets.NULL);
                cols[counter++] = new GenericColumn("tf" + (i + 1), seriesName + " tf", BInterpolationTrendFlags.DEFAULT.toDataValue().getType(), 0, BFacets.NULL);
            }
        }
        return new GenericColumnList(cols);
    }

    public BFacets getTableFacets() {
        BFacets facets = this.trendFacets.get(0);
        if (this.mcx != null && !this.mcx.getAggMode()) {
            facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)"mt", (BIDataValue)BBoolean.TRUE, (String)"tc", (BIDataValue)BInteger.make((int)this.trendFacets.size())));
        }
        return facets;
    }
}

