/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.naming;

import com.tridium.seriestransform.IntervalSeriesCursor;
import com.tridiumx.analytics.data.AbstractAnalyticValue;
import com.tridiumx.analytics.data.Values;
import com.tridiumx.analytics.naming.BAnalyticTrendRecord;
import javax.baja.collection.AbstractRow;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.Row;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BInteger;
import javax.baja.sys.Slot;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class AnalyticTrendCursor
extends IntervalSeriesCursor<BAnalyticTrendRecord> {
    public static final String SERIES_NAME_FACET = "seriesName";
    private BTimeZone timeZone;
    protected BAnalyticTrendRecord aVal;
    protected BAnalyticTrendRecord firstRecord;
    protected BAnalyticTrendRecord lastRecord;
    protected AnalyticTrend trend;
    protected AnalyticContext context;
    protected boolean isFirstRecord = true;

    protected AnalyticTrendCursor(BITable<BAnalyticTrendRecord> series, AnalyticTrend trend, BFacets facets, AnalyticContext ctx) {
        super(series);
        this.trend = trend;
        this.context = ctx;
        if (trend.hasNext()) {
            AnalyticValue temp = trend.next();
            this.init(facets, temp);
        }
    }

    protected AnalyticTrendCursor(BITable<BAnalyticTrendRecord> series, AnalyticTrend trend, BFacets facets) {
        this(series, trend, facets, trend.getContext());
    }

    protected boolean advanceCursor() {
        if (this.isFirstRecord && this.aVal != null) {
            this.isFirstRecord = false;
            return true;
        }
        if (this.trend.hasNext()) {
            AnalyticValue temp = this.trend.next();
            this.lastRecord = this.aVal = new BAnalyticTrendRecord(BAbsTime.make((long)temp.getTimestamp()), Values.getSimple(temp), BStatus.make((int)temp.getStatus()), ((AbstractAnalyticValue)temp).getTrendFlags());
            return true;
        }
        return false;
    }

    public Row<BAnalyticTrendRecord> row() {
        class AnalyticRow<T extends BAnalyticTrendRecord>
        extends AbstractRow<T> {
            final /* synthetic */ AnalyticTrendCursor this$0;

            protected AnalyticRow(BITable<T> table, T rowObject) {
                this.this$0 = this$0;
                super(table, rowObject);
            }

            public BIObject cell(Column column) {
                BAnalyticTrendRecord record = (BAnalyticTrendRecord)this.rowObject();
                if (null == record) {
                    return null;
                }
                return record.get(column.getName());
            }

            public BFacets getCellFacets(Column column) {
                BAnalyticTrendRecord currentRecord = (BAnalyticTrendRecord)this.rowObject();
                if (null == currentRecord) {
                    return BFacets.NULL;
                }
                String name = column.getName();
                Slot slot = currentRecord.getSlot(name);
                return currentRecord.getSlotFacets(slot);
            }

            public Row<T> safeCopy() {
                BAnalyticTrendRecord newCopy = (BAnalyticTrendRecord)((BAnalyticTrendRecord)this.rowObject()).newCopy().asComplex();
                return new AnalyticRow(this.this$0, this.getTable(), newCopy);
            }
        }
        return new AnalyticRow(this, this.getTable(), this.aVal);
    }

    protected BTimeZone getTimeZone() {
        return this.timeZone;
    }

    protected void init(BFacets facets, AnalyticValue temp) {
        if (temp != null) {
            BAbsTime time = BAbsTime.make((long)temp.getTimestamp());
            this.timeZone = time.getTimeZone();
            this.aVal = new BAnalyticTrendRecord(time, Values.getSimple(temp), BStatus.make((int)temp.getStatus()), ((AbstractAnalyticValue)temp).getTrendFlags());
            this.aVal.setFacets(this.aVal.getSlot("timestamp"), BFacets.make((String)"TimeZone", (BIDataValue)this.timeZone));
            BFacets valueFacets = BFacets.DEFAULT;
            BUnit inUnit = (BUnit)facets.get("units");
            valueFacets = BFacets.make((BFacets)valueFacets, (BFacets)BFacets.make((String)"units", (BIDataValue)(inUnit == null ? BUnit.NULL : inUnit), (String)"precision", (BIDataValue)BInteger.make((int)2)));
            String seriesName = String.valueOf(facets.get(SERIES_NAME_FACET));
            valueFacets = BFacets.make((BFacets)valueFacets, (BFacets)BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)SERIES_NAME_FACET, (String)seriesName)));
            this.aVal.setFacets(this.aVal.getSlot("value"), valueFacets);
            this.firstRecord = this.aVal;
        }
    }

    public final BAnalyticTrendRecord getFirstRecord() {
        return this.firstRecord;
    }

    public final BAnalyticTrendRecord getLastRecord() {
        return this.lastRecord;
    }
}

