/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.data.substitute;

import com.tridiumx.analytics.data.AbstractAnalyticValue;
import com.tridiumx.analytics.data.BooleanValue;
import com.tridiumx.analytics.data.EnumValue;
import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.data.ObjectValue;
import com.tridiumx.analytics.data.substitute.AnalyticValueEntry;
import com.tridiumx.analytics.data.substitute.AnalyticValueWrapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import javax.baja.status.BStatus;
import javax.bajax.analytics.data.AnalyticBoolean;
import javax.bajax.analytics.data.AnalyticEnum;
import javax.bajax.analytics.data.AnalyticNumeric;
import javax.bajax.analytics.data.AnalyticValue;

public class KNNLinkedList {
    private LinkedList<AnalyticValueEntry> leftEntryList;
    private LinkedList<AnalyticValueEntry> rightEntryList;
    private int knnVal;
    private Map<String, AnalyticValueWrapper> stateFrequencies;
    private Map<Long, AnalyticValue> visitedValues = new LinkedHashMap<Long, AnalyticValue>();

    public KNNLinkedList(int knnVal) {
        if (knnVal > 0) {
            this.leftEntryList = new LinkedList();
            this.rightEntryList = new LinkedList();
            this.knnVal = knnVal;
            this.stateFrequencies = new HashMap<String, AnalyticValueWrapper>();
        }
    }

    public boolean tryInsert(AnalyticValue currVal, long offset) {
        String toBeInserted;
        long rFarthestDiff;
        long curTs = currVal.getTimestamp();
        if (this.leftEntryList.size() + this.rightEntryList.size() < this.knnVal) {
            boolean leftListCurrVal = this.leftEntryList.add(new AnalyticValueEntry(currVal, offset));
            return leftListCurrVal && this.updateFrequencyMap(String.valueOf(currVal.getValue()), null, curTs, -1L);
        }
        String toBeRemoved = null;
        if (this.rightEntryList.size() == 0) {
            AnalyticValueEntry leftFirst = this.leftEntryList.removeFirst();
            toBeRemoved = String.valueOf(leftFirst.getValue().getValue());
            this.leftEntryList.addLast(new AnalyticValueEntry(currVal, offset));
            AnalyticValueEntry leftLast = this.leftEntryList.getLast();
            String toBeInserted2 = String.valueOf(leftLast.getValue().getValue());
            this.visitedValues.remove(leftFirst.getSyntheticTimestamp());
            return this.updateFrequencyMap(toBeInserted2, toBeRemoved, curTs, -1L);
        }
        if (this.isSameRecord(currVal, this.rightEntryList.getFirst().getValue(), offset)) {
            AnalyticValueEntry rightFirst = this.rightEntryList.removeFirst();
            this.leftEntryList.addLast(new AnalyticValueEntry(currVal, offset));
            this.visitedValues.put(rightFirst.getSyntheticTimestamp(), rightFirst.getValue());
            return this.updateFrequencyMap(String.valueOf(rightFirst.getValue().getValue()), String.valueOf(currVal.getValue()), curTs, -1L);
        }
        long lFarthestDiff = 0L;
        if (this.leftEntryList.size() > 0) {
            lFarthestDiff = Math.abs(currVal.getTimestamp() - this.leftEntryList.getFirst().getValue().getTimestamp());
        }
        if (lFarthestDiff >= (rFarthestDiff = Math.abs(currVal.getTimestamp() - this.rightEntryList.getLast().getValue().getTimestamp()))) {
            if (this.leftEntryList.size() > 0) {
                AnalyticValueEntry leftFirst = this.leftEntryList.removeFirst();
                toBeRemoved = String.valueOf(leftFirst.getValue().getValue());
                this.visitedValues.remove(leftFirst.getSyntheticTimestamp());
            }
            this.leftEntryList.addLast(new AnalyticValueEntry(currVal, offset));
            toBeInserted = String.valueOf(currVal.getValue());
        } else {
            AnalyticValueEntry rVal = this.rightEntryList.removeLast();
            toBeRemoved = String.valueOf(rVal.getValue().getValue());
            this.visitedValues.remove(rVal.getSyntheticTimestamp());
            this.leftEntryList.addLast(new AnalyticValueEntry(currVal, offset));
            this.visitedValues.put(rVal.getSyntheticTimestamp(), rVal.getValue());
            toBeInserted = String.valueOf(currVal.getValue());
        }
        return this.updateFrequencyMap(toBeInserted, toBeRemoved, curTs, -1L);
    }

    public boolean tryInsert(AnalyticValue currVal, long refTimeStamp, long offset) {
        long refTsFromCurrVal;
        long curTs = currVal.getTimestamp();
        if (this.getRecordByTimestamp(currVal.getTimestamp() + offset) != null) {
            return false;
        }
        if (this.rightEntryList.size() + this.leftEntryList.size() < this.knnVal) {
            AnalyticValueEntry entry = new AnalyticValueEntry(currVal, offset);
            if (this.rightEntryList.add(entry)) {
                this.updateFrequencyMap(String.valueOf(currVal.getValue()), null, curTs, refTimeStamp);
                return true;
            }
            return false;
        }
        if (this.leftEntryList.size() == 0) {
            return false;
        }
        long refTsFromFirstLeft = Math.abs(this.leftEntryList.getFirst().getValue().getTimestamp() - refTimeStamp);
        if (refTsFromFirstLeft > (refTsFromCurrVal = Math.abs(currVal.getTimestamp() - refTimeStamp))) {
            this.rightEntryList.add(new AnalyticValueEntry(currVal, offset));
            AnalyticValueEntry leftFirst = this.leftEntryList.removeFirst();
            String toBeRemoved = String.valueOf(leftFirst.getValue().getValue());
            this.updateFrequencyMap(String.valueOf(currVal.getValue()), toBeRemoved, curTs, refTimeStamp);
            return true;
        }
        return false;
    }

    public AnalyticValue getInterpolatedValue(long curTs) {
        LinkedList<Map.Entry<String, AnalyticValueWrapper>> list = new LinkedList<Map.Entry<String, AnalyticValueWrapper>>(this.stateFrequencies.entrySet());
        Collections.sort(list, (entry1, entry2) -> {
            AnalyticValueWrapper avw1 = (AnalyticValueWrapper)entry1.getValue();
            AnalyticValueWrapper avw2 = (AnalyticValueWrapper)entry2.getValue();
            if (avw1.getFrequency() < avw2.getFrequency()) {
                return 1;
            }
            if (avw1.getFrequency() > avw2.getFrequency()) {
                return -1;
            }
            if (Math.abs(curTs - avw1.getTimestamp()) > Math.abs(curTs - avw2.getTimestamp())) {
                return 1;
            }
            if (Math.abs(curTs - avw1.getTimestamp()) < Math.abs(curTs - avw2.getTimestamp())) {
                return -1;
            }
            return Long.valueOf(avw1.getTimestamp()).compareTo(avw2.getTimestamp());
        });
        return this.getAnalyticValue(list.getFirst().getKey());
    }

    public AnalyticValue getRecordByTimestamp(long currentTimestamp) {
        AnalyticValue avv = this.visitedValues.get(currentTimestamp);
        if (avv != null) {
            this.visitedValues.remove(currentTimestamp);
            return avv;
        }
        Optional<AnalyticValueEntry> avr = this.rightEntryList.stream().filter(val -> val.getSyntheticTimestamp() == currentTimestamp).findFirst();
        if (avr.isPresent()) {
            return avr.get().getValue();
        }
        Optional<AnalyticValueEntry> avl = this.leftEntryList.stream().filter(val -> val.getSyntheticTimestamp() == currentTimestamp).findFirst();
        if (avl.isPresent()) {
            return avl.get().getValue();
        }
        return null;
    }

    private boolean isSameRecord(AnalyticValue currVal, AnalyticValue valueToCompare, long offset) {
        return currVal.getTimestamp() + offset == valueToCompare.getTimestamp();
    }

    private boolean updateFrequencyMap(String toBeInserted, String toBeRemoved, long timestamp, long reference) {
        AnalyticValueWrapper toBeRemovedValue;
        AnalyticValueWrapper valueWrapper = this.stateFrequencies.get(toBeInserted);
        if (valueWrapper == null) {
            this.stateFrequencies.put(toBeInserted, new AnalyticValueWrapper(toBeInserted, 1, timestamp));
        } else {
            AnalyticValueWrapper temp = new AnalyticValueWrapper(toBeInserted);
            temp.setFrequency(valueWrapper.getFrequency() + 1);
            if (reference == -1L) {
                temp.setTimestamp(timestamp);
            } else {
                long distanceFromExisting;
                long distanceFromRef = Math.abs(timestamp - reference);
                if (distanceFromRef < (distanceFromExisting = Math.abs(valueWrapper.getTimestamp() - reference))) {
                    temp.setTimestamp(timestamp);
                } else {
                    temp.setTimestamp(valueWrapper.getTimestamp());
                }
            }
            this.stateFrequencies.put(toBeInserted, temp);
        }
        if (toBeRemoved != null && (toBeRemovedValue = this.stateFrequencies.get(toBeRemoved)) != null && toBeRemovedValue.getFrequency() > 0) {
            toBeRemovedValue.setFrequency(toBeRemovedValue.getFrequency() - 1);
        }
        return true;
    }

    private AnalyticValue getAnalyticValue(String maxKey) {
        AnalyticValue sample = null;
        if (this.leftEntryList.size() > 0) {
            sample = this.leftEntryList.getFirst().getValue().newCopy();
        } else if (this.rightEntryList.size() > 0) {
            sample = this.rightEntryList.getFirst().getValue();
        }
        AbstractAnalyticValue ret = null;
        if (sample != null) {
            int status = BStatus.ok.getBits();
            ret = sample instanceof AnalyticBoolean ? new BooleanValue(sample.getTimestamp(), Boolean.parseBoolean(maxKey), status) : (sample instanceof AnalyticEnum ? new EnumValue(sample.getTimestamp(), Integer.parseInt(maxKey), status) : (sample instanceof AnalyticNumeric ? new NumericValue(sample.getTimestamp(), Double.parseDouble(maxKey), status) : new ObjectValue(sample.getTimestamp(), maxKey, status)));
        }
        return ret;
    }
}

