/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.data;

import com.tridiumx.analytics.data.AnalyticDataSource;
import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.trend.ConstantTrend;
import java.util.Optional;
import javax.baja.data.BIDataValue;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BComponent;
import javax.baja.tag.Id;
import javax.baja.tag.Taggable;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class ValueTagDataSource
implements AnalyticDataSource {
    private AnalyticValue value = null;
    private boolean hasTrend = false;

    public ValueTagDataSource(BINavNode node, Id data) {
        Optional dv;
        if (node != null && node instanceof BComponent && (dv = ((Taggable)node).tags().get(data)).isPresent()) {
            this.value = this.parse(((BIDataValue)dv.get()).toString());
            this.hasTrend = true;
        }
    }

    public ValueTagDataSource(BIDataValue value) {
        if (value != null) {
            this.value = this.parse(value.toString());
            this.hasTrend = true;
        }
    }

    private NumericValue parse(String number) {
        double n = 0.0;
        try {
            n = Double.parseDouble(number);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new NumericValue(n);
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        if (this.hasTrend) {
            return new ConstantTrend(this.value, cx);
        }
        return null;
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        return this.value;
    }

    @Override
    public boolean hasTrend(AnalyticContext cx) {
        return this.hasTrend;
    }
}

