/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.data;

import com.tridiumx.analytics.util.Utils;
import java.util.TimeZone;
import java.util.function.Function;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;
import javax.baja.user.BUser;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticNumeric;
import javax.bajax.analytics.data.AnalyticValue;

public class UnitConverter
implements AnalyticConstants,
Function<AnalyticValue, AnalyticValue> {
    private static final long FIRST_US_TZ = -14400000L;
    private static final long LAST_US_TZ = -36000000L;
    private BUnit from;
    private BUnit to;

    private UnitConverter(BUnit from, BUnit to) {
        this.from = from;
        this.to = to;
    }

    @Override
    public AnalyticValue apply(AnalyticValue arg) {
        double d = this.from.convertTo(this.to, arg.toNumeric());
        if (arg instanceof AnalyticNumeric) {
            ((AnalyticNumeric)arg).setValue(d);
        } else {
            arg.setValue(BDouble.make((double)d));
        }
        return arg;
    }

    public double convert(double arg) {
        return this.from.convertTo(this.to, arg);
    }

    public static AnalyticValue convert(AnalyticValue value, BUnit from, BUnit to) {
        UnitConverter tmp = UnitConverter.make(from, to);
        if (tmp != null) {
            return tmp.apply(value);
        }
        return value;
    }

    public static BUnit getConversionUnit(BUnit from, BUnit to, AnalyticContext cx) {
        if (from == null && to == null) {
            return null;
        }
        BUnitConversion system = UnitConverter.getUnitConversion(cx);
        if (from == null) {
            from = to;
            to = system.getDesiredUnit(to);
        } else {
            to = to == null ? system.getDesiredUnit(from) : system.getDesiredUnit(to);
        }
        if (from.equals((Object)to)) {
            return null;
        }
        if (!from.isConvertible(to)) {
            if (from.isNull() || to.isNull()) {
                return null;
            }
            throw new IllegalArgumentException(Utils.lex("unconvertableUnits") + ": " + from.getUnitName() + "->" + to.getUnitName());
        }
        return to;
    }

    public static BUnitConversion getUnitConversion(AnalyticContext cx) {
        TimeZone tz;
        int off;
        if (cx == null) {
            return BUnitConversion.none;
        }
        boolean en = false;
        BUser user = cx.getUser();
        if (user != null) {
            BDynamicEnum de = (BDynamicEnum)user.getFacets().get("unitConversion");
            BUnitConversion ret = null;
            if (de != null) {
                ret = BUnitConversion.make((int)de.getOrdinal());
            }
            if (ret != null) {
                return ret;
            }
            String lang = user.getLanguage();
            if (lang != null && lang.length() > 0) {
                if (lang.equals("en-US")) {
                    return BUnitConversion.english;
                }
                if (lang.startsWith("en")) {
                    en = true;
                } else {
                    return BUnitConversion.metric;
                }
            }
        }
        if ((long)(off = (tz = cx.getTimeZone()).getRawOffset()) <= -14400000L && (long)off >= -36000000L) {
            if (en) {
                return BUnitConversion.english;
            }
        } else {
            return BUnitConversion.metric;
        }
        return BUnitConversion.none;
    }

    public static UnitConverter make(BUnit from, BUnit to) {
        if (from == null || to == null) {
            return null;
        }
        if (from.equals((Object)to)) {
            return null;
        }
        if (!from.isConvertible(to)) {
            if (from.isNull() || to.isNull()) {
                return null;
            }
            throw new IllegalArgumentException(Utils.lex("unconvertableUnits") + ": " + from.getUnitName() + "->" + to.getUnitName());
        }
        return new UnitConverter(from, to);
    }
}

