/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.data;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.algorithm.Algorithm;
import com.tridiumx.analytics.data.AggregateDataSource;
import com.tridiumx.analytics.data.AnalyticDataSource;
import com.tridiumx.analytics.data.NodeInfo;
import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.trend.OneCountTrend;
import com.tridiumx.analytics.util.Utils;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.baja.nav.BINavNode;
import javax.baja.tag.Entity;
import javax.baja.units.BUnit;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class AlgorithmDataSource
implements AnalyticConstants,
AnalyticDataSource {
    private Algorithm algo;
    private BINavNode node;

    public AlgorithmDataSource(Algorithm algo, BINavNode node) {
        this.algo = algo;
        this.node = node;
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        Predicate<Entity> filter = cx.getDataFilter();
        AnalyticContextWrapper cw = new AnalyticContextWrapper(cx);
        BUnit algoUnit = (BUnit)this.algo.getFacets().get("units");
        if (algoUnit != null) {
            cw.setUnit(algoUnit);
        } else {
            cw.setUnit(BUnit.NULL);
        }
        if (filter != null && !this.test(this.node, filter)) {
            ArrayList<AnalyticDataSource> sources = this.findSources(this.node, filter, null, cx);
            if (sources == null || sources.size() == 0) {
                return null;
            }
            AnalyticTrend ret = new AggregateDataSource(sources).getTrend(cx);
            if (cw.getEndTime() != ret.getContext().getEndTime()) {
                cw.setTimeRange(ret.getContext().getTimeRange(true));
            }
            ret.setContext(cw);
            return ret;
        }
        AnalyticTrend ret = this.algo.getTrend(this.prepare(cx));
        if (cw.getEndTime() != ret.getContext().getEndTime()) {
            cw.setTimeRange(ret.getContext().getTimeRange(true));
        }
        ret.setContext(cw);
        if (cx.getAggregation(true).getOrdinal() == 2) {
            return new OneCountTrend(ret);
        }
        return ret;
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        Predicate<Entity> filter = cx.getDataFilter();
        if (filter != null && !this.test(this.node, filter)) {
            ArrayList<AnalyticDataSource> sources = this.findSources(this.node, filter, null, cx);
            if (sources == null || sources.size() == 0) {
                return null;
            }
            return new AggregateDataSource(sources).getValue(cx);
        }
        AnalyticValue ret = this.algo.getValue(this.prepare(cx));
        if (cx.getAggregation(true).getOrdinal() == 2) {
            NumericValue num = new NumericValue();
            num.setTimestamp(ret.getTimestamp());
            num.setStatus(ret.getStatus());
            num.setValue(1.0);
            return num;
        }
        return ret;
    }

    @Override
    public boolean hasTrend(AnalyticContext cx) {
        Predicate<Entity> filter = cx.getDataFilter();
        if (filter != null && !this.test(this.node, filter)) {
            ArrayList<AnalyticDataSource> sources = this.findSources(this.node, filter, null, cx);
            if (sources == null || sources.size() == 0) {
                return false;
            }
            return new AggregateDataSource(sources).hasTrend(cx);
        }
        return this.algo.hasTrend(this.prepare(cx));
    }

    private AnalyticContext prepare(AnalyticContext cx) {
        if (cx.getNode() == this.node) {
            return cx;
        }
        return new AnalyticContextWrapper(cx).setNode(this.node);
    }

    private ArrayList<AnalyticDataSource> findSources(BINavNode node, Predicate<Entity> filter, ArrayList<AnalyticDataSource> sources, AnalyticContext cx) {
        NodeInfo info;
        AnalyticDataSource source;
        if (this.test(node, filter) && (source = (info = NodeInfo.get(node, true)).getAnalyticDataSource(this.algo.getDataId(), true, cx)) != null) {
            if (sources == null) {
                sources = new ArrayList();
            }
            sources.add(source);
            return sources;
        }
        if (!node.hasNavChildren()) {
            return sources;
        }
        for (BINavNode kid : node.getNavChildren()) {
            if (!BAnalyticService.getInstance().isValidNodeType(kid)) {
                if (!Utils.log().isLoggable(Level.FINE)) continue;
                Utils.log().log(Level.FINE, "Skipping invalid analytic node type " + kid.getNavOrd() + " from algorithm execution");
                continue;
            }
            sources = this.findSources(kid, filter, sources, cx);
        }
        return sources;
    }

    private boolean test(BINavNode node, Predicate<Entity> filter) {
        if ((node = Utils.getProxyTarget(node)) instanceof Entity) {
            return filter.test((Entity)node);
        }
        return false;
    }
}

