/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.cache;

import com.tridiumx.analytics.cache.NodeInfoCacheKey;
import com.tridiumx.analytics.data.AggregateDataSource;
import com.tridiumx.analytics.data.AnalyticDataSource;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class NodeInfoCache {
    private static ConcurrentHashMap<NodeInfoCacheKey, AnalyticDataSource> nodeDataSourceMap = new ConcurrentHashMap();
    private static Set<NodeInfoCacheKey> nullDataSourceHashcodeBuffer = ConcurrentHashMap.newKeySet();

    private NodeInfoCache() {
    }

    public static void put(NodeInfoCacheKey nodeInfoCacheKey, AnalyticDataSource dataSource) {
        nodeDataSourceMap.put(nodeInfoCacheKey, dataSource);
    }

    public static void put(NodeInfoCacheKey nodeInfoCacheKey) {
        nullDataSourceHashcodeBuffer.add(nodeInfoCacheKey);
    }

    public static AnalyticDataSource get(NodeInfoCacheKey nodeInfoCacheKey) {
        AnalyticDataSource dataSource = nodeDataSourceMap.get(nodeInfoCacheKey);
        if (dataSource != null) {
            return dataSource;
        }
        NodeInfoCacheKey keyCopy = NodeInfoCacheKey.make(nodeInfoCacheKey.getUserName(), nodeInfoCacheKey.getDataId(), nodeInfoCacheKey.getNodeOrd());
        String nodeOrd = keyCopy.getNodeOrd();
        while (true) {
            if (nullDataSourceHashcodeBuffer.contains(keyCopy)) {
                return new AggregateDataSource(new ArrayList<AnalyticDataSource>());
            }
            int lastIndex = nodeOrd.lastIndexOf(47);
            if (lastIndex == -1) break;
            nodeOrd = nodeOrd.substring(0, lastIndex);
            keyCopy.setNodeOrd(nodeOrd);
        }
        return null;
    }

    public static void clear() {
        nodeDataSourceMap.clear();
        nullDataSourceHashcodeBuffer.clear();
    }
}

