/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.algorithm.AlgorithmBlock;
import com.tridiumx.analytics.time.TimeBinding;
import com.tridiumx.analytics.util.BOptionalSimple;
import com.tridiumx.analytics.util.BOptionalStruct;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTimeRange;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.algorithm.BlockTrend;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="in", type="BBlockPin", defaultValue="new BBlockPin()", flags=8), @NiagaraProperty(name="currentDayOfWeek", type="BOptionalSimple", defaultValue="new BOptionalSimple(false,BBoolean.FALSE)", flags=8), @NiagaraProperty(name="currentWeekOfMonth", type="BOptionalSimple", defaultValue="new BOptionalSimple(false,BBoolean.FALSE)", flags=8), @NiagaraProperty(name="currentMonth", type="BOptionalSimple", defaultValue="new BOptionalSimple(false,BBoolean.FALSE)", flags=8), @NiagaraProperty(name="currentTimeWindow", type="BOptionalSimple", defaultValue="new BOptionalSimple(false,BRelTime.HOUR)", flags=8), @NiagaraProperty(name="timeRange1", type="BOptionalStruct", defaultValue="new BOptionalStruct(false,new BTimeRange())", flags=8), @NiagaraProperty(name="timeRange2", type="BOptionalStruct", defaultValue="new BOptionalStruct(false,new BTimeRange())", flags=8), @NiagaraProperty(name="invertTimeRange", type="boolean", defaultValue="false")})
public class BTimeFilterBlock
extends BOutputBlock {
    @Generated
    public static final Property in = BTimeFilterBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    @Generated
    public static final Property currentDayOfWeek = BTimeFilterBlock.newProperty((int)8, (BValue)new BOptionalSimple(false, (BSimple)BBoolean.FALSE), null);
    @Generated
    public static final Property currentWeekOfMonth = BTimeFilterBlock.newProperty((int)8, (BValue)new BOptionalSimple(false, (BSimple)BBoolean.FALSE), null);
    @Generated
    public static final Property currentMonth = BTimeFilterBlock.newProperty((int)8, (BValue)new BOptionalSimple(false, (BSimple)BBoolean.FALSE), null);
    @Generated
    public static final Property currentTimeWindow = BTimeFilterBlock.newProperty((int)8, (BValue)new BOptionalSimple(false, (BSimple)BRelTime.HOUR), null);
    @Generated
    public static final Property timeRange1 = BTimeFilterBlock.newProperty((int)8, (BValue)new BOptionalStruct(false, (BStruct)new BTimeRange()), null);
    @Generated
    public static final Property timeRange2 = BTimeFilterBlock.newProperty((int)8, (BValue)new BOptionalStruct(false, (BStruct)new BTimeRange()), null);
    @Generated
    public static final Property invertTimeRange = BTimeFilterBlock.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTimeFilterBlock.class);

    @Generated
    public BBlockPin getIn() {
        return (BBlockPin)this.get(in);
    }

    @Generated
    public void setIn(BBlockPin v) {
        this.set(in, (BValue)v, null);
    }

    @Generated
    public BOptionalSimple getCurrentDayOfWeek() {
        return (BOptionalSimple)this.get(currentDayOfWeek);
    }

    @Generated
    public void setCurrentDayOfWeek(BOptionalSimple v) {
        this.set(currentDayOfWeek, (BValue)v, null);
    }

    @Generated
    public BOptionalSimple getCurrentWeekOfMonth() {
        return (BOptionalSimple)this.get(currentWeekOfMonth);
    }

    @Generated
    public void setCurrentWeekOfMonth(BOptionalSimple v) {
        this.set(currentWeekOfMonth, (BValue)v, null);
    }

    @Generated
    public BOptionalSimple getCurrentMonth() {
        return (BOptionalSimple)this.get(currentMonth);
    }

    @Generated
    public void setCurrentMonth(BOptionalSimple v) {
        this.set(currentMonth, (BValue)v, null);
    }

    @Generated
    public BOptionalSimple getCurrentTimeWindow() {
        return (BOptionalSimple)this.get(currentTimeWindow);
    }

    @Generated
    public void setCurrentTimeWindow(BOptionalSimple v) {
        this.set(currentTimeWindow, (BValue)v, null);
    }

    @Generated
    public BOptionalStruct getTimeRange1() {
        return (BOptionalStruct)this.get(timeRange1);
    }

    @Generated
    public void setTimeRange1(BOptionalStruct v) {
        this.set(timeRange1, (BValue)v, null);
    }

    @Generated
    public BOptionalStruct getTimeRange2() {
        return (BOptionalStruct)this.get(timeRange2);
    }

    @Generated
    public void setTimeRange2(BOptionalStruct v) {
        this.set(timeRange2, (BValue)v, null);
    }

    @Generated
    public boolean getInvertTimeRange() {
        return this.getBoolean(invertTimeRange);
    }

    @Generated
    public void setInvertTimeRange(boolean v) {
        this.setBoolean(invertTimeRange, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        return new MyTrend(this, cx);
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        AnalyticValue val = this.getInput(0).getValue(cx);
        if (!this.testWithoutInvert(val)) {
            val.setStatus(64);
        }
        return val;
    }

    private boolean isInvert() {
        return this.getInvertTimeRange();
    }

    private boolean testWithoutInvert(AnalyticValue val) {
        Boolean x;
        long now = System.currentTimeMillis();
        long valTs = val.getTimestamp();
        if (this.getCurrentDayOfWeek().getHasValue() && TimeBinding.getDayOfWeek(valTs) != TimeBinding.getDayOfWeek(now)) {
            return false;
        }
        if (this.getCurrentWeekOfMonth().getHasValue() && TimeBinding.getWeekOfMonth(valTs) != TimeBinding.getWeekOfMonth(now)) {
            return false;
        }
        if (this.getCurrentMonth().getHasValue() && TimeBinding.getMonth(valTs) != TimeBinding.getMonth(now)) {
            return false;
        }
        if (this.getCurrentTimeWindow().getHasValue()) {
            long millis = ((BRelTime)this.getCurrentTimeWindow().getValue()).getMillis();
            if (valTs < now - millis) {
                return false;
            }
            if (valTs > now + millis) {
                return false;
            }
        }
        if ((x = this.isTRApplicable(valTs)) != null) {
            return this.isInvert() ? !x.booleanValue() : x;
        }
        return true;
    }

    private Boolean isTRApplicable(long valTs) {
        if (this.getTimeRange1().getHasValue() || this.getTimeRange2().getHasValue()) {
            BTimeRange tr;
            long tod;
            if (this.getTimeRange1().getHasValue() && (tod = (long)TimeBinding.getTimeOfDay(valTs)) > (tr = (BTimeRange)this.getTimeRange1().getValue()).getStartTime().getTimeOfDayMillis() && tod < tr.getEndTime().getTimeOfDayMillis()) {
                return true;
            }
            if (this.getTimeRange2().getHasValue() && (tod = (long)TimeBinding.getTimeOfDay(valTs)) > (tr = (BTimeRange)this.getTimeRange2().getValue()).getStartTime().getTimeOfDayMillis() && tod < tr.getEndTime().getTimeOfDayMillis()) {
                return true;
            }
            return false;
        }
        return null;
    }

    private class MyTrend
    extends BlockTrend {
        public MyTrend(AlgorithmBlock block, AnalyticContext cx) {
            super(block, cx);
        }

        @Override
        protected AnalyticValue getNext() {
            while (this.advance()) {
                AnalyticValue in = this.getValue(0);
                if (!BTimeFilterBlock.this.testWithoutInvert(in)) continue;
                return in;
            }
            return null;
        }
    }
}

