/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.time.TimeBinding;
import com.tridiumx.analytics.trend.SimpleTrend;
import com.tridiumx.analytics.util.Utils;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.data.Combiner;
import javax.bajax.analytics.time.BAnalyticTimeRange;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="trendIn", type="BBlockPin", defaultValue="new BBlockPin()", flags=8), @NiagaraProperty(name="rollup", type="BCombination", defaultValue="BCombination.first", flags=8), @NiagaraProperty(name="timeRange", type="BAnalyticTimeRange", defaultValue="BAnalyticTimeRange.make(\"previous60days\")", flags=8), @NiagaraProperty(name="useRequestRollup", type="boolean", defaultValue="true", flags=8), @NiagaraProperty(name="useRequestTimeRange", type="boolean", defaultValue="true", flags=8)})
public class BDayBuilderBlock
extends BOutputBlock {
    @Generated
    public static final Property trendIn = BDayBuilderBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    @Generated
    public static final Property rollup = BDayBuilderBlock.newProperty((int)8, (BValue)BCombination.first, null);
    @Generated
    public static final Property timeRange = BDayBuilderBlock.newProperty((int)8, (BValue)BAnalyticTimeRange.make("previous60days"), null);
    @Generated
    public static final Property useRequestRollup = BDayBuilderBlock.newProperty((int)8, (boolean)true, null);
    @Generated
    public static final Property useRequestTimeRange = BDayBuilderBlock.newProperty((int)8, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDayBuilderBlock.class);

    @Generated
    public BBlockPin getTrendIn() {
        return (BBlockPin)this.get(trendIn);
    }

    @Generated
    public void setTrendIn(BBlockPin v) {
        this.set(trendIn, (BValue)v, null);
    }

    @Generated
    public BCombination getRollup() {
        return (BCombination)this.get(rollup);
    }

    @Generated
    public void setRollup(BCombination v) {
        this.set(rollup, (BValue)v, null);
    }

    @Generated
    public BAnalyticTimeRange getTimeRange() {
        return (BAnalyticTimeRange)this.get(timeRange);
    }

    @Generated
    public void setTimeRange(BAnalyticTimeRange v) {
        this.set(timeRange, (BValue)v, null);
    }

    @Generated
    public boolean getUseRequestRollup() {
        return this.getBoolean(useRequestRollup);
    }

    @Generated
    public void setUseRequestRollup(boolean v) {
        this.setBoolean(useRequestRollup, v, null);
    }

    @Generated
    public boolean getUseRequestTimeRange() {
        return this.getBoolean(useRequestTimeRange);
    }

    @Generated
    public void setUseRequestTimeRange(boolean v) {
        this.setBoolean(useRequestTimeRange, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        try (AnalyticTrend trend = this.getInput(0).getTrend(this.prepareContext(cx));){
            Combiner rollup;
            Long key;
            AnalyticValue val;
            cx = trend.getContext();
            TreeMap<Long, Combiner> map = new TreeMap<Long, Combiner>();
            long today = TimeBinding.alignDay(TimeBinding.now());
            long end = cx.getEndTime();
            while (trend.hasNext() && !Utils.isEnded((val = trend.next()).getTimestamp(), end)) {
                key = today + (long)TimeBinding.getTimeOfDay(val.getTimestamp());
                rollup = (Combiner)map.get(key);
                if (rollup == null) {
                    rollup = this.getUseRequestRollup() ? cx.getRollup(true).makeCombiner() : this.getRollup().makeCombiner();
                    map.put(key, rollup);
                }
                rollup.update(val);
            }
            AnalyticContextWrapper w = new AnalyticContextWrapper(cx);
            w.setTimeRange(BAnalyticTimeRange.today);
            SimpleTrend ret = new SimpleTrend(w);
            for (Map.Entry me : map.entrySet()) {
                key = (Long)me.getKey();
                rollup = (Combiner)me.getValue();
                AnalyticValue res = rollup.getValue();
                res.setTimestamp(key);
                ret.add(res);
            }
            SimpleTrend simpleTrend = ret;
            return simpleTrend;
        }
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        return Utils.rollup(this.getTrend(cx));
    }

    private AnalyticContext prepareContext(AnalyticContext cx) {
        if (cx.getTimeRange(false) == null || !this.getUseRequestTimeRange()) {
            cx = new AnalyticContextWrapper(cx);
            cx.setTimeRange(this.getTimeRange());
        }
        return cx;
    }
}

