/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.util.Utils;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="add"), @Range(value="subtract"), @Range(value="multiply"), @Range(value="divide"), @Range(value="modulo"), @Range(value="exponent"), @Range(value="min"), @Range(value="max"), @Range(value="avg")})
public final class BBiMathOperator
extends BFrozenEnum {
    @Generated
    public static final int ADD = 0;
    @Generated
    public static final int SUBTRACT = 1;
    @Generated
    public static final int MULTIPLY = 2;
    @Generated
    public static final int DIVIDE = 3;
    @Generated
    public static final int MODULO = 4;
    @Generated
    public static final int EXPONENT = 5;
    @Generated
    public static final int MIN = 6;
    @Generated
    public static final int MAX = 7;
    @Generated
    public static final int AVG = 8;
    @Generated
    public static final BBiMathOperator add = new BBiMathOperator(0);
    @Generated
    public static final BBiMathOperator subtract = new BBiMathOperator(1);
    @Generated
    public static final BBiMathOperator multiply = new BBiMathOperator(2);
    @Generated
    public static final BBiMathOperator divide = new BBiMathOperator(3);
    @Generated
    public static final BBiMathOperator modulo = new BBiMathOperator(4);
    @Generated
    public static final BBiMathOperator exponent = new BBiMathOperator(5);
    @Generated
    public static final BBiMathOperator min = new BBiMathOperator(6);
    @Generated
    public static final BBiMathOperator max = new BBiMathOperator(7);
    @Generated
    public static final BBiMathOperator avg = new BBiMathOperator(8);
    @Generated
    public static final BBiMathOperator DEFAULT = add;
    @Generated
    public static final Type TYPE = Sys.loadType(BBiMathOperator.class);

    @Generated
    public static BBiMathOperator make(int ordinal) {
        return (BBiMathOperator)add.getRange().get(ordinal, false);
    }

    @Generated
    public static BBiMathOperator make(String tag) {
        return (BBiMathOperator)add.getRange().get(tag);
    }

    @Generated
    private BBiMathOperator(int ordinal) {
        super(ordinal);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String toString(Context cx) {
        switch (this.getOrdinal()) {
            case 0: {
                return Utils.lex("add");
            }
            case 1: {
                return Utils.lex("subtract");
            }
            case 3: {
                return Utils.lex("divide");
            }
            case 2: {
                return Utils.lex("multiply");
            }
            case 4: {
                return Utils.lex("block.mod");
            }
            case 5: {
                return Utils.lex("exponent");
            }
            case 6: {
                return Utils.lex("min");
            }
            case 7: {
                return Utils.lex("max");
            }
            case 8: {
                return Utils.lex("avg");
            }
        }
        return super.toString(cx);
    }

    public double evaluate(double first, double second) {
        switch (this.getOrdinal()) {
            case 0: {
                return first + second;
            }
            case 1: {
                return first - second;
            }
            case 2: {
                return first * second;
            }
            case 3: {
                return first / second;
            }
            case 4: {
                return first % second;
            }
            case 5: {
                return Math.pow(first, second);
            }
            case 6: {
                return Math.min(first, second);
            }
            case 7: {
                return Math.max(first, second);
            }
            case 8: {
                return (first + second) / 2.0;
            }
        }
        return Double.NaN;
    }
}

