/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.alert;

import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.alert.AlertEntry;
import com.tridiumx.analytics.alert.BAlertMode;
import com.tridiumx.analytics.algorithm.Algorithm;
import com.tridiumx.analytics.algorithm.AlgorithmBlock;
import com.tridiumx.analytics.algorithm.BAlgorithm;
import com.tridiumx.analytics.algorithm.BDataSourceBlock;
import com.tridiumx.analytics.algorithm.missingdata.BMissingDataStrategy;
import com.tridiumx.analytics.data.NodeInfo;
import com.tridiumx.analytics.hier.BHierNode;
import com.tridiumx.analytics.poll.AnalyticConfigurable;
import com.tridiumx.analytics.poll.BAnalyticPoller;
import com.tridiumx.analytics.util.Alarms;
import com.tridiumx.analytics.util.BAnalyticVector;
import com.tridiumx.analytics.util.BConfigurableObject;
import com.tridiumx.analytics.util.BOptionalSimple;
import com.tridiumx.analytics.util.NeqlPredicate;
import com.tridiumx.analytics.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.data.BIDataValue;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.util.BFormat;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.time.BAnalyticTimeRange;
import javax.bajax.analytics.time.BInterval;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="roots", type="BAnalyticVector", defaultValue="new BAnalyticVector()", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR,BString.make(\"analytics:NodeVectorFe\"))")}), @NiagaraProperty(name="exclusions", type="BAnalyticVector", defaultValue="new BAnalyticVector()", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR,BString.make(\"analytics:NodeVectorFe\"))")}), @NiagaraProperty(name="nodeFilter", type="String", defaultValue="", facets={@Facet(value="makeTextFacets()")}), @NiagaraProperty(name="nodeCount", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="alertCount", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="data", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"analytics:DataFe\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"analytics:AnalyticDataEditor\"")}), @NiagaraProperty(name="dataFilter", type="String", defaultValue=""), @NiagaraProperty(name="timeRange", type="BOptionalSimple", defaultValue="new BOptionalSimple(false,BAnalyticTimeRange.today)"), @NiagaraProperty(name="aggregation", type="BOptionalSimple", defaultValue="new BOptionalSimple(false,BCombination.first)"), @NiagaraProperty(name="interval", type="BOptionalSimple", defaultValue="new BOptionalSimple(false,BInterval.fifteenMinutes)"), @NiagaraProperty(name="rollup", type="BOptionalSimple", defaultValue="new BOptionalSimple(false,BCombination.first)"), @NiagaraProperty(name="totalize", type="BOptionalSimple", defaultValue="new BOptionalSimple(false,BBoolean.TRUE)"), @NiagaraProperty(name="alertMode", type="BAlertMode", defaultValue="BAlertMode.DEFAULT"), @NiagaraProperty(name="cost", type="double", defaultValue="1.0"), @NiagaraProperty(name="poller", type="String", defaultValue="Default", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR,BString.make(\"analytics:PollerFe\"))")}), @NiagaraProperty(name="ignoreStatus", type="BStatus", defaultValue="BStatus.make(BStatus.DISABLED|BStatus.FAULT|BStatus.DOWN|BStatus.STALE|BStatus.NULL)"), @NiagaraProperty(name="relatedData", type="BVector", defaultValue="new BVector()", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR,BString.make(\"analytics:DataVectorFe\"))")}), @NiagaraProperty(name="description", type="String", defaultValue="", facets={@Facet(value="makeTextFacets()")}), @NiagaraProperty(name="alarm", type="boolean", defaultValue="false"), @NiagaraProperty(name="alarmClass", type="String", defaultValue="defaultAlarmClass", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"alarm:AlarmClassFE\"), BFacets.UX_FIELD_EDITOR, BString.make(\"alarm:AlarmClassEditor\"))")}), @NiagaraProperty(name="alarmData", type="BFacets", defaultValue="BFacets.NULL"), @NiagaraProperty(name="alarmMessage", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_WIDTH,BInteger.make(100))")}), @NiagaraProperty(name="sourceName", type="BFormat", defaultValue="BFormat.make(\"%node.navName%_%alert.name%\")"), @NiagaraProperty(name="missingDataStrategy", type="BMissingDataStrategy", defaultValue="new BMissingDataStrategy()")})
@NiagaraActions(value={@NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4), @NiagaraAction(name="findRelatedData", flags=16), @NiagaraAction(name="invalidateTargets", flags=20), @NiagaraAction(name="listNodes", returnType="BComponent", flags=4), @NiagaraAction(name="resyncPoller", flags=20)})
public class BAnalyticAlert
extends BConfigurableObject
implements BIAlarmSource {
    @Generated
    public static final Property roots = BAnalyticAlert.newProperty((int)0, (BValue)new BAnalyticVector(), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"analytics:NodeVectorFe")));
    @Generated
    public static final Property exclusions = BAnalyticAlert.newProperty((int)0, (BValue)new BAnalyticVector(), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"analytics:NodeVectorFe")));
    @Generated
    public static final Property nodeFilter = BAnalyticAlert.newProperty((int)0, (String)"", (BFacets)BAnalyticAlert.makeTextFacets());
    @Generated
    public static final Property nodeCount = BAnalyticAlert.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property alertCount = BAnalyticAlert.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property data = BAnalyticAlert.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"analytics:DataFe")), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"analytics:AnalyticDataEditor")));
    @Generated
    public static final Property dataFilter = BAnalyticAlert.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property timeRange = BAnalyticAlert.newProperty((int)0, (BValue)new BOptionalSimple(false, BAnalyticTimeRange.today), null);
    @Generated
    public static final Property aggregation = BAnalyticAlert.newProperty((int)0, (BValue)new BOptionalSimple(false, (BSimple)BCombination.first), null);
    @Generated
    public static final Property interval = BAnalyticAlert.newProperty((int)0, (BValue)new BOptionalSimple(false, (BSimple)BInterval.fifteenMinutes), null);
    @Generated
    public static final Property rollup = BAnalyticAlert.newProperty((int)0, (BValue)new BOptionalSimple(false, (BSimple)BCombination.first), null);
    @Generated
    public static final Property totalize = BAnalyticAlert.newProperty((int)0, (BValue)new BOptionalSimple(false, (BSimple)BBoolean.TRUE), null);
    @Generated
    public static final Property alertMode = BAnalyticAlert.newProperty((int)0, (BValue)BAlertMode.DEFAULT, null);
    @Generated
    public static final Property cost = BAnalyticAlert.newProperty((int)0, (double)1.0, null);
    @Generated
    public static final Property poller = BAnalyticAlert.newProperty((int)0, (String)"Default", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"analytics:PollerFe")));
    @Generated
    public static final Property ignoreStatus = BAnalyticAlert.newProperty((int)0, (BValue)BStatus.make((int)87), null);
    @Generated
    public static final Property relatedData = BAnalyticAlert.newProperty((int)0, (BValue)new BVector(), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"analytics:DataVectorFe")));
    @Generated
    public static final Property description = BAnalyticAlert.newProperty((int)0, (String)"", (BFacets)BAnalyticAlert.makeTextFacets());
    @Generated
    public static final Property alarm = BAnalyticAlert.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property alarmClass = BAnalyticAlert.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassEditor")));
    @Generated
    public static final Property alarmData = BAnalyticAlert.newProperty((int)0, (BValue)BFacets.NULL, null);
    @Generated
    public static final Property alarmMessage = BAnalyticAlert.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)100)));
    @Generated
    public static final Property sourceName = BAnalyticAlert.newProperty((int)0, (BValue)BFormat.make((String)"%node.navName%_%alert.name%"), null);
    @Generated
    public static final Property missingDataStrategy = BAnalyticAlert.newProperty((int)0, (BValue)new BMissingDataStrategy(), null);
    @Generated
    public static final Action ackAlarm = BAnalyticAlert.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Action findRelatedData = BAnalyticAlert.newAction((int)16, null);
    @Generated
    public static final Action invalidateTargets = BAnalyticAlert.newAction((int)20, null);
    @Generated
    public static final Action listNodes = BAnalyticAlert.newAction((int)4, null);
    @Generated
    public static final Action resyncPoller = BAnalyticAlert.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAnalyticAlert.class);
    private static Predicate<Entity> includeAll = new IncludeAll();
    private Id dataId;
    private HashMap<BINavNode, AlertEntry> entries = new HashMap();
    private Predicate<Entity> nodePredicate;
    private BAnalyticPoller lastPoller;
    private boolean stale;

    @Generated
    public BAnalyticVector getRoots() {
        return (BAnalyticVector)this.get(roots);
    }

    @Generated
    public void setRoots(BAnalyticVector v) {
        this.set(roots, (BValue)v, null);
    }

    @Generated
    public BAnalyticVector getExclusions() {
        return (BAnalyticVector)this.get(exclusions);
    }

    @Generated
    public void setExclusions(BAnalyticVector v) {
        this.set(exclusions, (BValue)v, null);
    }

    @Generated
    public String getNodeFilter() {
        return this.getString(nodeFilter);
    }

    @Generated
    public void setNodeFilter(String v) {
        this.setString(nodeFilter, v, null);
    }

    @Generated
    public int getNodeCount() {
        return this.getInt(nodeCount);
    }

    @Generated
    public void setNodeCount(int v) {
        this.setInt(nodeCount, v, null);
    }

    @Generated
    public int getAlertCount() {
        return this.getInt(alertCount);
    }

    @Generated
    public void setAlertCount(int v) {
        this.setInt(alertCount, v, null);
    }

    @Generated
    public String getData() {
        return this.getString(data);
    }

    @Generated
    public void setData(String v) {
        this.setString(data, v, null);
    }

    @Generated
    public String getDataFilter() {
        return this.getString(dataFilter);
    }

    @Generated
    public void setDataFilter(String v) {
        this.setString(dataFilter, v, null);
    }

    @Generated
    public BOptionalSimple getTimeRange() {
        return (BOptionalSimple)this.get(timeRange);
    }

    @Generated
    public void setTimeRange(BOptionalSimple v) {
        this.set(timeRange, (BValue)v, null);
    }

    @Generated
    public BOptionalSimple getAggregation() {
        return (BOptionalSimple)this.get(aggregation);
    }

    @Generated
    public void setAggregation(BOptionalSimple v) {
        this.set(aggregation, (BValue)v, null);
    }

    @Generated
    public BOptionalSimple getInterval() {
        return (BOptionalSimple)this.get(interval);
    }

    @Generated
    public void setInterval(BOptionalSimple v) {
        this.set(interval, (BValue)v, null);
    }

    @Generated
    public BOptionalSimple getRollup() {
        return (BOptionalSimple)this.get(rollup);
    }

    @Generated
    public void setRollup(BOptionalSimple v) {
        this.set(rollup, (BValue)v, null);
    }

    @Generated
    public BOptionalSimple getTotalize() {
        return (BOptionalSimple)this.get(totalize);
    }

    @Generated
    public void setTotalize(BOptionalSimple v) {
        this.set(totalize, (BValue)v, null);
    }

    @Generated
    public BAlertMode getAlertMode() {
        return (BAlertMode)this.get(alertMode);
    }

    @Generated
    public void setAlertMode(BAlertMode v) {
        this.set(alertMode, (BValue)v, null);
    }

    @Generated
    public double getCost() {
        return this.getDouble(cost);
    }

    @Generated
    public void setCost(double v) {
        this.setDouble(cost, v, null);
    }

    @Generated
    public String getPoller() {
        return this.getString(poller);
    }

    @Generated
    public void setPoller(String v) {
        this.setString(poller, v, null);
    }

    @Generated
    public BStatus getIgnoreStatus() {
        return (BStatus)this.get(ignoreStatus);
    }

    @Generated
    public void setIgnoreStatus(BStatus v) {
        this.set(ignoreStatus, (BValue)v, null);
    }

    @Generated
    public BVector getRelatedData() {
        return (BVector)this.get(relatedData);
    }

    @Generated
    public void setRelatedData(BVector v) {
        this.set(relatedData, (BValue)v, null);
    }

    @Generated
    public String getDescription() {
        return this.getString(description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Generated
    public boolean getAlarm() {
        return this.getBoolean(alarm);
    }

    @Generated
    public void setAlarm(boolean v) {
        this.setBoolean(alarm, v, null);
    }

    @Generated
    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    @Generated
    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    @Generated
    public BFacets getAlarmData() {
        return (BFacets)this.get(alarmData);
    }

    @Generated
    public void setAlarmData(BFacets v) {
        this.set(alarmData, (BValue)v, null);
    }

    @Generated
    public String getAlarmMessage() {
        return this.getString(alarmMessage);
    }

    @Generated
    public void setAlarmMessage(String v) {
        this.setString(alarmMessage, v, null);
    }

    @Generated
    public BFormat getSourceName() {
        return (BFormat)this.get(sourceName);
    }

    @Generated
    public void setSourceName(BFormat v) {
        this.set(sourceName, (BValue)v, null);
    }

    @Generated
    public BMissingDataStrategy getMissingDataStrategy() {
        return (BMissingDataStrategy)this.get(missingDataStrategy);
    }

    @Generated
    public void setMissingDataStrategy(BMissingDataStrategy v) {
        this.set(missingDataStrategy, (BValue)v, null);
    }

    @Generated
    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Generated
    public void findRelatedData() {
        this.invoke(findRelatedData, null, null);
    }

    @Generated
    public void invalidateTargets() {
        this.invoke(invalidateTargets, null, null);
    }

    @Generated
    public BComponent listNodes() {
        return (BComponent)this.invoke(listNodes, null, null);
    }

    @Generated
    public void resyncPoller() {
        this.invoke(resyncPoller, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBoolean doAckAlarm(BAlarmRecord rec, Context cx) {
        Alarms.ackAlarm(rec, cx);
        return Alarms.save(rec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTargets() {
        this.leavePoller();
        HashMap<BINavNode, AlertEntry> hashMap = this.entries;
        synchronized (hashMap) {
            this.entries.clear();
        }
        this.setNodeCount(0);
        this.setAlertCount(0);
    }

    @Override
    public void changed(Property p, Context cx) {
        if (this.isRunning()) {
            if (p.equals(enabled)) {
                if (!this.getEnabled()) {
                    this.invalidateTargets();
                }
            } else if (p.equals(data)) {
                this.dataId = null;
                this.invalidateTargets();
            } else if (p.equals(exclusions) || p.equals(roots)) {
                this.invalidateTargets();
            } else if (p.equals(nodeFilter)) {
                this.nodePredicate = null;
                this.invalidateTargets();
            } else if (p.equals(poller)) {
                this.resyncPoller();
            } else {
                super.changed(p, cx);
            }
        }
    }

    public void doFindRelatedData() {
        Id id = this.getDataId();
        if (id == null) {
            return;
        }
        HashSet<Id> data = new HashSet<Id>();
        data.add(id);
        SlotCursor cur = this.getRelatedData().getProperties();
        while (cur.next()) {
            data.add(Id.newId((String)cur.get().toString(null)));
        }
        this.findRelatedData(id, data);
        ArrayList<Id> tmp = new ArrayList<Id>();
        tmp.addAll(data);
        Collections.sort(tmp);
        BVector v = new BVector();
        for (Id i : tmp) {
            v.add(null, (BValue)BString.make((String)i.toString()));
        }
        this.setRelatedData(v);
    }

    public void doInvalidateTargets() {
        this.stale = true;
        this.clearTargets();
        this.updateConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BComponent doListNodes() {
        BComponent ret = new BComponent();
        HashMap<BINavNode, AlertEntry> hashMap = this.entries;
        synchronized (hashMap) {
            for (BINavNode node : this.entries.keySet()) {
                ret.add(null, (BValue)Utils.getNodeOrd(node));
            }
        }
        return ret;
    }

    public void doResyncPoller() {
        this.leavePoller();
        this.enterPoller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<AlertEntry> getEntries(Context cx) {
        ArrayList<AlertEntry> ret = new ArrayList<AlertEntry>();
        if (this.getPermissions(cx).hasOperatorRead()) {
            HashMap<BINavNode, AlertEntry> hashMap = this.entries;
            synchronized (hashMap) {
                Map<BINavNode, AlertEntry> entriesFiltered = this.entries.entrySet().stream().filter(p -> Utils.hasOperatorRead((BINavNode)p.getKey(), cx)).collect(Collectors.toMap(p -> (BINavNode)p.getKey(), p -> (AlertEntry)p.getValue()));
                ret.addAll(entriesFiltered.values());
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findTargets() {
        this.stale = false;
        this.updateConfig();
        if (this.isOperational()) {
            this.findAllNodes();
            int count = 0;
            HashMap<BINavNode, AlertEntry> hashMap = this.entries;
            synchronized (hashMap) {
                count = this.entries.size();
            }
            this.setNodeCount(count);
            if (count > 0) {
                this.enterPoller();
            }
        }
    }

    public Id getDataId() {
        if (this.dataId == null) {
            this.dataId = Id.newId((String)this.getData());
        }
        return this.dataId;
    }

    public BIcon getIcon() {
        return Utils.iconAlert;
    }

    public void stopped() throws Exception {
        this.clearTargets();
        super.stopped();
    }

    @Override
    protected void updateConfig() {
        int bits = 0;
        if (!this.getEnabled()) {
            bits = 1;
        }
        if (this.stale) {
            bits |= 0x10;
        }
        if (this.getData().length() == 0) {
            this.updateConfig(bits | 2, Utils.lex("missingDataId"));
            return;
        }
        try {
            this.getNodePredicate().test((Entity)this);
        }
        catch (Exception x) {
            this.updateConfig(bits | 2, Utils.lex("invalidNodeFilter"));
            return;
        }
        if (BAnalyticService.getInstance().getPoller(this.getPoller()) == null) {
            this.updateConfig(bits | 2, Utils.lex("invalidPoller"));
            return;
        }
        if (this.getRoots().getSlotCount() == 0) {
            this.updateConfig(bits | 2, Utils.lex("missingRoots"));
            return;
        }
        this.updateConfig(bits, null);
    }

    void plusAlertCount() {
        this.setAlertCount(this.getAlertCount() + 1);
    }

    void minusAlertCount() {
        this.setAlertCount(this.getAlertCount() - 1);
    }

    private void createEntryFor(NodeInfo info) {
        boolean entryDoesNotExist;
        boolean bl = entryDoesNotExist = !this.entries.keySet().stream().anyMatch(key -> key.getNavOrd().equals((Object)info.getNode().getNavOrd()));
        if (entryDoesNotExist) {
            AlertEntry entry = new AlertEntry(this, info);
            info.putEntry(this, entry);
            this.entries.put(info.getNode(), entry);
        }
    }

    private void findAllNodes() {
        BINavNode o2;
        SlotCursor cur = this.getExclusions().getProperties();
        TreeSet<BOrd> exclude = new TreeSet<BOrd>();
        while (cur.next()) {
            try {
                o2 = Utils.resolveNode(BOrd.make((String)cur.get().toString(null)).resolve((BObject)this));
                exclude.add(Utils.getNodeOrd(o2));
                this.updateOrdListCopy(this.getExclusions(), cur.property(), o2);
            }
            catch (Exception o2) {}
        }
        cur = this.getRoots().getProperties();
        while (cur.next()) {
            try {
                o2 = Utils.resolveNode(BOrd.make((String)cur.get().toString(null)).resolve((BObject)this));
                if (Utils.log().isLoggable(Level.FINER)) {
                    BAnalyticService.RequestContext.getReqAnalyticContext().set(new AnalyticContext().setNode(o2));
                    BAnalyticService.RequestContext.getReqOrigin().set("alert:" + this.getName());
                }
                this.tryMonitor(o2, exclude);
                this.updateOrdListCopy(this.getRoots(), cur.property(), o2);
            }
            catch (Exception exception) {}
        }
    }

    private void updateOrdListCopy(BAnalyticVector vector, Property prop, BINavNode o) {
        if (o instanceof BHierNode) {
            vector.lease();
            BOrd hierarchyOrd = ((BLevelElem)((BHierNode)o).getHierarchyNode()).getHierarchyOrd();
            vector.remove(prop);
            vector.add(null, (BValue)hierarchyOrd);
        }
    }

    private void findRelatedData(AlgorithmBlock block, HashSet<Id> relatedData) {
        Id id;
        if (block == null) {
            return;
        }
        if (block instanceof BDataSourceBlock && (id = ((BDataSourceBlock)block).getDataId()) != null) {
            relatedData.add(id);
            this.findRelatedData(id, relatedData);
        }
        int len = block.getInputCount();
        for (int i = 0; i < len; ++i) {
            this.findRelatedData(block.getInput(i), relatedData);
        }
    }

    private void findRelatedData(Id id, HashSet<Id> relatedData) {
        Algorithm alg = BAnalyticService.getInstance().getAlgorithm(id);
        if (alg instanceof BAlgorithm) {
            BAlgorithm balg = (BAlgorithm)alg;
            this.findRelatedData(balg.getResult(), relatedData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enterPoller() {
        BAnalyticPoller poller;
        if (!this.isOperational()) {
            return;
        }
        this.lastPoller = poller = BAnalyticService.getInstance().getPoller(this.getPoller());
        if (poller == null) {
            return;
        }
        HashMap<BINavNode, AlertEntry> hashMap = this.entries;
        synchronized (hashMap) {
            this.entries.values().forEach(e -> poller.register((AnalyticConfigurable)e));
        }
    }

    public String getNodeFilterTrimmed() {
        String str = this.getNodeFilter();
        return str.trim();
    }

    private Predicate<Entity> getNodePredicate() {
        if (this.nodePredicate == null) {
            String str = this.getNodeFilterTrimmed();
            this.nodePredicate = str.length() == 0 ? includeAll : new NeqlPredicate(str);
        }
        return this.nodePredicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leavePoller() {
        if (this.lastPoller == null) {
            return;
        }
        BAnalyticPoller poller = this.lastPoller;
        HashMap<BINavNode, AlertEntry> hashMap = this.entries;
        synchronized (hashMap) {
            this.entries.values().forEach(e -> poller.unregister((AnalyticConfigurable)e));
        }
        this.lastPoller = null;
    }

    private static BFacets makeTextFacets() {
        BFacets ret = BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE);
        ret = BFacets.make((BFacets)ret, (String)"fieldWidth", (BIDataValue)BInteger.make((int)100));
        return ret;
    }

    private void tryMonitor(BINavNode node, TreeSet<BOrd> exclude) {
        BINavNode[] kids;
        NodeInfo info;
        BINavNode orig = node;
        node = Utils.getProxyTarget(node);
        if (!BAnalyticService.getInstance().isValidNodeType(node)) {
            return;
        }
        if (exclude.contains(Utils.getNodeOrd(orig))) {
            return;
        }
        if (node != orig && exclude.contains(Utils.getNodeOrd(node))) {
            return;
        }
        boolean passFilter = true;
        if (node instanceof Entity) {
            passFilter &= this.getNodePredicate().test((Entity)node);
        } else if (this.getNodeFilterTrimmed().length() > 0) {
            passFilter = false;
        }
        if (node != orig && orig instanceof Entity) {
            passFilter &= this.getNodePredicate().test((Entity)node);
        }
        if (passFilter && node instanceof BINavNode && (info = NodeInfo.get(orig, true)) != null && info.getEntry(this) == null) {
            String debugTrace;
            boolean isNotNullAnalyticDataSource = info.isAnalyticDataSourceNotNull(this.getDataId(), true);
            if (isNotNullAnalyticDataSource) {
                this.createEntryFor(info);
            } else if (Utils.log().isLoggable(Level.FINER) && (debugTrace = BAnalyticAlert.prepareLogMessage(orig, this.getDataId())) != null && !debugTrace.isEmpty()) {
                BAnalyticService.RequestContext.getReqMessages().get().add(debugTrace);
            }
        }
        if ((kids = orig.getNavChildren()) != null && kids.length > 0) {
            int len = kids.length;
            for (int i = 0; i < len; ++i) {
                this.tryMonitor(kids[i], exclude);
            }
        }
    }

    private static String prepareLogMessage(BINavNode node, Id id) {
        AnalyticContext oCx;
        String nodeName = null;
        String dataStr = null;
        String algName = null;
        String aSource = null;
        if (node != null && node.getNavOrd() != null) {
            nodeName = node.getNavOrd().toString();
        }
        if (id != null) {
            dataStr = id.getQName();
        }
        if (BAnalyticService.RequestContext.getReqOrigin() != null) {
            aSource = BAnalyticService.RequestContext.getReqOrigin().get();
        }
        if ((oCx = BAnalyticService.RequestContext.getReqAnalyticContext().get()) != null && oCx.getNode() != null && oCx.getNode().equals(node)) {
            return Utils.prepareDebugMessage(aSource, dataStr, nodeName, algName, null);
        }
        return null;
    }

    private static class IncludeAll
    implements Predicate<Entity> {
        private IncludeAll() {
        }

        @Override
        public boolean test(Entity e) {
            return true;
        }
    }
}

