/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.alert;

import com.tridiumx.analytics.Analytics;
import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.alert.BAnalyticAlert;
import com.tridiumx.analytics.algorithm.missingdata.BMissingDataStrategy;
import com.tridiumx.analytics.data.NodeInfo;
import com.tridiumx.analytics.data.Values;
import com.tridiumx.analytics.poll.AnalyticConfigurable;
import com.tridiumx.analytics.util.Alarms;
import com.tridiumx.analytics.util.Utils;
import java.util.HashMap;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Clock;
import javax.baja.sys.Cursor;
import javax.baja.util.BFormat;
import javax.baja.util.BUuid;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.time.BAnalyticTimeRange;
import javax.bajax.analytics.time.Interval;
import javax.bajax.analytics.time.TimeRange;

public class AlertEntry
implements AnalyticConfigurable,
Comparable<Object> {
    private BUuid alarmRecord;
    private BAnalyticAlert alert;
    private String alertId;
    private static HashMap<String, BUuid> alarmMap;
    private int exceptions = 0;
    private boolean inAlert;
    private NodeInfo nodeInfo;
    private int skip = 0;
    private double totalCost;

    public AlertEntry(BAnalyticAlert alert, NodeInfo info) {
        this.alert = alert;
        this.nodeInfo = info;
        this.alarmRecord = alarmMap.remove(this.getAlertId());
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof AlertEntry)) {
            return -1;
        }
        AlertEntry other = (AlertEntry)obj;
        int ret = this.getNodeOrd().toString(null).compareTo(other.getNodeOrd().toString(null));
        if (ret == 0) {
            ret = this.alert.toPathString().compareTo(other.getAlert().toPathString());
        }
        return ret;
    }

    public static void clearRemainingAlarms() {
        for (BUuid uuid : alarmMap.values()) {
            try {
                BAlarmRecord rec = Alarms.getAlarm(uuid);
                if (rec == null) continue;
                Alarms.clear(rec, Utils.lex("invalidRecord"));
                Alarms.save(rec);
            }
            catch (Exception exception) {}
        }
        alarmMap = null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AlertEntry)) {
            return false;
        }
        return this.getAlertId().equals(((AlertEntry)obj).getAlertId());
    }

    public String getAlertId() {
        if (this.alertId == null) {
            this.alertId = Integer.toHexString(this.alert.toPathString().hashCode()) + "_" + Integer.toHexString(this.getNodeOrd().toString(null).hashCode());
        }
        return this.alertId;
    }

    public BAnalyticAlert getAlert() {
        return this.alert;
    }

    public double getTotalCost() {
        return this.totalCost;
    }

    @Override
    public boolean getEnabled() {
        return this.alert.getEnabled();
    }

    public BINavNode getNode() {
        return this.nodeInfo.getNode();
    }

    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public BOrd getNodeOrd() {
        return Utils.getNodeOrd(this.getNode());
    }

    public int hashCode() {
        return this.getAlertId().hashCode();
    }

    public boolean isInAlert() {
        return this.inAlert;
    }

    public static void loadOpenAlarms() {
        alarmMap = new HashMap();
        try (Cursor<BAlarmRecord> cur = Alarms.openAlarms();){
            while (cur.next()) {
                BObject alertId;
                BAlarmRecord rec = (BAlarmRecord)cur.get();
                if (rec.getSourceState() == BSourceState.normal || (alertId = rec.getAlarmFacet("alertId")) == null) continue;
                alarmMap.put(alertId.toString(null), rec.getUuid());
            }
        }
        catch (Exception x) {
            Utils.log().log(Level.SEVERE, Utils.lex("scanningOpenAlarms"), x);
        }
    }

    @Override
    public void updateConfig() {
        if (this.alert != null) {
            this.alert.updateConfig();
        }
    }

    @Override
    public void run() {
        block19: {
            if (this.skip > 0) {
                --this.skip;
                return;
            }
            try {
                BMissingDataStrategy mds;
                BAnalyticService svc = BAnalyticService.getInstance();
                if (!svc.isOperational()) {
                    this.alert.updateConfig();
                    if (!svc.isOperational()) {
                        return;
                    }
                }
                AnalyticContext cx = new AnalyticContext();
                cx.setData(this.alert.getDataId());
                cx.setNode(this.nodeInfo.getNode());
                boolean last = this.inAlert;
                if (this.alert.getInterval().getHasValue()) {
                    cx.setInterval((Interval)this.alert.getInterval().getValue());
                }
                if (this.alert.getDataFilter().length() > 0) {
                    cx.setDataFilter(this.alert.getDataFilter());
                }
                if (this.alert.getTotalize().getHasValue()) {
                    cx.setHisTotEnabled(!((BBoolean)this.alert.getTotalize().getValue()).getBoolean());
                }
                if ((mds = this.alert.getMissingDataStrategy()).getEnabled()) {
                    cx.setMissingDataStrategy(mds);
                }
                if (this.alert.getTimeRange().getHasValue()) {
                    TimeRange tr = (TimeRange)this.alert.getTimeRange().getValue();
                    long now = System.currentTimeMillis();
                    BAbsTime start = BAbsTime.make((long)tr.getStart(now));
                    BAbsTime end = BAbsTime.make((long)(tr.getEnd(now) + 1L));
                    cx.setTimeRange(BAnalyticTimeRange.make(start, end));
                    AnalyticTrend trend = Analytics.getTrend(cx);
                    if (this.alert.getAlertMode().isRuntime()) {
                        long millis = Utils.runtimeMillis(trend);
                        if (millis > 0L) {
                            double val = this.alert.getAlertMode().convertMillis(millis);
                            this.setInAlert(this.alert.getAlertMode().isAlert(val));
                            this.totalCost = this.alert.getCost() * val;
                        } else {
                            this.setInAlert(false);
                        }
                    } else {
                        int count = Utils.countToTrue(trend);
                        this.setInAlert(this.alert.getAlertMode().isAlert(count));
                        this.totalCost = this.alert.getCost() * (double)count;
                    }
                } else {
                    AnalyticValue val = Analytics.getValue(cx);
                    this.setInAlert(this.processAlertOn(val) && val.toBoolean());
                    this.totalCost = this.alert.getCost();
                }
                if (last != this.inAlert) {
                    if (this.inAlert) {
                        this.alert.plusAlertCount();
                    } else {
                        this.alert.minusAlertCount();
                    }
                }
                if (!this.inAlert) {
                    this.totalCost = 0.0;
                }
                this.exceptions = 0;
            }
            catch (Exception x) {
                ++this.exceptions;
                this.skip = this.exceptions;
                if (this.exceptions != 1) break block19;
                x.printStackTrace();
            }
        }
    }

    private boolean processAlertOn(AnalyticValue val) {
        if (val.isValid()) {
            return true;
        }
        return Values.isAlarm(val.getStatus()) && Values.isFault(val.getStatus());
    }

    protected BUuid makeAlarm() {
        BAlarmRecord rec = new BAlarmRecord(BUuid.make());
        rec.setSource(BOrdList.make((BOrd)this.alert.getSlotPathOrd()));
        rec.setTimestamp(Clock.time());
        rec.setLastUpdate(Clock.time());
        rec.setAlarmData(this.alert.getAlarmData());
        rec.setAlarmClass(BFormat.format((String)this.alert.getAlarmClass(), (Object)this));
        rec.setSourceState(BSourceState.fault);
        BFacets data = rec.getAlarmData();
        data = BFacets.make((BFacets)this.alert.getAlarmData(), (BFacets)data);
        for (String key : data.list()) {
            String nxt;
            String cur;
            BObject obj = data.get(key);
            if (!(obj instanceof BString) || (cur = obj.toString(null)).equals(nxt = BFormat.format((String)cur, (Object)this, null))) continue;
            rec.addAlarmFacet(key, (BIDataValue)BString.make((String)nxt));
        }
        rec.addAlarmFacet("alertId", (BIDataValue)BString.make((String)this.getAlertId()));
        rec.addAlarmFacet("node", (BIDataValue)BString.make((String)this.getNodeOrd().toString(null)));
        rec.addAlarmFacet("msgText", (BIDataValue)BString.make((String)BFormat.format((String)this.alert.getAlarmMessage(), (Object)this, null)));
        String sourceName = this.getAlert().getSourceName().format((Object)this);
        if (sourceName.contains("%err:")) {
            sourceName = BFormat.format((String)BAnalyticAlert.sourceName.getDefaultValue().toString(), (Object)this);
            rec.addAlarmFacet("notes", BString.make((String)Utils.lex("problemWithAlertSourceNameBFormatMessage", new String[]{this.alert.getName()})).toDataValue());
            Utils.log().log(Level.SEVERE, Utils.lex("problemWithAlertSourceNameBFormatMessage", new String[]{this.alert.getName()}));
        }
        rec.addAlarmFacet("sourceName", BOrdList.make((String)sourceName).toDataValue());
        rec.addAlarmFacet("alertName", (BIDataValue)BString.make((String)this.alert.getName().toString()));
        Alarms.save(rec);
        return rec.getUuid();
    }

    private void setInAlert(boolean arg) {
        if (arg == this.inAlert) {
            return;
        }
        this.inAlert = arg;
        if (arg && this.alert.getAlarm()) {
            if (this.alarmRecord == null) {
                this.alarmRecord = this.makeAlarm();
            }
        } else if (!arg && this.alarmRecord != null) {
            try {
                BAlarmRecord rec = Alarms.getAlarm(this.alarmRecord);
                if (rec != null) {
                    Alarms.toNormal(rec);
                    Alarms.save(rec);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            this.alarmRecord = null;
        }
    }
}

