/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.util;

public class StringUtil {
    private static final int SPACES_PER_STOP = 2;

    public static String indent(String string, int numStops) {
        StringBuilder buf = new StringBuilder();
        for (String line : string.split("\n")) {
            for (int i = 0; i < 2 * numStops; ++i) {
                buf.append(" ");
            }
            buf.append(line);
            buf.append("\n");
        }
        return buf.toString();
    }

    public static String indent(String string) {
        return StringUtil.indent(string, 1);
    }

    public static String hexdump(int bytesPerLine, byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        for (int start = 0; start < bytes.length; start += bytesPerLine) {
            int pos;
            int end = Math.min(bytes.length, start + bytesPerLine);
            for (pos = start; pos < end; ++pos) {
                builder.append(String.format("%02X ", bytes[pos] & 0xFF));
            }
            for (int i = 0; i < bytesPerLine - (end - start); ++i) {
                builder.append("   ");
            }
            builder.append("|");
            for (pos = start; pos < end; ++pos) {
                char ch = (char)(bytes[pos] & 0xFF);
                if (!Character.isISOControl(ch) && !Character.isWhitespace(ch)) {
                    builder.append(ch);
                } else {
                    builder.append(" ");
                }
                builder.append("|");
            }
            builder.append("\n");
        }
        return builder.toString();
    }
}

