/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.point;

import com.tridium.ace.enums.BAcePrimitiveTypeEnum;
import com.tridium.ace.enums.BAceSlotTypeEnum;
import com.tridium.ace.point.AppComponentPoints;
import com.tridium.ace.point.AppPointDescriptor;
import com.tridium.ace.point.ComponentCollector;
import com.tridium.ace.point.KitComponentPoints;
import com.tridium.ace.point.KitPointDefinition;
import com.tridium.ace.point.PointDefinition;
import com.tridium.ace.point.PointDescriptions;
import com.tridium.ace.point.PointDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;

public class DevicePointDescriptions
extends PointDescriptions
implements ComponentCollector {
    private final Map<Integer, AppComponentPoints> appComponents = new TreeMap<Integer, AppComponentPoints>();
    private final Map<String, KitComponentPoints> kitComponents = new HashMap<String, KitComponentPoints>();

    @Override
    public Iterator<PointDescriptor> iterator() {
        return new PointIterator(this.appComponents.values().iterator());
    }

    @Override
    public int size() {
        int s = 0;
        for (AppComponentPoints appComponent : this.appComponents.values()) {
            String typeName = appComponent.getTypeName();
            s += this.getKitComponent(typeName).size();
        }
        return s;
    }

    @Override
    public boolean hasKitComponent(String typeName) {
        return this.kitComponents.containsKey(typeName);
    }

    @Override
    public void foundKitPoint(String typeName, int slotId, String slotName, BAcePrimitiveTypeEnum dataType, BAceSlotTypeEnum slotType, boolean config, BFacets facets, BValue defaultValue) {
        this.getKitComponent(typeName).setPoint(slotId, slotName, slotType, config, dataType, facets, defaultValue);
    }

    @Override
    public void foundAppComponentId(int id) {
        this.getAppComponent(id);
    }

    @Override
    public void foundAppComponentTypeName(int id, String typeName) {
        this.getAppComponent(id).setTypeName(typeName);
    }

    @Override
    public void foundAppComponentFullName(int id, String fullName) {
        this.getAppComponent(id).setFullName(fullName);
    }

    @Override
    public void foundAppComponentSlotEnumRange(int id, int slotId, BValue value) {
        this.getAppComponent(id).setPointEnumRange(slotId, value);
    }

    public int getSlotId(String typeName, String slotName) {
        KitComponentPoints k = this.kitComponents.get(typeName);
        if (k == null) {
            return -1;
        }
        KitPointDefinition def = k.getPoint(slotName);
        if (def == null) {
            return -1;
        }
        return def.getSlotId();
    }

    public String getSlotName(String typeName, int slotId) {
        PointDefinition p = this.getPointDefinition(typeName, slotId);
        return p == null ? null : p.getSlotName();
    }

    public BAcePrimitiveTypeEnum getDataType(String typeName, int slotId) {
        PointDefinition p = this.getPointDefinition(typeName, slotId);
        return p == null ? null : p.getDataType();
    }

    public BAceSlotTypeEnum getSlotType(String typeName, int slotId) {
        PointDefinition p = this.getPointDefinition(typeName, slotId);
        return p == null ? null : p.getSlotType();
    }

    public boolean getConfig(String typeName, int slotId) {
        PointDefinition p = this.getPointDefinition(typeName, slotId);
        return p != null && p.getConfig();
    }

    public BFacets getFacets(String typeName, int slotId) {
        PointDefinition p = this.getPointDefinition(typeName, slotId);
        return p == null ? null : p.getFacets();
    }

    public BValue getDefaultValue(String typeName, int slotId) {
        PointDefinition p = this.getPointDefinition(typeName, slotId);
        return p == null ? null : p.getDefaultValue();
    }

    private PointDefinition getPointDefinition(String typeName, int slotId) {
        KitComponentPoints k = this.kitComponents.get(typeName);
        if (k == null) {
            return null;
        }
        PointDefinition p = (PointDefinition)k.get(slotId);
        if (p == null) {
            return null;
        }
        return p;
    }

    public boolean hasSolitaryPoint(String typeName) {
        KitComponentPoints k = this.kitComponents.get(typeName);
        return k != null && k.hasSolitaryPoint();
    }

    public AppComponentPoints getAppComponent(int id) {
        return this.appComponents.computeIfAbsent(id, k -> new AppComponentPoints(this, id));
    }

    private KitComponentPoints getKitComponent(String typeName) {
        return this.kitComponents.computeIfAbsent(typeName, k -> new KitComponentPoints(typeName));
    }

    private class PointIterator
    implements Iterator<PointDescriptor> {
        private final Iterator<AppComponentPoints> appComponentIterator;
        private AppComponentPoints currentAppComponent;
        private Iterator<PointDefinition> kitPointIterator;

        PointIterator(Iterator<AppComponentPoints> appComponentIterator) {
            this.appComponentIterator = appComponentIterator;
        }

        @Override
        public boolean hasNext() {
            while ((this.kitPointIterator == null || !this.kitPointIterator.hasNext()) && this.appComponentIterator.hasNext()) {
                this.currentAppComponent = this.appComponentIterator.next();
                this.kitPointIterator = DevicePointDescriptions.this.getKitComponent(this.currentAppComponent.getTypeName()).values().iterator();
            }
            return this.kitPointIterator != null && this.kitPointIterator.hasNext();
        }

        @Override
        public PointDescriptor next() {
            this.hasNext();
            if (this.kitPointIterator == null || !this.kitPointIterator.hasNext()) {
                throw new NoSuchElementException();
            }
            KitPointDefinition pointDef = (KitPointDefinition)this.kitPointIterator.next();
            int slotId = pointDef.getSlotId();
            if (this.currentAppComponent.containsKey(slotId)) {
                return (PointDescriptor)this.currentAppComponent.get(slotId);
            }
            return new AppPointDescriptor(this.currentAppComponent, slotId);
        }
    }
}

