/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.point;

import com.tridium.ace.enums.BAcePrimitiveTypeEnum;
import com.tridium.ace.enums.BAceSlotTypeEnum;
import com.tridium.ace.point.AppComponentPoints;
import com.tridium.ace.point.PointDescriptor;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;

public class AppPointDescriptor
extends PointDescriptor {
    private final AppComponentPoints appComponent;
    private final int id;
    private BStatusValue value;
    private BValue rangeVal;
    private boolean linkTarget = false;

    public AppPointDescriptor(AppComponentPoints appComponent, int id) {
        this.appComponent = appComponent;
        this.id = id;
    }

    @Override
    public String getAppComponentFullName() {
        return SlotPath.unescape((String)this.appComponent.getFullName());
    }

    @Override
    public int getAppComponentId() {
        return this.appComponent.getId();
    }

    @Override
    public int getSlotId() {
        return this.id;
    }

    @Override
    public boolean isSolitary() {
        return this.appComponent.hasSolitaryPoint();
    }

    @Override
    public String getSlotName() {
        return this.appComponent.getSlotName(this.id);
    }

    @Override
    public BAcePrimitiveTypeEnum getDataType() {
        return this.appComponent.getDataType(this.id);
    }

    @Override
    public BAceSlotTypeEnum getSlotType() {
        return this.appComponent.getSlotType(this.id);
    }

    @Override
    public boolean getConfig() {
        return this.appComponent.getConfig(this.id);
    }

    @Override
    public BFacets getFacets() {
        return this.appComponent.getFacets(this.id);
    }

    @Override
    public BValue getDefaultValue() {
        return this.appComponent.getDefaultValue(this.id);
    }

    @Override
    public BStatusValue getValue() {
        return this.value;
    }

    @Override
    public BValue getEnumRange() {
        return this.rangeVal;
    }

    public void setValue(BStatusValue value) {
        this.value = value;
    }

    public void setEnumRange(BValue value) {
        this.rangeVal = value;
    }

    @Override
    public boolean isLinkTarget() {
        return this.linkTarget;
    }

    public void setLinkTarget(boolean v) {
        this.linkTarget = v;
    }
}

