/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.message;

import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.component.BAceLink;
import com.tridium.ace.enums.BAceReqActionTypeEnum;
import com.tridium.ace.message.AceMessage;
import com.tridium.ndriver.io.TypedInputStream;
import com.tridium.ndriver.io.TypedOutputStream;
import javax.baja.sys.BajaRuntimeException;

public class AceLinkReq
extends AceMessage {
    String srcComp;
    String srcSlot;
    String tgtComp;
    String tgtSlot;
    BAceReqActionTypeEnum action;

    public AceLinkReq() {
        super(9);
    }

    public static AceLinkReq makeAdd(BAceLink link) {
        AceLinkReq nal = new AceLinkReq();
        nal.srcComp = ((BAceComponent)link.getSourceComponent()).getAceFullPathName();
        nal.srcSlot = link.getSourceSlot().getName();
        nal.tgtComp = ((BAceComponent)link.getTargetComponent()).getAceFullPathName();
        nal.tgtSlot = link.getTargetSlot().getName();
        nal.action = BAceReqActionTypeEnum.add;
        nal.setNextTag();
        return nal;
    }

    public static AceLinkReq makeRemove(BAceLink link) {
        AceLinkReq nal = new AceLinkReq();
        nal.srcComp = ((BAceComponent)link.getSourceComponent()).getAceFullPathName();
        nal.srcSlot = link.getSourceSlot().getName();
        nal.tgtComp = ((BAceComponent)link.getTargetComponent()).getAceFullPathName();
        nal.tgtSlot = link.getTargetSlot().getName();
        nal.action = BAceReqActionTypeEnum.delete;
        nal.setNextTag();
        return nal;
    }

    @Override
    protected void toTypedOutputStream(TypedOutputStream out) {
        out.writeUnsigned8(this.action.getOrdinal());
        this.addString(out, this.srcComp, 255);
        this.addString(out, this.srcSlot, 32);
        this.addString(out, this.tgtComp, 255);
        this.addString(out, this.tgtSlot, 32);
    }

    private void addString(TypedOutputStream out, String s, int maxLen) {
        if (s.length() > maxLen) {
            throw new BajaRuntimeException("Name exceeds maximum allowed length");
        }
        out.writeUnsigned8(s.length());
        out.writeCharArray(s, s.length());
    }

    @Override
    protected void fromTypedInputStream(TypedInputStream in) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    protected void toTraceString(StringBuffer sb) {
        sb.append("action:").append((Object)this.action);
        sb.append("link:").append(this.srcComp).append(".").append(this.srcSlot).append(">>").append(this.tgtComp).append(".").append(this.tgtSlot).append("\n");
    }
}

