/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.datatypes;

import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.datatypes.BIAceInteger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BExeParam
extends BSimple
implements BIAceInteger {
    public static final BExeParam DEFAULT = new BExeParam(0);
    public static final Type TYPE = Sys.loadType(BExeParam.class);
    private int v;

    public Type getType() {
        return TYPE;
    }

    private BExeParam(int n) {
        this.v = n;
    }

    public static BExeParam make(int level, int order) {
        return new BExeParam(BAceComponent.toExeParam(level, order));
    }

    public String toString(Context cx) {
        return (this.getLevel() > 0 ? "level:" + (this.getLevel() + 1) + " " : "") + "order:" + this.getExecOrder();
    }

    public int getLevel() {
        return BAceComponent.getLevel(this.v);
    }

    public int getExecOrder() {
        return BAceComponent.getExecOrder(this.v);
    }

    @Override
    public BIAceInteger make(int n) {
        return new BExeParam(n);
    }

    @Override
    public int getValue() {
        return this.v;
    }

    public int hashCode() {
        return this.toString(null).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BExeParam) {
            return ((BExeParam)obj).getValue() == this.v;
        }
        return false;
    }

    public void encode(DataOutput encoder) throws IOException {
        encoder.writeInt(this.getLevel());
        encoder.writeInt(this.getExecOrder());
    }

    public BObject decode(DataInput decoder) throws IOException {
        return BExeParam.make(decoder.readInt(), decoder.readInt());
    }

    public String encodeToString() throws IOException {
        return this.getLevel() + ":" + this.getExecOrder();
    }

    public BObject decodeFromString(String s) throws IOException {
        int pos = s.indexOf(58);
        int lev = Integer.parseInt(s.substring(s.indexOf(61) + 1, pos).trim());
        int order = Integer.parseInt(s.substring(pos + 1).trim());
        return BExeParam.make(lev, order);
    }
}

