/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.component;

import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.component.BAceLink;
import com.tridium.ace.sys.BAceApp;
import com.tridium.driver.util.DrUtil;
import java.util.ArrayList;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BComponent;
import javax.baja.util.BWsAnnotation;

public class ExecOrder {
    int maxOid = -1;
    private static final int INVALID_ORDER = 0;
    private static final int ORDER_INCREMENT = 1;
    private static int maxExeOrder = BAceComponent.getMaxExecutionOrder();
    IntHashMap compInfoMap = new IntHashMap();

    public static void sort(BAceApp app, boolean force) {
        BAceComponent[] comps = (BAceComponent[])DrUtil.getDecendantsByClass((BComponent)app, BAceComponent.class);
        new ExecOrder().doSort(comps, force);
    }

    public static void sort(BAceComponent[] comps, boolean force) {
        new ExecOrder().doSort(comps, force);
    }

    private void doSort(BAceComponent[] comps, boolean force) {
        ArrayList<CompInfo> wrkLst = new ArrayList<CompInfo>();
        for (BAceComponent cp : comps) {
            if (cp.getObjectId() < 0) continue;
            CompInfo ci = this.getCompInfo(cp);
            if (force) {
                ci.setOrder(0);
            }
            if (force || ci.getOrder() == 0) {
                wrkLst.add(ci);
            }
            this.compInfoMap.put(ci.getOid(), (Object)ci);
        }
        CompInfo[] updateList = wrkLst.toArray(new CompInfo[0]);
        for (int i = wrkLst.size() - 1; i >= 0; --i) {
            CompInfo ci = (CompInfo)wrkLst.get(i);
            if (ci.lnkSrcOids.length == 0) {
                ci.setOrder(1);
                wrkLst.remove(i);
                continue;
            }
            if (ci.getOrder() < 1) continue;
            wrkLst.remove(i);
        }
        this.sort(wrkLst);
        while (wrkLst.size() > 0) {
            CompInfo ci = wrkLst.get(0);
            for (int i = 1; i < wrkLst.size(); ++i) {
                CompInfo tmp = wrkLst.get(i);
                if (ci.annPQ <= tmp.annPQ) continue;
                ci = tmp;
            }
            int order = 0;
            for (int oid : ci.lnkSrcOids) {
                int otherOrder = ((CompInfo)this.compInfoMap.get(oid)).getOrder();
                if (otherOrder <= order) continue;
                order = otherOrder;
            }
            if (++order > maxExeOrder) {
                order = maxExeOrder;
            }
            ci.setOrder(order);
            wrkLst.remove(ci);
            this.sort(wrkLst);
        }
        for (CompInfo ci : updateList) {
            ci.update();
        }
    }

    private void sort(ArrayList<CompInfo> wrkLst) {
        for (int order = 2; order <= maxExeOrder; ++order) {
            for (int i = wrkLst.size() - 1; i >= 0; --i) {
                CompInfo ci = wrkLst.get(i);
                if (!this.orderGood(ci, order)) continue;
                ci.setOrder(order);
                wrkLst.remove(ci);
            }
        }
    }

    private boolean orderGood(CompInfo ci, int order) {
        for (int oid : ci.lnkSrcOids) {
            int otherOrder = ((CompInfo)this.compInfoMap.get(oid)).getOrder();
            if (otherOrder > 0 && otherOrder < order) continue;
            return false;
        }
        return true;
    }

    private CompInfo getCompInfo(BAceComponent cp) {
        CompInfo ci = new CompInfo(cp);
        BWsAnnotation ann = (BWsAnnotation)ci.cp.get("wsAnnotation");
        if (ann != null) {
            ci.annPQ = (long)ann.p << 31 | (long)ann.q;
        }
        BAceLink[] la = (BAceLink[])cp.getChildren(BAceLink.class);
        int[] oids = new int[la.length];
        int i = 0;
        for (BAceLink lk : la) {
            BComponent c;
            if (!lk.isActive()) {
                lk.activate();
            }
            if (!((c = lk.getSourceComponent()) instanceof BAceComponent)) continue;
            int oid = ((BAceComponent)c).getObjectId();
            boolean dup = false;
            for (int n = 0; n < i; ++n) {
                if (oid != oids[n]) continue;
                dup = true;
            }
            if (dup) continue;
            oids[i++] = oid;
        }
        if (i < oids.length) {
            int[] a = new int[i];
            System.arraycopy(oids, 0, a, 0, i);
            oids = a;
        }
        ci.lnkSrcOids = oids;
        return ci;
    }

    int getNextOid(BAceComponent[] comps) {
        if (this.maxOid == -1) {
            for (BAceComponent cp : comps) {
                int oid = cp.getObjectId();
                if (oid <= this.maxOid) continue;
                this.maxOid = oid;
            }
        }
        return ++this.maxOid;
    }

    static class CompInfo {
        private BAceComponent cp;
        private int order;
        int[] lnkSrcOids;
        long annPQ = 0L;

        CompInfo(BAceComponent cp) {
            this.cp = cp;
            this.order = cp.getExecOrder();
        }

        int getOid() {
            return this.cp.getObjectId();
        }

        void setOrder(int order) {
            this.order = order;
        }

        int getOrder() {
            return this.order;
        }

        public String toString() {
            return this.cp.getName() + "{" + this.getOid() + "}" + this.getOrder();
        }

        void update() {
            this.cp.setExecOrder(this.order, null);
        }
    }
}

