/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfHttp.comm.rsp;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.IDdfReadable;
import com.tridium.ddf.comm.rsp.BDdfResponse;
import com.tridium.ddf.comm.rsp.BIDdfReadResponse;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.point.BDdfProxyExt;
import com.tridium.ddfHttp.identify.BIDdfHttpInspectExpression;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BStringPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDdfHttpInspectReadResponse
extends BDdfResponse
implements BIDdfReadResponse {
    @Generated
    public static final Type TYPE = Sys.loadType(BDdfHttpInspectReadResponse.class);
    protected String htmlText;
    protected String urlAddress;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDdfHttpInspectReadResponse() {
    }

    public BDdfHttpInspectReadResponse(IDdfDataFrame httpResponseData, String urlAddress) {
        this.urlAddress = urlAddress;
        byte[] httpResponseBytes = new byte[httpResponseData.getFrameSize()];
        System.arraycopy(httpResponseData.getFrameBytes(), 0, httpResponseBytes, 0, httpResponseData.getFrameSize());
        this.htmlText = new String(httpResponseBytes);
    }

    public BStatusValue parseReadValue(IDdfReadable readableSource) {
        if (readableSource instanceof BDdfProxyExt) {
            BDdfProxyExt proxy = (BDdfProxyExt)readableSource;
            BDdfIdParams pointId = proxy.getPointId();
            if (pointId instanceof BIDdfHttpInspectExpression) {
                BIDdfHttpInspectExpression httpInspectResult = (BIDdfHttpInspectExpression)pointId;
                return this.getReadValue(proxy, httpInspectResult);
            }
            return null;
        }
        return null;
    }

    protected double parseNumericValue(String sRawValue) {
        try {
            return Long.parseLong(sRawValue);
        }
        catch (NumberFormatException nfe) {
            return Double.parseDouble(sRawValue);
        }
    }

    protected BStatusValue getReadValue(BDdfProxyExt proxy, BIDdfHttpInspectExpression inspectResult) {
        String sRawValue = this.inspectHtml(proxy, inspectResult);
        BControlPoint controlPoint = proxy.getParentPoint();
        if (sRawValue == null) {
            if (controlPoint instanceof BIBoolean) {
                return new BStatusBoolean(false);
            }
            throw new BajaRuntimeException("RegEx Pattern Not Found: " + inspectResult.getRegExp() + "\nUrl: " + this.urlAddress + "\nSlot: " + proxy.getSlotPath());
        }
        if (controlPoint instanceof BINumeric) {
            return new BStatusNumeric(this.parseNumericValue(sRawValue));
        }
        if (controlPoint instanceof BIBoolean) {
            return new BStatusBoolean(true);
        }
        if (controlPoint instanceof BIEnum) {
            BStatusEnum e = ((BEnumPoint)controlPoint).getOut();
            try {
                double d = this.parseNumericValue(sRawValue);
                return new BStatusEnum((BEnum)BDynamicEnum.make((int)((int)Math.round(d)), (BEnumRange)e.getValue().getRange()));
            }
            catch (NumberFormatException nfe) {
                BEnum newEnum = e.getValue().getRange().get(sRawValue);
                return new BStatusEnum((BEnum)BDynamicEnum.make((int)newEnum.getOrdinal(), (BEnumRange)e.getValue().getRange()));
            }
        }
        if (controlPoint instanceof BStringPoint) {
            return new BStatusString(sRawValue);
        }
        throw new IllegalStateException("Unsupported control point type: " + controlPoint.getType() + "! Please have my program fixed.");
    }

    protected String inspectHtml(BDdfProxyExt proxy, BIDdfHttpInspectExpression pointInspectInfo) {
        Pattern oroPattern = null;
        try {
            oroPattern = Pattern.compile(pointInspectInfo.getRegExp());
        }
        catch (PatternSyntaxException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        Matcher oroMatcher = oroPattern.matcher(this.htmlText);
        if (oroMatcher.find()) {
            MatchResult oroResult = oroMatcher.toMatchResult();
            return oroResult.group(pointInspectInfo.getRegExpGroup());
        }
        return null;
    }
}

