/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfHttp.comm;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import com.tridium.ddf.comm.singleTransaction.BDdfSingleTransactionCommunicator;
import com.tridium.ddfHttp.comm.BDdfHttpReceiver;
import com.tridium.ddfHttp.comm.BDdfHttpTransmitter;
import com.tridium.ddfHttp.comm.BDdfHttpUserNameAndPassword;
import com.tridium.ddfHttp.comm.DdfHttpHelper;
import com.tridium.ddfHttp.comm.req.BIDdfHttpCredentialsReq;
import com.tridium.ddfHttp.comm.req.BIDdfHttpStreamRequest;
import java.net.MalformedURLException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BICredentials;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="transmitter", type="BDdfTransmitter", defaultValue="new BDdfHttpTransmitter()", override=true), @NiagaraProperty(name="receiver", type="BDdfReceiver", defaultValue="new BDdfHttpReceiver()", override=true), @NiagaraProperty(name="credentials", type="BDdfHttpUserNameAndPassword", defaultValue="new BDdfHttpUserNameAndPassword()", facets={@Facet(value="DdfFacets.combine(MGR_INCLUDE, MGR_OPTIONAL_IN_TABLE)")})})
public class BDdfHttpCommunicator
extends BDdfSingleTransactionCommunicator {
    @Generated
    public static final Property transmitter = BDdfHttpCommunicator.newProperty((int)0, (BValue)new BDdfHttpTransmitter(), null);
    @Generated
    public static final Property receiver = BDdfHttpCommunicator.newProperty((int)0, (BValue)new BDdfHttpReceiver(), null);
    @Generated
    public static final Property credentials = BDdfHttpCommunicator.newProperty((int)0, (BValue)new BDdfHttpUserNameAndPassword(), (BFacets)DdfFacets.combine((BFacets)MGR_INCLUDE, (BFacets)MGR_OPTIONAL_IN_TABLE));
    @Generated
    public static final Type TYPE = Sys.loadType(BDdfHttpCommunicator.class);
    HttpUrlChecker httpUrlChecker;

    @Generated
    public BDdfHttpUserNameAndPassword getCredentials() {
        return (BDdfHttpUserNameAndPassword)this.get(credentials);
    }

    @Generated
    public void setCredentials(BDdfHttpUserNameAndPassword v) {
        this.set(credentials, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDdfHttpTransmitter getHttpTransmitter() {
        return (BDdfHttpTransmitter)this.getDdfTransmitter();
    }

    public BDdfHttpReceiver getHttpReceiver() {
        return (BDdfHttpReceiver)this.getDdfReceiver();
    }

    public BICredentials getHttpCredentials(BIDdfRequest ddfHttpRequest) {
        if (ddfHttpRequest instanceof BIDdfHttpCredentialsReq) {
            BICredentials reqCredentials = ((BIDdfHttpCredentialsReq)ddfHttpRequest).getCredentials();
            if (reqCredentials == null) {
                return this.getCredentials();
            }
            return reqCredentials;
        }
        return this.getCredentials();
    }

    public String getHttpContentType(BIDdfRequest ddfHttpRequest) {
        return "application/x-www-form-urlencoded";
    }

    public int getSoTimeout(BIDdfRequest ddfHttpRequest) {
        return (int)ddfHttpRequest.getResponseTimeout().getMillis();
    }

    protected void preProcessStreamRequest(BIDdfHttpStreamRequest ddfRequest) {
        ddfRequest.setResponseTimeout(BRelTime.DEFAULT);
    }

    protected void preValidateUrl(BIDdfRequest ddfRequest) throws Exception {
        if (this.httpUrlChecker == null) {
            this.httpUrlChecker = new HttpUrlChecker();
        }
        this.httpUrlChecker.checkUrl(ddfRequest);
    }

    public void doCommunicate(BIDdfRequest ddfRequest) {
        if (ddfRequest instanceof BIDdfHttpStreamRequest) {
            this.preProcessStreamRequest((BIDdfHttpStreamRequest)ddfRequest);
        }
        try {
            this.preValidateUrl(ddfRequest);
            super.doCommunicate(ddfRequest);
        }
        catch (Exception e) {
            DdfRequestUtil.processTimeout((BIDdfRequest)ddfRequest);
        }
    }

    public boolean traceText() {
        return false;
    }

    class HttpUrlChecker
    extends DdfHttpHelper {
        HttpUrlChecker() {
            super(BDdfHttpCommunicator.this.getHttpTransmitter());
        }

        void checkUrl(BIDdfRequest ddfRequest) throws MalformedURLException {
            this.mostRecentDdfRequest = ddfRequest;
            this.httpCommunicator = BDdfHttpCommunicator.this;
            this.parseJavaUrl();
            String host = this.mostRecentJavaUrl.getHost();
            if (host.length() == 0 || host.equals("###.###.###.###") || host.equals("[***DEFAULT***]")) {
                throw new MalformedURLException("Invalid host: " + host);
            }
        }
    }
}

