/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.histEmail;

import com.lynxspring.histEmail.BHistoryEmailService;
import com.lynxspring.histEmail.BHistoryEmailTargetedExtension;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.data.BIDataValue;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAddressList;
import javax.baja.email.BEmailPart;
import javax.baja.email.BEmailPartList;
import javax.baja.email.BEmailService;
import javax.baja.email.BOutgoingAccount;
import javax.baja.email.BTextPart;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

public abstract class BHistoryEmailTrigger
extends BTimeTrigger
implements BIService {
    private static Lexicon lex = Lexicon.make(BHistoryEmailTargetedExtension.class);
    private static int maxCsvs = 2;
    public static final Property licensed = BHistoryEmailTrigger.newProperty((int)7, (boolean)false, null);
    public static final Property enabled = BHistoryEmailTrigger.newProperty((int)0, (boolean)true, null);
    public static final Property to = BHistoryEmailTrigger.newProperty((int)0, (BValue)BEmailAddressList.DEFAULT, null);
    public static final Property cc = BHistoryEmailTrigger.newProperty((int)0, (BValue)BEmailAddressList.DEFAULT, null);
    public static final Property bcc = BHistoryEmailTrigger.newProperty((int)0, (BValue)BEmailAddressList.DEFAULT, null);
    public static final Property emailAccount = BHistoryEmailTrigger.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"email:OutgoingAccountFE")));
    public static final Property subject = BHistoryEmailTrigger.newProperty((int)0, (BValue)BFormat.make((String)lex.getText("subject.text")), null);
    public static final Property body = BHistoryEmailTrigger.newProperty((int)0, (BValue)BFormat.make((String)lex.getText("body.text")), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property clearTrendAfterExport = BHistoryEmailTrigger.newProperty((int)0, (boolean)false, null);
    public static final Property csvFilesToKeep = BHistoryEmailTrigger.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)maxCsvs));
    public static final Action clearLastTrigger = BHistoryEmailTrigger.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BHistoryEmailTrigger.class);
    protected static final String[] columnNames = new String[]{"History Id", "Timestamp", "Trend Flags", "Status", "Value"};
    private static final BFacets TIME_FACETS = BFacets.make((String)"showSeconds", (boolean)true);

    public boolean getLicensed() {
        return this.getBoolean(licensed);
    }

    public void setLicensed(boolean v) {
        this.setBoolean(licensed, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BEmailAddressList getTo() {
        return (BEmailAddressList)this.get(to);
    }

    public void setTo(BEmailAddressList v) {
        this.set(to, (BValue)v, null);
    }

    public BEmailAddressList getCc() {
        return (BEmailAddressList)this.get(cc);
    }

    public void setCc(BEmailAddressList v) {
        this.set(cc, (BValue)v, null);
    }

    public BEmailAddressList getBcc() {
        return (BEmailAddressList)this.get(bcc);
    }

    public void setBcc(BEmailAddressList v) {
        this.set(bcc, (BValue)v, null);
    }

    public String getEmailAccount() {
        return this.getString(emailAccount);
    }

    public void setEmailAccount(String v) {
        this.setString(emailAccount, v, null);
    }

    public BFormat getSubject() {
        return (BFormat)this.get(subject);
    }

    public void setSubject(BFormat v) {
        this.set(subject, (BValue)v, null);
    }

    public BFormat getBody() {
        return (BFormat)this.get(body);
    }

    public void setBody(BFormat v) {
        this.set(body, (BValue)v, null);
    }

    public boolean getClearTrendAfterExport() {
        return this.getBoolean(clearTrendAfterExport);
    }

    public void setClearTrendAfterExport(boolean v) {
        this.setBoolean(clearTrendAfterExport, v, null);
    }

    public int getCsvFilesToKeep() {
        return this.getInt(csvFilesToKeep);
    }

    public void setCsvFilesToKeep(int v) {
        this.setInt(csvFilesToKeep, v, null);
    }

    public void clearLastTrigger() {
        this.invoke(clearLastTrigger, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    abstract ArrayList<String> processExtensions();

    abstract String getCsvFilePrefix();

    abstract String getFileName();

    public abstract BIcon getIcon();

    public abstract Type[] getServiceTypes();

    public final void serviceStarted() throws Exception {
        try {
            Sys.getLicenseManager().checkFeature("Lynxspring", "histEmail");
            this.setLicensed(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setLicensed(false);
        }
    }

    public final void serviceStopped() throws Exception {
    }

    public final void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (!this.isRunning()) {
            return;
        }
        if (prop == csvFilesToKeep) {
            for (int i = maxCsvs; i > this.getCsvFilesToKeep(); --i) {
                File tmp = this.csv(i);
                if (!tmp.exists()) continue;
                tmp.delete();
            }
        }
    }

    public final boolean isParentLegal(BComponent parent) {
        if (this instanceof BHistoryEmailService) {
            return true;
        }
        return parent instanceof BHistoryExt || parent instanceof BControlPoint;
    }

    public final void doClearLastTrigger() {
        this.setLastTrigger(BAbsTime.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFireTrigger() {
        if (!(this.getEnabled() && this.getLicensed() && this.isRunning())) {
            return;
        }
        for (int i = maxCsvs; i >= 0; --i) {
            File tmp = this.csv(i);
            if (!tmp.exists()) continue;
            if (i >= this.getCsvFilesToKeep()) {
                tmp.delete();
                continue;
            }
            tmp.renameTo(this.csv(i + 1));
        }
        ArrayList<String> model = this.processExtensions();
        File csvFile = this.csv(0);
        FileOutputStream out = null;
        boolean exportSuccessful = false;
        try {
            out = new FileOutputStream(csvFile);
            for (int z = 0; z < model.size(); ++z) {
                out.write(model.get(z).getBytes());
            }
            out.close();
            exportSuccessful = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
        this.setLastTrigger(Clock.time());
        this.sendEmail(exportSuccessful);
        if (csvFile.exists() && this.getCsvFilesToKeep() == 0) {
            csvFile.delete();
        }
    }

    protected final ArrayList<String> processHistoryExt(BHistoryExt ext, ArrayList<String> model) {
        block6: {
            try {
                BHistoryService hist = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                HistorySpaceConnection conn = hist.getDatabase().getDbConnection(null).getHistoryDatabase().getConnection(null);
                BHistoryConfig config = ext.getHistoryConfig();
                BHistoryId bhistoryid = config.getId();
                BIHistory histext = ext.getHistory();
                BITable table = conn.timeQuery(histext, this.getLastTrigger(), null);
                TableCursor tc = table.cursor();
                while (tc.next()) {
                    try {
                        BHistoryRecord rec = (BHistoryRecord)tc.get();
                        model.add("\"" + bhistoryid.toString() + "\",\"" + rec.get(table.getColumns().get(0).getName()) + "\",\"" + rec.get(table.getColumns().get(1).getName()) + "\",\"" + rec.get(table.getColumns().get(2).getName()) + "\",\"" + rec.get(table.getColumns().get(3).getName()) + "\"\n");
                    }
                    catch (Exception e) {
                        System.err.println("Error adding row in " + this.getType());
                        e.printStackTrace();
                    }
                }
                if (this.getClearTrendAfterExport()) {
                    hist.getDatabase().getDbConnection(null).clearAllRecords(bhistoryid);
                }
            }
            catch (Exception e) {
                if (!Log.getLog((String)"Message").isTraceOn()) break block6;
                System.err.println("Error processing BHistoryExt in " + this.getType());
                e.printStackTrace();
            }
        }
        return model;
    }

    private final void sendEmail(boolean attachFile) {
        block7: {
            BComponent bcomponent = Sys.getService((Type)BEmailService.TYPE);
            BOutgoingAccount boutgoingaccount = (BOutgoingAccount)bcomponent.loadSlots().get(this.getEmailAccount());
            if (boutgoingaccount == null) {
                System.out.println(this.getType() + ".sendEmail: cannot find email account '" + this.getEmailAccount() + '.');
                return;
            }
            EmailContext emailcontext = new EmailContext(Sys.getLanguage());
            BEmail bemail = new BEmail();
            bemail.setTo(this.getTo());
            bemail.setCc(this.getCc());
            bemail.setBcc(this.getBcc());
            bemail.setDate(BAbsTime.now());
            bemail.setSubject(BFormat.make((String)this.getSubject().format((Object)this, (Context)emailcontext)).format((Object)this, (Context)emailcontext));
            String s2 = BFormat.make((String)this.getBody().format((Object)this, (Context)emailcontext)).format((Object)this, (Context)emailcontext);
            bemail.setBody((BEmailPart)new BTextPart("", s2));
            if (attachFile) {
                BEmailPartList att = new BEmailPartList();
                att.addAttachment(BOrd.make((String)("file:^" + this.getFileName() + ".csv")));
                bemail.setAttachments(att);
            }
            try {
                boutgoingaccount.getClass().getMethod("doSend", BEmail.class, Context.class).invoke((Object)boutgoingaccount, bemail, null);
            }
            catch (Exception e) {
                if (Log.getLog((String)"email").isTraceOn()) {
                    Log.getLog((String)"email").trace("Error sending message from histEmail doSend(BEmail, Context)", (Throwable)e);
                }
                try {
                    boutgoingaccount.getClass().getMethod("doSend", BEmail.class).invoke((Object)boutgoingaccount, bemail);
                }
                catch (Exception e2) {
                    if (!Log.getLog((String)"email").isTraceOn()) break block7;
                    Log.getLog((String)"email").trace("Error sending message from histEmail doSend(BEmail)", (Throwable)e);
                }
            }
        }
    }

    private final File csv(int i) {
        if (i > 0) {
            return new File(Sys.getStationHome(), this.getFileName() + "_" + i + ".csv");
        }
        return new File(Sys.getStationHome(), this.getFileName() + ".csv");
    }

    private final class EmailContext
    implements Context {
        String lang;

        EmailContext(String s) {
            this.lang = s;
        }

        public Context getBase() {
            return null;
        }

        public BUser getUser() {
            return new BUser();
        }

        public BFacets getFacets() {
            return TIME_FACETS;
        }

        public BObject getFacet(String s) {
            return this.getFacets().get(s);
        }

        public String getLanguage() {
            return this.lang;
        }
    }
}

