/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemIndex;

import com.tridium.fox.sys.NiagaraStation;
import com.tridium.fox.sys.UnreachableStationException;
import com.tridium.nd.sysdef.BReachableStationInfo;
import com.tridium.util.ThrowableUtil;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.tag.Id;
import javax.baja.tag.Tags;
import javax.baja.util.BTypeSpec;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualGateway;

public final class SystemIndexUtil {
    private static final Logger LOGGER = Logger.getLogger("systemIndex");
    private static final Id N_TYPE_ID = Id.newId((String)"n", (String)"type");

    private SystemIndexUtil() {
    }

    public static boolean hasVirtualTypeTag(Tags tags) {
        if (tags == null) {
            return false;
        }
        BIDataValue typeTagValue = tags.get(N_TYPE_ID).orElse(null);
        if (typeTagValue == null || typeTagValue.getType() != BString.TYPE) {
            return false;
        }
        try {
            TypeInfo typeInfo = BTypeSpec.make((String)typeTagValue.toString()).getTypeInfo();
            return typeInfo.is(BVirtualGateway.TYPE) || typeInfo.is(BVirtualComponent.TYPE);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, e, () -> "When determining whether an entity is a virtual type,  could not convert the type tag value " + typeTagValue + " to a type.");
            return false;
        }
    }

    public static boolean hasAnyMatchingTagId(Tags tags, Set<Id> ids) {
        if (tags == null || ids == null) {
            return false;
        }
        for (Id id : ids) {
            if (!tags.contains(id)) continue;
            return true;
        }
        return false;
    }

    public static Throwable processAndLogSystemIndexError(Throwable error, BComponent source) {
        Throwable t;
        boolean isLocalizable = error instanceof LocalizableException || error instanceof LocalizableRuntimeException;
        String name = null;
        if (!isLocalizable || LOGGER.isLoggable(Level.WARNING)) {
            name = source instanceof NiagaraStation ? ((NiagaraStation)source).getStationName() : (source instanceof BReachableStationInfo ? ((BReachableStationInfo)source).getStationName() : source.toDisplayPathString(null));
        }
        if (isLocalizable) {
            t = error;
        } else {
            t = UnreachableStationException.extractUnoperationalStationException((Throwable)error).orElse(null);
            if (t == null) {
                t = new LocalizableRuntimeException("systemIndex", "systemIndex.unexpectedFailure", (Object[])new String[]{name}, error);
            }
        }
        if (name != null) {
            if (isLocalizable) {
                LOGGER.log(Level.WARNING, "System Index operation against \"" + name + "\" failed: ", t);
            } else {
                LOGGER.log(Level.WARNING, SystemIndexUtil.getFailureReason(t, true), error);
            }
        }
        return t;
    }

    public static String getFailureReason(Throwable ex) {
        return SystemIndexUtil.getFailureReason(ex, false);
    }

    public static String getFailureReason(Throwable ex, boolean removeNewLines) {
        String reason = ex == null ? "" : (ex instanceof Localizable ? ((Localizable)ex).toString(null) : ThrowableUtil.dumpToString((Throwable)ex, (int)1));
        if (reason == null) {
            reason = ex.toString();
        }
        if (removeNewLines) {
            reason = reason.replace("\n", "");
        }
        return reason;
    }
}

