/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemIndex;

import com.tridium.systemDb.BSystemDb;
import com.tridium.systemDb.BSystemDbService;
import com.tridium.systemDb.SystemDbConnection;
import com.tridium.systemIndex.BIIndexQueryProvider;
import com.tridium.systemIndex.BSystemIndexJob;
import com.tridium.systemIndex.BSystemIndexService;
import com.tridium.systemIndex.BSystemIndexSource;
import com.tridium.systemIndex.SystemIndexLog;
import com.tridium.systemIndex.SystemIndexUtil;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BAbstractDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Tags;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="false", override=true), @NiagaraProperty(name="alarmOnFailure", type="boolean", defaultValue="true"), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="defaultIndexQueries", type="BOrdList", defaultValue="BSystemIndexService.DEFAULT_INDEX_QUERY_ORDS", flags=3, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="useDefaultIndexQueries", type="boolean", defaultValue="true", facets={@Facet(name="BFacets.TRUE_TEXT", value="BString.make(\"%lexicon(systemIndex:systemIndex.useDefaultQueries.true)%\")"), @Facet(name="BFacets.FALSE_TEXT", value="BString.make(\"%lexicon(systemIndex:systemIndex.useDefaultQueries.false)%\")")}), @NiagaraProperty(name="customIndexQueries", type="BOrdList", defaultValue="BOrdList.NULL", facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")})})
@NiagaraActions(value={@NiagaraAction(name="retryFailedIndexes", flags=16), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)})
public abstract class BSystemIndexer
extends BAbstractDescriptor
implements BIIndexQueryProvider,
BIAlarmSource {
    @Generated
    public static final Property enabled = BSystemIndexer.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property alarmOnFailure = BSystemIndexer.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property alarmSourceInfo = BSystemIndexer.newProperty((int)0, (BValue)BSystemIndexer.initAlarmSourceInfo(), null);
    @Generated
    public static final Property defaultIndexQueries = BSystemIndexer.newProperty((int)3, (BValue)BSystemIndexService.DEFAULT_INDEX_QUERY_ORDS, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property useDefaultIndexQueries = BSystemIndexer.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (BIDataValue)BString.make((String)"%lexicon(systemIndex:systemIndex.useDefaultQueries.true)%")), (BFacets)BFacets.make((String)"falseText", (BIDataValue)BString.make((String)"%lexicon(systemIndex:systemIndex.useDefaultQueries.false)%"))));
    @Generated
    public static final Property customIndexQueries = BSystemIndexer.newProperty((int)0, (BValue)BOrdList.NULL, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Action retryFailedIndexes = BSystemIndexer.newAction((int)16, null);
    @Generated
    public static final Action ackAlarm = BSystemIndexer.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSystemIndexer.class);
    public static final Logger systemIndexJobLog = Logger.getLogger("systemIndex.job");
    static final Lexicon LEXICON = Lexicon.make(BSystemIndexer.class);
    private static final int MAX_RETRY = AccessController.doPrivileged(() -> Integer.getInteger("systemIndex.retry", 2));
    private AlarmSupport alarmSupport;
    private static final Set<Id> FILTERED_OUT_IDS = Collections.singleton(Id.newId((String)"systemIndex:excluded"));
    private long numExecutes;
    private long totalExecuteTime;
    private long minExecuteTime = Long.MAX_VALUE;
    private long maxExecuteTime;
    private long numRetries;
    private long totalRetryTime;
    private long minRetryTime = Long.MAX_VALUE;
    private long maxRetryTime;
    private volatile boolean fatalFault;
    private final AtomicBoolean executionInProgress = new AtomicBoolean();

    @Generated
    public boolean getAlarmOnFailure() {
        return this.getBoolean(alarmOnFailure);
    }

    @Generated
    public void setAlarmOnFailure(boolean v) {
        this.setBoolean(alarmOnFailure, v, null);
    }

    @Generated
    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    @Generated
    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    @Generated
    public BOrdList getDefaultIndexQueries() {
        return (BOrdList)this.get(defaultIndexQueries);
    }

    @Generated
    public void setDefaultIndexQueries(BOrdList v) {
        this.set(defaultIndexQueries, (BValue)v, null);
    }

    @Generated
    public boolean getUseDefaultIndexQueries() {
        return this.getBoolean(useDefaultIndexQueries);
    }

    @Generated
    public void setUseDefaultIndexQueries(boolean v) {
        this.setBoolean(useDefaultIndexQueries, v, null);
    }

    @Generated
    public BOrdList getCustomIndexQueries() {
        return (BOrdList)this.get(customIndexQueries);
    }

    @Generated
    public void setCustomIndexQueries(BOrdList v) {
        this.set(customIndexQueries, (BValue)v, null);
    }

    @Generated
    public void retryFailedIndexes() {
        this.invoke(retryFailedIndexes, null, null);
    }

    @Generated
    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public final BOrdList getOperationalIndexQueries() {
        return BSystemIndexer.computeIndexQueries(this.getCustomIndexQueries(), this.getDefaultIndexQueries(), this.getUseDefaultIndexQueries());
    }

    static BOrdList computeIndexQueries(BOrdList customQueries, BOrdList defaultQueries, boolean useDefaultQueries) {
        if (useDefaultQueries) {
            if (customQueries.isNull()) {
                return defaultQueries;
            }
            LinkedHashSet mergedOrds = new LinkedHashSet((int)Math.ceil((double)(customQueries.size() + defaultQueries.size()) / 0.75));
            defaultQueries.iterator().forEachRemaining(mergedOrds::add);
            customQueries.iterator().forEachRemaining(mergedOrds::add);
            return BOrdList.make((BOrd[])mergedOrds.toArray(new BOrd[0]));
        }
        return customQueries;
    }

    static void checkDefaultIndexQueries(BComponent component, String defaultIndexQueriesPropName, String customIndexQueriesPropName) {
        Property defaultIndexQueriesProp = component.getProperty(defaultIndexQueriesPropName);
        BValue defaultValue = defaultIndexQueriesProp.getDefaultValue();
        if (!component.get(defaultIndexQueriesProp).equals((Object)defaultValue)) {
            component.set(defaultIndexQueriesProp, defaultValue);
            BSystemIndexService.log.severe("An attempt was made to modify the default index queries for " + component.toDisplayPathString(null) + ". This change is not allowed and has been reverted. Please modify the " + component.getDisplayName((Slot)component.getProperty(customIndexQueriesPropName), null) + " property instead.");
        }
    }

    protected abstract void executeFullIndex(SystemIndexLog var1, Context var2) throws Exception;

    public boolean shouldRetryFailedIndexes(Context cx) {
        return !this.isUnoperational() && this.isFault() && this.getState() == BDescriptorState.idle;
    }

    protected void executeFailedIndexes(SystemIndexLog log, Context cx) throws Exception {
        if (!this.isUnoperational()) {
            this.executeFullIndex(log, cx);
        }
    }

    public final void doExecute() {
        this.doExecute(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doExecute(Context cx) {
        if (this.isUnoperational()) {
            return;
        }
        long startTicks = Clock.ticks();
        try {
            BSystemIndexer.runIndex(Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("systemIndex.job.fullIndex", new Object[]{this.getIndexDescription(cx)}), cx, (log, context) -> {
                try {
                    this.executeInProgress();
                    if (log.isLoggingEnabled()) {
                        log.start("systemIndex", "systemIndex.job.startFullIndex", new String[]{this.toDisplayPathString(cx), this.getOperationalIndexQueries().toString(cx)});
                    }
                    this.executeFullIndex((SystemIndexLog)log, (Context)context);
                    this.executeOk();
                    if (log.isLoggingEnabled()) {
                        log.success("systemIndex", "systemIndex.job.completeFullIndex", new String[]{this.toDisplayPathString(cx), this.getOperationalIndexQueries().toString(cx)});
                    }
                }
                catch (Exception e) {
                    this.executeFail(e);
                    if (log.isLoggingEnabled()) {
                        log.failed("systemIndex", "systemIndex.job.failedFullIndex", new String[]{this.toDisplayPathString(cx), this.getOperationalIndexQueries().toString(cx)}, (Throwable)e);
                    }
                    throw BSystemIndexer.convertIndexException(e);
                }
            });
        }
        finally {
            this.updateStatistics(startTicks, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doRetryFailedIndexes(Context cx) {
        if (this.isUnoperational()) {
            return;
        }
        long startTicks = Clock.ticks();
        try {
            BSystemIndexer.runIndex(Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("systemIndex.job.retryFailedIndex", new Object[]{this.getIndexDescription(cx)}), cx, (log, context) -> {
                try {
                    this.executeInProgress();
                    if (log.isLoggingEnabled()) {
                        log.start("systemIndex", "systemIndex.job.startRetryIndex", new String[]{this.toDisplayPathString(cx), this.getOperationalIndexQueries().toString(cx)});
                    }
                    this.executeFailedIndexes((SystemIndexLog)log, (Context)context);
                    this.executeOk();
                    if (log.isLoggingEnabled()) {
                        log.success("systemIndex", "systemIndex.job.completeRetryIndex", new String[]{this.toDisplayPathString(cx), this.getOperationalIndexQueries().toString(cx)});
                    }
                }
                catch (Exception e) {
                    this.executeFail(e);
                    if (log.isLoggingEnabled()) {
                        log.failed("systemIndex", "systemIndex.job.failedRetryIndex", new String[]{this.toDisplayPathString(cx), this.getOperationalIndexQueries().toString(cx)}, (Throwable)e);
                    }
                    throw BSystemIndexer.convertIndexException(e);
                }
            });
        }
        finally {
            this.updateStatistics(startTicks, true);
        }
    }

    public final IFuture post(Action action, BValue arg, Context cx) {
        if (execute.equals(action) || retryFailedIndexes.equals(action)) {
            if (this.isUnoperational() || this.getState() != BDescriptorState.idle) {
                return null;
            }
            this.setLastAttempt(Clock.time());
            try {
                this.validateIndexQueries(cx);
            }
            catch (LocalizableException | LocalizableRuntimeException e) {
                this.executeFail(e);
                return null;
            }
            catch (Exception e) {
                this.executeFail(Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("systemIndex.malformedIndexQueries"));
                return null;
            }
            this.setState(BDescriptorState.pending);
            this.executionInProgress.set(true);
            try {
                return this.postAsync(action, arg, cx);
            }
            catch (Exception e) {
                if (this.getState() != BDescriptorState.idle) {
                    this.executeFail(e);
                }
                throw e;
            }
        }
        return this.postAsync(action, arg, cx);
    }

    protected final IFuture postExecute(Action action, BValue arg, Context cx) {
        this.postAsync(action, arg, cx);
        return null;
    }

    protected IFuture postAsync(Action action, BValue arg, Context cx) {
        BSystemIndexer.runAsync(this.getSystemIndexService(), (Runnable)new Invocation((BComponent)this, action, arg, cx));
        return null;
    }

    protected static CompletableFuture<Void> runAsync(BSystemIndexService indexService, Runnable r) {
        return BSystemIndexer.runAsync(indexService, null, r);
    }

    protected static CompletableFuture<Void> runAsync(BSystemIndexService indexService, String deviceName, Runnable r) {
        Executor defaultExecutor;
        Executor executor = defaultExecutor = indexService != null && indexService.isOperational() ? indexService.getExecutor(deviceName) : null;
        if (defaultExecutor == null) {
            throw new NotRunningException(LEXICON.getText("systemIndex.inoperableSystemIndex"));
        }
        return CompletableFuture.runAsync(r, defaultExecutor);
    }

    public static void runIndex(String indexName, Context cx, BiConsumer<SystemIndexLog, Context> indexOperation) {
        SystemIndexLog log;
        BSystemIndexJob job = null;
        if (systemIndexJobLog.isLoggable(Level.FINE)) {
            job = new BSystemIndexJob(indexName);
            log = SystemIndexLog.makeJobSystemIndexLog(job, true);
            job.submit(cx);
            log.message(indexName);
        } else {
            log = SystemIndexLog.DEFAULT_SYSTEM_INDEX_LOG;
        }
        try {
            indexOperation.accept(log, cx);
            if (job != null) {
                job.success();
            }
        }
        catch (Throwable t) {
            if (job != null) {
                job.failed(t);
            }
            throw t;
        }
    }

    public static RuntimeException convertIndexException(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof LocalizableException) {
            LocalizableException localizable = (LocalizableException)((Object)e);
            return new LocalizableRuntimeException(localizable.getLexiconModule(), localizable.getLexiconKey(), localizable.getLexiconArguments(), (Throwable)e);
        }
        return new BajaRuntimeException(e.getLocalizedMessage(), (Throwable)e);
    }

    public static void systemIndexToSystemDb(String stationName, Supplier<Stream<Entity>> indexResults, SystemIndexLog log, Context cx) throws Exception {
        BSystemIndexer.checkServicesOperational(log);
        BSystemDbService systemDbService = (BSystemDbService)Sys.getService((Type)BSystemDbService.TYPE);
        HashSet logCache = new HashSet();
        int numAttempts = MAX_RETRY > 0 ? MAX_RETRY + 1 : 1;
        BSystemDb systemDb = systemDbService.getSystemDatabase();
        try (SystemDbConnection conn = systemDb.makeConnection(cx);){
            for (int attempts = 0; attempts < numAttempts; ++attempts) {
                try {
                    AccessController.doPrivileged(() -> {
                        conn.removeStationEntities(new String[]{stationName});
                        return null;
                    });
                    AtomicInteger counter = new AtomicInteger(0);
                    try (Stream<Entity> entityStream = indexResults.get();){
                        Stream<Entity> entities = entityStream.filter(e -> {
                            Tags tags = e.tags();
                            return !SystemIndexUtil.hasVirtualTypeTag(tags) && !SystemIndexUtil.hasAnyMatchingTagId(tags, FILTERED_OUT_IDS);
                        });
                        if (log.isLoggingEnabled()) {
                            entities = entities.peek(e -> {
                                counter.incrementAndGet();
                                if (log.isLoggingIndividualEntityRecords()) {
                                    BOrd ord = null;
                                    if (e instanceof BINavNode && (ord = ((BINavNode)e).getNavOrd()) != null) {
                                        ord = ord.relativizeToSession();
                                    }
                                    if (ord == null) {
                                        ord = e.getOrdToEntity().orElse(null);
                                    }
                                    if (!logCache.contains(ord)) {
                                        log.message("systemIndex", "systemIndex.job.indexedEntity", String.valueOf(ord));
                                        logCache.add(ord);
                                    }
                                }
                            });
                        }
                        Stream<Entity> relativizedEntities = entities;
                        AccessController.doPrivileged(() -> {
                            conn.addEntities(relativizedEntities);
                            return null;
                        });
                    }
                    if (log.isLoggingEnabled()) {
                        log.message("systemIndex", "systemIndex.job.entitiesIndexed", new String[]{counter.toString(), stationName});
                    }
                    break;
                }
                catch (Exception e2) {
                    Throwable temp = e2;
                    boolean doARetry = false;
                    if (attempts < numAttempts - 1) {
                        while (temp.getCause() != null) {
                            if (temp.getCause() instanceof SystemDbConnection.AddEntityException) {
                                if (log.isLoggingEnabled()) {
                                    log.message("systemIndex", "systemIndex.job.retryIndex", new String[]{String.valueOf(attempts + 1), String.valueOf(numAttempts - 1)});
                                }
                                if (BSystemIndexService.log.isLoggable(Level.WARNING)) {
                                    BSystemIndexService.log.log(Level.WARNING, LEXICON.getText("systemIndex.job.retryIndex", new Object[]{String.valueOf(attempts + 1), String.valueOf(numAttempts - 1)}), e2);
                                }
                                doARetry = true;
                            }
                            temp = temp.getCause();
                            if (!doARetry) continue;
                        }
                    }
                    if (doARetry) continue;
                    if (log.isLoggingEnabled()) {
                        log.failed("systemIndex", "systemIndex.job.failureToAdd", e2);
                    }
                    throw e2;
                }
            }
        }
    }

    public void executeOk() {
        this.setFaultCause("");
        this.setLastSuccess(Clock.time());
        this.setState(BDescriptorState.idle);
        this.executionInProgress.set(false);
        if (this.getStatus().isAlarm()) {
            BSystemIndexer.processAlarmNormal(this.alarmSupport);
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)false));
        }
        this.updateStatus();
    }

    public final void executeFail(Throwable ex) {
        this.executeFail(SystemIndexUtil.getFailureReason(ex));
    }

    public final void executeFail(String reason) {
        if (reason == null) {
            reason = "";
        }
        this.setLastFailure(Clock.time());
        this.setFaultCause(reason);
        this.setState(BDescriptorState.idle);
        this.executionInProgress.set(false);
        if (this.getAlarmOnFailure() && !this.getStatus().isAlarm()) {
            boolean ackRequired = BSystemIndexer.processAlarmOffNormal(this.alarmSupport, this.getAlarmSourceInfo(), reason);
            int newStatus = this.getStatus().getBits();
            newStatus |= 8;
            if (ackRequired) {
                newStatus |= 0x80;
            }
            this.setStatus(BStatus.make((int)newStatus));
        }
        this.updateStatus();
    }

    public final void executeInProgress() {
        super.executeInProgress();
        this.executionInProgress.set(true);
    }

    public final BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        BBoolean alarmAck = BSystemIndexer.processAlarmAck(this.alarmSupport, ackRequest);
        if (alarmAck.getBoolean()) {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)128, (boolean)false));
        }
        return alarmAck;
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"%parent.displayName%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(systemIndex:systemIndexFail)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(systemIndex:systemIndexSuccess)%"));
        return asi;
    }

    static BBoolean processAlarmAck(AlarmSupport support, BAlarmRecord ackRequest) {
        try {
            return BBoolean.make((boolean)support.ackAlarm(ackRequest));
        }
        catch (Throwable e) {
            BSystemIndexService.log.log(Level.WARNING, "Failed to ack alarm for " + support.getSourceOrd(), e);
            return BBoolean.FALSE;
        }
    }

    static void processAlarmNormal(AlarmSupport support) {
        try {
            support.toNormal((Context)null);
        }
        catch (Throwable e) {
            BSystemIndexService.log.log(Level.WARNING, "Failed to send toNormal alarm for " + support.getSourceOrd(), e);
        }
    }

    static boolean processAlarmOffNormal(AlarmSupport support, BAlarmSourceInfo info, String reason) {
        boolean ackRequired = false;
        try {
            ackRequired = support.isAckRequired(BSourceState.offnormal);
            BFacets alarmData = info.makeAlarmData(BSourceState.offnormal);
            String msgText = alarmData.gets("msgText", "");
            alarmData = BFacets.make((BFacets)alarmData, (String)"msgText", (BIDataValue)BString.make((String)(msgText + '\n' + reason)));
            support.newOffnormalAlarm(alarmData);
        }
        catch (Throwable e) {
            BSystemIndexService.log.log(Level.WARNING, "Failed to send offNormal alarm for " + support.getSourceOrd(), e);
        }
        return ackRequired;
    }

    public final Optional<BSystemIndexSource> getSystemIndexSource() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.getType().is(BSystemIndexSource.TYPE)) continue;
            return Optional.of((BSystemIndexSource)parent);
        }
        return Optional.empty();
    }

    public final BSystemIndexService getSystemIndexService() {
        if (this.isMounted()) {
            return (BSystemIndexService)BOrd.make((String)"service:systemIndex:SystemIndexService").get((BObject)this);
        }
        return (BSystemIndexService)BOrd.make((String)"service:systemIndex:SystemIndexService").get(null);
    }

    public final BSystemDbService getSystemDbService() {
        return (BSystemDbService)BOrd.make((String)"service:systemDb:SystemDbService").get((BObject)this);
    }

    protected String getIndexDescription(Context cx) {
        return this.toDisplayPathString(cx);
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isUnoperational() {
        return this.fatalFault || this.isDisabled();
    }

    public final void updateStatus() {
        BStatus serviceStatus;
        int newStatus = this.getStatus().getBits();
        Optional<BSystemIndexSource> source = this.getSystemIndexSource();
        if (source.isPresent()) {
            serviceStatus = source.get().getStatus();
        } else {
            try {
                serviceStatus = this.getSystemIndexService().getStatus();
            }
            catch (UnresolvedException e) {
                serviceStatus = BStatus.fault;
            }
        }
        newStatus = !this.getEnabled() || serviceStatus.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = serviceStatus.isDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        newStatus = this.isFatalFault() || !this.getLastFailure().isNull() && this.getLastFailure().isAfter(this.getLastSuccess()) || serviceStatus.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == this.getStatus().getBits()) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
    }

    protected String checkFatalFault() {
        return null;
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    private void computeFatalFault() {
        BSystemIndexService systemIndexService = null;
        try {
            systemIndexService = this.getSystemIndexService();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (systemIndexService == null) {
            try {
                Sys.getLicenseManager().getFeature("tridium", "systemDb").check();
                Sys.getLicenseManager().getFeature("tridium", "systemIndex").check();
            }
            catch (Exception e) {
                this.fatalFault = true;
                this.setFaultCause(LEXICON.getText("systemIndex.inoperableSystemIndex"));
                return;
            }
        } else if (systemIndexService.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause(LEXICON.getText("systemIndex.inoperableSystemIndex") + ": " + systemIndexService.getFaultCause());
            return;
        }
        String fatalCause = this.checkFatalFault();
        if (fatalCause != null) {
            this.fatalFault = true;
            this.setFaultCause(fatalCause);
            return;
        }
        this.setFaultCause("");
    }

    public static void checkServicesOperational(SystemIndexLog log) {
        BSystemIndexService systemIndexService;
        BSystemDbService systemDbService;
        try {
            systemDbService = (BSystemDbService)Sys.getService((Type)BSystemDbService.TYPE);
        }
        catch (Exception e) {
            if (log != null && log.isLoggingEnabled()) {
                log.failed("systemIndex", "systemIndex.missingSystemDb");
            }
            throw new LocalizableRuntimeException("systemIndex", "systemIndex.missingSystemDb", (Throwable)e);
        }
        if (!systemDbService.isOperational()) {
            if (log != null && log.isLoggingEnabled()) {
                log.failed("systemIndex", "systemIndex.inoperableSystemDb");
            }
            throw new LocalizableRuntimeException("systemIndex", "systemIndex.inoperableSystemDb");
        }
        try {
            systemIndexService = (BSystemIndexService)Sys.getService((Type)BSystemIndexService.TYPE);
        }
        catch (Exception ignore) {
            if (log != null && log.isLoggingEnabled()) {
                log.failed("systemIndex", "systemIndex.missingSystemIndex");
            }
            throw new LocalizableRuntimeException("systemIndex", "systemIndex.missingSystemIndex");
        }
        if (!systemIndexService.isOperational()) {
            if (log != null && log.isLoggingEnabled()) {
                log.failed("systemIndex", "systemIndex.inoperableSystemIndex");
            }
            throw new LocalizableRuntimeException("systemIndex", "systemIndex.inoperableSystemIndex");
        }
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BSystemIndexService.TYPE) || parent.getType().is(BSystemIndexSource.TYPE);
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                return this.fwStarted(a, b, c, d);
            }
            case 2: {
                return this.fwChanged((Property)a, b, c, d);
            }
            case 23: {
                return null;
            }
            case 20: {
                this.fwSteadyState();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private Object fwStarted(Object a, Object b, Object c, Object d) {
        this.computeFatalFault();
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        BSystemIndexer.checkDefaultIndexQueries((BComponent)this, defaultIndexQueries.getName(), customIndexQueries.getName());
        super.fw(11, a, b, c, d);
        if (Sys.atSteadyState()) {
            this.fwSteadyState();
        }
        return null;
    }

    private void fwSteadyState() {
        if (this.getState() != BDescriptorState.idle && !this.executionInProgress.get()) {
            this.setState(BDescriptorState.idle);
            this.execute();
        }
    }

    private Object fwChanged(Property prop, Object b, Object c, Object d) {
        if (this.isRunning() && prop.equals(defaultIndexQueries)) {
            BSystemIndexer.checkDefaultIndexQueries((BComponent)this, defaultIndexQueries.getName(), customIndexQueries.getName());
            return null;
        }
        return super.fw(2, (Object)prop, b, c, d);
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning()) {
            out.startProps();
            out.trTitle((Object)"SystemIndexer Statistics", 2);
            out.prop((Object)"Total ExecuteFull attempts", (Object)String.valueOf(this.numExecutes));
            out.prop((Object)"Total ExecuteFull time", (Object)BRelTime.make((long)this.totalExecuteTime));
            long avgIndexerExecute = this.numExecutes > 0L ? this.totalExecuteTime / this.numExecutes : 0L;
            out.prop((Object)"Avg ExecuteFull time", (Object)BRelTime.make((long)avgIndexerExecute));
            long min = this.minExecuteTime != Long.MAX_VALUE ? this.minExecuteTime : 0L;
            out.prop((Object)"Min ExecuteFull time", (Object)BRelTime.make((long)min));
            out.prop((Object)"Max ExecuteFull time", (Object)BRelTime.make((long)this.maxExecuteTime));
            out.prop((Object)"Total Retry attempts", (Object)String.valueOf(this.numRetries));
            out.prop((Object)"Total Retry time", (Object)BRelTime.make((long)this.totalRetryTime));
            long avgIndexerRetry = this.numRetries > 0L ? this.totalRetryTime / this.numRetries : 0L;
            out.prop((Object)"Avg Retry time", (Object)BRelTime.make((long)avgIndexerRetry));
            min = this.minRetryTime != Long.MAX_VALUE ? this.minRetryTime : 0L;
            out.prop((Object)"Min Retry time", (Object)BRelTime.make((long)min));
            out.prop((Object)"Max Retry time", (Object)BRelTime.make((long)this.maxRetryTime));
            if (Spy.ROOT.find("orientSystemDb") != null) {
                out.propValueLink((Object)"Detailed Orient Spy", (Object)"spy:/orientSystemDb", (Object)"spy:/orientSystemDb");
            }
            out.endProps();
        }
        super.spy(out);
    }

    private void updateStatistics(long startTicks, boolean retry) {
        long duration = Clock.ticks() - startTicks;
        BSystemIndexService.updateStatistics((BComponent)this, duration, retry);
        if (retry) {
            ++this.numRetries;
            this.totalRetryTime += duration;
            if (duration <= this.minRetryTime) {
                this.minRetryTime = duration;
            }
            if (duration >= this.maxRetryTime) {
                this.maxRetryTime = duration;
            }
        } else {
            ++this.numExecutes;
            this.totalExecuteTime += duration;
            if (duration <= this.minExecuteTime) {
                this.minExecuteTime = duration;
            }
            if (duration >= this.maxExecuteTime) {
                this.maxExecuteTime = duration;
            }
        }
    }
}

