/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemIndex;

import com.tridium.systemIndex.BSystemIndexService;
import com.tridium.systemIndex.BSystemIndexer;
import javax.baja.license.Feature;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;

@NiagaraType
public abstract class BSystemIndexSource
extends BAbstractService
implements BIRestrictedComponent {
    @Generated
    public static final Type TYPE = Sys.loadType(BSystemIndexSource.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"index.png"), (BIcon)BIcon.std((String)"badges/find.png"));

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void updateStatus() {
        super.updateStatus();
        this.setStatus(this.getStatus());
        SlotCursor cursor = this.getProperties();
        while (cursor.next(BSystemIndexer.class)) {
            ((BSystemIndexer)cursor.get()).updateStatus();
        }
    }

    public final void setStatus(BStatus v) {
        BComponentSpace space = this.getComponentSpace();
        if (space != null && space.getType().equals(BComponentSpace.TYPE)) {
            int oldStatus = this.getStatus().getBits();
            int newStatus = v.getBits();
            BSystemIndexService service = (BSystemIndexService)Sys.getService((Type)BSystemIndexService.TYPE);
            if (service.isDisabled()) {
                newStatus |= 1;
            }
            if (service.isFault()) {
                newStatus |= 2;
            }
            if (oldStatus == newStatus) {
                return;
            }
            super.setStatus(BStatus.make((int)newStatus));
        } else {
            super.setStatus(v);
        }
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BSystemIndexService.TYPE);
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkForDuplicates((BComponent)parent, (BIRestrictedComponent)this, (boolean)true);
    }

    public final Feature getLicenseFeature() {
        Sys.getLicenseManager().getFeature("tridium", "systemDb").check();
        Sys.getLicenseManager().getFeature("tridium", "systemIndex").check();
        return this.getSourceLicenseFeature();
    }

    protected Feature getSourceLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "systemIndex");
    }

    public BIcon getIcon() {
        return icon;
    }
}

