/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.ui.device;

import com.tridium.bacnet.ui.device.BBacnetDeviceManager;
import com.tridium.bacnetAws.datatypes.BBackupConfig;
import com.tridium.bacnetAws.datatypes.BCommControlConfig;
import com.tridium.bacnetAws.datatypes.BReinitializeDeviceConfig;
import com.tridium.bacnetAws.datatypes.BRestoreConfig;
import com.tridium.bacnetAws.ui.device.BBacnetAwsDeviceManager;
import com.tridium.bacnetOws.ui.device.BBacnetOwsDeviceManager;
import com.tridium.bacnetOws.ui.device.BacnetOwsDeviceController;
import com.tridium.util.TimeFormat;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrController;

public class BacnetAwsDeviceController
extends BacnetOwsDeviceController {
    public final MgrController.MgrCommand deviceCommunicationControl;
    public final MgrController.MgrCommand reinitializeDevice;
    public final MgrController.MgrCommand backup;
    public final MgrController.MgrCommand restore;
    private static final Logger logger = Logger.getLogger("bacnetAws.ui");

    protected BacnetAwsDeviceController(BBacnetAwsDeviceManager manager) {
        super((BBacnetOwsDeviceManager)manager);
        this.deviceCommunicationControl = new DeviceCommunicationControl((BWidget)manager);
        this.reinitializeDevice = new ReinitializeDevice((BWidget)manager);
        this.backup = new Backup((BWidget)manager);
        this.restore = new Restore((BWidget)manager);
        this.deviceCommunicationControl.setFlags(7);
        this.reinitializeDevice.setFlags(7);
        this.backup.setFlags(7);
        this.restore.setFlags(7);
    }

    protected MgrController.IMgrCommand[] makeBacnetCommands() {
        return BacnetAwsDeviceController.append((MgrController.IMgrCommand[])super.makeBacnetCommands(), (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.deviceCommunicationControl, this.reinitializeDevice, this.backup, this.restore});
    }

    protected void setBacnetCommandsEnable(boolean enable) {
        super.setBacnetCommandsEnable(enable);
        if (enable) {
            BComponent[] devs = this.getSelectedComponentsWithoutFolders();
            boolean selection = false;
            if (devs.length == 1) {
                selection = true;
            }
            this.deviceCommunicationControl.setEnabled(selection);
            this.reinitializeDevice.setEnabled(selection);
            this.backup.setEnabled(selection);
            this.restore.setEnabled(selection);
        } else {
            this.deviceCommunicationControl.setEnabled(false);
            this.reinitializeDevice.setEnabled(false);
            this.backup.setEnabled(false);
            this.restore.setEnabled(false);
        }
    }

    public CommandArtifact doDeviceCommunicationControl() throws Exception {
        try {
            BCommControlConfig params = (BCommControlConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)this.lex().get("devCommCtrl.title"), (BObject)new BCommControlConfig());
            if (params != null) {
                BComponent[] devs = this.getSelectedComponentsWithoutFolders();
                BBacnetDevice dev = (BBacnetDevice)devs[0];
                BBacnetNetwork bacnet = ((BBacnetDeviceManager)this.getManager()).getNetwork();
                params.setDeviceAddress((BBacnetAddress)dev.getAddress().newCopy());
                params.setCharacterSet(dev.getCharacterSet());
                this.setJob(bacnet.submitDeviceManagerJob((BValue)params));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred in doDeviceCommunicationControl", e);
            String msg = MessageFormat.format(this.lex().get("devCommCtrl.fail"), e);
            BDialog.message((BWidget)this.getManager(), (String)this.lex().get("devCommCtrl.title"), (Object)msg);
        }
        return null;
    }

    public CommandArtifact doReinitializeDevice() throws Exception {
        try {
            BReinitializeDeviceConfig params = (BReinitializeDeviceConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)this.lex().get("reinitDevice.title"), (BObject)new BReinitializeDeviceConfig());
            if (params != null) {
                BComponent[] devs = this.getSelectedComponentsWithoutFolders();
                BBacnetDevice dev = (BBacnetDevice)devs[0];
                BBacnetNetwork bacnet = ((BBacnetDeviceManager)this.getManager()).getNetwork();
                params.setDeviceAddress((BBacnetAddress)dev.getAddress().newCopy());
                params.setCharacterSet(dev.getCharacterSet());
                this.setJob(bacnet.submitDeviceManagerJob((BValue)params));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred in doReinitializeDevice", e);
            String msg = MessageFormat.format(this.lex().get("reinitDevice.fail"), e);
            BDialog.message((BWidget)this.getManager(), (String)this.lex().get("reinitDevice.title"), (Object)msg);
        }
        return null;
    }

    public CommandArtifact doBackup() throws Exception {
        try {
            BOrd backupDir = BDirectoryChooser.show((BWidget)this.getManager());
            if (backupDir == null) {
                return null;
            }
            BBackupConfig params = new BBackupConfig();
            params.setBaseDirectory(backupDir);
            BComponent[] devs = this.getSelectedComponentsWithoutFolders();
            BBacnetDevice dev = (BBacnetDevice)devs[0];
            String timestamp = TimeFormat.format((BAbsTime)Clock.time(), (String)"YYYYMMDD_HHmm");
            params.setDeviceDirectoryName(dev.getName() + timestamp);
            params = (BBackupConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)this.lex().get("backup.title"), (BObject)params);
            if (params != null) {
                BBacnetNetwork bacnet = ((BBacnetDeviceManager)this.getManager()).getNetwork();
                params.setDeviceAddress((BBacnetAddress)dev.getAddress().newCopy());
                params.setDeviceId(dev.getConfig().getDeviceObject().getObjectId());
                params.setCharacterSet(dev.getCharacterSet());
                this.learnMode.setSelected(true);
                this.setJob(bacnet.submitDeviceManagerJob((BValue)params));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred in doBackup", e);
            String msg = MessageFormat.format(this.lex().get("backup.fail"), e);
            BDialog.message((BWidget)this.getManager(), (String)this.lex().get("backup.title"), (Object)msg);
        }
        return null;
    }

    public CommandArtifact doRestore() throws Exception {
        try {
            BOrd restoreDir = BDirectoryChooser.show((BWidget)this.getManager());
            if (restoreDir == null) {
                return null;
            }
            BRestoreConfig params = new BRestoreConfig();
            params.setDirectory(restoreDir);
            BComponent[] devs = this.getSelectedComponentsWithoutFolders();
            BBacnetDevice dev = (BBacnetDevice)devs[0];
            params = (BRestoreConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)this.lex().get("restore.title"), (BObject)params);
            if (params != null) {
                BBacnetNetwork bacnet = ((BBacnetDeviceManager)this.getManager()).getNetwork();
                params.setDeviceAddress((BBacnetAddress)dev.getAddress().newCopy());
                params.setDeviceId(dev.getConfig().getDeviceObject().getObjectId());
                params.setCharacterSet(dev.getCharacterSet());
                this.learnMode.setSelected(true);
                this.setJob(bacnet.submitDeviceManagerJob((BValue)params));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred in doRestore", e);
            String msg = MessageFormat.format(this.lex().get("restore.fail"), e);
            BDialog.message((BWidget)this.getManager(), (String)this.lex().get("restore.title"), (Object)msg);
        }
        return null;
    }

    private UiLexicon lex() {
        return BBacnetAwsDeviceManager.wslex;
    }

    class Restore
    extends MgrController.MgrCommand {
        Restore(BWidget owner) {
            super(owner, (Lexicon)BacnetAwsDeviceController.this.lex(), "restore");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BacnetAwsDeviceController.this.doRestore();
        }
    }

    class Backup
    extends MgrController.MgrCommand {
        Backup(BWidget owner) {
            super(owner, (Lexicon)BacnetAwsDeviceController.this.lex(), "backup");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BacnetAwsDeviceController.this.doBackup();
        }
    }

    class ReinitializeDevice
    extends MgrController.MgrCommand {
        ReinitializeDevice(BWidget owner) {
            super(owner, (Lexicon)BacnetAwsDeviceController.this.lex(), "reinitDevice");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BacnetAwsDeviceController.this.doReinitializeDevice();
        }
    }

    class DeviceCommunicationControl
    extends MgrController.MgrCommand {
        DeviceCommunicationControl(BWidget owner) {
            super(owner, (Lexicon)BacnetAwsDeviceController.this.lex(), "devCommCtrl");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BacnetAwsDeviceController.this.doDeviceCommunicationControl();
        }
    }
}

