/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.ip;

import com.tridium.bacnet.stack.link.ip.BBdtEntry;
import com.tridium.bacnet.stack.link.ip.BBroadcastDistributionTable;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"bacnet:BroadcastDistributionTable"}, requiredPermissions="W")})
public class BBdtManager
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BBdtManager.class);
    private BTable table;
    private DefaultTableModel model;
    private BDTCellRenderer cellRenderer = new BDTCellRenderer();
    private Command newCmd;
    private Command editCmd;
    private Command deleteCmd;
    private static UiLexicon lex = UiLexicon.makeUiLexicon(BBdtManager.class);
    private static String[] colNames = new String[]{lex.getText("bdtfdt.bipAddr"), lex.getText("bdtfdt.bdMask")};

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBdtManager() {
        this.model = new DefaultTableModel(colNames);
        this.table = new BTable((TableModel)this.model);
        this.table.setCellRenderer((TableCellRenderer)this.cellRenderer);
        this.table.setSelection((TableSelection)new Selection());
        BGridPane buttonPane = this.makeButtonPane();
        BEdgePane content = new BEdgePane();
        content.setCenter((BWidget)this.table);
        content.setBottom((BWidget)new BBorderPane((BWidget)buttonPane, 5.0, 5.0, 0.0, 5.0));
        this.setContent((BWidget)content);
    }

    public BMenu[] getViewMenus() {
        return null;
    }

    public BToolBar getViewToolBar() {
        BToolBar bar = new BToolBar();
        return bar;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.registerForComponentEvents((BComponent)((BBroadcastDistributionTable)value));
        this.updateTable((BBroadcastDistributionTable)value);
    }

    public void handleComponentEvent(BComponentEvent event) {
        this.updateTable(this.getBDT());
    }

    private void updateTable(BBroadcastDistributionTable bdt) {
        this.model.removeAllRows();
        this.cellRenderer.setLocalRow(-1);
        BBdtEntry[] kids = (BBdtEntry[])bdt.getChildren(BBdtEntry.class);
        for (int i = 0; i < kids.length; ++i) {
            if (kids[i].getName().equals("localDevice")) {
                this.cellRenderer.setLocalRow(this.model.getRowCount());
            }
            this.model.addRow(new Object[]{kids[i].getBacnetIPAddress(), kids[i].getBroadcastDistributionMask()});
        }
        this.table.setModel((TableModel)this.model);
        this.table.relayout();
        this.updateCommands();
    }

    private BBroadcastDistributionTable getBDT() {
        return (BBroadcastDistributionTable)this.getCurrentValue();
    }

    private BGridPane makeButtonPane() {
        BInsets insets = BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0);
        BGridPane buttonPane = new BGridPane();
        this.newCmd = new New((BWidget)this);
        this.editCmd = new Edit((BWidget)this);
        this.deleteCmd = new Delete((BWidget)this);
        BAbstractButton bNew = BAbstractButton.make((Command)this.newCmd);
        BAbstractButton bEdit = BAbstractButton.make((Command)this.editCmd);
        BAbstractButton bDelete = BAbstractButton.make((Command)this.deleteCmd);
        bNew.setPadding(insets);
        bEdit.setPadding(insets);
        bDelete.setPadding(insets);
        buttonPane.add("bNew", (BValue)bNew);
        buttonPane.add("bEdit", (BValue)bEdit);
        buttonPane.add("bDelete", (BValue)bDelete);
        buttonPane.setColumnCount(3);
        return buttonPane;
    }

    private void updateCommands() {
        int selxn = this.table.getSelection().getRowCount();
        boolean sel = selxn > 0;
        this.editCmd.setEnabled(sel);
        this.deleteCmd.setEnabled(sel);
    }

    public CommandArtifact doNew() throws Exception {
        BBdtEntry entry = (BBdtEntry)BWbFieldEditor.dialog((BWidget)this, (String)this.newCmd.getLabel(), (BObject)new BBdtEntry());
        if (entry == null) {
            return null;
        }
        if (!entry.isAddressValid()) {
            BDialog.error((BWidget)this, (Object)lex.getText("bdtfdt.error.invalidAddress"));
            return null;
        }
        if (!entry.isMaskValid()) {
            BDialog.error((BWidget)this, (Object)lex.getText("bdtfdt.error.invalidMask"));
            return null;
        }
        BBroadcastDistributionTable bdt = this.getBDT();
        bdt.add(null, (BValue)entry);
        this.updateTable(bdt);
        return null;
    }

    public CommandArtifact doEdit() throws Exception {
        int[] rows = this.table.getSelection().getRows();
        if (rows.length != 1) {
            return null;
        }
        BBroadcastDistributionTable bdt = this.getBDT();
        BBdtEntry entry = new BBdtEntry((String)this.model.getValueAt(rows[0], 0), (String)this.model.getValueAt(rows[0], 1));
        entry = (BBdtEntry)BWbFieldEditor.dialog((BWidget)this, (String)this.newCmd.getLabel(), (BObject)entry);
        if (entry == null) {
            return null;
        }
        if (!entry.isAddressValid()) {
            BDialog.error((BWidget)this, (Object)lex.getText("bdtfdt.error.invalidAddress"));
        }
        if (!entry.isMaskValid()) {
            BDialog.error((BWidget)this, (Object)lex.getText("bdtfdt.error.invalidMask"));
        }
        bdt.modifyEntry(rows[0], entry, null);
        this.updateTable(bdt);
        return null;
    }

    public CommandArtifact doDelete() throws Exception {
        int[] rows = this.table.getSelection().getRows();
        BBroadcastDistributionTable bdt = this.getBDT();
        for (int i = 0; i < rows.length; ++i) {
            bdt.removeEntry(rows[i], null);
            this.updateTable(bdt);
        }
        return null;
    }

    static class BDTCellRenderer
    extends TableCellRenderer {
        private int localRow = -1;

        BDTCellRenderer() {
        }

        void setLocalRow(int row) {
            this.localRow = row;
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            if (cell.row == this.localRow) {
                return BBrush.makeSolid((BColor)BColor.lightSteelBlue);
            }
            return super.getBackground(cell);
        }
    }

    class Delete
    extends Command {
        Delete(BWidget owner) {
            super(owner, (Lexicon)lex, "bdtfdt.delete");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BBdtManager.this.doDelete();
        }
    }

    class Edit
    extends Command {
        Edit(BWidget owner) {
            super(owner, (Lexicon)lex, "bdtfdt.edit");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BBdtManager.this.doEdit();
        }
    }

    class New
    extends Command {
        New(BWidget owner) {
            super(owner, (Lexicon)lex, "bdtfdt.new");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BBdtManager.this.doNew();
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BBdtManager.this.updateCommands();
        }
    }
}

