/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.fe;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BSpinnerButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="increment"), @NiagaraAction(name="decrement"), @NiagaraAction(name="wildcard")})
public abstract class BMultiWildcardableFieldFE
extends BWbFieldEditor {
    @Generated
    public static final Action increment = BMultiWildcardableFieldFE.newAction((int)0, null);
    @Generated
    public static final Action decrement = BMultiWildcardableFieldFE.newAction((int)0, null);
    @Generated
    public static final Action wildcard = BMultiWildcardableFieldFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMultiWildcardableFieldFE.class);
    protected WCField[] fields;
    BSpinnerButton spinner = new BSpinnerButton();
    BButton wildcardButton;
    int selection = 0;
    double charWidth;
    boolean paintNull;
    double prefHeight;
    static final double textViewFix = 4.0;
    protected static final UiLexicon lex = UiLexicon.makeUiLexicon(BMultiWildcardableFieldFE.class);
    static final String LAST = lex.getText("bacnetDate.dayOfMonth.last").substring(0, 2);
    static final String ODD_DAYS = lex.getText("bacnetDate.dayOfMonth.odd").substring(0, 2);
    static final String EVEN_DAYS = lex.getText("bacnetDate.dayOfMonth.even").substring(0, 2);
    static final String ODD = lex.getText("bacnetDate.month.odd").substring(0, 3);
    static final String EVEN = lex.getText("bacnetDate.month.even").substring(0, 3);

    @Generated
    public void increment() {
        this.invoke(increment, null, null);
    }

    @Generated
    public void decrement() {
        this.invoke(decrement, null, null);
    }

    @Generated
    public void wildcard() {
        this.invoke(wildcard, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMultiWildcardableFieldFE() {
        this.add("spinner", (BValue)this.spinner);
        this.linkTo("incrementLink", (BComponent)this.spinner, (Slot)BSpinnerButton.increment, (Slot)increment);
        this.linkTo("decrementLink", (BComponent)this.spinner, (Slot)BSpinnerButton.decrement, (Slot)decrement);
        this.wildcardButton = new BButton("*");
        this.wildcardButton.setFocusTraversable(false);
        this.wildcardButton.setButtonStyle(BButtonStyle.toolBar);
        this.add("wc", (BValue)this.wildcardButton);
        this.linkTo("wcLink", (BComponent)this.wildcardButton, (Slot)BButton.actionPerformed, (Slot)wildcard);
    }

    protected void doSetReadonly(boolean readonly) {
        this.relayout();
    }

    public void computePreferredSize() {
        BFont font = Theme.textField().getFont();
        this.charWidth = font.width("0");
        double tw = 0.0;
        for (int i = 0; i < this.fields.length; ++i) {
            if (i > 0) {
                tw += this.charWidth * (double)this.fields[i].prefix().length();
            }
            tw += this.charWidth * (double)this.fields[i].length();
        }
        BInsets insets = Theme.textField().getInsets();
        double pw = tw + insets.left + insets.right + 13.0;
        double ph = font.getHeight() - 4.0 + insets.top + insets.bottom;
        this.wildcardButton.computePreferredSize();
        ph = Math.max(ph, this.wildcardButton.getPreferredHeight());
        this.setPreferredSize(pw += this.wildcardButton.getPreferredWidth() + 3.0, ph);
    }

    public void doLayout(BWidget[] kids) {
        this.computePreferredSize();
        BFont font = Theme.textField().getFont();
        BInsets insets = Theme.textField().getInsets();
        this.charWidth = font.width("0");
        this.prefHeight = this.getPreferredHeight();
        if (this.isReadonly()) {
            this.spinner.setVisible(false);
            this.spinner.setBounds(-1.0, -1.0, 0.0, 0.0);
            this.wildcardButton.setVisible(false);
            this.wildcardButton.setBounds(-1.0, -1.0, 0.0, 0.0);
        } else {
            double w = this.getWidth();
            double h = this.getHeight();
            double sw = 13.0;
            double th = font.getHeight() - 4.0 + insets.top + insets.bottom;
            this.wildcardButton.computePreferredSize();
            double wcw = this.wildcardButton.getPreferredWidth();
            this.wildcardButton.setVisible(true);
            this.wildcardButton.setBounds(w - wcw, 0.0, wcw, Math.min(h, this.prefHeight));
            this.spinner.setVisible(true);
            this.spinner.setBounds(w - sw - (wcw + 5.0), 0.0, sw, Math.min(th, this.prefHeight));
        }
    }

    int fieldAt(double x, double y) {
        int pos = (int)(x / this.charWidth);
        int f1 = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            int prefix = i == 0 ? 0 : this.fields[i].prefix().length();
            int f2 = f1 + prefix + this.fields[i].length();
            if (f1 <= pos && pos <= f2) {
                return i;
            }
            f1 = f2;
        }
        return -1;
    }

    public void paint(Graphics g) {
        BFont font = Theme.textField().getFont();
        BInsets insets = Theme.textField().getInsets();
        double w = this.getWidth();
        double tw = w - this.spinner.getWidth();
        double th = font.getHeight() - 4.0 + insets.top + insets.bottom;
        boolean readonly = this.isReadonly();
        boolean focus = this.hasFocus();
        tw -= this.wildcardButton.getWidth() + 5.0;
        BBrush fg = this.isReadonly() ? Theme.widget().getControlForeground() : Theme.widget().getWindowForeground();
        BBrush bg = this.isReadonly() ? Theme.widget().getControlBackground() : Theme.widget().getWindowBackground();
        BBrush fgSel = Theme.widget().getSelectionForeground();
        BBrush bgSel = Theme.widget().getSelectionBackground();
        g.setFont(font);
        g.setBrush(bg);
        g.fillRect(0.0, 0.0, tw, th);
        g.setBrush(fg);
        double tx = insets.left;
        double ty = th - insets.bottom - 2.0;
        if (this.paintNull && readonly) {
            g.drawString("null", tx, ty);
        } else {
            for (int i = 0; i < this.fields.length; ++i) {
                String str;
                WCField f = this.fields[i];
                if (i > 0) {
                    g.setBrush(fg);
                    String prefix = f.prefix();
                    if (prefix == null) {
                        prefix = "?";
                    }
                    g.drawString(prefix, tx, ty);
                    tx += this.charWidth * (double)prefix.length();
                }
                if ((str = f.string()) == null) {
                    str = "?";
                }
                double strWidth = this.charWidth * (double)str.length();
                if (i == this.selection && focus) {
                    g.setBrush(bgSel);
                    g.fillRect(tx, insets.top, strWidth, th - insets.top - insets.bottom);
                    g.setBrush(fgSel);
                }
                g.drawString(str, tx, ty);
                tx += strWidth;
                g.setBrush(fg);
            }
        }
        Theme.textField().paintBorder(g, (BWidget)this, tw, th);
        this.paintChildren(g);
    }

    public void mousePressed(BMouseEvent event) {
        super.mousePressed(event);
        if (this.isReadonly()) {
            return;
        }
        this.requestFocus();
        int f = this.fieldAt(event.getX(), event.getY());
        if (f != -1 && this.fields[f].isEditable()) {
            this.setSelection(f);
        }
    }

    public void keyTyped(BKeyEvent event) {
        char key = event.getKeyChar();
        if (key == '\n' || key == '\r') {
            this.fireActionPerformed(new BWidgetEvent(2, (BWidget)this));
            event.consume();
        } else if (this.fields[this.selection].keyTyped(key)) {
            this.timeModified();
            event.consume();
        }
    }

    public void keyPressed(BKeyEvent event) {
        if (event.getModifiersEx() != 0) {
            return;
        }
        int s = this.selection;
        switch (event.getKeyCode()) {
            case 39: {
                do {
                    if (++s < this.fields.length) continue;
                    s = 0;
                } while (!this.fields[s].isEditable());
                this.setSelection(s);
                event.consume();
                break;
            }
            case 37: {
                do {
                    if (--s >= 0) continue;
                    s = this.fields.length - 1;
                } while (!this.fields[s].isEditable());
                this.setSelection(s);
                event.consume();
                break;
            }
            case 38: {
                this.doIncrement();
                event.consume();
                break;
            }
            case 40: {
                this.doDecrement();
                event.consume();
            }
        }
    }

    public boolean isFocusTraversable() {
        return !this.isReadonly();
    }

    public void focusGained(BFocusEvent event) {
        this.repaint();
    }

    public void focusLost(BFocusEvent event) {
        this.repaint();
    }

    public void doIncrement() {
        this.fields[this.selection].increment();
        this.timeModified();
    }

    public void doDecrement() {
        this.fields[this.selection].decrement();
        this.timeModified();
    }

    public void doWildcard() {
        this.fields[this.selection].wildcard();
        this.timeModified();
    }

    void setSelection(int f) {
        if (!this.fields[f].isEditable()) {
            throw new IllegalStateException();
        }
        this.fields[this.selection].typeCount = 0;
        this.selection = f;
        this.repaint();
    }

    protected void timeModified() {
        this.setModified();
        this.repaint();
    }

    public class WeekdayField
    extends WCField {
        @Override
        String prefix() {
            return " ";
        }

        @Override
        int length() {
            return 3;
        }

        @Override
        int max() {
            return 6;
        }

        @Override
        public void set(int v) {
            if (v < 0) {
                this.value = -1;
                this.string = "***";
            } else {
                this.value = v;
                if (v == 7) {
                    v = 0;
                }
                BWeekday wd = BWeekday.make((int)v);
                this.string = wd.getShortDisplayTag(null);
            }
        }
    }

    public class HundredthField
    extends WCField {
        @Override
        String prefix() {
            return ".";
        }

        @Override
        int length() {
            return 2;
        }

        @Override
        int max() {
            return 99;
        }
    }

    public class TimeZoneField
    extends WCField {
        TimeZoneField() {
            this.string = "???";
        }

        @Override
        String prefix() {
            return " ";
        }

        @Override
        int length() {
            return this.string.length();
        }

        @Override
        boolean isEditable() {
            return false;
        }

        @Override
        int max() {
            return 1;
        }
    }

    public class YearField
    extends WCField {
        @Override
        String prefix() {
            return " ";
        }

        @Override
        int length() {
            return 4;
        }

        @Override
        int max() {
            return 2154;
        }

        @Override
        int min() {
            return 1900;
        }
    }

    public class MonthField
    extends WCField {
        @Override
        String prefix() {
            return " ";
        }

        @Override
        int length() {
            return 3;
        }

        @Override
        int max() {
            return 13;
        }

        @Override
        public void set(int v) {
            if (v < 0) {
                this.value = -1;
                this.string = "***";
            } else if (v == 12) {
                this.value = v;
                this.string = ODD;
            } else if (v == 13) {
                this.value = v;
                this.string = EVEN;
            } else {
                this.value = v;
                BMonth m = BMonth.make((int)v);
                this.string = m.getShortDisplayTag(null);
            }
        }

        @Override
        boolean keyTyped(int key) {
            return false;
        }
    }

    public class DayField
    extends WCField {
        @Override
        String prefix() {
            return " ";
        }

        @Override
        int length() {
            return 2;
        }

        @Override
        int max() {
            return 34;
        }

        @Override
        public void set(int v) {
            if (v < 0) {
                this.value = -1;
                this.string = "**";
            } else if (v == 32) {
                this.value = v;
                this.string = LAST;
            } else if (v == 33) {
                this.value = v;
                this.string = ODD_DAYS;
            } else if (v == 34) {
                this.value = v;
                this.string = EVEN_DAYS;
            } else {
                this.value = v;
                this.string = String.valueOf(v);
                for (int i = this.string.length(); i < this.length(); ++i) {
                    this.string = "0" + this.string;
                }
            }
        }

        @Override
        void increment() {
            int v = this.value + 1;
            if (v > this.max()) {
                v = 1;
            }
            if (v < 1) {
                v = 1;
            }
            this.set(v);
        }

        @Override
        void decrement() {
            int v = this.value - 1;
            if (v < 1) {
                v = this.max();
            }
            this.set(v);
        }
    }

    public class MillisecondField
    extends WCField {
        @Override
        String prefix() {
            return ".";
        }

        @Override
        int length() {
            return 3;
        }

        @Override
        int max() {
            return 999;
        }
    }

    public class SecondField
    extends WCField {
        @Override
        String prefix() {
            return ":";
        }

        @Override
        int length() {
            return 2;
        }

        @Override
        int max() {
            return 59;
        }
    }

    public class MinuteField
    extends WCField {
        @Override
        String prefix() {
            return ":";
        }

        @Override
        int length() {
            return 2;
        }

        @Override
        int max() {
            return 59;
        }
    }

    public class BigHourField
    extends WCField {
        @Override
        String prefix() {
            return " ";
        }

        @Override
        int length() {
            return 5;
        }

        @Override
        int max() {
            return 99999;
        }
    }

    public class HourField
    extends WCField {
        @Override
        String prefix() {
            return " ";
        }

        @Override
        int length() {
            return 2;
        }

        @Override
        int max() {
            return 23;
        }
    }

    public abstract class WCField {
        public int value;
        String string;
        int typeCount;

        WCField() {
            this.set(0);
        }

        abstract String prefix();

        int min() {
            return 0;
        }

        abstract int max();

        abstract int length();

        void wildcard() {
            this.set(-1);
        }

        boolean isEditable() {
            return true;
        }

        String string() {
            return this.string;
        }

        public void set(int v) {
            if (v < 0) {
                this.value = -1;
                this.string = "*";
                while (this.string.length() < this.length()) {
                    this.string = this.string + "*";
                }
            } else {
                this.value = v;
                this.string = String.valueOf(v);
                for (int i = this.string.length(); i < this.length(); ++i) {
                    this.string = "0" + this.string;
                }
            }
        }

        void increment() {
            int v = this.value + 1;
            if (v > this.max() || v < this.min()) {
                v = this.min();
            }
            this.set(v);
        }

        void decrement() {
            int v = this.value - 1;
            if (v < this.min() || v > this.max()) {
                v = this.max();
            }
            this.set(v);
        }

        boolean keyTyped(int key) {
            if (Character.isDigit((char)key)) {
                int v;
                int k = key - 48;
                if (this.typeCount == 0) {
                    v = k;
                } else {
                    int pow = 1;
                    for (int i = 0; i < this.length() - 1; ++i) {
                        pow *= 10;
                    }
                    v = this.value % pow * 10 + k;
                }
                if (v <= this.max()) {
                    this.set(v);
                }
                ++this.typeCount;
                return true;
            }
            return false;
        }
    }
}

