/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.fe;

import com.tridium.bacnet.datatypes.BDiscoveryNetworks;
import com.tridium.bacnet.ui.fe.BBacnetAddressFE;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"bacnet:DiscoveryNetworks"})})
@NiagaraActions(value={@NiagaraAction(name="clearAll"), @NiagaraAction(name="selectAll")})
public class BDiscoveryNetworksFE
extends BWbFieldEditor {
    @Generated
    public static final Action clearAll = BDiscoveryNetworksFE.newAction((int)0, null);
    @Generated
    public static final Action selectAll = BDiscoveryNetworksFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDiscoveryNetworksFE.class);
    static UiLexicon lex = UiLexicon.makeUiLexicon(BBacnetAddressFE.class);
    BGridPane netsPane;
    BCheckBox global;
    BCheckBox[] cboxes;

    @Generated
    public void clearAll() {
        this.invoke(clearAll, null, null);
    }

    @Generated
    public void selectAll() {
        this.invoke(selectAll, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDiscoveryNetworksFE() {
        BEdgePane pane = new BEdgePane();
        this.netsPane = new BGridPane(5);
        BGridPane buttonPane = new BGridPane(3);
        this.global = new BCheckBox(lex.getText("discoveryNetworks.global"));
        this.linkTo((BComponent)this.global, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        buttonPane.add("glob", (BValue)this.global);
        BButton allButton = new BButton(lex.getText("discoveryNetworks.selectAll"));
        this.linkTo("lAll", (BComponent)allButton, (Slot)BButton.actionPerformed, (Slot)selectAll);
        buttonPane.add("all", (BValue)allButton);
        BButton clrButton = new BButton(lex.getText("discoveryNetworks.clearAll"));
        this.linkTo("lClr", (BComponent)clrButton, (Slot)BButton.actionPerformed, (Slot)clearAll);
        buttonPane.add("clr", (BValue)clrButton);
        pane.setTop((BWidget)buttonPane);
        pane.setCenter((BWidget)this.netsPane);
        this.setContent((BWidget)pane);
    }

    protected void doSetReadonly(boolean readonly) {
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BDiscoveryNetworks discNets = (BDiscoveryNetworks)value;
        this.global.setSelected(discNets.isAllNetworks());
        int[] nets = discNets.getNetworks();
        int len = nets.length;
        this.cboxes = new BCheckBox[len];
        this.netsPane.removeAll();
        for (int i = 0; i < len; ++i) {
            this.cboxes[i] = new BCheckBox(String.valueOf(nets[i]), true);
            this.netsPane.add("net" + nets[i], (BValue)this.cboxes[i], null);
            this.cboxes[i].setEnabled(!this.isReadonly());
            this.linkTo((BComponent)this.cboxes[i], (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        }
        int columns = this.netsPane.getColumnCount();
        int emptyCells = columns - this.cboxes.length % columns - 1;
        for (int i = 0; i < emptyCells; ++i) {
            this.netsPane.add("blnk" + i, (BValue)new BNullWidget());
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.global.getSelected() ? "all;" : "-;");
        for (int i = 0; i < this.cboxes.length; ++i) {
            if (!this.cboxes[i].isSelected()) continue;
            sb.append(this.cboxes[i].getText()).append(',');
        }
        BObject ret = ((BDiscoveryNetworks)value).decodeFromString(sb.substring(0, sb.length()));
        return ret;
    }

    public void doClearAll() {
        this.global.setSelected(false);
        for (int i = 0; i < this.cboxes.length; ++i) {
            this.cboxes[i].setSelected(false);
        }
        this.setModified();
    }

    public void doSelectAll() {
        for (int i = 0; i < this.cboxes.length; ++i) {
            this.cboxes[i].setSelected(true);
        }
        this.setModified();
    }
}

