/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.fe;

import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BBacnetWeekNDayFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetWeekNDayFE.class);
    static UiLexicon lex = UiLexicon.makeUiLexicon(BBacnetWeekNDayFE.class);
    BGridPane pane = new BGridPane(3);
    BListDropDown month = new BListDropDown();
    BListDropDown weekOfMonth = new BListDropDown();
    BListDropDown dayOfWeek = new BListDropDown();
    private static final int MAX_MONTH = 14;
    private static final int MAX_WEEK_OF_MONTH = 9;
    private static final int MAX_DAY_OF_WEEK = 7;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetWeekNDayFE() {
        this.pane.add("month", (BValue)this.month);
        this.pane.add("week", (BValue)this.weekOfMonth);
        this.pane.add("day", (BValue)this.dayOfWeek);
        this.month.getList().addItem((Object)lex.getText("weekNDay.b0.-1"));
        this.month.getList().addItem((Object)lex.getText("weekNDay.b0.1"));
        this.month.getList().addItem((Object)lex.getText("weekNDay.b0.2"));
        this.month.getList().addItem((Object)lex.getText("weekNDay.b0.3"));
        this.month.getList().addItem((Object)lex.getText("weekNDay.b0.4"));
        this.month.getList().addItem((Object)lex.getText("weekNDay.b0.5"));
        this.month.getList().addItem((Object)lex.getText("weekNDay.b0.6"));
        this.month.getList().addItem((Object)lex.getText("weekNDay.b0.7"));
        this.month.getList().addItem((Object)lex.getText("weekNDay.b0.8"));
        this.month.getList().addItem((Object)lex.getText("weekNDay.b0.9"));
        this.month.getList().addItem((Object)lex.getText("weekNDay.b0.10"));
        this.month.getList().addItem((Object)lex.getText("weekNDay.b0.11"));
        this.month.getList().addItem((Object)lex.getText("weekNDay.b0.12"));
        this.month.getList().addItem((Object)lex.getText("weekNDay.b0.13"));
        this.month.getList().addItem((Object)lex.getText("weekNDay.b0.14"));
        this.weekOfMonth.getList().addItem((Object)lex.getText("weekNDay.b1.-1"));
        this.weekOfMonth.getList().addItem((Object)lex.getText("weekNDay.b1.1"));
        this.weekOfMonth.getList().addItem((Object)lex.getText("weekNDay.b1.2"));
        this.weekOfMonth.getList().addItem((Object)lex.getText("weekNDay.b1.3"));
        this.weekOfMonth.getList().addItem((Object)lex.getText("weekNDay.b1.4"));
        this.weekOfMonth.getList().addItem((Object)lex.getText("weekNDay.b1.5"));
        this.weekOfMonth.getList().addItem((Object)lex.getText("weekNDay.b1.6"));
        this.weekOfMonth.getList().addItem((Object)lex.getText("weekNDay.b1.7"));
        this.weekOfMonth.getList().addItem((Object)lex.getText("weekNDay.b1.8"));
        this.weekOfMonth.getList().addItem((Object)lex.getText("weekNDay.b1.9"));
        this.dayOfWeek.getList().addItem((Object)lex.getText("weekNDay.b2.-1"));
        this.dayOfWeek.getList().addItem((Object)lex.getText("weekNDay.b2.1"));
        this.dayOfWeek.getList().addItem((Object)lex.getText("weekNDay.b2.2"));
        this.dayOfWeek.getList().addItem((Object)lex.getText("weekNDay.b2.3"));
        this.dayOfWeek.getList().addItem((Object)lex.getText("weekNDay.b2.4"));
        this.dayOfWeek.getList().addItem((Object)lex.getText("weekNDay.b2.5"));
        this.dayOfWeek.getList().addItem((Object)lex.getText("weekNDay.b2.6"));
        this.dayOfWeek.getList().addItem((Object)lex.getText("weekNDay.b2.7"));
        this.linkTo("lk0", (BComponent)this.month, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.month, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.weekOfMonth, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk3", (BComponent)this.weekOfMonth, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk4", (BComponent)this.dayOfWeek, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk5", (BComponent)this.dayOfWeek, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
        this.setContent((BWidget)this.pane);
    }

    protected void doSetReadonly(boolean readonly) {
        this.month.setDropDownEnabled(!readonly);
        this.weekOfMonth.setDropDownEnabled(!readonly);
        this.dayOfWeek.setDropDownEnabled(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BBacnetOctetString bs = (BBacnetOctetString)value;
        if (bs.length() < 3) {
            throw new IllegalArgumentException("Invalid bit string length for WeekNDay:" + bs.length());
        }
        byte m = bs.byteAt(0);
        if (m < 0 || m > 14) {
            m = 0;
        }
        this.month.setSelectedIndex((int)m);
        byte w = bs.byteAt(1);
        if (w < 0 || w > 9) {
            w = 0;
        }
        this.weekOfMonth.setSelectedIndex((int)w);
        byte d = bs.byteAt(2);
        if (d < 0 || d > 7) {
            d = 0;
        }
        this.dayOfWeek.setSelectedIndex((int)d);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        int m = this.month.getSelectedIndex();
        int w = this.weekOfMonth.getSelectedIndex();
        int d = this.dayOfWeek.getSelectedIndex();
        if (m == 0) {
            m = -1;
        }
        if (w == 0) {
            w = -1;
        }
        if (d == 0) {
            d = -1;
        }
        BBacnetOctetString ret = BBacnetOctetString.make((byte[])new byte[]{(byte)m, (byte)w, (byte)d});
        return ret;
    }
}

