/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.fe;

import java.util.StringTokenizer;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetAddress"})})
@NiagaraAction(name="loadMac")
public class BBacnetAddressFE
extends BWbFieldEditor {
    @Generated
    public static final Action loadMac = BBacnetAddressFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetAddressFE.class);
    static Lexicon lex = UiLexicon.makeUiLexicon(BBacnetAddressFE.class);
    static String lexNetNum = lex.get("bacnetAddress.networkNumber", "Network Number");
    static String lexMacAddr = lex.get("bacnetAddress.macAddress", "MAC Address");
    static String lexMacStyle = lex.get("bacnetAddress.macStyle", "MAC Address Style");
    static String lexMacTypeUnknown = lex.get("bacnetAddress.macType.Unknown", "Unknown");
    static String lexMacTypeEthernet = lex.get("bacnetAddress.macType.Ethernet", "Ethernet");
    static String lexMacTypeIP = lex.get("bacnetAddress.macType.IP", "IP");
    static String lexMacTypeMSTP = lex.get("bacnetAddress.macType.MSTP", "MSTP/Other");
    static String lexMacTypeSC = lex.get("bacnetAddress.macType.SC", "SC");
    private BGridPane editPane = new BGridPane(2);
    private BTextField networkNumber = new BTextField();
    private BTextField macAddress = new BTextField();
    private BListDropDown macType = new BListDropDown();
    private BLabel styleLabel = new BLabel(lexMacStyle);
    private BBacnetAddress address;

    @Generated
    public void loadMac() {
        this.invoke(loadMac, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetAddressFE() {
        this.setContent((BWidget)this.editPane);
        this.editPane.add("netlabel", (BValue)new BLabel(lexNetNum));
        this.editPane.add("networkNumber", (BValue)this.networkNumber);
        this.editPane.add("maclabel", (BValue)new BLabel(lexMacAddr));
        this.editPane.add("macAddress", (BValue)this.macAddress);
        this.editPane.add("styleLabel", (BValue)this.styleLabel);
        this.editPane.add("displayAs", (BValue)this.macType);
        this.macType.getList().removeAllItems();
        this.macType.getList().addItem((Object)lexMacTypeUnknown);
        this.macType.getList().addItem((Object)lexMacTypeEthernet);
        this.macType.getList().addItem((Object)lexMacTypeIP);
        this.macType.getList().addItem((Object)lexMacTypeMSTP);
        this.macType.getList().addItem((Object)lexMacTypeSC);
        this.linkTo("lk0", (BComponent)this.networkNumber, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.networkNumber, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.macType, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk3", (BComponent)this.macType, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk4", (BComponent)this.macAddress, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk5", (BComponent)this.macAddress, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.linkTo("ld", (BComponent)this.macType, (Slot)BListDropDown.valueModified, (Slot)loadMac);
    }

    protected void doSetReadonly(boolean readonly) {
        this.networkNumber.setEditable(!readonly);
        this.macType.setVisible(!readonly);
        this.styleLabel.setVisible(!readonly);
        this.macAddress.setEditable(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.address = (BBacnetAddress)value;
        this.networkNumber.setText(Integer.toString(this.address.getNetworkNumber()));
        byte[] mac = this.address.getMacAddress().getBytes();
        if (mac == null || mac.length == 0) {
            this.macType.setSelectedIndex(0);
        } else if (mac.length == 1) {
            this.macType.setSelectedIndex(3);
        } else {
            this.macType.setSelectedIndex(this.address.getAddressType());
        }
        this.macAddress.setText(BBacnetAddress.bytesToString((int)this.macType.getSelectedIndex(), (byte[])this.address.getMacAddress().getBytes()));
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        this.address = (BBacnetAddress)value;
        byte[] mac = BBacnetAddress.stringToBytes((int)this.macType.getSelectedIndex(), (int)5, (String)this.macAddress.getText());
        this.address.setInt(BBacnetAddress.networkNumber, Integer.parseInt(this.networkNumber.getText()), cx);
        this.address.setInt(BBacnetAddress.addressType, this.macType.getSelectedIndex(), cx);
        this.address.setMac(mac, cx);
        return this.address;
    }

    public void doLoadMac() {
        this.macAddress.setText(BBacnetAddressFE.convertMac(this.macType.getSelectedIndex(), this.macAddress.getText()));
    }

    private static String convertMac(int type, String oldMac) {
        if (oldMac == null || oldMac.length() == 0 || oldMac.equals("null")) {
            return oldMac;
        }
        StringBuilder sb = new StringBuilder();
        switch (type) {
            case 1: {
                if (oldMac.indexOf(46) < 0) {
                    StringTokenizer st = new StringTokenizer(oldMac, ": ");
                    while (st.hasMoreTokens()) {
                        sb.append(st.nextToken().toUpperCase()).append(':');
                    }
                    sb.setLength(sb.length() - 1);
                    break;
                }
                StringTokenizer st = new StringTokenizer(oldMac, ".: ");
                if (st.countTokens() < 5) {
                    return oldMac;
                }
                sb.append(TextUtil.byteToHexString((int)Integer.decode(st.nextToken())).toUpperCase()).append(':');
                sb.append(TextUtil.byteToHexString((int)Integer.decode(st.nextToken())).toUpperCase()).append(':');
                sb.append(TextUtil.byteToHexString((int)Integer.decode(st.nextToken())).toUpperCase()).append(':');
                sb.append(TextUtil.byteToHexString((int)Integer.decode(st.nextToken())).toUpperCase()).append(':');
                int port = Integer.decode(st.nextToken());
                sb.append(TextUtil.byteToHexString((int)(port >> 8 & 0xFF)).toUpperCase()).append(':');
                sb.append(TextUtil.byteToHexString((int)(port & 0xFF)).toUpperCase());
                break;
            }
            case 2: {
                if (oldMac.indexOf(46) < 0) {
                    StringTokenizer st = new StringTokenizer(oldMac, ": ");
                    if (st.countTokens() < 6) {
                        return oldMac;
                    }
                    for (int i = 0; i < 4; ++i) {
                        sb.append(Integer.parseInt(st.nextToken(), 16)).append('.');
                    }
                    sb.setCharAt(sb.length() - 1, ':');
                    int port = (Integer.parseInt(st.nextToken(), 16) & 0xFF) << 8;
                    sb.append("0x").append(Integer.toHexString(port |= Integer.parseInt(st.nextToken(), 16) & 0xFF).toUpperCase());
                    break;
                }
                sb.append(oldMac);
                break;
            }
            case 0: 
            case 3: 
            case 4: {
                if (oldMac.indexOf(46) < 0) {
                    StringTokenizer st = new StringTokenizer(oldMac, ": ");
                    while (st.hasMoreTokens()) {
                        sb.append(st.nextToken().toUpperCase()).append(' ');
                    }
                    sb.setLength(sb.length() - 1);
                    break;
                }
                StringTokenizer st = new StringTokenizer(oldMac, ".:");
                if (st.countTokens() < 5) {
                    return oldMac;
                }
                sb.append(TextUtil.byteToHexString((int)Integer.parseInt(st.nextToken())).toUpperCase()).append(' ');
                sb.append(TextUtil.byteToHexString((int)Integer.parseInt(st.nextToken())).toUpperCase()).append(' ');
                sb.append(TextUtil.byteToHexString((int)Integer.parseInt(st.nextToken())).toUpperCase()).append(' ');
                sb.append(TextUtil.byteToHexString((int)Integer.parseInt(st.nextToken())).toUpperCase()).append(' ');
                int port = Integer.decode(st.nextToken());
                sb.append(TextUtil.byteToHexString((int)(port >> 8 & 0xFF)).toUpperCase()).append(' ');
                sb.append(TextUtil.byteToHexString((int)(port & 0xFF)).toUpperCase());
            }
        }
        return sb.toString();
    }
}

