/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.export;

import com.tridium.bacnet.datatypes.BNextInstArgs;
import com.tridium.bacnet.stack.server.BBacnetExportFolder;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import com.tridium.bacnet.stack.server.BIBacnetExportFolder;
import com.tridium.bacnet.ui.col.PropName;
import com.tridium.bacnet.ui.export.BBacnetMgrTable;
import com.tridium.bacnet.ui.export.BacnetWritable;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.workbench.bql.builder.BBqlQueryBuilder;
import com.tridium.workbench.fieldeditors.BStringMgrColFE;
import com.tridium.workbench.util.WbViewEventWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BBacnetAnalogInputDescriptor;
import javax.baja.bacnet.export.BBacnetAnalogOutputDescriptor;
import javax.baja.bacnet.export.BBacnetAnalogValueDescriptor;
import javax.baja.bacnet.export.BBacnetAnalogValuePrioritizedDescriptor;
import javax.baja.bacnet.export.BBacnetBinaryInputDescriptor;
import javax.baja.bacnet.export.BBacnetBinaryOutputDescriptor;
import javax.baja.bacnet.export.BBacnetBinaryValueDescriptor;
import javax.baja.bacnet.export.BBacnetBinaryValuePrioritizedDescriptor;
import javax.baja.bacnet.export.BBacnetBooleanScheduleDescriptor;
import javax.baja.bacnet.export.BBacnetCalendarDescriptor;
import javax.baja.bacnet.export.BBacnetCharacterStringDescriptor;
import javax.baja.bacnet.export.BBacnetEnumScheduleDescriptor;
import javax.baja.bacnet.export.BBacnetFileDescriptor;
import javax.baja.bacnet.export.BBacnetLargeAnalogValueDescriptor;
import javax.baja.bacnet.export.BBacnetLargeAnalogValuePrioritizedDescriptor;
import javax.baja.bacnet.export.BBacnetMultiStateInputDescriptor;
import javax.baja.bacnet.export.BBacnetMultiStateOutputDescriptor;
import javax.baja.bacnet.export.BBacnetMultiStateValueDescriptor;
import javax.baja.bacnet.export.BBacnetMultiStateValuePrioritizedDescriptor;
import javax.baja.bacnet.export.BBacnetNiagaraHistoryDescriptor;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BBacnetNumericScheduleDescriptor;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BBacnetStringScheduleDescriptor;
import javax.baja.bacnet.export.BBacnetTrendLogDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Tables;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.history.BIHistory;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrEditDialog;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;
import javax.baja.workbench.mgr.folder.FolderState;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetExportTable", "bacnet:BacnetExportFolder"})})
public class BBacnetExportManager
extends BFolderManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetExportManager.class);
    BBacnetExportTable exports;
    private final HashMap<BOrd, BIBacnetExportObject> exportsByOrd = new HashMap();
    static Lexicon lex = UiLexicon.makeUiLexicon(BBacnetExportManager.class);
    static String lexLocalObjects = lex.getText("exportManager.local");
    static String lexExportedObjects = lex.getText("exportManager.exportedObjects");
    static String lexTargetName = lex.getText("exportManager.targetName");
    static String lexObjectName = lex.getText("exportManager.objectName");
    static String lexObjectType = lex.getText("exportManager.objectType");
    static String lexInstanceNumber = lex.getText("exportManager.instanceNumber");
    static String lexOut = lex.getText("exportManager.out");
    static String lexExportOrd = lex.getText("exportManager.exportOrd");
    static String lexExportStatus = lex.getText("exportManager.exportStatus");
    static String lexFaultCause = lex.getText("exportManager.faultCause");
    static String lexDescription = lex.getText("exportManager.description");
    static String lexSlotPath = UiLexicon.bajaui().getText("slotPath");
    static String lexHandle = UiLexicon.bajaui().getText("handle");
    static String lexType = UiLexicon.bajaui().getText("type");
    static String lexInvalidOrd = lex.getText("exportManager.invalidOrd");
    static Lexicon wblex = Lexicon.make(MgrController.class);
    static String addLabel = wblex.getText("add.label");
    static String newLabel = wblex.getText("new.label");
    private static final Logger logger = Logger.getLogger("bacnet.ui");
    static MgrTypeInfo[] NEW_TYPES = new MgrTypeInfo[]{MgrTypeInfo.make((Type)BBacnetAnalogInputDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetAnalogOutputDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetAnalogValueDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetAnalogValuePrioritizedDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetLargeAnalogValueDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetLargeAnalogValuePrioritizedDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetBinaryInputDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetBinaryOutputDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetBinaryValueDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetBinaryValuePrioritizedDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetMultiStateInputDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetMultiStateOutputDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetMultiStateValueDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetMultiStateValuePrioritizedDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetNotificationClassDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetBooleanScheduleDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetNumericScheduleDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetEnumScheduleDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetStringScheduleDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetCalendarDescriptor.TYPE), MgrTypeInfo.make((Type)BBacnetCharacterStringDescriptor.TYPE)};
    MgrColumn mcolName = new MgrColumn.Name(7);
    MgrColumn mcolTargetName = new TargetName();
    MgrColumn mcolObjName = new ObjectName();
    MgrColumn mcolObjType = new ObjectType();
    MgrColumn mcolType = new MgrColumn.Type(3);
    MgrColumn mcolInstNum = new InstanceNumber();
    MgrColumn mcolTgtOut = new TargetOutput();
    MgrColumn mcolExportOrd = new ExportOrd();
    MgrColumn mcolExportStatus = new PropName(lexExportStatus, "status");
    MgrColumn mcolFaultCause = new PropName(lexFaultCause, "faultCause", 2);
    MgrColumn mcolDescr = new PropName(lexDescription, "description", 3);
    MgrColumn mcolWritable = new BacnetWritable();
    MgrColumn dcolPath = new Column(lexSlotPath, "toPathString");
    MgrColumn dcolHandle = new Column(lexHandle, "handle", 2);
    MgrColumn dcolType = new Column(lexType, "type");
    MgrColumn[] dcols = new MgrColumn[]{this.dcolPath, this.dcolHandle, this.dcolType};
    static final Context folderCx = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return "Bacnet:folderCx";
        }
    };

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context cx) {
        super.doLoadValue(value, cx);
        this.exports = ((BIBacnetExportFolder)value).getExports();
        BComponent exportTable = (BComponent)value;
        SlotCursor sc = exportTable.getSlots();
        while (sc.next(BIBacnetExportObject.class)) {
            BComponent c;
            BIBacnetExportObject expObj = (BIBacnetExportObject)sc.get();
            BObject o = expObj.getObject();
            if (o == null || !o.isComponent() || (c = o.asComponent()) == null) continue;
            WbViewEventWorker.getInstance().registerForComponentEventsLater((BWbComponentView)this, c, 0);
        }
        this.rehashExportTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rehashExportTable() {
        HashMap<BOrd, BIBacnetExportObject> hashMap = this.exportsByOrd;
        synchronized (hashMap) {
            this.exportsByOrd.clear();
            ComponentTableModel model = this.getModel().getTable().getComponentModel();
            for (int i = 0; i < model.getRowCount(); ++i) {
                BComponent comp = model.getComponentAt(i);
                if (!comp.getType().is(BIBacnetExportObject.TYPE)) continue;
                BIBacnetExportObject obj = (BIBacnetExportObject)comp;
                BOrd objOrd = obj.getObjectOrd().relativizeToSession();
                this.exportsByOrd.put(objOrd, obj);
            }
            this.handleComponentEvent(new BComponentEvent(1, (BComponent)this, null, null));
        }
    }

    BBacnetExportTable getExports() {
        return this.exports;
    }

    protected MgrModel makeModel() {
        return new ExportModel(this);
    }

    protected MgrLearn makeLearn() {
        return new ExportLearn(this);
    }

    protected MgrController makeController() {
        return new ExportController(this);
    }

    protected MgrState makeState() {
        return new ExportState();
    }

    void loadNodes(ExportNode[] nodes) {
        Array acc = new Array(BComponent.class);
        boolean needSubscription = false;
        for (int i = 0; i < nodes.length; ++i) {
            ExportNode node = nodes[i];
            if (node.value != null) continue;
            needSubscription = true;
            String handle = node.get(this.dcolHandle).toString();
            BComponent c = (BComponent)BOrd.make((String)("station:|h:" + handle)).get((BObject)node.session);
            node.value = c;
            node.name = c.getName();
            node.path = c.getSlotPath().getBody();
            acc.add((Object)c);
        }
        if (needSubscription) {
            BComponent[] toLease = (BComponent[])acc.trim();
            BComponent.lease((BComponent[])toLease, (int)0);
        }
    }

    class ExportNode {
        public BFoxSession session;
        public BImage icon;
        public BIObject[] cells;
        ExportNode parent;
        String name;
        String path;
        BValue value;

        public ExportNode(BFoxSession session) {
            this.session = session;
        }

        public String toString() {
            return "ExportNode:n=" + this.name + ", p=" + this.path + ", v=" + this.value;
        }

        public BImage getIcon() {
            return this.icon;
        }

        public Object get(MgrColumn col) {
            return ((Column)col).get(this);
        }

        public boolean hasChildren() {
            return false;
        }

        public ExportNode[] getChildren() {
            return new ExportNode[0];
        }

        public BIObject[] getCells() {
            return this.cells;
        }

        public void update(BIRandomAccessTable<?> table, int rowIndex) {
            ColumnList cols = table.getColumns();
            this.cells = new BIObject[cols.size() - 1];
            for (int c = 0; c < this.cells.length; ++c) {
                this.cells[c] = table.get(rowIndex).cell(cols.get(c));
            }
            this.icon = BImage.make((String)table.get(rowIndex).cell(cols.get(cols.size() - 1)).toString());
        }

        BValue loadNode() {
            if (this.value == null) {
                BBacnetExportManager.this.loadNodes(new ExportNode[]{this});
            }
            return this.value;
        }

        public String getPath() {
            return this.path;
        }
    }

    public static class Column
    extends MgrColumn {
        public final String projection;
        int colIndex = -1;

        public Column(String displayName, String projection) {
            this(displayName, projection, 0);
        }

        public Column(String displayName, String projection, int flags) {
            super(displayName, flags);
            this.projection = projection;
        }

        public int getColumnIndex() {
            if (this.colIndex == -1) {
                MgrColumn[] cols = this.getManager().getLearn().getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    if (cols[i] != this) continue;
                    this.colIndex = i;
                    break;
                }
                if (this.colIndex == -1) {
                    throw new IllegalStateException("Column not in manager.getDiscoveryColumns()");
                }
            }
            return this.colIndex;
        }

        public Object get(Object discovery) {
            return ((ExportNode)discovery).getCells()[this.getColumnIndex()];
        }
    }

    public static class ExportOrd
    extends MgrColumn {
        public ExportOrd() {
            this(3);
        }

        public ExportOrd(int flags) {
            super(lexExportOrd, flags);
        }

        public Object get(Object row) {
            if (row instanceof BIBacnetExportObject) {
                return ((BIBacnetExportObject)row).getObjectOrd();
            }
            return "";
        }

        public BValue load(MgrEditRow row) throws Exception {
            BComponent c = row.getTarget();
            if (c instanceof BBacnetExportFolder && !c.isMounted()) {
                return BOrd.NULL;
            }
            if (c instanceof BIBacnetExportObject) {
                return ((BIBacnetExportObject)row.getTarget()).getObjectOrd();
            }
            return BString.DEFAULT;
        }

        public void save(MgrEditRow row, BValue value, Context cx) throws Exception {
            BComponent c = row.getTarget();
            if (!(c instanceof BBacnetExportFolder) && c instanceof BIBacnetExportObject && ((BIBacnetExportObject)c).getObject() != c) {
                ((BIBacnetExportObject)c).setObjectOrd((BOrd)value, cx);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
            if (rows == null || rows.length != 1) {
                return null;
            }
            if (rows[0].getTarget() instanceof BBacnetExportFolder) {
                return null;
            }
            BOrd ord = (BOrd)rows[0].getCell(colIndex);
            BWbFieldEditor editor = (BWbFieldEditor)currentEditor;
            if (editor == null) {
                editor = BWbFieldEditor.makeFor((BObject)ord);
            }
            BFacets facets = BFacets.make((String)"targetType", (String)"baja:Component");
            editor.loadValue((BObject)ord, (Context)facets);
            if (rows[0].getTarget() instanceof BBacnetExportFolder) {
                editor.setReadonly(true);
            }
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BOrd ord = (BOrd)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, (BValue)ord);
            }
        }
    }

    public static class TargetOutput
    extends MgrColumn {
        public TargetOutput() {
            super(lexOut);
        }

        public TargetOutput(String title) {
            super(title);
        }

        public Object get(Object row) {
            try {
                if (row instanceof BIBacnetExportObject) {
                    return ((BIBacnetExportObject)row).getObjectOrd().get((BObject)row).toString(null);
                }
                return "";
            }
            catch (Exception e) {
                return lexInvalidOrd;
            }
        }
    }

    public static class InstanceNumber
    extends MgrColumn {
        public InstanceNumber() {
            super(lexInstanceNumber, 1);
        }

        public Object get(Object row) {
            if (row instanceof BIBacnetExportObject) {
                return ((BIBacnetExportObject)row).getObjectId().getInstanceNumber();
            }
            return "";
        }

        public BValue load(MgrEditRow row) throws Exception {
            BComponent c = row.getTarget();
            if (c instanceof BIBacnetExportObject) {
                BIBacnetExportObject e = (BIBacnetExportObject)c;
                if (c.isMounted()) {
                    return BInteger.make((int)e.getObjectId().getInstanceNumber());
                }
                BNextInstArgs args = new BNextInstArgs(e.getObjectId().getObjectType());
                BBacnetExportManager mgr = (BBacnetExportManager)row.getManager();
                return mgr.exports.getNextInst(args);
            }
            return BInteger.make((int)-1);
        }

        public void save(MgrEditRow row, BValue value, Context cx) throws Exception {
            BComponent c = row.getTarget();
            if (c instanceof BIBacnetExportObject) {
                BIBacnetExportObject export = (BIBacnetExportObject)c;
                Property p = c.getProperty("objectId");
                c.set(p, (BValue)export.getObjectId().newId(((BInteger)value).getInt()), cx);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
            if (rows == null || rows.length == 0) {
                return null;
            }
            BInteger instanceNumber = (BInteger)rows[0].getCell(colIndex);
            BWbFieldEditor editor = (BWbFieldEditor)currentEditor;
            if (editor == null) {
                editor = BWbFieldEditor.makeFor((BObject)instanceNumber);
            }
            BFacets facets = BFacets.makeInt((int)0, (int)0x3FFFFE);
            editor.loadValue((BObject)instanceNumber, (Context)facets);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            int instanceNumber = ((BInteger)editor.saveValue()).getInt();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, (BValue)BInteger.make((int)(instanceNumber + i)));
                String nam = rows[i].getName();
                int ubar = nam.indexOf("_");
                if (ubar < 0) continue;
                nam = nam.substring(0, ubar + 1) + (instanceNumber + i);
                rows[i].setName(nam);
            }
        }
    }

    public static class ObjectType
    extends MgrColumn {
        public ObjectType() {
            super(lexObjectType, 5);
        }

        public Object get(Object row) {
            if (row instanceof BIBacnetExportObject) {
                return TextUtil.toFriendly((String)BBacnetObjectType.tag((int)((BIBacnetExportObject)row).getObjectId().getObjectType()));
            }
            return "";
        }

        public BValue load(MgrEditRow row) throws Exception {
            BComponent c = row.getTarget();
            if (c instanceof BIBacnetExportObject) {
                return BDynamicEnum.make((int)((BIBacnetExportObject)c).getObjectId().getObjectType(), (BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE));
            }
            return BString.DEFAULT;
        }

        public void save(MgrEditRow row, BValue value, Context cx) throws Exception {
            BComponent c = row.getTarget();
            if (c instanceof BIBacnetExportObject) {
                Property objectIdProp = c.getProperty("objectId");
                BBacnetObjectIdentifier objectId = (BBacnetObjectIdentifier)c.get(objectIdProp);
                c.set(objectIdProp, (BValue)BBacnetObjectIdentifier.make((int)((BDynamicEnum)value).getOrdinal(), (int)objectId.getInstanceNumber()), cx);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
            if (rows == null || rows.length == 0) {
                return null;
            }
            int ndx = 0;
            if (ndx >= rows.length) {
                return null;
            }
            BDynamicEnum objectType = (BDynamicEnum)rows[ndx].getCell(colIndex);
            BWbFieldEditor editor = (BWbFieldEditor)currentEditor;
            if (editor == null) {
                editor = BWbFieldEditor.makeFor((BObject)objectType);
            }
            BFacets facets = BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE));
            editor.loadValue((BObject)objectType, (Context)facets);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BDynamicEnum objectType = (BDynamicEnum)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i].getTarget() instanceof BBacnetExportFolder) continue;
                rows[i].setCell(colIndex, (BValue)objectType);
            }
        }
    }

    public static class ObjectName
    extends MgrColumn {
        public ObjectName() {
            super(lexObjectName, 1);
        }

        public Object get(Object row) {
            if (row instanceof BIBacnetExportObject) {
                return ((BIBacnetExportObject)row).getObjectName();
            }
            return "";
        }

        public BValue load(MgrEditRow row) throws Exception {
            BComponent c = row.getTarget();
            if (c instanceof BIBacnetExportObject) {
                return BString.make((String)((BIBacnetExportObject)c).getObjectName());
            }
            return BString.DEFAULT;
        }

        public void save(MgrEditRow row, BValue value, Context cx) throws Exception {
            BComponent c = row.getTarget();
            if (c instanceof BIBacnetExportObject) {
                Property objectNameProp = c.getProperty("objectName");
                c.set(objectNameProp, value, cx);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
            if (rows == null || rows.length == 0) {
                return null;
            }
            BString objectName = (BString)rows[0].getCell(colIndex);
            for (int i = 1; i < rows.length; ++i) {
                if (rows[i].getCell(colIndex).getClass() == BString.class) continue;
                return null;
            }
            BStringMgrColFE editor = new BStringMgrColFE(colIndex);
            if (currentEditor != null && currentEditor.getClass() == editor.getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            editor.loadValue((BObject)objectName);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BString objectName = (BString)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, (BValue)objectName);
            }
        }
    }

    public static class TargetName
    extends MgrColumn {
        public TargetName() {
            super(lexTargetName);
        }

        public Object get(Object row) {
            try {
                if (row instanceof BIBacnetExportObject) {
                    BObject target = ((BIBacnetExportObject)row).getObjectOrd().get((BObject)row);
                    if (target.isComplex()) {
                        return target.asComplex().getName();
                    }
                    Type t = target.getType();
                    if (t.is(BIFile.TYPE)) {
                        return ((BIFile)target).getFileName();
                    }
                    if (t.is(BIHistory.TYPE)) {
                        return ((BIHistory)target).getId().getHistoryName();
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Unhandled target type:" + t);
                    }
                    return t.toString();
                }
                return "";
            }
            catch (UnresolvedException e) {
                return lexInvalidOrd;
            }
        }
    }

    class ExportController
    extends FolderController {
        boolean added;

        public ExportController(BBacnetExportManager manager) {
            super((BFolderManager)manager);
            this.cancel.setFlags(0);
        }

        public void updateCommands() {
            super.updateCommands();
            int[] sel = this.getSelectedRows();
            this.edit.setEnabled(sel.length > 0);
            ExportLearn lrn = (ExportLearn)this.getManager().getLearn();
            boolean addEnabled = false;
            BLearnTable lrnTbl = this.getLearnTable();
            if (lrnTbl != null) {
                Object[] dis = lrnTbl.getSelectedObjects();
                for (int i = 0; i < dis.length; ++i) {
                    if (!lrn.canExport(dis[i])) continue;
                    addEnabled = true;
                    break;
                }
            }
            this.add.setEnabled(addEnabled);
        }

        public CommandArtifact doEdit(Context cx) throws Exception {
            BComponent[] sel = this.getSelectedComponents();
            if (sel.length == 0) {
                return null;
            }
            MgrEdit edit = this.makeEdit(this.edit.getLabel());
            for (int i = 0; i < sel.length; ++i) {
                edit.addRow(sel[i]);
            }
            edit.setSelectAll(true);
            return edit.invoke(cx);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            ExportLearn learn = (ExportLearn)this.getManager().getLearn();
            BFoxSession session = learn.getTargetSession();
            if (session == null) {
                return null;
            }
            BBacnetExportManager.this.rehashExportTable();
            learn.bqlDiscover(session, BTypeSpec.make((String)"control:ControlPoint"));
            return null;
        }

        protected CommandArtifact doAdd(Object[] discovery, Context cx) throws Exception {
            try {
                ExportNode[] nodes = new ExportNode[discovery.length];
                System.arraycopy(discovery, 0, nodes, 0, discovery.length);
                BBacnetExportManager.this.loadNodes(nodes);
                this.added = false;
                MgrEdit edit = this.makeEdit(this.add.getLabel());
                BBacnetExportManager.this.exports.lease(Integer.MAX_VALUE);
                for (int i = 0; i < discovery.length; ++i) {
                    ExportNode dis = (ExportNode)discovery[i];
                    MgrTypeInfo[] types = this.getManager().getLearn().toTypes((Object)dis);
                    if (types == null || types.length == 0) continue;
                    MgrEditRow row = edit.addRow((Object)dis, types);
                    ((ExportLearn)this.getManager().getLearn()).toRow(dis, row, edit);
                }
                CommandArtifact ret = edit.invoke(cx);
                if (!this.added) {
                    return ret;
                }
                MgrEditRow[] rows = edit.getRows();
                for (int i = 0; i < rows.length; ++i) {
                    BIBacnetExportObject obj = (BIBacnetExportObject)rows[i].getTargetParent().get(rows[i].getName());
                    BOrd ord = ((BBacnetExportManager)this.getManager()).getExports().getObjectOrdById(obj.getObjectId());
                    if (ord == null || ord.equals((Object)BOrd.NULL)) continue;
                    try {
                        BComponent c = (BComponent)ord.get((BObject)((BBacnetExportManager)this.getManager()).getExports());
                        BIBacnetExportObject exp = (BIBacnetExportObject)c;
                        if (!(exp instanceof BBacnetPointDescriptor)) continue;
                        ((BBacnetPointDescriptor)exp).makeWritable(rows[i].getCell(BBacnetExportManager.this.mcolWritable));
                        continue;
                    }
                    catch (NullOrdException e) {
                        logger.log(Level.SEVERE, "Error Exporting Point: exportOrd=" + ord + " objectId=" + obj.getObjectId(), e);
                    }
                }
                BBacnetExportManager.this.rehashExportTable();
                return ret;
            }
            catch (ActionInvokeException e) {
                logger.log(Level.SEVERE, "ActionInvokeException occurred in doAdd", e);
                Throwable t = e.getCause();
                if (t != null) {
                    logger.log(Level.SEVERE, "ActionInvokeException caused by " + t, t);
                }
                throw e;
            }
        }

        public CommandArtifact doNewFolder() throws Exception {
            String title = this.newCommand.getLabel();
            MgrEdit edit = this.makeEdit(title);
            edit.addRow(new MgrEditRow((BComponent)new BBacnetExportFolder(), null, null));
            return edit.invoke(null);
        }

        public MgrEdit makeEdit(String label) {
            if (label == null) {
                return super.makeEdit(label);
            }
            if (label.equals(newLabel)) {
                return new MgrEdit(this.getManager(), label){

                    public CommandArtifact commit() throws Exception {
                        CommandArtifact ret = super.commit();
                        MgrEditRow[] rows = this.getRows();
                        for (int i = 0; i < rows.length; ++i) {
                            BIBacnetExportObject obj = (BIBacnetExportObject)rows[i].getTargetParent().get(rows[i].getName());
                            BOrd ord = ((BBacnetExportManager)this.getManager()).getExports().getObjectOrdById(obj.getObjectId());
                            if (ord == null || ord.equals((Object)BOrd.NULL)) continue;
                            try {
                                BComponent c = (BComponent)ord.get((BObject)((BBacnetExportManager)this.getManager()).getExports());
                                BIBacnetExportObject exp = (BIBacnetExportObject)c;
                                if (!(exp instanceof BBacnetPointDescriptor)) continue;
                                ((BBacnetPointDescriptor)exp).makeWritable(rows[i].getCell(BBacnetExportManager.this.mcolWritable));
                                continue;
                            }
                            catch (NullOrdException e) {
                                logger.log(Level.SEVERE, "Error Exporting Point: exportOrd=" + ord + " objectId=" + obj.getObjectId(), e);
                            }
                        }
                        return ret;
                    }
                };
            }
            if (label.equals(addLabel)) {
                return new MgrEdit(this.getManager(), label){

                    public boolean prompt() throws Exception {
                        BMgrEditDialog dialog = new BMgrEditDialog((MgrEdit)this, this.getSelectAll());
                        dialog.setScreenSizeToPreferredSize();
                        dialog.setBoundsCenteredOnOwner();
                        dialog.open();
                        ExportController.this.added = dialog.getResult() == 1;
                        return ExportController.this.added;
                    }
                };
            }
            return super.makeEdit(label);
        }
    }

    static class ExportState
    extends FolderState {
        ExportNode[] lastLearn;

        ExportState() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BBacnetExportManager mgr = (BBacnetExportManager)m;
            ExportLearn lrn = (ExportLearn)mgr.getLearn();
            this.lastLearn = lrn.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BBacnetExportManager mgr = (BBacnetExportManager)m;
            ExportLearn lrn = (ExportLearn)mgr.getLearn();
            if (this.lastLearn != null) {
                lrn.updateTable(this.lastLearn);
            }
        }
    }

    class ExportLearn
    extends MgrLearn {
        BOrd bqlQuery;
        BComponent target;
        BFoxSession targetSession;
        ExportNode[] lastLearn;

        public ExportLearn(BBacnetExportManager manager) {
            super((BAbstractManager)manager);
        }

        public BComponent getTarget() {
            return this.target;
        }

        public BFoxSession getTargetSession() {
            return this.targetSession;
        }

        public String makeTableTitle() {
            return lexLocalObjects;
        }

        public void load(BComponent target) {
            super.load(target);
            this.target = target;
            BISession session = target.getSession();
            if (session instanceof BFoxSession) {
                this.targetSession = (BFoxSession)session;
            }
        }

        protected MgrColumn[] makeColumns() {
            return BBacnetExportManager.this.dcols;
        }

        public BImage getIcon(Object node) {
            return ((ExportNode)node).getIcon();
        }

        public boolean isGroup(Object node) {
            return this.hasChildren(node);
        }

        public boolean hasChildren(Object node) {
            return ((ExportNode)node).hasChildren();
        }

        public Object[] getChildren(Object node) {
            return ((ExportNode)node).getChildren();
        }

        public MgrTypeInfo[] toTypes(Object dis) throws Exception {
            String typeSpec = BBacnetExportManager.this.dcolType.get(dis).toString();
            TypeInfo type = Sys.getRegistry().getType(typeSpec);
            AgentFilter filter = AgentFilter.is((Type)BIBacnetExportObject.TYPE);
            AgentList list = Sys.getRegistry().getAgents(type).filter(filter);
            return MgrTypeInfo.makeArray((AgentInfo[])list.list());
        }

        public void toRow(Object dis, MgrEditRow row) throws Exception {
            this.toRow(dis, row, row.getEdit());
        }

        public void toRow(Object dis, MgrEditRow row, MgrEdit edit) throws Exception {
            ExportNode node = (ExportNode)dis;
            node.loadNode();
            BComponent c = row.getTarget();
            BIBacnetExportObject obj = (BIBacnetExportObject)c;
            BBacnetObjectIdentifier objId = obj.getObjectId();
            int objectType = objId.getObjectType();
            int instNum = -1;
            if (BBacnetExportManager.this.exports.getLeaseExpiration() == -1L) {
                BBacnetExportManager.this.exports.lease(Integer.MAX_VALUE);
            }
            if (edit == null) {
                BNextInstArgs args = new BNextInstArgs(objectType);
                instNum = BBacnetExportManager.this.exports.getNextInst(args).getInt();
            } else {
                MgrColumn[] cols = edit.getColumns();
                int objTypeColNdx = -1;
                int instNumColNdx = -1;
                for (int i = 0; i < cols.length; ++i) {
                    if (cols[i].getDisplayName().equals(lexInstanceNumber)) {
                        instNumColNdx = i;
                        continue;
                    }
                    if (!cols[i].getDisplayName().equals(lexObjectType)) continue;
                    objTypeColNdx = i;
                }
                int[] siblingCandidates = new int[edit.getRowCount()];
                int siblingCount = 0;
                for (int i = 0; i < edit.getRowCount() - 1; ++i) {
                    String rowObjTypeStr = TextUtil.fromFriendly((String)((String)edit.getValueAt(i, objTypeColNdx)));
                    int rowObjType = BBacnetObjectType.ordinal((String)rowObjTypeStr);
                    int rowInstNum = Integer.parseInt((String)edit.getValueAt(i, instNumColNdx));
                    if (objectType != rowObjType || rowInstNum < 0) continue;
                    siblingCandidates[siblingCount++] = rowInstNum;
                }
                int[] siblings = new int[siblingCount];
                System.arraycopy(siblingCandidates, 0, siblings, 0, siblingCount);
                instNum = BBacnetExportManager.this.exports.getNextInstance(objectType, siblings);
            }
            row.setCell(BBacnetExportManager.this.mcolInstNum, (BValue)BInteger.make((int)instNum));
            objId = BBacnetObjectIdentifier.make((int)objectType, (int)instNum);
            row.setDefaultName(objId.toString(BacnetConst.nameContext));
            row.setCell(BBacnetExportManager.this.mcolExportOrd, (BValue)BOrd.make((String)("h:" + node.get(BBacnetExportManager.this.dcolHandle).toString())));
            row.setCell(BBacnetExportManager.this.mcolObjName, (BValue)BString.make((String)TextUtil.replace((String)SlotPath.unescape((String)node.getPath().substring(1)), (String)"/", (String)".")));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BComponent getExisting(Object discovery) {
            if (!(discovery instanceof ExportNode)) {
                return null;
            }
            if (!this.canExport(discovery)) {
                return null;
            }
            BIBacnetExportObject existingObject = null;
            HashMap hashMap = BBacnetExportManager.this.exportsByOrd;
            synchronized (hashMap) {
                ExportNode n = (ExportNode)discovery;
                BOrd h = BOrd.make((String)("h:" + n.get(BBacnetExportManager.this.dcolHandle).toString())).relativizeToSession();
                existingObject = (BIBacnetExportObject)BBacnetExportManager.this.exportsByOrd.get(h);
                if (existingObject != null) {
                    return (BComponent)existingObject;
                }
                BOrd sp = BOrd.make((String)("slot:" + n.get(BBacnetExportManager.this.dcolPath).toString())).relativizeToSession();
                existingObject = (BIBacnetExportObject)BBacnetExportManager.this.exportsByOrd.get(sp);
                if (existingObject != null) {
                    return (BComponent)existingObject;
                }
            }
            return null;
        }

        public boolean isExisting(Object discovery, BComponent component) {
            if (!(discovery instanceof ExportNode) || component == null) {
                return false;
            }
            if (!component.getType().is(BIBacnetExportObject.TYPE)) {
                return false;
            }
            if (!this.canExport(discovery)) {
                return false;
            }
            ExportNode n = (ExportNode)discovery;
            BOrd h = BOrd.make((String)("h:" + n.get(BBacnetExportManager.this.dcolHandle).toString())).relativizeToSession();
            BOrd sp = BOrd.make((String)("slot:" + n.get(BBacnetExportManager.this.dcolPath).toString())).relativizeToSession();
            BIBacnetExportObject obj = (BIBacnetExportObject)component;
            BOrd objOrd = obj.getObjectOrd().relativizeToSession();
            return objOrd.equals((Object)h) || objOrd.equals((Object)sp);
        }

        private boolean canExport(Object discovery) {
            String typeSpec = BBacnetExportManager.this.dcolType.get(discovery).toString();
            TypeInfo type = Sys.getRegistry().getType(typeSpec);
            AgentFilter filter = AgentFilter.is((Type)BIBacnetExportObject.TYPE);
            AgentList list = Sys.getRegistry().getAgents(type).filter(filter);
            return list.size() > 0;
        }

        public void bqlDiscover(BFoxSession session, BTypeSpec filterType) throws Exception {
            BComponentSpace space;
            BStation station;
            BBqlQueryBuilder builder;
            BOrd bql;
            if (this.bqlQuery == null) {
                String projection = this.getBqlProjection();
                this.bqlQuery = BOrd.make((String)("station:|slot:/|bql:select " + projection + " from " + filterType));
            }
            if ((bql = (builder = new BBqlQueryBuilder((BObject)(station = (BStation)(space = (BComponentSpace)session.getNavChild("station")).getRootComponent()), this.bqlQuery, false)).open((BWidget)this.getManager())) == null) {
                return;
            }
            if (!bql.relativizeToSession().toString().startsWith("station")) {
                return;
            }
            this.bqlQuery = bql;
            BITable table = (BITable)bql.get((BObject)station);
            this.updateTable(session, table);
        }

        public String getBqlProjection() {
            StringBuilder s = new StringBuilder();
            MgrColumn[] cols = this.getColumns();
            for (int i = 0; i < cols.length; ++i) {
                if (i > 0) {
                    s.append(",");
                }
                Column col = (Column)cols[i];
                s.append(col.projection);
            }
            s.append(",icon");
            return s.toString();
        }

        public void updateTable(BFoxSession session, BITable<?> table) {
            BIRandomAccessTable rtable = Tables.slurp(table);
            ArrayList<ExportNode> exportNodes = new ArrayList<ExportNode>((rtable.size() + 1) / 2);
            ExportNode node = null;
            for (int i = 0; i < rtable.size(); ++i) {
                node = this.makeNode(session);
                node.update(rtable, i);
                if (!this.canExport(node)) continue;
                exportNodes.add(node);
            }
            Object[] roots = exportNodes.toArray(new ExportNode[0]);
            this.lastLearn = roots;
            this.updateRoots(roots);
        }

        void updateTable(ExportNode[] table) {
            this.lastLearn = table;
            this.updateRoots(table);
        }

        protected ExportNode makeNode(BFoxSession session) {
            return new ExportNode(session);
        }
    }

    class ExportModel
    extends FolderModel {
        public ExportModel(BBacnetExportManager manager) {
            super((BFolderManager)manager);
        }

        public String makeTableTitle() {
            return lexExportedObjects;
        }

        public Type getFolderType() {
            return BBacnetExportFolder.TYPE;
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{BBacnetExportManager.this.mcolName, BBacnetExportManager.this.mcolTargetName, BBacnetExportManager.this.mcolObjName, BBacnetExportManager.this.mcolType, BBacnetExportManager.this.mcolObjType, BBacnetExportManager.this.mcolInstNum, BBacnetExportManager.this.mcolTgtOut, BBacnetExportManager.this.mcolExportOrd, BBacnetExportManager.this.mcolExportStatus, BBacnetExportManager.this.mcolFaultCause, BBacnetExportManager.this.mcolDescr, BBacnetExportManager.this.mcolWritable};
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BIBacnetExportObject.TYPE, BIBacnetExportFolder.TYPE};
        }

        public boolean accept(BComponent c) {
            Type t = c.getType();
            if (t.is(BIBacnetExportObject.TYPE)) {
                if (t.is(BBacnetTrendLogDescriptor.TYPE)) {
                    return false;
                }
                if (t.is(BBacnetNiagaraHistoryDescriptor.TYPE)) {
                    return false;
                }
                return !t.is(BBacnetFileDescriptor.TYPE);
            }
            return true;
        }

        public MgrTypeInfo[] getNewTypes() {
            return NEW_TYPES;
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BComponent obj = type.newInstance();
            return obj;
        }

        public BMgrTable makeTable() {
            return new BBacnetMgrTable((MgrModel)this, BBacnetExportManager.this);
        }
    }
}

