/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nvideo.camera;

import com.tridium.ndriver.util.SfUtil;
import com.tridium.nvideo.BVideoNetwork;
import com.tridium.nvideo.camera.BSimpleVideoCamera;
import com.tridium.nvideo.camera.BVideoSourcePreferences;
import com.tridium.nvideo.camera.controlHelper.BCameraControlHelper;
import com.tridium.nvideo.camera.controlHelper.BCameraControlTimings;
import com.tridium.nvideo.camera.controlHelper.BFocusControlHelper;
import com.tridium.nvideo.camera.controlHelper.BIrisControlHelper;
import com.tridium.nvideo.camera.controlHelper.BMovementControlHelper;
import com.tridium.nvideo.camera.controlHelper.BZoomControlHelper;
import com.tridium.nvideo.datatypes.BVideoCameraInfo;
import com.tridium.nvideo.datatypes.BVideoDeviceId;
import com.tridium.nvideo.display.BVideoDisplay;
import com.tridium.nvideo.display.BVideoDisplayChooser;
import com.tridium.nvideo.dvr.BVideoDvr;
import com.tridium.util.PxUtil;
import com.tridium.videoDriver.BIVideoDeviceSystem;
import com.tridium.videoDriver.BIVideoNetwork;
import com.tridium.videoDriver.camera.BIVideoPtzCamera;
import com.tridium.videoDriver.camera.control.BIVideoFocusControl;
import com.tridium.videoDriver.camera.control.BIVideoIrisControl;
import com.tridium.videoDriver.camera.control.BIVideoStorePresetControl;
import com.tridium.videoDriver.display.BIVideoDisplay;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BVideoAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFocusEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoIrisEnum;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.gx.BColor;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="ptzSupport", type="BVideoCameraInfo", defaultValue="new BVideoCameraInfo()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_UNSEEN)")}), @NiagaraProperty(name="controlTiming", type="BCameraControlTimings", defaultValue="new BCameraControlTimings()"), @NiagaraProperty(name="videoPreferences", type="BVideoSourcePreferences", defaultValue="new BVideoSourcePreferences()", facets={@Facet(value="SfUtil.incl()")})})
@NiagaraActions(value={@NiagaraAction(name="move", parameterType="BVideoPanTiltEnum", defaultValue="BVideoPanTiltEnum.none", flags=20), @NiagaraAction(name="zoom", parameterType="BVideoZoomEnum", defaultValue="BVideoZoomEnum.none", flags=20), @NiagaraAction(name="moveToPreset", parameterType="BDynamicEnum", defaultValue="BDynamicEnum.make(0, BEnumRange.DEFAULT)", flags=20), @NiagaraAction(name="storePreset", parameterType="BDynamicEnum", defaultValue="BDynamicEnum.make(0, BEnumRange.DEFAULT)", flags=20), @NiagaraAction(name="makeActive", parameterType="BVideoDisplayChooser", defaultValue="new BVideoDisplayChooser()", flags=20), @NiagaraAction(name="irisControl", parameterType="BVideoIrisEnum", defaultValue="BVideoIrisEnum.none", flags=20), @NiagaraAction(name="focusControl", parameterType="BVideoFocusEnum", defaultValue="BVideoFocusEnum.none", flags=20), @NiagaraAction(name="reevaluate", parameterType="BCameraControlHelper", defaultValue="new BMovementControlHelper(null)", flags=20), @NiagaraAction(name="sendToDisplay")})
public abstract class BVideoCamera
extends BSimpleVideoCamera
implements BIVideoPtzCamera,
BIVideoFocusControl,
BIVideoIrisControl,
BIVideoStorePresetControl,
BIVideoSource {
    @Generated
    public static final Property ptzSupport = BVideoCamera.newProperty((int)0, (BValue)new BVideoCameraInfo(), (BFacets)SfUtil.incl((String)"ed.un"));
    @Generated
    public static final Property controlTiming = BVideoCamera.newProperty((int)0, (BValue)new BCameraControlTimings(), null);
    @Generated
    public static final Property videoPreferences = BVideoCamera.newProperty((int)0, (BValue)new BVideoSourcePreferences(), (BFacets)SfUtil.incl());
    @Generated
    public static final Action move = BVideoCamera.newAction((int)20, (BValue)BVideoPanTiltEnum.none, null);
    @Generated
    public static final Action zoom = BVideoCamera.newAction((int)20, (BValue)BVideoZoomEnum.none, null);
    @Generated
    public static final Action moveToPreset = BVideoCamera.newAction((int)20, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.DEFAULT), null);
    @Generated
    public static final Action storePreset = BVideoCamera.newAction((int)20, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.DEFAULT), null);
    @Generated
    public static final Action makeActive = BVideoCamera.newAction((int)20, (BValue)new BVideoDisplayChooser(), null);
    @Generated
    public static final Action irisControl = BVideoCamera.newAction((int)20, (BValue)BVideoIrisEnum.none, null);
    @Generated
    public static final Action focusControl = BVideoCamera.newAction((int)20, (BValue)BVideoFocusEnum.none, null);
    @Generated
    public static final Action reevaluate = BVideoCamera.newAction((int)20, (BValue)new BMovementControlHelper(null), null);
    @Generated
    public static final Action sendToDisplay = BVideoCamera.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BVideoCamera.class);
    protected static final BIcon icon = BIcon.make((String)"module://videoDriver/icons/camera.png");
    protected int videoStreamThreadNumber = 1;
    protected BFocusControlHelper focusControlHelper = new BFocusControlHelper(this);
    protected BIrisControlHelper irisControlHelper = new BIrisControlHelper(this);
    protected BZoomControlHelper zoomControlHelper = new BZoomControlHelper(this);
    protected BMovementControlHelper movementControlHelper = new BMovementControlHelper(this);
    public static final BRelTime ONE_SECOND = BRelTime.makeSeconds((int)1);

    @Generated
    public BVideoCameraInfo getPtzSupport() {
        return (BVideoCameraInfo)this.get(ptzSupport);
    }

    @Generated
    public void setPtzSupport(BVideoCameraInfo v) {
        this.set(ptzSupport, (BValue)v, null);
    }

    @Generated
    public BCameraControlTimings getControlTiming() {
        return (BCameraControlTimings)this.get(controlTiming);
    }

    @Generated
    public void setControlTiming(BCameraControlTimings v) {
        this.set(controlTiming, (BValue)v, null);
    }

    @Generated
    public BVideoSourcePreferences getVideoPreferences() {
        return (BVideoSourcePreferences)this.get(videoPreferences);
    }

    @Generated
    public void setVideoPreferences(BVideoSourcePreferences v) {
        this.set(videoPreferences, (BValue)v, null);
    }

    @Generated
    public void move(BVideoPanTiltEnum parameter) {
        this.invoke(move, (BValue)parameter, null);
    }

    @Generated
    public void zoom(BVideoZoomEnum parameter) {
        this.invoke(zoom, (BValue)parameter, null);
    }

    @Generated
    public void moveToPreset(BDynamicEnum parameter) {
        this.invoke(moveToPreset, (BValue)parameter, null);
    }

    @Generated
    public void storePreset(BDynamicEnum parameter) {
        this.invoke(storePreset, (BValue)parameter, null);
    }

    @Generated
    public void makeActive(BVideoDisplayChooser parameter) {
        this.invoke(makeActive, (BValue)parameter, null);
    }

    @Generated
    public void irisControl(BVideoIrisEnum parameter) {
        this.invoke(irisControl, (BValue)parameter, null);
    }

    @Generated
    public void focusControl(BVideoFocusEnum parameter) {
        this.invoke(focusControl, (BValue)parameter, null);
    }

    @Generated
    public void reevaluate(BCameraControlHelper parameter) {
        this.invoke(reevaluate, (BValue)parameter, null);
    }

    @Generated
    public void sendToDisplay() {
        this.invoke(sendToDisplay, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        if (this.addLiveVideoView()) {
            String cameraViewTypeSpec = this.getCameraViewTypeSpec();
            AgentInfo cameraView = Sys.getRegistry().getType(cameraViewTypeSpec).getAgentInfo();
            agents.add(cameraView);
            if (this.areCameraViewsTopMost()) {
                agents.toTop(cameraView);
            }
        }
        if (this.addPlaybackView()) {
            String playbackViewTypeSpec = this.getPlaybackViewTypeSpec();
            AgentInfo playbackView = Sys.getRegistry().getType(playbackViewTypeSpec).getAgentInfo();
            agents.add(playbackView);
            if (this.areCameraViewsTopMost()) {
                agents.toTop(playbackView);
            }
        }
        try {
            AgentInfo accessControlView = Sys.getRegistry().getType("accessControl:HxWbAccessView").getAgentInfo();
            agents.add(accessControlView);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PxUtil.movePxViewsToTop((AgentList)agents);
    }

    protected boolean addLiveVideoView() {
        return true;
    }

    protected boolean addPlaybackView() {
        return true;
    }

    protected String getCameraViewTypeSpec() {
        return "videoDriver:LiveVideo";
    }

    protected String getPlaybackViewTypeSpec() {
        return "videoDriver:VideoPlayback";
    }

    protected boolean areCameraViewsTopMost() {
        return true;
    }

    protected BValue getMoveToPresetActionDefault() {
        return BString.make((String)"-");
    }

    protected BValue getStorePresetActionDefault() {
        return BString.make((String)"-");
    }

    public BVideoCameraInfo getCameraInfo() {
        return this.getPtzSupport();
    }

    public BIVideoDeviceSystem getVideoSystem() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BIVideoDeviceSystem)) continue;
            return (BIVideoDeviceSystem)parent;
        }
        return null;
    }

    public void doReevaluate(BCameraControlHelper target) {
        target.doReevaluate();
    }

    public void doMove(BVideoPanTiltEnum panTiltAction) {
        if (this.getCameraInfo().getSupportsPanTilt()) {
            this.movementControlHelper.controlCamera(panTiltAction);
        }
    }

    public void doZoom(BVideoZoomEnum zoomAction) {
        if (this.getCameraInfo().getSupportsZoom()) {
            this.zoomControlHelper.controlCamera(zoomAction);
        }
    }

    public void doMoveToPreset(BDynamicEnum presetPosition) {
    }

    public void doStorePreset(BDynamicEnum presetPosition) {
    }

    public void doMakeActive(BVideoDisplayChooser videoDisplayChooser) {
        BOrd displaySlotPathOrd = videoDisplayChooser.getVideoDisplayOrd();
        try {
            BOrd displayOrd = BOrd.make((BOrd)this.getOrdInHost(), (BOrd)displaySlotPathOrd);
            BVideoDisplay display = (BVideoDisplay)displayOrd.get();
            display.makeActiveCamera(this.getAbsoluteOrd());
        }
        catch (NullOrdException noe) {
            throw new LocalizableRuntimeException("nvideo", "makeCameraActive.noDisplays");
        }
    }

    public void doIrisControl(BVideoIrisEnum irisEnum) {
        if (this.getCameraInfo().getSupportsIris()) {
            this.irisControlHelper.controlCamera(irisEnum);
        }
    }

    public void doFocusControl(BVideoFocusEnum focusEnum) {
        if (this.getCameraInfo().getSupportsFocus()) {
            this.focusControlHelper.controlCamera(focusEnum);
        }
    }

    public void doSendToDisplay() {
        BIVideoDisplay[] displays = this.getDvr().getDisplayExt().getAllDisplays();
        if (displays.length == 0) {
            return;
        }
        BIVideoDisplay display = displays[0];
        display.mapCamerasToCurrentLayout(new BOrd[]{this.getHandleOrd()});
    }

    @Override
    public String getCameraDescription() {
        BVideoDeviceId deviceId = this.getVideoDeviceId();
        return deviceId.getDescription();
    }

    public abstract Action getMoveToPresetAction();

    public abstract Action getStorePresetAction();

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(makeActive)) {
            BComponent videoSystem = (BComponent)this.getVideoSystem();
            BOrd videoSystemOrd = videoSystem.getAbsoluteOrd();
            BVideoDisplayChooser actionDefault = new BVideoDisplayChooser();
            actionDefault.setVideoSystemOrd(videoSystemOrd);
            return actionDefault;
        }
        if (action.equals(moveToPreset)) {
            return this.getMoveToPresetActionDefault();
        }
        return super.getActionParameterDefault(action);
    }

    public void onFocusControl(BVideoFocusEnum focusEnum) {
    }

    public void onIrisControl(BVideoIrisEnum irisEnum) {
    }

    public void onZoom(BVideoZoomEnum zoomAction) {
    }

    public void onMove(BVideoPanTiltEnum panTiltAction) {
    }

    public void streamToDestination(BPlaybackParams playbackParams, IVideoDestination videoDestination) {
        throw new BajaRuntimeException("streamToDestination not implemented");
    }

    public boolean isMoveToPresetEnabled() {
        BVideoCameraInfo cameraInfo = this.getCameraInfo();
        return cameraInfo != null && cameraInfo.getSupportsMoveToPreset();
    }

    public boolean isPanTiltEnabled() {
        BVideoCameraInfo cameraInfo = this.getCameraInfo();
        return cameraInfo != null && cameraInfo.getSupportsPanTilt();
    }

    public boolean isStorePresetEnabled() {
        BVideoCameraInfo cameraInfo = this.getCameraInfo();
        return cameraInfo != null && cameraInfo.getSupportsStorePreset();
    }

    public boolean isZoomEnabled() {
        BVideoCameraInfo cameraInfo = this.getCameraInfo();
        return cameraInfo != null && cameraInfo.getSupportsZoom();
    }

    public boolean isFocusEnabled() {
        BVideoCameraInfo cameraInfo = this.getCameraInfo();
        return cameraInfo != null && cameraInfo.getSupportsFocus();
    }

    public boolean isIrisEnabled() {
        BVideoCameraInfo cameraInfo = this.getCameraInfo();
        return cameraInfo != null && cameraInfo.getSupportsIris();
    }

    public boolean supportsPlaybackControl() {
        return true;
    }

    public boolean isTimestampPreferred() {
        return this.getVideoPreferences().getTimestampPreferred();
    }

    public BRelTime getInterframeTimeout() {
        if (this.isDown()) {
            return ONE_SECOND;
        }
        return this.getVideoPreferences().getInterframeTimeout();
    }

    protected boolean recurseFoxVideoStreamPreferredToNet() {
        BIVideoNetwork net = this.getVideoNetwork();
        if (net != null && net instanceof BVideoNetwork) {
            if (net instanceof BComponent) {
                ((BComponent)net).lease();
                try {
                    ((BComponent)net).getComponentSpace().sync();
                }
                catch (Exception e) {
                    return false;
                }
            }
            return ((BVideoNetwork)net).getFoxVideoStreamPreferred();
        }
        return false;
    }

    protected boolean recurseFoxVideoStreamPreferredToDvr() {
        BIVideoDvr dvr = this.getDvr();
        if (dvr != null && dvr instanceof BVideoDvr) {
            BVideoDvr nDvr = (BVideoDvr)dvr;
            BFoxVideoStreamEnum dvrFoxStreamEnum = nDvr.getFoxVideoStreamPreferred();
            if (dvr instanceof BComponent) {
                ((BComponent)dvr).lease();
                try {
                    ((BComponent)dvr).getComponentSpace().sync();
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (dvrFoxStreamEnum == BFoxVideoStreamEnum.inherit) {
                return this.recurseFoxVideoStreamPreferredToNet();
            }
            if (dvrFoxStreamEnum == BFoxVideoStreamEnum.no) {
                return false;
            }
            if (dvrFoxStreamEnum == BFoxVideoStreamEnum.yes) {
                return true;
            }
            throw new IllegalStateException("Unrecognized foxStreamEnum: " + dvrFoxStreamEnum);
        }
        return this.recurseFoxVideoStreamPreferredToNet();
    }

    public boolean isFoxVideoStreamPreferred() {
        BFoxVideoStreamEnum foxStreamEnum = this.getFoxVideoStreamSetting();
        if (foxStreamEnum == BFoxVideoStreamEnum.inherit) {
            return this.recurseFoxVideoStreamPreferredToDvr();
        }
        if (foxStreamEnum == BFoxVideoStreamEnum.no) {
            return false;
        }
        if (foxStreamEnum == BFoxVideoStreamEnum.yes) {
            return true;
        }
        throw new IllegalStateException("Unrecognized foxStreamEnum: " + foxStreamEnum);
    }

    public BFoxVideoStreamEnum getFoxVideoStreamSetting() {
        return this.getVideoPreferences().getPreferredVideoStreamFox();
    }

    public BColor getPreferredBackgroundColor() {
        return this.getVideoPreferences().getPreferredBackgroundColor();
    }

    public BVideoAspectRatioEnum getPreferredAspectRatio() {
        return this.getVideoPreferences().getPreferredAspectRatio();
    }

    public BVideoFrameRateEnum getPreferredFrameRate() {
        return this.getVideoPreferences().getPreferredFrameRate();
    }

    public BVideoResolutionEnum getPreferredResolution() {
        return this.getVideoPreferences().getPreferredResolution();
    }

    public BVideoCompressionEnum getPreferredCompression() {
        return this.getVideoPreferences().getPreferredCompression();
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

