/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.backup;

import com.tridium.cloud.client.BCloudConnector;
import com.tridium.cloud.client.backup.BCloudBackupCreateInfo;
import com.tridium.cloud.client.backup.BRandomizedTimeTrigger;
import com.tridium.cloud.util.HttpUtils;
import com.tridium.cloud.util.StandardHttpUtils;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.backup.BBackupService;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="timeTrigger", type="BRandomizedTimeTrigger", defaultValue="new BRandomizedTimeTrigger()"), @NiagaraProperty(name="backupUrl", type="BString", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="ncpTokenId", type="BString", defaultValue="BString.make(\"ncbackupservice\")", flags=1), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="blockSize", type="BInteger", defaultValue="BInteger.make(4)", facets={@Facet(name="BFacets.MIN", value="BInteger.make(1)"), @Facet(name="BFacets.MAX", value="BInteger.make(4)")}), @NiagaraProperty(name="shareMode", type="BEnum", defaultValue="BDynamicEnum.make(SHARE_MODE_DEFAULT_ORDINAL,BEnumRange.make(new String[] {SHARE_MODE_DEFAULT_TAG}))", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="backup", parameterType="BCloudBackupCreateInfo", defaultValue="BCloudBackupCreateInfo.DEFAULT", returnType="BOrd", flags=8), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=5), @NiagaraAction(name="goodbye", flags=20)})
public final class BCloudBackupService
extends BBackupService
implements BIAlarmSource {
    public static final Property timeTrigger = BCloudBackupService.newProperty((int)0, (BValue)new BRandomizedTimeTrigger(), null);
    public static final Property backupUrl = BCloudBackupService.newProperty((int)1, (BValue)BString.DEFAULT, null);
    public static final Property ncpTokenId = BCloudBackupService.newProperty((int)1, (BValue)BString.make((String)"ncbackupservice"), null);
    public static final Property alarmSourceInfo = BCloudBackupService.newProperty((int)0, (BValue)BCloudBackupService.initAlarmSourceInfo(), null);
    public static final Property blockSize = BCloudBackupService.newProperty((int)0, (int)((BInteger)BInteger.make((int)4).as(BInteger.class)).getInt(), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)4))));
    public static final Property shareMode = BCloudBackupService.newProperty((int)5, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])new String[]{"default"})), null);
    public static final Action backup = BCloudBackupService.newAction((int)8, (BValue)BCloudBackupCreateInfo.DEFAULT, null);
    public static final Action ackAlarm = BCloudBackupService.newAction((int)5, (BValue)new BAlarmRecord(), null);
    public static final Action goodbye = BCloudBackupService.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BCloudBackupService.class);
    private static final Logger log = Logger.getLogger("cloudBackup");
    private static final Lexicon lex = Lexicon.make((String)"cloudBackup");
    public static final String jsonMimeType = "application/json; charset=UTF-8";
    public static final String binaryDataMimeType = "application/octet-stream";
    public static final String LOCALHOST_IP_ADDRESS = "127.0.0.1";
    public static final String BACKUP_NOTES_KEY = "backupNotes";
    public static final String RETENTION_POLICY_KEY = "retentionPolicy";
    public static final String AUTOMATIC_TRIGGER_RETENTION = "automatic";
    private static final String SHARE_MODE_ATTR = "shareMode";
    private AlarmSupport alarmSupport;
    private volatile boolean inAlarm;
    private volatile int alarmBits;
    private final HttpUtils httpUtils = StandardHttpUtils.getInstance();

    public BRandomizedTimeTrigger getTimeTrigger() {
        return (BRandomizedTimeTrigger)this.get(timeTrigger);
    }

    public void setTimeTrigger(BRandomizedTimeTrigger v) {
        this.set(timeTrigger, (BValue)v, null);
    }

    public String getBackupUrl() {
        return this.getString(backupUrl);
    }

    public void setBackupUrl(String v) {
        this.setString(backupUrl, v, null);
    }

    public String getNcpTokenId() {
        return this.getString(ncpTokenId);
    }

    public void setNcpTokenId(String v) {
        this.setString(ncpTokenId, v, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    public int getBlockSize() {
        return this.getInt(blockSize);
    }

    public void setBlockSize(int v) {
        this.setInt(blockSize, v, null);
    }

    public BEnum getShareMode() {
        return (BEnum)this.get(shareMode);
    }

    public void setShareMode(BEnum v) {
        this.set(shareMode, (BValue)v, null);
    }

    public BOrd backup(BCloudBackupCreateInfo parameter) {
        return (BOrd)this.invoke(backup, (BValue)parameter, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public void goodbye() {
        this.invoke(goodbye, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo info = new BAlarmSourceInfo();
        info.setToOffnormalText(BFormat.make((String)"%lexicon(cloudBackup:backupFailed)%"));
        info.setToFaultText(BFormat.make((String)"%lexicon(cloudBackup:unableToConnectToCloud)%"));
        return info;
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE, BBackupService.TYPE};
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "cloudBackupService");
    }

    public void started() throws Exception {
        super.started();
        if (Sys.atSteadyState()) {
            this.atSteadyState();
        }
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.goodbye();
    }

    public void doGoodbye() {
        Logger.getLogger("cloudBackup").info("Removing defunct CloudBackupService used for BaaS");
        BComponent parent = this.getParent().asComponent();
        Property property = this.getPropertyInParent();
        parent.remove(property);
        Logger.getLogger("cloudBackup").info("CloudBackupService has been removed; contact your sales channel for Niagara Cloud Suite options providing this functionality.");
        BTypeSpec ncnTs = BTypeSpec.make((String)"nCloudDriver:NiagaraCloudNetwork");
        Optional optNcn = Sys.findService((Type)ncnTs.getResolvedType());
        if (optNcn.isPresent()) {
            Logger.getLogger("cloudBackup").info("Leaving Cloud Connector in place as a Cloud Network was found");
        } else {
            Sys.findService((Type)BCloudConnector.TYPE).ifPresent(c -> {
                Logger.getLogger("cloudBackup").info("Removing unused Cloud Connector used for BaaS");
                BComponent cParent = ((BComponent)c.as(BComponent.class)).getParent().asComponent();
                Property cProperty = ((BComponent)c.as(BComponent.class)).getPropertyInParent();
                cParent.remove(cProperty);
                Logger.getLogger("cloudBackup").info("Unused Cloud Connector has been removed");
            });
        }
    }

    public static BCloudBackupService getBackupService() {
        return (BCloudBackupService)Sys.getService((Type)TYPE);
    }

    public BOrd doBackup(BCloudBackupCreateInfo args, Context cx) throws IOException {
        log.info(lex.get("baasEolUseNcs"));
        return BOrd.DEFAULT;
    }

    @NiagaraRpc(permissions="W", transports={@Transport(type=TransportType.box)})
    public String runBackup(Map<String, String> args, Context cx) throws IOException {
        BCloudBackupCreateInfo createInfo = new BCloudBackupCreateInfo();
        if (args.containsKey(BACKUP_NOTES_KEY)) {
            createInfo.setBackupNotes(args.get(BACKUP_NOTES_KEY));
        }
        if (args.containsKey(RETENTION_POLICY_KEY)) {
            createInfo.setRetentionPolicy(args.get(RETENTION_POLICY_KEY));
        }
        return this.runBackup(createInfo, cx);
    }

    public String runBackup(BCloudBackupCreateInfo createInfo, Context cx) throws IOException {
        return BOrd.NULL.toString();
    }

    private static boolean isTriggeredBySchedule(Context cx) {
        return cx == null || cx.getUser() == null;
    }

    @NiagaraRpc(permissions="W", transports={@Transport(type=TransportType.box)})
    public JSONArray listBackups(Context cx) throws Exception {
        log.info(lex.get("baasEolUseNcs"));
        return new JSONArray();
    }

    @NiagaraRpc(permissions="W", transports={@Transport(type=TransportType.box)})
    public JSONObject getPolicy(Context cx) throws Exception {
        log.info(lex.get("baasEolUseNcs"));
        JSONObject obj = new JSONObject();
        obj.put("status", (Object)"notFound");
        return obj;
    }

    @NiagaraRpc(permissions="W", transports={@Transport(type=TransportType.box)})
    public String delete(List<String> backupIds, Context cx) throws Exception {
        log.info(lex.get("baasEolUseNcs"));
        return "Unsupported";
    }

    @NiagaraRpc(permissions="R", transports={@Transport(type=TransportType.box)})
    public void triggerDownloadNotification(List<Map<String, String>> downloadList, Context cx) {
    }

    @NiagaraRpc(permissions="R", transports={@Transport(type=TransportType.box)})
    public String getLastBackupJob(Context cx) throws Exception {
        log.info(lex.get("baasEolUseNcs"));
        return "";
    }

    void checkHealth() throws LocalizableRuntimeException {
    }

    boolean ping() {
        return true;
    }

    public void updateStatus() {
        super.updateStatus();
    }

    public BBoolean doAckAlarm(BAlarmRecord record) {
        if (!this.isRunning() || this.alarmSupport == null) {
            return BBoolean.FALSE;
        }
        BBoolean res = BBoolean.FALSE;
        try {
            res = BBoolean.make((boolean)this.alarmSupport.ackAlarm(record));
            if (res.getBoolean()) {
                this.alarmBits &= 0xFFFFFF7F;
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)128, (boolean)false));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    void backupFailed(String cause, String remoteAddr, String userName, BAbsTime timestamp) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("backupFailureCause", BString.make((String)cause));
        data.put("backupRemoteAddr", BString.make((String)remoteAddr));
        data.put("backupUser", BString.make((String)userName));
        data.put("backupTimestamp", timestamp);
        if (this.alarmSupport != null) {
            try {
                this.alarmSupport.newAlert(BFacets.make(data));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to create backup failure alarm", e);
            }
        }
    }

    String getBearerToken() {
        return "";
    }

    protected String getFoxChannelId() {
        return "backup";
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        this.setShareModeFromLicense(this.getLicenseFeature().get(SHARE_MODE_ATTR, "default"));
    }

    private void setShareModeFromLicense(String bkupFeatureStr) {
        try {
            BEnumRange myShareRange = this.getShareMode().getRange();
            BEnumRange licShareRange = BEnumRange.make((String[])bkupFeatureStr.split(","));
            if (!myShareRange.equals((Object)licShareRange)) {
                if (!"default".equals(licShareRange.getTag(0))) {
                    throw new IllegalArgumentException("invalid shareMode options range from license: " + bkupFeatureStr);
                }
                this.setShareMode((BEnum)BDynamicEnum.make((int)0, (BEnumRange)licShareRange));
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, "Exception setting shareMode", e);
            this.setShareMode((BEnum)this.getProperty(SHARE_MODE_ATTR).getDefaultValue());
            this.configFatal(lex.getText("cannotSetShareMode"));
        }
    }
}

