/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx.table;

import javax.baja.hx.HxOp;
import javax.baja.hx.table.TableModel;
import javax.baja.io.HtmlWriter;

public class TableRenderer {
    private TableModel model;

    public void writeHeader(int col, HxOp op) throws Exception {
        int colCount = this.getModel().getColumnCount();
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<td ");
        if (col == colCount - 1) {
            out.w((Object)"width='100%' ");
        }
        out.attr("class", "tableHeader").w((Object)">");
        out.safe((Object)this.getModel().getColumnName(col, op));
        out.w((Object)"</td>");
    }

    public void writeGroup(int group, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<td");
        out.attr(" colspan", this.getModel().getColumnCount());
        out.attr(" class", "tableGroup").w((Object)">");
        out.safe((Object)this.getModel().getGroupName(group, op));
        out.w((Object)"</td>");
    }

    public void writeCell(int group, int row, int col, HxOp op) throws Exception {
        Object value = this.model.getValueAt(group, row, col, op);
        TableModel model = this.getModel();
        int rowCount = model.getRowCount(group);
        int colCount = model.getColumnCount();
        String cls = "tableCell tableHgrid";
        if (col < colCount - 1) {
            cls = cls + " tableVgrid";
        }
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<td ");
        if (col == colCount - 1) {
            out.w((Object)"width='100%' ");
        }
        out.attr("class", cls).w((Object)">");
        this.writeCellValue(value, group, row, col, op);
        out.w((Object)"</td>");
    }

    public void writeCellValue(Object value, int group, int row, int col, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        String str = String.valueOf(value);
        if (str != null && str.length() == 0) {
            out.w((Object)"&nbsp;");
        } else {
            out.safe((Object)str);
        }
    }

    public TableModel getModel() {
        return this.model;
    }

    void setModel(TableModel model) {
        this.model = model;
    }
}

