/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.hx.BHxOrdTargetResolver;
import com.tridium.hx.BHxWebWidget;
import com.tridium.hx.ErrorDialog;
import com.tridium.hx.HxHyperlinkInfo;
import com.tridium.hx.px.BHxPxWbView;
import com.tridium.hx.util.BenchmarkCommand;
import com.tridium.hx.util.HxUtils;
import com.tridium.sys.registry.NAgentInfo;
import com.tridium.sys.registry.NTypeInfo;
import com.tridium.util.CustomThemeModuleManager;
import com.tridium.util.PxUtil;
import com.tridium.util.ThrowableUtil;
import com.tridium.ux.NiagaraEnv;
import com.tridium.web.IWebEnvProvider;
import com.tridium.web.RequireJsUtil;
import com.tridium.web.WebEnv;
import com.tridium.web.WebProcessException;
import com.tridium.web.WebUtil;
import com.tridium.web.filters.ViewFilter;
import com.tridium.web.servlets.WbServlet;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.bajaux.BBajauxJsBuild;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.file.BExporter;
import javax.baja.file.types.image.BIImageFile;
import javax.baja.file.types.text.BCsvFile;
import javax.baja.file.types.text.BIHtmlFile;
import javax.baja.file.types.text.BPxFile;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.BIEncodable;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.session.INiagaraSuperSession;
import javax.baja.session.SessionUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Localizable;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.web.BIFormFactorMax;
import javax.baja.web.BIWebProfile;
import javax.baja.web.BServletView;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.BWebService;
import javax.baja.web.IWebEnv;
import javax.baja.web.WebDev;
import javax.baja.web.WebOp;
import javax.baja.web.hx.BIHxProfile;
import javax.baja.web.js.BIJavaScript;
import javax.baja.web.js.BIWebResource;
import javax.baja.web.mobile.BIMobileWebProfile;
import javax.baja.xml.XWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

@NiagaraType
public abstract class BHxProfile
extends BSingleton
implements BIMobileWebProfile,
IWebEnvProvider,
BIHxProfile {
    @Generated
    public static final Type TYPE = Sys.loadType(BHxProfile.class);
    public static final String themeKey = "selectedHxTheme";
    public static final String fullScreenKey = "fullScreen";
    public static final String autoRefreshKey = "autoRefreshTrigger";
    public static final String showCommandBarOnUxMediaPages = "showCommandBarOnUxMediaPages";
    public static final BOrd coreThemeCss = BOrd.make((String)"module://web/rc/theme/theme.css");
    public static final BOrd coreHxCss = BOrd.make((String)"module://hx/javax/baja/hx/default.css");
    public static final BOrd coreHxJs = BOrd.make((String)"module://hx/javax/baja/hx/hx.js");
    public static final BOrd hxContainerCss = BOrd.make((String)"module://hx/rc/container/container.css");
    public static final BOrd hxContainerJs = BOrd.make((String)"module://hx/rc/container/hxContainer.built.min.js");
    public static final BOrd jQueryJs = BOrd.make((String)"module://js/rc/jquery/jquery.min.js");
    public static final BOrd contextMenuCss = BOrd.make((String)"module://js/rc/jquery/contextMenu/jquery.contextMenu.css");
    private int eventCounter = 0;
    HashMap<String, Event> events = new HashMap();
    private static Command benchmark;
    private static final TypeInfo hxPxWbView;
    private static final TypeInfo servlet;
    private static final TypeInfo exporter;
    private static final String UTF_8;
    private static final BFacets THEME_FACETS;
    private static final String[] DEV_VIEWS;
    private static final boolean AUTO_REFRESH_ENABLED;
    private static final Map<String, Boolean> devViewsEnabled;
    private static boolean themeWarningWasLogged;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxProfile() {
        benchmark = new BenchmarkCommand();
        this.registerEvent(benchmark);
    }

    public String[] listConfig() {
        if (AUTO_REFRESH_ENABLED) {
            return new String[]{themeKey, showCommandBarOnUxMediaPages, autoRefreshKey};
        }
        return new String[]{themeKey, showCommandBarOnUxMediaPages};
    }

    public BValue getConfig(String key) {
        switch (key) {
            case "selectedHxTheme": {
                return BFoxSession.getDefaultThemeEnumForSession();
            }
            case "autoRefreshTrigger": {
                return BManualTriggerMode.make();
            }
            case "showCommandBarOnUxMediaPages": {
                return BBoolean.TRUE;
            }
        }
        return null;
    }

    public BFacets getConfigFacets(String key) {
        if (key.equals(themeKey)) {
            return THEME_FACETS;
        }
        return BFacets.NULL;
    }

    public void setConfig(String key, BValue value) {
    }

    public String getPageTitle(BHxView view, HxOp op) throws Exception {
        return view.getPageTitle(op);
    }

    public void doHead(HxOp op) throws Exception {
    }

    public void doBody(BHxView view, HxOp op) throws Exception {
        view.write(op);
        this.displayError(op);
    }

    public HxOp createOp(WebOp c) throws Exception {
        HxOp op = new HxOp(c);
        op.getResponse().setCharacterEncoding(UTF_8);
        return op;
    }

    public void destroyOp(HxOp op) throws Exception {
        op.deleteTempFiles();
    }

    public String getAppName() {
        return null;
    }

    public String[] getAppNames() {
        if (this.getAppName() != null) {
            return new String[]{this.getAppName()};
        }
        return new String[0];
    }

    public boolean hasView(BObject target, AgentInfo agentInfo) {
        if (agentInfo.getAgentType().toString().equals("obixDriver:ObjectToObix")) {
            return false;
        }
        Boolean enabled = devViewsEnabled.get(agentInfo.getAgentId());
        return enabled == null || enabled != false;
    }

    public AgentList getViews(HxOp op) {
        int editorIndex;
        int downloadIndex;
        AgentList list = WebEnvHolder.INSTANCE.getDefaultViews(op);
        for (String devView : DEV_VIEWS) {
            if (devViewsEnabled.get(devView).booleanValue()) continue;
            list.remove(devView);
        }
        BObject obj = op.get();
        if (!(obj instanceof BIHtmlFile || obj instanceof BPxFile || obj instanceof BIImageFile || obj instanceof BCsvFile || (downloadIndex = list.indexOf("web:FileDownloadView")) <= -1 || (editorIndex = list.indexOf("webEditors:TextFileEditor")) <= -1)) {
            list.add(downloadIndex, "webEditors:TextFileEditor");
        }
        return list;
    }

    public boolean isFullScreen(BHxView view, HxOp op) {
        return "true".equals(op.getViewParameter(fullScreenKey, "false"));
    }

    @Deprecated
    protected boolean hasWebStartAddressBar() {
        return true;
    }

    @Deprecated
    protected boolean hasWebStartStatusBar() {
        return true;
    }

    private void doWebStartMetaTags(PrintWriter out) {
        out.println("<meta name='niagara-webstart-has-address-bar' content='" + this.hasWebStartAddressBar() + "' />");
        out.println("<meta name='niagara-webstart-has-status-bar' content='" + this.hasWebStartStatusBar() + "' />");
    }

    public void writeDocument(BHxView view, HxOp op) throws Exception {
        String[] onunload;
        int i;
        String themeName = this.setupTheme(op);
        op.getResponse().setCharacterEncoding("UTF-8");
        INiagaraSuperSession superSession = SessionUtil.getCurrentNiagaraSuperSession();
        if (superSession != null) {
            HxUtil.writeFormValue("csrfToken", superSession.getCsrfToken(), op);
        }
        this.doBody(view, op);
        if (op.isRaw()) {
            return;
        }
        if (op.isErrorSent()) {
            return;
        }
        String url = op.getRedirect();
        if (url != null) {
            op.getResponse().sendRedirect(url);
            return;
        }
        String[] htags = op.getHeadTags();
        BOrd[] styles = op.getStyleSheetOrds();
        BOrd[] scripts = op.getJavaScriptOrds();
        String[] global = op.getGlobal();
        op.setContentType("text/html");
        PrintWriter out = op.getResponse().getWriter();
        String title = "";
        String pageTitle = this.getPageTitle(view, op);
        if (pageTitle != null) {
            title = pageTitle;
        }
        out.println("<!DOCTYPE html>");
        out.println("<html xmlns='http://www.w3.org/1999/xhtml' lang='en' xml:lang='en' style='overflow:auto;'>");
        out.println("<head>");
        out.println("<title>" + XWriter.safeToString((String)title, (boolean)true) + "</title>");
        out.print("<meta http-equiv=\"X-UA-Compatible\" content=\"");
        out.print(XWriter.safeToString((String)WbServlet.xuaCompatibleContent, (boolean)false));
        out.println("\">");
        out.println("<meta http-equiv='Content-type' content='text/html;charset=UTF-8' />");
        for (int i2 = 0; i2 < htags.length; ++i2) {
            out.println(htags[i2]);
        }
        this.doWebStartMetaTags(out);
        out.println("<link rel='shortcut icon' href='/favicon.ico' />");
        boolean bindResources = op.isBindResources();
        if (bindResources) {
            long lastBuildTime = Sys.getRegistry().getLastBuildTime().getMillis();
            String typeSpec = BHxOrdTargetResolver.TYPE.toString().replace(":", "%3A");
            RequireJsUtil requireJsUtil = RequireJsUtil.make((boolean)false, (Context)op);
            out.println("<script type='text/javascript'>");
            requireJsUtil.requirejsNoHtml((Writer)out);
            out.println("</script>");
            out.println(String.format("<link rel='stylesheet' type='text/css' href='/vfile/hx/app.css?typeSpec=%s&version=%d'/>", typeSpec, lastBuildTime));
            out.println(String.format("<script type='text/javascript' src='/vfile/hx/app.js?typeSpec=%s&version=%d'></script>", typeSpec, lastBuildTime));
            out.println(HxUtils.getInitSyncedSessionStorageScript());
            out.println("<script type='text/javascript'>");
            out.println(requireJsUtil.defineSystemProperties());
            out.println("</script>");
        } else {
            out.println("<link rel='stylesheet' type='text/css' href='" + WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)coreThemeCss) + "'/>");
            out.println("<link rel='stylesheet' type='text/css' href='" + WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)coreHxCss) + "'/>");
            out.println("<link rel='stylesheet' type='text/css' href='" + WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)contextMenuCss) + "'/>");
            out.println("<link rel='stylesheet' type='text/css' href='" + WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)hxContainerCss) + "'/>");
        }
        if (!themeName.isEmpty()) {
            BOrd ord = BOrd.make((String)("module://theme" + themeName + "/hx/theme.css"));
            try {
                ord.resolve((BObject)BLocalHost.INSTANCE, (Context)op);
                out.println("<link rel='stylesheet' type='text/css' href='" + WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)ord) + "'/>");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        for (i = 0; i < styles.length; ++i) {
            String cssUrl = WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)styles[i]);
            out.println("<link rel='stylesheet' type='text/css' href='" + HxUtil.encodeURLForHref(cssUrl) + "'/>");
        }
        if (!bindResources) {
            if (!RequireJsUtil.USE_NATIVE_PROMISES) {
                out.println("<script type='text/javascript' src='" + WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)this.getPromiseJS()) + "'></script>");
            }
            RequireJsUtil.make((boolean)false, (Context)op).requirejs((Writer)out);
            out.println(HxUtils.getInitSyncedSessionStorageScript());
            if (op.isJQuery()) {
                out.println("<script type='text/javascript' src='" + WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)jQueryJs) + "'></script>");
                out.println("<script type='text/javascript'>jQuery.noConflict();</script>");
            }
            out.println("<script type='text/javascript' src='" + WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)coreHxJs) + "'></script>");
        }
        for (i = 0; i < scripts.length; ++i) {
            String javascriptUrl = WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)scripts[i]);
            out.println("<script type='text/javascript' src='" + javascriptUrl + "'></script>");
        }
        out.println("<script type='text/javascript'>");
        new NiagaraEnv(NiagaraEnv.EnvType.HX).withProfile(op.getProfile().getType()).withWebOp((WebOp)op).toJavaScript(out);
        out.println("hx.startActivityMonitor();");
        if (this.isFullScreen(view, op)) {
            out.println("hx.setFullScreen(true);");
        }
        BValue value = op.getProfileConfig().get(showCommandBarOnUxMediaPages);
        String showCommandBarOnUxMediaPages = BBoolean.TRUE.encodeToString();
        BWebProfileConfig profileConfig = op.getProfileConfig();
        BValue showOnPopup = profileConfig.get("showCommandBarOnUxMediaPopups");
        if (value instanceof BIEncodable) {
            showCommandBarOnUxMediaPages = ((BIEncodable)value).encodeToString();
        }
        if (showOnPopup instanceof BBoolean && !((BBoolean)showOnPopup).getBoolean()) {
            showCommandBarOnUxMediaPages = "falseForPopups";
        }
        String agentId = ViewFilter.getViewId((WebOp)op);
        String profileInfo = "{viewId: '" + HxUtil.escapeJsStringLiteral(agentId) + '\'' + ',' + "showCommandBarOnUxMediaPages: '" + showCommandBarOnUxMediaPages + '\'' + '}';
        out.print("hx.setProfileInfo(" + profileInfo + ");");
        if (global.length > 0) {
            for (int i3 = 0; i3 < global.length; ++i3) {
                out.println(global[i3]);
            }
        }
        if (BenchmarkCommand.isActive()) {
            op.addOnload(this.getBenchmarkCommand().getInvokeCode(op));
        }
        out.print("function hxProfileOnload(){  require(['Promise'], function () { hx.started(" + op.isDynamic() + ", " + HxUtil.pollFreq + ");");
        String[] onload = op.getOnload();
        for (int i4 = 0; i4 < onload.length; ++i4) {
            out.print(" " + HxUtil.unescapeJsForInvocation(onload[i4]));
        }
        out.println("})}");
        String[] resize = op.getOnresize();
        if (resize.length > 0) {
            out.print("function hxProfileOnresize(){");
            for (int i5 = 0; i5 < resize.length; ++i5) {
                out.print(" " + HxUtil.unescapeJsForInvocation(resize[i5]));
            }
            out.println("}");
        }
        if ((onunload = op.getOnunload()).length > 0) {
            out.print("function hxProfileOnunload(){");
            for (int i6 = 0; i6 < onunload.length; ++i6) {
                out.print(" " + HxUtil.unescapeJsForInvocation(onunload[i6]));
            }
            out.println("}");
        }
        out.print("try {");
        RequireJsUtil.withRequiredBuiltFiles((PrintWriter)out, () -> {
            out.print("  require([ 'bajaux/commands/UndoManager' ], function (UndoManager) {");
            out.print("    UndoManager.$installGlobal()");
            out.print("      .catch(function (err) { console.error(err); });");
            out.print("  });");
        }, (BIWebResource[])new BIWebResource[]{BBajauxJsBuild.INSTANCE});
        out.print("} catch (e) {");
        out.print("  console.error(e);");
        out.print("}");
        out.println("</script>");
        if (AUTO_REFRESH_ENABLED) {
            HxUtils.writeAutoRefresh(op);
        }
        this.doHead(op);
        out.println("</head>");
        out.print("<body ");
        if (!themeName.isEmpty()) {
            out.print("class=\"" + themeName + "\" ");
        }
        out.print(" onload='hxProfileOnload();' ");
        if (resize.length > 0) {
            out.print("onresize='hxProfileOnresize();' ");
        }
        if (onunload.length > 0) {
            out.print("onunload='hxProfileOnunload();' ");
        }
        out.println(">");
        out.print("<form class='hx " + XWriter.safeToString((String)String.valueOf(this.getCssClassName(op)), (boolean)false) + "' method='post' action='/ord?");
        XWriter.safe((Writer)out, (String)String.valueOf(op.getOrd()), (boolean)false);
        out.print("'");
        if (op.isMultiPartForm()) {
            out.print(" enctype='multipart/form-data'");
        }
        out.println(">");
        out.print(op.getContent().toString());
        out.println("<div style='display:none'><input type='submit' id='hx_submit' onclick='hx.$formClicked=true; return hx.$allowFormSubmit;'/></div>");
        out.println("</form>");
        out.println("</body>");
        out.println("</html>");
    }

    public String getCssClassName(HxOp op) {
        return this.getType().getTypeSpec().getTypeName();
    }

    private BOrd getPromiseJS() {
        if (WebDev.get((String)"js").isEnabled()) {
            return BOrd.make((String)"module://js/rc/bluebird/bluebird.js");
        }
        return BOrd.make((String)"module://js/rc/bluebird/bluebird.min.js");
    }

    public void updateDocument(BHxView view, HxOp op) throws Exception {
        view.update(op);
    }

    public boolean processDocument(BHxView view, HxOp op) throws Exception {
        return view.process(op);
    }

    public void saveDocument(BHxView view, HxOp op) throws Exception {
        view.save(op);
    }

    public void setError(Throwable err, HxOp op) {
        String details = "";
        details = ((BWebService)Sys.getService((Type)BWebService.TYPE)).getShowStackTrace() ? ThrowableUtil.dumpToString((Throwable)err) : err.toString();
        String error = null;
        if (err instanceof Localizable) {
            error = ((Localizable)err).toString((Context)op);
        } else {
            String localizableToString;
            Localizable localizable;
            error = err.getMessage();
            if (error == null) {
                error = err.getClass().getName();
            }
            if ((localizable = ThrowableUtil.toLocalizable((Throwable)err)) != null && (localizableToString = localizable.toString((Context)op)) != null) {
                error = error + "\n" + localizableToString;
            }
        }
        op.getRequest().getSession().setAttribute("hx.error", (Object)error);
        op.getRequest().getSession().setAttribute("hx.error.name", (Object)err.getClass().getName().substring(err.getClass().getName().lastIndexOf(46) + 1));
        op.getRequest().getSession().setAttribute("hx.error.details", (Object)details);
    }

    public void clearError(HxOp op) {
        op.getRequest().getSession().removeAttribute("hx.error");
        op.getRequest().getSession().removeAttribute("hx.error.name");
        op.getRequest().getSession().removeAttribute("hx.error.details");
    }

    public boolean displayError(HxOp op) throws Exception {
        String error = (String)op.getRequest().getSession().getAttribute("hx.error");
        String details = (String)op.getRequest().getSession().getAttribute("hx.error.details");
        String name = (String)op.getRequest().getSession().getAttribute("hx.error.name");
        if (error != null) {
            HtmlWriter out = op.getHtmlWriter();
            out.write("<script>");
            ErrorDialog dialog = new ErrorDialog(name, error, details);
            dialog.open(op);
            out.write("</script>");
            this.clearError(op);
            return true;
        }
        return false;
    }

    private String setupTheme(HxOp op) {
        HttpSession httpSession;
        String themeName;
        block8: {
            themeName = "";
            BDynamicEnum userTheme = (BDynamicEnum)op.getProfileConfig().get(themeKey);
            if (userTheme != null) {
                themeName = userTheme.getTag();
            }
            BDynamicEnum themesEnum = CustomThemeModuleManager.getModuleEnumForTag((String)themeName);
            try {
                themesEnum.getRange().get(themeName);
            }
            catch (InvalidEnumException e) {
                themeName = themesEnum.getTag();
                if (themeWarningWasLogged) break block8;
                Logger.getLogger("hx").warning(String.format("There was a problem setting profile theme and was switched to the fallback %s theme.", themeName));
                themeWarningWasLogged = true;
            }
        }
        NiagaraWebSession session = WebSessionUtil.getSession((HttpServletRequest)op.getRequest());
        if (!themeName.isEmpty()) {
            if (session.getAttribute("themeName") == null) {
                session.setAttribute("themeName", (Object)themeName);
            }
        } else {
            String sessionTheme = (String)session.getAttribute("themeName");
            if (sessionTheme != null && !sessionTheme.isEmpty()) {
                themeName = sessionTheme;
            }
        }
        if (!themeName.isEmpty() && (httpSession = op.getRequest().getSession()).getAttribute("themeName") == null) {
            httpSession.setAttribute("themeName", (Object)themeName);
        }
        return themeName;
    }

    public void registerEvent(Event event) {
        event.setId("profileEvent" + this.eventCounter++);
        this.events.put(event.getId(), event);
    }

    public static IWebEnv webEnv() {
        return WebEnvHolder.INSTANCE;
    }

    public final IWebEnv getWebEnv(WebOp op) throws WebProcessException {
        return BHxProfile.webEnv();
    }

    public Command getBenchmarkCommand() {
        return benchmark;
    }

    static {
        hxPxWbView = BHxPxWbView.TYPE.getTypeInfo();
        servlet = BServletView.TYPE.getTypeInfo();
        exporter = BExporter.TYPE.getTypeInfo();
        UTF_8 = StandardCharsets.UTF_8.name();
        THEME_FACETS = BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:FrozenEnumFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:FrozenEnumEditor"));
        DEV_VIEWS = new String[]{"bajaui:CollectionView"};
        AUTO_REFRESH_ENABLED = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.profile.hx.autoRefreshEnabled"));
        devViewsEnabled = new HashMap<String, Boolean>();
        AccessController.doPrivileged(() -> {
            for (String s : DEV_VIEWS) {
                devViewsEnabled.put(s, Boolean.getBoolean("profile.enableDevView." + s));
            }
            return null;
        });
    }

    private static interface WebEnvHolder {
        public static final HxWebEnv INSTANCE = new HxWebEnv();
    }

    private static class HxWebEnv
    extends WebEnv {
        private HxWebEnv() {
            this.filter = HxWebEnv.add((AgentFilter)this.filter, (TypeInfo)pxView);
            this.filter = HxWebEnv.add((AgentFilter)this.filter, (TypeInfo)exporter);
            this.filter = AgentFilter.or((AgentFilter)this.filter, (AgentFilter)new HxFilter());
        }

        public AgentList getViews(WebOp op) {
            BIWebProfile profile = op.getWebEnv().getWebProfile(op);
            if (profile != null && profile instanceof BHxProfile) {
                try {
                    HxOp hxOp = op instanceof HxOp ? (HxOp)op : new HxOp(op, false);
                    return ((BHxProfile)profile).getViews(hxOp);
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
            return this.getDefaultViews(op);
        }

        private AgentList getDefaultViews(WebOp op) {
            AgentList agentList = op.get().getAgents((Context)op).filter(AgentFilter.or((AgentFilter)this.filter, (AgentFilter)new HxWbFilter(this.getWebProfile(op))));
            agentList.toBottom((AgentFilter)new HxHyperlinkInfo.DeprecatedFilter((Context)op));
            return agentList;
        }

        public AgentInfo getDefaultView(WebOp op, AgentList views) {
            BObject obj = op.get();
            if (obj instanceof BPxFile) {
                return views.filter(AgentFilter.is((TypeInfo)hxView)).getDefault();
            }
            for (int i = 0; i < views.size(); ++i) {
                AgentInfo agent = views.get(i);
                TypeInfo agentType = agent.getAgentType();
                if (agentType.is(servlet)) {
                    return agent;
                }
                if (agentType.is(pxView)) {
                    return agent;
                }
                if (agentType.is(wbView)) {
                    return agent;
                }
                if (!agentType.is(BIFormFactorMax.TYPE) || !agentType.is(BIJavaScript.TYPE)) continue;
                return agent;
            }
            return super.getDefaultView(op, views);
        }

        public AgentInfo getView(AgentList allViews, String viewId) {
            if (viewId.equals("hx:HxActionView")) {
                TypeInfo actionInfo = Sys.getRegistry().getType("hx:HxActionView");
                return new NAgentInfo((NTypeInfo)actionInfo);
            }
            return super.getView(allViews, viewId);
        }

        public AgentInfo translate(WebOp op, AgentInfo viewInfo) {
            TypeInfo viewTypeInfo = viewInfo.getAgentType();
            if (viewInfo instanceof BAbstractPxView) {
                AgentList agentList = Sys.getRegistry().getAgents(((BAbstractPxView)viewInfo).getType().getTypeInfo());
                agentList = agentList.filter(AgentFilter.is((TypeInfo)hxView));
                TypeInfo typeInfo = agentList.getDefault().getAgentType();
                return new PxUtil.PxHx((BAbstractPxView)viewInfo, typeInfo);
            }
            if (viewTypeInfo.is(wbView)) {
                AgentList hxViews = Sys.getRegistry().getAgents(viewTypeInfo);
                AgentList result = hxViews.filter(AgentFilter.and((AgentFilter)AgentFilter.is((TypeInfo)hxView), (AgentFilter)HxHyperlinkInfo.getViewsFilter(op)));
                return result.getDefault();
            }
            if (viewTypeInfo.is(BIFormFactorMax.TYPE) && viewTypeInfo.is(BIJavaScript.TYPE)) {
                return BHxWebWidget.TYPE.getTypeInfo().getAgentInfo();
            }
            return viewInfo;
        }

        public BWebProfileConfig makeWebProfileConfig() {
            return new BWebProfileConfig();
        }

        public BWebProfileConfig getWebProfileConfig(BUser user) {
            return (BWebProfileConfig)user.getMixIn(BWebProfileConfig.TYPE);
        }

        public BIWebProfile getWebProfile(WebOp op) {
            BUser user = op.getUser();
            BWebProfileConfig profileConfig = (BWebProfileConfig)op.getRequest().getSession(true).getAttribute("profileConfig");
            if (profileConfig == null) {
                profileConfig = (BWebProfileConfig)user.getMixIn(BWebProfileConfig.TYPE);
                op.getRequest().getSession(true).setAttribute("profileConfig", (Object)profileConfig);
            }
            BIWebProfile profile = (BIWebProfile)profileConfig.make();
            return profile;
        }

        private static class HxWbFilter
        extends AgentFilter {
            BIWebProfile profile;

            public HxWbFilter(BIWebProfile profile) {
                this.profile = profile;
            }

            public boolean include(AgentInfo agent) {
                if (agent.getAgentType().is(WebEnv.wbView)) {
                    AgentList hxViews = Sys.getRegistry().getAgents(agent.getAgentType());
                    hxViews = hxViews.filter(AgentFilter.is((TypeInfo)WebEnv.hxView));
                    for (int i = 0; i < hxViews.size(); ++i) {
                        AgentInfo hxView = hxViews.get(i);
                        TypeInfo typeInfo = hxView.getAgentType();
                        if (hxView.getAgentType().is(hxPxWbView)) continue;
                        if (hxView.getAppName() != null && this.profile != null) {
                            String[] profileAppNames = this.profile.getAppNames();
                            for (int j = 0; j < profileAppNames.length; ++j) {
                                if (!profileAppNames[j].equals(hxView.getAppName())) continue;
                                return true;
                            }
                            continue;
                        }
                        return true;
                    }
                }
                return false;
            }
        }

        private static class HxFilter
        extends AgentFilter {
            private HxFilter() {
            }

            public boolean include(AgentInfo agent) {
                if (agent.getAgentType().is(WebEnv.hxView)) {
                    return !agent.getAgentId().endsWith("/hx");
                }
                if (agent.getAgentType().is(servlet)) {
                    return true;
                }
                return agent.getAgentType().is(BIFormFactorMax.TYPE) && agent.getAgentType().is(BIJavaScript.TYPE);
            }
        }
    }
}

