/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.px;

import com.tridium.agent.BILoadablePxView;
import com.tridium.hx.px.BHxWidgetShell;
import com.tridium.hx.px.HxShellManager;
import com.tridium.hx.stub.StubHxOp;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.sys.spy.CacheSpy;
import com.tridium.ui.Binder;
import com.tridium.util.ObjectUtil;
import com.tridium.util.warmup.BWarmupConfig;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BDynamicPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BDataFile;
import javax.baja.file.BIFile;
import javax.baja.file.types.text.BPxFile;
import javax.baja.gx.BImage;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.OrdUtil;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.px.PxDecoder;

public class HxPxCache {
    private static final BRelTime BINDING_TIMEOUT = BRelTime.make((long)AccessController.doPrivileged(() -> Integer.getInteger("niagara.ui.pxCache.binding.timeout", HxUtil.getPollFreq() * 6)).intValue());
    private static final BRelTime CACHE_TIMEOUT = BRelTime.make((long)AccessController.doPrivileged(() -> Integer.getInteger("niagara.ui.pxCache.timeout", 120000)).intValue());
    private String ord;
    private OrdTarget target;
    private final BAbstractPxView view;
    private BComponentSpace space;
    private HxPxBinder binder;
    private BAbsTime lastInterest = BAbsTime.now();
    private String id;
    private boolean warmup;
    private BOrd pxFileOrd = BOrd.NULL;
    private BIFile pxFile;
    private BAbsTime pxFileLastModified;
    private BFacets facets;
    private String uid = null;
    private static Monitor monitor = new Monitor();
    private static final Logger log = Logger.getLogger("hx.px.cache");
    private static final Logger foundLog = Logger.getLogger("hx.px.cache.found");
    private static final List<String> IGNORED_VIEW_QUERY_PARAMS = Arrays.asList("fullScreen", "previewMedia");

    private HxPxCache(OrdTarget target, BAbstractPxView view, String id, boolean warmup) {
        this.target = HxUtil.getMinimalOrdTarget(target);
        this.ord = HxPxCache.getMinimalOrd(target);
        this.view = view;
        this.id = id;
        this.warmup = warmup;
        if (view instanceof BDynamicPxView) {
            this.uid = ((BDynamicPxView)view).getUniqueId(target);
        }
        this.facets = target.getFacets();
    }

    private static String getMinimalOrd(OrdTarget target) {
        return OrdUtil.getOrdWithoutViewQueryParameters((OrdTarget)target, IGNORED_VIEW_QUERY_PARAMS, (boolean)true).toString();
    }

    public static BComponentSpace get(OrdTarget target, BAbstractPxView view, boolean checkReloadRequire, HxOp op) throws Exception {
        String id = op.getRequest().getSession().getId();
        HxPxCache cacheEntry = new HxPxCache(target, view, id, op instanceof StubHxOp);
        return HxPxCache.monitor.get((HxPxCache)cacheEntry, (boolean)checkReloadRequire, (HxOp)op).space;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.uid != null) {
            buf.append(this.uid);
        } else if (this.view != null) {
            buf.append(this.view.getName());
        } else {
            buf.append("unknown");
        }
        buf.append(" [");
        buf.append(this.target);
        buf.append("]");
        if (this.warmup) {
            buf.append(" warmup");
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HxPxCache)) {
            return false;
        }
        HxPxCache other = (HxPxCache)obj;
        if (!(this.warmup || other.warmup || other.id.equals(this.id))) {
            return false;
        }
        if (!this.ord.equals(other.ord)) {
            return false;
        }
        if (this.view == null && other.view != null) {
            return false;
        }
        if (this.view != null && other.view == null) {
            return false;
        }
        if (this.view != null) {
            if (!this.view.getType().is(other.view.getType())) {
                return false;
            }
            if (this.view instanceof BDynamicPxView) {
                return !(this.uid != null && !this.uid.equals(other.uid) || this.uid == null && other.uid != null);
            }
            return this.view.equivalent((Object)other.view);
        }
        return true;
    }

    public int hashCode() {
        return this.target.getOrd().hashCode();
    }

    private void syncImages(BComplex object) {
        BWidget root;
        SlotCursor cursor = object.getProperties();
        while (cursor.nextComponent()) {
            BComplex kid = (BComplex)cursor.get();
            if (kid instanceof BWidget) {
                BWidget widget = (BWidget)kid;
                SlotCursor imageCursor = widget.getProperties();
                while (imageCursor.next(BImage.class)) {
                    BImage image = (BImage)imageCursor.get();
                    if (image == null || image.isNull()) continue;
                    image.syncDimensions();
                }
            }
            this.syncImages(kid);
        }
        if (object instanceof BPxInclude && (root = ((BPxInclude)object).getRootWidget()) != null && root.getParent() == null) {
            this.syncImages((BComplex)root);
        }
    }

    private boolean requiresReload(HxOp op) {
        return this.hasFileBeenModified() || this.hasFacetsBeenModified(op) && !this.warmup || !this.binder.isAlive() || this.space != null && HxPxCache.requiresReload((BWidget)this.space.getRootComponent(), (Context)op) || this.view instanceof BILoadablePxView && this.pxFileLastModified != null && ((BILoadablePxView)this.view).isPxViewModified(this.pxFileLastModified);
    }

    private boolean hasFileBeenModified() {
        if (this.pxFile == null) {
            return false;
        }
        if (this.view instanceof BPxView && !((BPxView)this.view).getPxFile().equals((Object)this.pxFileOrd)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("File have been changed: " + ((BPxView)this.view).getPxFile().getOrd() + "!=" + this.pxFileOrd);
            }
            return true;
        }
        BIFile x = (BIFile)this.pxFile.getNavOrd().get();
        return !x.getLastModified().equals((Object)this.pxFileLastModified);
    }

    private boolean hasFacetsBeenModified(HxOp op) {
        BFacets newFacets;
        BFacets bFacets = newFacets = op == null ? null : op.getFacets();
        if (this.facets == null || newFacets == null) {
            return false;
        }
        if (!this.facets.equals((Object)newFacets)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Facets have been modified: " + newFacets);
            }
            this.facets = newFacets;
            return true;
        }
        return false;
    }

    private static boolean requiresReload(BWidget widget, Context cx) {
        if (widget != null) {
            if (BBoolean.TRUE.equals(widget.fw(308, (Object)cx, null, null, null))) {
                return true;
            }
            for (BWidget bWidget : widget.getChildWidgets()) {
                if (!HxPxCache.requiresReload(bWidget, cx)) continue;
                return true;
            }
            for (BWidget bWidget : widget.getBindings()) {
                if (!BBoolean.TRUE.equals(bWidget.fw(308, (Object)cx, null, null, null))) continue;
                return true;
            }
            if (widget instanceof BPxInclude) {
                BWidget root = ((BPxInclude)widget).getRootWidget();
                return root != null && root.getParentWidget() == null && HxPxCache.requiresReload(root, cx);
            }
        }
        return false;
    }

    private static void trimAll() {
        Monitor.cache.clear();
        log.info("Entire cache cleared");
    }

    private static class HxPxCacheSpy
    extends CacheSpy {
        HxPxCacheSpy() {
            super("HxPx Cache", "/hxPxCache");
        }

        public void clearCache() {
            HxPxCache.trimAll();
        }

        public void write(SpyWriter out) throws Exception {
            super.write(out);
            Object[] items = (HxPxCache[])Monitor.cache.filterNull().trim();
            BAbsTime now = BAbsTime.now();
            Object[] ages = new Long[items.length];
            for (int i = 0; i < items.length; ++i) {
                HxPxCache item = items[i];
                ages[i] = item.lastInterest.delta(now).getMillis();
            }
            SortUtil.sort((Object[])ages, (Object[])items);
            out.startTable(true);
            out.trTitle((Object)("HxPx Cache [" + items.length + ']'), 3);
            out.w((Object)"<tr>").th((Object)"Ord").th((Object)"User").th((Object)"Age").w((Object)"</tr>\n");
            for (Object item : items) {
                String username = "";
                if (((HxPxCache)item).target != null && ((HxPxCache)item).target.getUser() != null) {
                    username = ((HxPxCache)item).target.getUser().getUsername();
                }
                String age = ((HxPxCache)item).lastInterest.delta(now).toString();
                out.tr((Object)((HxPxCache)item).ord, (Object)username, (Object)age);
            }
            out.endTable();
        }
    }

    private static class Monitor
    implements Runnable {
        private final Thread thread = new Thread((Runnable)this, "HxPxCache");
        private static Array<HxPxCache> cache = new Array(HxPxCache.class);

        public Monitor() {
            this.thread.setDaemon(true);
            this.thread.start();
            Spy.ROOT.add("hxPxCache", (Spy)new HxPxCacheSpy());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HxPxCache get(HxPxCache hxPxCache, boolean checkReloadRequire, HxOp op) throws Exception {
            BWidget widget;
            BObject targetObject;
            HxPxCache cacheFallback = hxPxCache;
            HxPxCache previousCache = null;
            boolean remove = false;
            boolean reload = false;
            boolean found = false;
            boolean switchFromWarmupToUser = false;
            Monitor monitor = this;
            synchronized (monitor) {
                int i = cache.indexOf((Object)hxPxCache);
                boolean bl = found = i >= 0;
                if (foundLog.isLoggable(Level.FINE) && op.getRequest().getMethod().equals("GET")) {
                    if (found) {
                        foundLog.fine("found:     " + hxPxCache.toString());
                    } else {
                        foundLog.fine("not found: " + hxPxCache.toString());
                    }
                }
                if (found) {
                    previousCache = hxPxCache = (HxPxCache)cache.get(i);
                    if (hxPxCache.warmup && !cacheFallback.warmup) {
                        switchFromWarmupToUser = true;
                        reload = true;
                        hxPxCache.target = cacheFallback.target;
                        hxPxCache.facets = cacheFallback.facets;
                        hxPxCache.warmup = false;
                        hxPxCache.id = op.getRequest().getSession().getId();
                    }
                    if (hxPxCache.lastInterest.isBefore(Clock.time().subtract(BINDING_TIMEOUT))) {
                        if (log.isLoggable(Level.FINER)) {
                            BRelTime difference = hxPxCache.lastInterest.delta(Clock.time());
                            log.finer("Last interest is too old for " + Monitor.getViewName(hxPxCache) + " : " + difference.toString() + " > " + BINDING_TIMEOUT);
                        }
                        reload = true;
                    } else if (log.isLoggable(Level.FINER)) {
                        BRelTime difference = hxPxCache.lastInterest.delta(Clock.time());
                        log.finer("Last interest is close enough " + Monitor.getViewName(hxPxCache) + " : " + difference.toString() + " < " + BINDING_TIMEOUT);
                    }
                    hxPxCache.lastInterest = BAbsTime.now();
                    if (checkReloadRequire && hxPxCache.requiresReload(op)) {
                        cache.remove((Object)hxPxCache);
                        remove = true;
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("HxPxCache requires reload for " + Monitor.getViewName(hxPxCache));
                        }
                    }
                    if (!remove && op.getRequest().getMethod().equals("GET")) {
                        if ("no-cache".equals(op.getRequest().getHeader("Pragma")) || "no-cache".equals(op.getRequest().getHeader("Cache-Control"))) {
                            cache.remove((Object)hxPxCache);
                            remove = true;
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("Forced reload for " + hxPxCache.toString());
                            }
                        } else {
                            reload = true;
                        }
                    }
                }
            }
            if (remove) {
                try {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Bindings for " + hxPxCache.toString() + " have been removed.");
                    }
                    hxPxCache.space.getRootComponent().stop();
                    hxPxCache.binder.stop();
                    hxPxCache = cacheFallback;
                    hxPxCache.lastInterest = BAbsTime.now();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Unable to stop px view " + hxPxCache.toString(), e);
                }
            } else if (found) {
                if (reload) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Reloading bindings for " + hxPxCache.toString());
                    }
                    hxPxCache.binder.unresolve();
                }
                hxPxCache.binder.checkItems();
                if (switchFromWarmupToUser && log.isLoggable(Level.FINE)) {
                    log.fine("warmup px switched to active user " + hxPxCache.toString());
                }
                return hxPxCache;
            }
            if ((targetObject = hxPxCache.target.get()) instanceof BDataFile) {
                hxPxCache.pxFileOrd = hxPxCache.target.getOrd();
            } else {
                if (hxPxCache.view == null) {
                    throw new IllegalArgumentException("pxView cannot be null when using " + targetObject.getType());
                }
                if (hxPxCache.view instanceof BPxView) {
                    hxPxCache.pxFileOrd = ((BPxView)hxPxCache.view).getPxFile();
                } else if (hxPxCache.view instanceof BDynamicPxView) {
                    hxPxCache.uid = ((BDynamicPxView)hxPxCache.view).getUniqueId(hxPxCache.target);
                } else {
                    throw new IllegalArgumentException("Don't know how to handle " + hxPxCache.view.getType());
                }
            }
            BasicContext cx = new BasicContext(op.getUser(), op.getLanguage());
            if (!hxPxCache.pxFileOrd.isNull()) {
                OrdTarget target = ObjectUtil.resolveAndCheckRead((BOrd)hxPxCache.pxFileOrd, (BObject)targetObject, (Context)op);
                hxPxCache.pxFile = (BIFile)target.get();
                widget = new PxDecoder(hxPxCache.pxFile, (Context)cx).decodeDocument();
                hxPxCache.pxFileLastModified = hxPxCache.pxFile.getLastModified();
            } else {
                String xml = ((BDynamicPxView)hxPxCache.view).generateXml((Object)hxPxCache.target.get(), (Context)hxPxCache.target);
                widget = new PxDecoder(hxPxCache.target.getOrd(), (InputStream)new ByteArrayInputStream(xml.getBytes()), (Context)cx).decodeDocument();
                hxPxCache.pxFileLastModified = BAbsTime.now();
            }
            if (op instanceof StubHxOp) {
                BWarmupConfig.checkInterrupted();
            }
            Monitor.visitWidgets((BComplex)widget, w -> {
                if (w instanceof BPxInclude) {
                    DiagnosticUtil.diagnoseIfLoggable((String)"BHxPxView.pxIncludeSync", () -> ((BPxInclude)w).sync());
                }
            });
            String agentId = "";
            if (hxPxCache.view != null) {
                agentId = hxPxCache.view.getAgentId();
            } else if (targetObject instanceof BPxFile) {
                agentId = "hx:HxPxView";
            }
            BHxWidgetShell shell = new BHxWidgetShell();
            shell.widgetSupport(new HxShellManager((BWidget)shell));
            shell.init(widget, hxPxCache.target, agentId);
            hxPxCache.binder = new HxPxBinder(widget);
            hxPxCache.binder.start(hxPxCache.target, (Context)hxPxCache.target);
            shell.setBinder(hxPxCache.binder);
            hxPxCache.space = new BComponentSpace("hxpx", null, BOrd.make((String)"hxpx:"));
            hxPxCache.space.setRootComponent((BComponent)widget);
            try {
                widget.start();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unable to start px view " + hxPxCache.toString(), e);
            }
            hxPxCache.binder.checkItems();
            hxPxCache.syncImages((BComplex)widget);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Caching " + hxPxCache.toString());
            }
            hxPxCache.lastInterest = BAbsTime.now();
            cache.add((Object)hxPxCache);
            Monitor monitor2 = this;
            synchronized (monitor2) {
                this.notify();
            }
            return hxPxCache;
        }

        private static void visitWidgets(BComplex c, Consumer<BWidget> widgetConsumer) {
            if (c == null) {
                return;
            }
            if (c instanceof BWidget) {
                BWidget root;
                widgetConsumer.accept((BWidget)c);
                if (c instanceof BPxInclude && (root = ((BPxInclude)c).getRootWidget()) != null && root.getParentWidget() == null) {
                    Monitor.visitWidgets((BComplex)root, widgetConsumer);
                }
            }
            SlotCursor cursor = c.getProperties();
            while (cursor.nextComponent()) {
                Monitor.visitWidgets((BComplex)cursor.get(), widgetConsumer);
            }
        }

        private static String getViewName(HxPxCache hxPxCache) {
            if (hxPxCache != null && hxPxCache.view != null) {
                return hxPxCache.view.getName();
            }
            return "unknown";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block17: while (true) {
                try {
                    while (true) {
                        HxPxCache[] cacheItems;
                        Monitor monitor = this;
                        synchronized (monitor) {
                            cacheItems = (HxPxCache[])cache.copy().trim();
                        }
                        int len = cacheItems != null ? cacheItems.length : 0;
                        BAbsTime now = BAbsTime.now();
                        BAbsTime timeoutCutoff = now.subtract(CACHE_TIMEOUT);
                        BAbsTime bindingCutoff = now.subtract(BINDING_TIMEOUT);
                        for (int i = 0; i < len; ++i) {
                            HxPxCache hxPxCache = cacheItems[i];
                            try {
                                BRelTime difference;
                                boolean removed = false;
                                Monitor monitor2 = this;
                                synchronized (monitor2) {
                                    if (hxPxCache.lastInterest.isAfter(now)) {
                                        hxPxCache.lastInterest = now;
                                    }
                                    if (hxPxCache.lastInterest.isBefore(timeoutCutoff)) {
                                        if (log.isLoggable(Level.FINE)) {
                                            log.fine("Removing " + hxPxCache.toString());
                                        }
                                        cache.remove((Object)hxPxCache);
                                        removed = true;
                                    }
                                }
                                if (!removed && hxPxCache.binder.isAlive()) {
                                    if (!hxPxCache.lastInterest.isAfter(bindingCutoff)) continue;
                                    if (log.isLoggable(Level.FINER)) {
                                        difference = hxPxCache.lastInterest.delta(now);
                                        log.finer("Checking bindings for " + hxPxCache.toString() + ": " + difference + " < " + BINDING_TIMEOUT);
                                    }
                                    hxPxCache.binder.checkItems();
                                    continue;
                                }
                                try {
                                    if (log.isLoggable(Level.FINER)) {
                                        difference = hxPxCache.lastInterest.delta(now);
                                        log.fine("Bindings for " + hxPxCache.toString() + " have been stopped: " + difference + " >= " + BINDING_TIMEOUT);
                                    }
                                    hxPxCache.binder.stop();
                                    hxPxCache.space.getRootComponent().stop();
                                }
                                catch (Exception e) {
                                    log.log(Level.SEVERE, "Unable to stop px view " + hxPxCache.toString(), e);
                                }
                                continue;
                            }
                            catch (Exception e) {
                                log.log(Level.SEVERE, "Unable to update bindings for " + hxPxCache.toString(), e);
                            }
                        }
                        if (len > 0) {
                            try {
                                int sleepTime = (int)((long)(HxUtil.getPollFreq() / 2) - BAbsTime.now().delta(now).abs().getMillis());
                                Thread.sleep(Math.max(sleepTime, 100));
                                continue block17;
                            }
                            catch (InterruptedException ie) {
                                if (!log.isLoggable(Level.FINE)) continue;
                                log.log(Level.FINE, "Monitoring interrupted", ie);
                                continue;
                            }
                        }
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Monitoring paused");
                        }
                        Monitor monitor3 = this;
                        synchronized (monitor3) {
                            while (cache.isEmpty()) {
                                this.wait(Math.max((long)HxUtil.getPollFreq(), 1000L));
                            }
                        }
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("Monitoring resumed");
                    }
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "Error in HxPxCacheMonitor", t);
                    continue;
                }
                break;
            }
        }
    }

    private static class HxPxBinder
    extends Binder {
        public HxPxBinder(BWidget owner) {
            super(owner);
        }

        public void checkItems() {
            super.checkItems();
        }

        protected synchronized void checkWorker() {
        }

        protected void postResolve(Binder.Item item, HashMap<BComponent, BComponent> toSubscribe) {
            OrdTarget target = item.getTarget();
            if (target != null && !target.canRead()) {
                item.removeTarget();
                log.warning("no read permission: " + target.getOrd());
            }
            super.postResolve(item, toSubscribe);
        }

        public void unresolve() {
            if (!this.isAlive()) {
                return;
            }
            super.unresolve();
            this.checkItems();
        }

        protected void updateBindings(List<BBinding> bindings, OrdTarget target) {
            super.updateBindings(bindings, target);
            for (BBinding binding : bindings) {
                BWidget widget = binding.getWidget();
                ((BHxWidgetShell)widget.getShell()).setModified(widget, false);
            }
        }

        public synchronized void unbind(BBinding binding) {
        }

        public boolean isAlive() {
            return this.isAlive;
        }
    }
}

