/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.gx;

import com.tridium.gx.geom.AbstractVectorPathPainter;
import com.tridium.gx.geom.PolygonGeomPainter;
import com.tridium.hx.gx.HtmlSvgPainter;
import com.tridium.hx.gx.HxGraphics;
import com.tridium.hx.gx.UxShapeUtil;
import com.tridium.web.WebUtil;
import java.util.Arrays;
import java.util.List;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPolygonGeom;
import javax.baja.gx.Point;
import javax.baja.gx.PolygonGeom;
import javax.baja.gx.RectGeom;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BajaRuntimeException;
import javax.servlet.http.HttpServletRequest;

public class HxSvgGraphics
extends HxGraphics {
    protected UxShapeUtil.RotateInfo rotateInfo;

    public static HxSvgGraphics makeSvg(HxOp op, String id, int width, int height) throws Exception {
        return new HxSvgGraphics(op, id, width, height);
    }

    private HxSvgGraphics(HxOp op, String id, int width, int height) throws Exception {
        this.op = op;
        this.out = op.getHtmlWriter();
        this.id = id;
        this.width = width;
        this.height = height;
        this.rotateInfo = UxShapeUtil.getRotateInfo(op.get());
        this.painter = new HtmlSvgPainter(this.out, false, this.rotateInfo);
        this.filler = new HtmlSvgPainter(this.out, true, this.rotateInfo);
        this.out.w((Object)"require(['d3'],function(d3){  ");
        this.out.w((Object)"var svg = d3.select(document.getElementById('").w((Object)id).w((Object)"'));\n");
        this.out.w((Object)"var defs = svg.append('defs');");
        this.out.w((Object)"var s = {g:svg, color: 'black', lineWidth: 1, p:'' };\n");
        this.out.w((Object)"var q = [ s ];\n");
        this.setBrush(BBrush.DEFAULT);
        this.setFont(BFont.DEFAULT);
        this.setPen(BPen.DEFAULT);
        this.clip(0.0, 0.0, width, height);
        this.out.w((Object)"hx.svgClearAll(svg);\n");
        this.out.w((Object)"s.g = s.g.append('g')");
        this.out.w((Object)".attr('transform', 'translate(0.5, 0.5)');\n");
    }

    @Override
    public void setBrush(BBrush b) {
        this.brush = b;
        BBrush.Paint paint = b.getPaint();
        if (paint instanceof BBrush.LinearGradient) {
            BBrush.LinearGradient gradient = (BBrush.LinearGradient)paint;
            BBrush.Stop[] stops = gradient.getStops();
            double angle = (gradient.getAngle() - 90.0) / 180.0 * Math.PI;
            double xPercent = Math.sin(angle %= Math.PI * 2) * 100.0;
            double yPercent = Math.cos(angle) * 100.0;
            double x1 = xPercent > 0.0 ? HxSvgGraphics.absAndCleanupFractions(xPercent) : 0.0;
            double x2 = xPercent < 0.0 ? HxSvgGraphics.absAndCleanupFractions(xPercent) : 0.0;
            double y1 = yPercent > 0.0 ? HxSvgGraphics.absAndCleanupFractions(yPercent) : 0.0;
            double y2 = yPercent < 0.0 ? HxSvgGraphics.absAndCleanupFractions(yPercent) : 0.0;
            String key = this.getId("lg", b);
            this.out.println("var id='" + key + "';");
            this.out.w((Object)"var gradient = svg.select('defs').append('linearGradient')");
            this.out.w((Object)".attr('id', id)");
            this.out.w((Object)(".attr('x1', '" + x1 + "%')"));
            this.out.w((Object)(".attr('x2', '" + x2 + "%')"));
            this.out.w((Object)(".attr('y1', '" + y1 + "%')"));
            this.out.w((Object)(".attr('y2', '" + y2 + "%')"));
            if (this.rotateInfo != null) {
                this.out.w((Object)".attr('gradientTransform', '").w((Object)this.rotateInfo.getLinearGradientTransform()).w((Object)"')");
            }
            this.out.println(";");
            for (BBrush.Stop stop : stops) {
                this.out.w((Object)"gradient.append('stop')");
                this.out.w((Object)(".attr('offset', '" + stop.getOffset() + "%')"));
                this.out.w((Object)(".attr('stop-color', '" + HxSvgGraphics.getColorString(stop.getColor()) + "');"));
            }
            this.out.w((Object)("s.color = \"u\" +\"rl('#" + key + "')\";"));
        } else if (paint instanceof BBrush.RadialGradient) {
            BBrush.RadialGradient gradient = UxShapeUtil.getRadialGradient((BBrush.RadialGradient)paint, this.rotateInfo);
            BBrush.Stop[] stops = gradient.getStops();
            double radius = gradient.getRadius();
            String key = this.getId("rg", b);
            this.out.println("var id='" + key + "';");
            this.out.w((Object)"var gradient = svg.select('defs').append('radialGradient')");
            this.out.w((Object)".attr('id', id)");
            if (this.rotateInfo != null) {
                this.out.w((Object)".attr('gradientTransform', '").w((Object)this.rotateInfo.getRadialGradientTransform()).w((Object)"')");
            }
            this.out.w((Object)(".attr('cx', '" + gradient.getCenter().x + "%')"));
            this.out.w((Object)(".attr('cy', '" + gradient.getCenter().y + "%')"));
            this.out.w((Object)(".attr('fx', '" + gradient.getFocal().x + "%')"));
            this.out.w((Object)(".attr('fy', '" + gradient.getFocal().y + "%')"));
            this.out.println(".attr('r', '" + radius + "%');");
            for (BBrush.Stop stop : stops) {
                this.out.w((Object)"gradient.append('stop')");
                this.out.w((Object)(".attr('offset', '" + stop.getOffset() + "%')"));
                this.out.println(".attr('stop-color', '" + HxSvgGraphics.getColorString(stop.getColor()) + "');");
            }
            this.out.w((Object)("s.color = \"u\" +\"rl('#" + key + "')\";"));
        } else if (paint instanceof BBrush.Image && ((BBrush.Image)paint).getImage().getOrdList().size() > 0) {
            BBrush.Image imageBrush = (BBrush.Image)paint;
            if (imageBrush.getTile() == 1) {
                BImage image = imageBrush.getImage();
                image.syncDimensions();
                double width = image.getWidth();
                double height = image.getHeight();
                String uri = HxUtil.escapeJsStringLiteral(WebUtil.toUri((OrdTarget)this.op, (HttpServletRequest)this.op.getRequest(), (BOrd)image.getOrdList().get(0)));
                String key = this.getId("p", uri);
                this.out.println("var id='" + key + "';");
                this.out.w((Object)"var pattern = svg.select('defs').append('pattern')");
                this.out.w((Object)".attr('patternUnits', 'userSpaceOnUse')");
                this.out.w((Object)".attr('id', id)");
                this.out.w((Object)".attr('x', '0')");
                this.out.w((Object)".attr('y', '0')");
                this.out.w((Object)(".attr('width', '" + width + "')"));
                this.out.w((Object)(".attr('height', '" + height + "')"));
                if (this.rotateInfo != null) {
                    this.out.w((Object)".attr('patternTransform', '").w((Object)this.rotateInfo.getPatternTransform()).w((Object)"')");
                }
                this.out.w((Object)".append('image')");
                this.out.w((Object)(".attr('width', '" + width + "')"));
                this.out.w((Object)(".attr('height', '" + height + "')"));
                this.out.w((Object)(".attr('href', '" + uri + "');"));
                this.out.w((Object)("s.color = \"u\" +\"rl('#" + key + "')\";"));
            } else {
                this.out.w((Object)("s.color = '" + HxSvgGraphics.getColorString(BColor.transparent) + "';"));
            }
        } else {
            BColor c = paint instanceof BBrush.Solid ? ((BBrush.Solid)paint).getColor() : BColor.black;
            this.out.w((Object)("s.color = '" + HxSvgGraphics.getColorString(c) + "';"));
        }
        this.out.w((Object)"\n");
    }

    public String getId(String prefix, Object info) {
        int code = info instanceof String ? info.hashCode() : System.identityHashCode(info);
        if (this.rotateInfo != null) {
            code += this.rotateInfo.hashCode();
        }
        return prefix + code;
    }

    private static String getColorString(BColor c) {
        return "rgba(" + c.getRed() + ',' + c.getGreen() + ',' + c.getBlue() + ',' + (double)c.getAlpha() / 255.0 + ')';
    }

    private static double absAndCleanupFractions(double value) {
        if ((value = Math.abs(value)) < 1.0E-4) {
            return 0.0;
        }
        return value;
    }

    @Override
    public void setPen(BPen p) {
        this.pen = p;
        this.out.w((Object)("s.lineWidth = " + this.getPen().getWidth() + ";\n"));
        if (p.getDash().length > 0) {
            this.out.w((Object)"s.lineDash = '");
            this.out.w((Object)String.join((CharSequence)" ", (CharSequence[])Arrays.stream(p.getDash()).mapToObj(s -> Integer.toString((int)(s * this.getPen().getWidth()))).toArray(String[]::new)));
            this.out.w((Object)"';\n");
        }
        switch (this.pen.getCap()) {
            case 103: {
                this.out.w((Object)"s.lineCap='round';\n");
                break;
            }
            case 102: {
                this.out.w((Object)"s.lineCap='square';\n");
            }
        }
        switch (this.pen.getJoin()) {
            case 202: {
                this.out.w((Object)"s.lineJoin='round';\n");
                break;
            }
            case 203: {
                this.out.w((Object)"s.lineJoin='bevel';\n");
            }
        }
    }

    @Override
    public void setFont(BFont font) {
        this.font = font;
        this.out.w((Object)"s.font = '");
        this.out.w((Object)HxUtil.makeFont(font));
        this.out.w((Object)"';\n");
    }

    @Override
    public void clip(IGeom geom) {
        this.clip = this.clip != null ? geom.intersection(this.clip) : geom;
    }

    @Override
    public void clip(double x, double y, double w, double h) {
        this.clip((IGeom)new RectGeom(x, y, w, h));
    }

    @Override
    public void strokeLine(double x1, double y1, double x2, double y2) {
        ((HtmlSvgPainter)this.painter).line(x1, y1, x2, y2, this.pen, this.brush);
    }

    @Override
    public void strokeRect(double x, double y, double width, double height) {
        ((HtmlSvgPainter)this.painter).rect(x, y, width, height, this.brush);
    }

    @Override
    public void fillRect(double x, double y, double width, double height) {
        ((HtmlSvgPainter)this.filler).rect(x, y, width, height, this.brush);
    }

    @Override
    public void drawString(String str, double x, double y) {
        if (this.brush.isNull()) {
            return;
        }
        try {
            ((HtmlSvgPainter)this.painter).text(str, x, y, this.tx, this.ty, this.font.getAscent());
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    protected void drawPolygon(IPolygonGeom p, boolean fill) {
        if (this.rotateInfo != null) {
            List<Point> points = this.rotateInfo.getRotatedPoints();
            int size = points.size();
            double[] x = new double[size];
            double[] y = new double[size];
            for (int i = 0; i < size; ++i) {
                x[i] = points.get(i).x();
                y[i] = points.get(i).y();
            }
            p = new PolygonGeom(x, y, size);
        }
        PolygonGeomPainter.paint((IPolygonGeom)p, (AbstractVectorPathPainter)(fill ? this.filler : this.painter));
    }

    @Override
    public void clear(int width, int height) {
    }
}

