/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.gx;

import com.tridium.gx.geom.AbstractVectorPathPainter;
import com.tridium.gx.geom.PathGeomPainter;
import com.tridium.gx.geom.PolygonGeomPainter;
import com.tridium.hx.gx.HtmlAbstractPainter;
import com.tridium.hx.gx.HtmlCanvasPainter;
import com.tridium.hx.gx.IHxGraphics;
import com.tridium.hx.px.BHxPxGraphics;
import com.tridium.web.WebUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.BRectGeom;
import javax.baja.gx.BTransform;
import javax.baja.gx.IEllipseGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.ILineGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.IPolygonGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BajaRuntimeException;
import javax.servlet.http.HttpServletRequest;

public class HxGraphics
implements IHxGraphics {
    protected HxOp op;
    protected HtmlWriter out;
    private final Stack<GxState> stack = new Stack();
    protected String id;
    protected int width;
    protected int height;
    protected double tx;
    protected double ty;
    protected BBrush brush;
    protected BPen pen;
    protected BFont font;
    protected IGeom clip;
    protected final ArrayList<String> images = new ArrayList();
    protected HtmlAbstractPainter painter;
    protected HtmlAbstractPainter filler;

    public static HxGraphics make(HxOp op, String id, int width, int height) throws Exception {
        return new HxGraphics(op, id, width, height);
    }

    protected HxGraphics() {
    }

    private HxGraphics(HxOp op, String id, int width, int height) throws Exception {
        this.op = op;
        this.out = op.getHtmlWriter();
        this.id = id;
        this.width = width;
        this.height = height;
        this.painter = new HtmlCanvasPainter(this.out, "g", false);
        this.filler = new HtmlCanvasPainter(this.out, "g", true);
        this.out.w((Object)"(function(){\n");
        this.out.w((Object)"var g = document.getElementById('").w((Object)id).w((Object)"').getContext('2d');\n");
        this.out.w((Object)"var images = [];\n");
        this.out.w((Object)"g.textAlign='left';");
        this.out.w((Object)"g.textBaseline='top';");
        this.painter.push();
        this.painter.translate(0.5, 0.5);
        this.setBrush(BBrush.DEFAULT);
        this.setFont(BFont.DEFAULT);
        this.setPen(BPen.DEFAULT);
        this.clip(0.0, 0.0, width, height);
    }

    public void useAntiAliasing(boolean b) {
    }

    public BBrush getBrush() {
        return this.brush;
    }

    public void setBrush(BBrush b) {
        this.brush = b;
        BBrush.Paint paint = b.getPaint();
        if (paint instanceof BBrush.LinearGradient) {
            BBrush.LinearGradient gradient = (BBrush.LinearGradient)paint;
            BBrush.Stop[] stops = gradient.getStops();
            double angle = (gradient.getAngle() - 90.0) / 180.0 * Math.PI;
            double penOffset = BHxPxGraphics.getPenOffset(this.op.get());
            double radius = Math.sqrt(Math.pow(this.height, 2.0) + Math.pow(this.width, 2.0));
            Point p1 = new Point(-this.tx + ((double)this.width + Math.sin(angle %= Math.PI * 2) * radius) / 2.0 + penOffset, -this.ty + ((double)this.height + Math.cos(angle) * radius) / 2.0 + penOffset);
            Point p2 = new Point(-this.tx + ((double)this.width + Math.sin(angle) * -radius) / 2.0 + penOffset, -this.ty + ((double)this.height + Math.cos(angle) * -radius) / 2.0 + penOffset);
            this.out.w((Object)("hx.setLinearGradient(g," + (int)p1.x + "," + (int)p1.y + "," + (int)p2.x + "," + (int)p2.y + "," + HxGraphics.toStopArrayString(stops) + ");"));
        } else if (paint instanceof BBrush.RadialGradient) {
            BBrush.RadialGradient gradient = (BBrush.RadialGradient)paint;
            BBrush.Stop[] stops = gradient.getStops();
            double penOffset = BHxPxGraphics.getPenOffset(this.op.get());
            double radius = 0.0;
            Point p1 = new Point(penOffset - this.tx + (double)this.width * gradient.getCenter().x() / 100.0, penOffset - this.ty + (double)this.height * gradient.getCenter().y() / 100.0);
            Point p2 = new Point(penOffset - this.tx + (double)this.width * gradient.getCenter().x() / 100.0, penOffset - this.ty + (double)this.height * gradient.getCenter().y() / 100.0);
            int longest = Math.max(this.width, this.height);
            if (longest != -1) {
                radius = (double)longest * gradient.getRadius() / 100.0;
            }
            this.out.w((Object)("hx.setRadialGradient(g," + (int)p1.x + "," + (int)p1.y + ",0," + (int)p2.x + "," + (int)p2.y + "," + (int)radius + "," + HxGraphics.toStopArrayString(stops) + ");"));
        } else if (paint instanceof BBrush.Image && ((BBrush.Image)paint).getImage().getOrdList().size() > 0) {
            BBrush.Image imageBrush = (BBrush.Image)paint;
            if (imageBrush.getTile() == 1) {
                String uri = HxUtil.escapeJsStringLiteral(WebUtil.toUri((OrdTarget)this.op, (HttpServletRequest)this.op.getRequest(), (BOrd)imageBrush.getImage().getOrdList().get(0)));
                String imageKey = "images[" + this.images.size() + "]";
                this.out.w((Object)imageKey).w((Object)" = new Image();\n");
                this.out.w((Object)imageKey).w((Object)".onload = function(){\n");
                this.out.w((Object)imageKey).w((Object)".onload=null;\n");
                this.out.w((Object)"var pattern = g.createPattern(").w((Object)imageKey).w((Object)", 'repeat');\n");
                this.out.w((Object)"hx.setColorObject(g, pattern);\n");
                this.images.add(uri);
            } else {
                this.out.w((Object)"hx.setColor(g, 0, 0, 0, 0);\n");
            }
        } else {
            BColor c = paint instanceof BBrush.Solid ? ((BBrush.Solid)paint).getColor() : BColor.black;
            this.out.w((Object)("hx.setColor(g," + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "," + (double)c.getAlpha() / 255.0 + ");\n"));
        }
    }

    private static String toStopArrayString(BBrush.Stop[] stops) {
        StringBuilder s = new StringBuilder("[");
        for (int i = 0; i < stops.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append("[").append(stops[i].getOffset()).append(",'").append(stops[i].getColor().toHtmlStringWithAlpha()).append("']");
        }
        s.append("]");
        return s.toString();
    }

    public void setBrush(BColor c) {
        this.setBrush(c.toBrush());
    }

    public BPen getPen() {
        return this.pen;
    }

    public void setPen(BPen p) {
        this.pen = p;
        this.out.w((Object)("g.lineWidth = " + this.getPen().getWidth() + ";\n"));
        if (p.getDash().length > 0) {
            this.out.w((Object)"g.setLineDash([");
            this.out.w((Object)String.join((CharSequence)",", (CharSequence[])Arrays.stream(p.getDash()).mapToObj(s -> Integer.toString((int)(s * this.getPen().getWidth()))).toArray(String[]::new)));
            this.out.w((Object)"]);\n");
        }
        switch (this.pen.getCap()) {
            case 103: {
                this.out.w((Object)"g.lineCap='round';\n");
                break;
            }
            case 102: {
                this.out.w((Object)"g.lineCap='square';\n");
            }
        }
        switch (this.pen.getJoin()) {
            case 202: {
                this.out.w((Object)"g.lineJoin='round';\n");
                break;
            }
            case 203: {
                this.out.w((Object)"g.lineJoin='bevel';\n");
            }
        }
    }

    public BFont getFont() {
        return this.font;
    }

    public void setFont(BFont font) {
        this.font = font;
        this.out.w((Object)"if(g.font){\n");
        this.out.w((Object)"g.font = '");
        this.out.w((Object)HxUtil.makeFont(font));
        this.out.w((Object)"';\n");
        this.out.w((Object)"}\n");
    }

    public void transform(BTransform btransform) {
        BTransform.Transform[] list;
        if (btransform == null) {
            return;
        }
        block5: for (BTransform.Transform x : list = btransform.getTransforms()) {
            switch (x.getTransformCase()) {
                case 2: {
                    BTransform.Scale scale = (BTransform.Scale)x;
                    if (Double.isNaN(scale.getY()) || Double.isNaN(scale.getX())) continue block5;
                    this.painter.scale(scale.getX(), scale.getY());
                    continue block5;
                }
                case 1: {
                    BTransform.Translate translate = (BTransform.Translate)x;
                    this.translate(translate.getX(), translate.getY());
                    continue block5;
                }
                case 3: {
                    BTransform.Rotate rotate = (BTransform.Rotate)x;
                    this.painter.rotate(rotate.getAngle());
                    continue block5;
                }
            }
        }
    }

    public void translate(double x, double y) {
        this.tx += x;
        this.ty += y;
        this.painter.translate(x, y);
        if (this.clip != null) {
            IRectGeom bounds = this.clip.bounds();
            this.clip = BRectGeom.make((double)(bounds.x() - x), (double)(bounds.y() - y), (double)bounds.width(), (double)bounds.height());
        }
    }

    public IGeom getClip() {
        return this.clip;
    }

    public IRectGeom getClipBounds() {
        return this.getClip().bounds();
    }

    public void clip(IGeom geom) {
        this.clip = this.clip != null ? geom.intersection(this.clip) : geom;
        IRectGeom r = this.clip.bounds();
        this.out.w((Object)("hx.clipRect(g," + (int)r.x() + "," + (int)r.y() + "," + (int)r.width() + "," + (int)r.height() + ");\n"));
    }

    public void clip(double x, double y, double w, double h) {
        this.clip((IGeom)new RectGeom(x, y, w, h));
    }

    public void stroke(IGeom geom) {
        switch (geom.getGeomCase()) {
            case 1: {
                ILineGeom l = (ILineGeom)geom;
                this.strokeLine(l.x1(), l.y1(), l.x2(), l.y2());
                break;
            }
            case 2: {
                IRectGeom r = (IRectGeom)geom;
                this.strokeRect(r.x(), r.y(), r.width(), r.height());
                break;
            }
            case 3: {
                this.drawEllipse((IEllipseGeom)geom, false);
                break;
            }
            case 4: {
                this.drawPolygon((IPolygonGeom)geom, false);
                break;
            }
            case 5: {
                this.drawPath((IPathGeom)geom, false);
            }
        }
    }

    public void fill(IGeom geom) {
        switch (geom.getGeomCase()) {
            case 2: {
                IRectGeom r = (IRectGeom)geom;
                this.fillRect(r.x(), r.y(), r.width(), r.height());
                break;
            }
            case 3: {
                this.drawEllipse((IEllipseGeom)geom, true);
                break;
            }
            case 4: {
                this.drawPolygon((IPolygonGeom)geom, true);
                break;
            }
            case 5: {
                this.drawPath((IPathGeom)geom, true);
            }
        }
    }

    public void strokeLine(double x1, double y1, double x2, double y2) {
        this.out.w((Object)("hx.strokeLine(g," + Math.round(x1) + "," + Math.round(y1) + "," + Math.round(x2) + "," + Math.round(y2) + ");\n"));
    }

    public void strokeRect(double x, double y, double width, double height) {
        this.out.w((Object)("g.strokeRect(" + Math.round(x) + "," + Math.round(y) + "," + Math.round(width) + "," + Math.round(height) + ");\n"));
    }

    public void fillRect(double x, double y, double width, double height) {
        this.out.w((Object)("g.fillRect(" + Math.round(x) + "," + Math.round(y) + "," + Math.round(width) + "," + Math.round(height) + ");\n"));
    }

    public void drawString(String str, double x, double y) {
        if (this.brush.isNull()) {
            return;
        }
        try {
            x = this.tx + x;
            y = this.ty + y - this.font.getAscent();
            this.out.w((Object)"if(g.fillText){\n");
            this.out.w((Object)("g.fillText(\"" + HxUtil.escapeJsStringLiteral(str) + "\"," + (int)(x - this.tx) + "," + (int)(y - this.ty + 2.0) + ");\n"));
            this.out.w((Object)"} else {\n");
            this.out.w((Object)"hx.drawString('").w((Object)this.id).w((Object)("',\"" + HxUtil.escapeJsStringLiteral(str) + "\",'" + HxUtil.makeColor(this.brush, BColor.black).toHtmlString() + "','" + HxUtil.makeFont(this.font) + "'," + (int)x + "," + (int)y + ");\n"));
            this.out.w((Object)"}\n");
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void drawString(char[] data, int offset, int length, double x, double y) {
        this.drawString(new String(data, offset, length), x, y);
    }

    public void drawImage(BImage img, double x, double y) {
        if (img != null && img.getOrdList().size() > 0) {
            this.out.w((Object)"if(g.drawImage) {\n");
            String uri = HxUtil.escapeJsStringLiteral(WebUtil.toUri((OrdTarget)this.op, (HttpServletRequest)this.op.getRequest(), (BOrd)img.getOrdList().get(0)));
            this.out.w((Object)"var img = new Image();\n");
            this.out.w((Object)("img.src='" + uri + "';\n"));
            this.out.w((Object)("g.drawImage(img, " + (int)x + "," + (int)y + ");"));
            this.out.w((Object)"}\n");
        }
    }

    private void drawEllipse(IEllipseGeom e, boolean fill) {
        double rx = e.width() / 2.0;
        double ry = e.height() / 2.0;
        double centerX = e.x() + rx;
        double centerY = e.y() + ry;
        (fill ? this.filler : this.painter).ellipse(centerX, centerY, rx, ry, 0.0);
    }

    protected void drawPolygon(IPolygonGeom p, boolean fill) {
        PolygonGeomPainter.paint((IPolygonGeom)p, (AbstractVectorPathPainter)(fill ? this.filler : this.painter));
    }

    private void drawPath(IPathGeom p, boolean fill) {
        PathGeomPainter.paint((IPathGeom)p, (AbstractVectorPathPainter)(fill ? this.filler : this.painter));
    }

    @Override
    public void clear(int width, int height) {
        this.out.w((Object)"hx.clearCanvas(g,'").w(width).w((Object)"','").w(height).w((Object)"','").w((Object)this.id).w((Object)"');\n");
    }

    @Override
    public void clear() {
        this.clear(this.width, this.height);
    }

    public void push() {
        this.painter.push();
        GxState s = new GxState();
        s.tx = this.tx;
        s.ty = this.ty;
        s.brush = this.brush;
        s.pen = this.pen;
        s.font = this.font;
        s.clip = this.clip;
        this.stack.push(s);
    }

    public void pop() {
        this.painter.pop();
        GxState s = this.stack.pop();
        this.tx = s.tx;
        this.ty = s.ty;
        this.brush = s.brush;
        this.pen = s.pen;
        this.font = s.font;
        this.clip = s.clip;
    }

    public void dispose() {
        this.painter.pop();
        for (int i = this.images.size() - 1; i >= 0; --i) {
            String imageKey = "images[" + i + "]";
            this.out.w((Object)"};\n");
            this.out.w((Object)imageKey).w((Object)(".src='" + this.images.get(i) + "';\n"));
        }
        this.out.w((Object)"})();\n");
    }

    static class GxState {
        public double tx;
        public double ty;
        public BBrush brush;
        public BPen pen;
        public BFont font;
        public IGeom clip;

        GxState() {
        }
    }
}

