/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.fieldeditors;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.owasp.encoder.Encode;

@NiagaraType(agent={@AgentOn(types={"workbench:DynamicEnumFE", "workbench:FrozenEnumFE"})})
@NiagaraSingleton
public class BHxEnumFE
extends BHxFieldEditor {
    @Generated
    public static final BHxEnumFE INSTANCE = new BHxEnumFE();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxEnumFE.class);
    public static final String PREFER_FROZEN_EDITOR_KEY = "preferFrozenEditor";
    public static final BFacets PREFER_FROZEN_EDITOR = BFacets.make((String)"preferFrozenEditor", (boolean)true);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxEnumFE() {
    }

    @Override
    public void write(HxOp op) throws Exception {
        this.write(op, new HashMap<String, String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(HxOp op, Map<String, String> attrs) throws Exception {
        BEnum value = (BEnum)op.get();
        BEnumRange range = this.getEnumRange(op, value);
        boolean useFrozenEditor = value instanceof BFrozenEnum || op.getFacets().getb(PREFER_FROZEN_EDITOR_KEY, false);
        HtmlWriter html = op.getHtmlWriter();
        Writer writer = HxUtil.startOnloadWriter(op);
        try {
            HtmlWriter js = op.getHtmlWriter();
            if (!useFrozenEditor) {
                op.addStyleSheet(BOrd.make((String)"module://webEditors/rc/fe/webEditors-structure.css"));
            }
            if (useFrozenEditor) {
                html.w((Object)"<select ");
            } else {
                html.w((Object)"<input ");
            }
            html.attr("id", op.scope("value")).attr("name", op.scope("value"));
            if (!useFrozenEditor) {
                html.w((Object)"value='");
                html.safe((Object)range.getDisplayTag(value.getOrdinal(), (Context)op));
                html.w((Object)"'/>");
                html.w((Object)"<datalist ").attr("id", op.scope("value") + "_datalist").w((Object)"></datalist>");
            } else {
                html.w((Object)"></select>");
            }
            js.w((Object)"require([");
            js.w((Object)"'jquery'");
            if (!useFrozenEditor) {
                js.w((Object)",'nmodule/js/rc/jquery/Relevant-Dropdowns/js/jquery.relevant-dropdown'");
            }
            js.w((Object)"], function ($) {");
            js.w((Object)"$(document).ready(function() {");
            if (useFrozenEditor) {
                js.w((Object)("var elem = $(document.getElementById('" + op.scope("value") + "'));"));
            } else {
                js.w((Object)("var elem = $(document.getElementById('" + op.scope("value") + "'));"));
                js.w((Object)("var datalist = $(document.getElementById('" + op.scope("value") + "_datalist'));"));
                js.w((Object)"elem.attr('type', 'text');");
                js.w((Object)("elem.attr('list', '" + op.scope("value").replaceAll("\\$", "\\\\\\\\\\$") + "_datalist');"));
                js.w((Object)"elem.attr('autocomplete', 'off');");
            }
            for (int ordinal : range.getOrdinals()) {
                js.w((Object)"$('<option/>').attr('value', '");
                if (useFrozenEditor) {
                    js.w((Object)Integer.toString(ordinal));
                    js.w((Object)"')");
                    if (ordinal == value.getOrdinal()) {
                        js.w((Object)".attr('selected', 'selected')");
                    }
                    js.w((Object)".text('");
                    js.safe((Object)range.getDisplayTag(ordinal, (Context)op));
                    js.w((Object)"')");
                    js.w((Object)".appendTo(elem);");
                    continue;
                }
                js.safe((Object)range.getDisplayTag(ordinal, (Context)op));
                js.w((Object)"')");
                js.w((Object)".appendTo(datalist);");
            }
            if (!useFrozenEditor) {
                js.w((Object)"elem.relevantDropdown({");
                js.w((Object)"'force': true,");
                js.w((Object)"'showAll': true,");
                js.w((Object)"'datalist': datalist,");
                js.w((Object)"'change': function () {");
                js.w((Object)"var element = elem[0];");
                js.w((Object)"if ('createEvent' in document) {");
                js.w((Object)"var evt = document.createEvent('HTMLEvents');");
                js.w((Object)"evt.initEvent('change', true, true);");
                js.w((Object)"element.dispatchEvent(evt);");
                js.w((Object)"} else ");
                js.w((Object)"element.fireEvent('onchange');");
                js.w((Object)"}");
                js.w((Object)"});");
            }
            if (!op.canWrite()) {
                if (useFrozenEditor) {
                    js.w((Object)"elem.attr('disabled', 'disabled');");
                } else {
                    js.w((Object)"elem.attr('readonly', 'readonly');");
                }
            }
            Object object = attrs.keySet().iterator();
            while (object.hasNext()) {
                Object k = object.next();
                js.w((Object)("elem.attr('" + k.toString() + "', '" + attrs.get(k).toString() + "');"));
            }
            if (useFrozenEditor) {
                js.w((Object)"elem.parent().addClass('hx-FrozenEnumFE');");
            } else {
                js.w((Object)"elem.parent().addClass('hx-DynamicEnumFE');");
                if (range.getOrdinals().length > 0) {
                    js.w((Object)"elem.parent().addClass('hx-DynamicEnumFE-NonEmpty');");
                }
            }
            js.w((Object)"});");
            js.w((Object)"});");
        }
        finally {
            HxUtil.finishOnloadWriter(writer, op);
        }
    }

    @Override
    public void update(HxOp op) throws Exception {
        if (!op.canWrite()) {
            BEnum value = (BEnum)op.get();
            BEnumRange range = this.getEnumRange(op, value);
            String ordinalOrTag = Encode.forHtml((String)range.getDisplayTag(value.getOrdinal(), (Context)op));
            boolean usingFrozenEditor = value instanceof BFrozenEnum || op.getFacets().getb(PREFER_FROZEN_EDITOR_KEY, false);
            HtmlWriter out = op.getHtmlWriter();
            if (usingFrozenEditor) {
                out.w((Object)("var selectElement = document.getElementById('" + op.scope("value") + "');"));
                out.w((Object)"for (var i = 0; i < selectElement.options.length; i++) {");
                out.w((Object)("if (selectElement.options[i].value === '" + value.getOrdinal() + "') {"));
                out.w((Object)"selectElement.selectedIndex = i;");
                out.w((Object)"break;");
                out.w((Object)"}");
                out.w((Object)"}");
            } else {
                out.w((Object)("var input = document.getElementById('" + op.scope("value") + "');"));
                out.w((Object)("input.value = '" + ordinalOrTag + "';"));
            }
        }
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        BEnum value = (BEnum)op.get();
        String formValue = op.getFormValue("value");
        if (formValue == null || formValue.equals("")) {
            return value;
        }
        Integer ordinal = null;
        BEnumRange range = this.getEnumRange(op, value);
        for (int tempOrdinal : range.getOrdinals()) {
            if (!formValue.equals(Encode.forHtml((String)range.getDisplayTag(tempOrdinal, (Context)op)))) continue;
            ordinal = tempOrdinal;
            break;
        }
        if (ordinal == null) {
            ordinal = Integer.parseInt(formValue);
        }
        if (value instanceof BFrozenEnum) {
            return value.getRange().get(ordinal.intValue());
        }
        return BDynamicEnum.make((int)ordinal, (BEnumRange)value.getRange());
    }

    private BEnumRange getEnumRange(HxOp op, BEnum value) {
        BEnumRange facetsEnumRange = (BEnumRange)op.getFacet("range");
        if (!(value instanceof BFrozenEnum) && facetsEnumRange != null) {
            return facetsEnumRange;
        }
        return value.getRange();
    }
}

